;========================================================================
;   1-wire AVR 0.6 MHz
;=======================================================================
    .equ PORT1W  = PORTB
    .equ PIN1W   = PINB
    .equ DDR1W   = DDRB
    .equ P1W     = PB3
;========================================================================
reset1w: ;      P1W (0.6)
;-----------------------------------------------------------------------
    set
    cbi  PORT1W,P1W
    sbi  DDR1W,P1W
    ldi  R16,100
reset1w_1:
    dec  R16
    brne reset1w_1 ; ~480 us
    in   R0,SREG
    cli  
    cbi  DDR1W,P1W
    ldi  R16,14
reset1w_2:
    dec  R16
    brne reset1w_2 ; ~70 us
    sbis PIN1W,P1W
    clt
    ldi  R16,85
reset1w_3:
    dec  R16
    brne reset1w_3 ; ~410 us
    sbis PIN1W,P1W
    set
    bld  R0,T
    out  SREG,R0
    ret    
;=======================================================================
write1w:    ;  R18    P1W
;-----------------------------------------------------------------------
    in   R0,SREG
    cli  
    ldi R17,8
write1w_loop:
    sbi DDR1W,P1W
    nop
    sbrc R18,0
    cbi DDR1W,P1W
    ldi  R16,12
write1w_delay:    
    dec  R16
    brne write1w_delay ; ~60 us
    cbi DDR1W,P1W
    lsr  R18
    dec  R17
    brne write1w_loop    
    out  SREG,R0
    ret
;=======================================================================
read1w:     ;    1W  R18
;-----------------------------------------------------------------------
    in   R0,SREG
    cli  
    ldi R17,8
read1w_loop:
    sbi DDR1W,P1W
    clc
    cbi DDR1W,P1W
    rcall read1w_ret ; ~12 us
    sbic PIN1W,P1W
    sec
    ror R18
    ldi  R16,10
read1w_delay:    
    dec  R16
    brne read1w_delay ; ~50 us
    dec  R17
    brne read1w_loop
    out  SREG,R0
read1w_ret:
    ret 
;=======================================================================
