;------------------------------------------------------------------------------
; CRC8 computing functions
; based on Application Note 27 from Dallas Semiconductor
; http://avr-mcu.dxp.pl
; e-mail: radek@dxp.pl
; (c) Radoslaw Kwiecien
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; Data segment
;------------------------------------------------------------------------------
.dseg
_crc : .byte 1
;------------------------------------------------------------------------------
; Code segment
;------------------------------------------------------------------------------
.cseg
;------------------------------------------------------------------------------
; Update crc value
;------------------------------------------------------------------------------
CRC8Update:
	push	r16
	push	r17
	push	r18
	push 	r16

	ldi		r17, 8
CRC8L:
	lds		r18, _crc
	eor		r16, r18
	ror		r16
	lds		r16, _crc
	brcc	CRC8zero
	ldi		r18, 0x18
	eor		r16, r18	

CRC8zero:
	ror		r16
	sts		_crc, r16
	pop		r16
	lsr		r16
	push	r16
	dec		r17
	brne	CRC8L
	pop		r16
	pop		r18
	pop		r17
	pop		r16
	ret
;------------------------------------------------------------------------------
; Clear crc value
;------------------------------------------------------------------------------
CRC8Init:
	push	r16
	ldi		r16,0
	sts		_crc, r16
	pop		r16
	ret
;------------------------------------------------------------------------------
; Copy crc value to r16
;------------------------------------------------------------------------------
GetCRC8:
	lds		r16, _crc	
	ret
;------------------------------------------------------------------------------
; End of crc8.asm file
;------------------------------------------------------------------------------
