;=======================================================================
EEWrite:
	sbic	EECR,EEWE	;if EEWE not clear
	rjmp	EEWrite		;    wait more
	out	EEAR,R17	;output address
	out	EEDR,R16	;output data
	sbi EECR,EEMPE
	sbi	EECR,EEWE	;set EEPROM Write strobe
	ret
;=======================================================================
;
;=======================================================================
EERead:
	sbic	EECR,EEWE	;if EEWE not clear
	rjmp	EERead		;    wait more
	out	EEAR,R17	;output address
	sbi	EECR,EERE	;set EEPROM Read strobe
	in	R16,EEDR	;get data
	ret
;=======================================================================
;
;=======================================================================
;EEWrite_seq:
;	sbic	EECR,EEWE	;if EEWE not clear
;	rjmp	EEWrite_seq	;    wait more
;	in	R0,EEAR	;get address
;	inc	R0		;increment address
;	out	EEAR,R0	;output address
;	out	EEDR,R16	;output data
;	sbi EECR,EEMPE
;	sbi	EECR,EEWE	;set EEPROM Write strobe
;	ret
;=======================================================================
;
;=======================================================================
;EERead_seq:
;	in	R0,EEAR	;get address
;	inc	R0		;increment address
;	out	EEAR,R0	;output address
;	sbi	EECR,EERE	;set EEPROM Read strobe
;	in	R16,EEDR	;get data
;	ret
;=======================================================================
;
;=======================================================================
EEFullErase:
    sbic    EECR,EEWE	;if EEWE not clear
    rjmp    EEFullErase	;    wait more
    sbi     EECR,EEPM0
    ldi     R17,EEPROMEND+1
EEFullErase_loop:
    sbic    EECR,EEWE
    rjmp    EEFullErase_loop
    dec     R17
    out     EEARL,R17
    sbi     EECR,EEMPE    
    sbi     EECR,EEWE	;set EEPROM Write strobe
    or      R17,R17
    brne    EEFullErase_loop
    cbi     EECR,EEPM0
    ret
;=======================================================================
	