;=======================================================================
;      iButton
;-----------------------------------------------------------------------
;   http://shoorick.org.ua
;=======================================================================
    .include "tn13Adef.inc"
;=======================================================================
    .equ    T   = 6
;-----------------------------------------------------------------------
    .dseg
    
SerialNum:  .byte 8        
;-----------------------------------------------------------------------
	.cseg
	.org 0x00

	rjmp  start ; Reset Handler
	rjmp  0x00 ; IRQ0 Handler
	rjmp  0x00 ; PCINT0 Handler
	rjmp  0x00 ; Timer0 Overflow Handler
	rjmp  0x00 ; EEPROM Ready Handler
	rjmp  0x00 ; Analog Comparator Handler
	rjmp  0x00 ; Timer0 CompareA Handler
	rjmp  0x00 ; Timer0 CompareB Handler
	rjmp  0x00 ; Watchdog Interrupt Handler
	rjmp  0x00 ; ADC Conversion Handler

    .include "1-wire.inc"
    .include "eeprom.inc"
    .include "crc8.inc"
;-----------------------------------------------------------------------
start:
    ldi     R16,RAMEND  ;  
    out     SPL,R16
;-----------------------------------------------------------------------
    cbi     PORTB,PB4   ; 
    cbi     PORTB,PB0   ; 
    sbi     DDRB,PB4
    sbi     DDRB,PB0
    cbi     DDRB,PB1    ; 
;-----------------------------------------------------------------------
main_loop:
    sbic    PINB,PB1    ;     
    ldi     YH,40       ;     
    sbiw    YL,1
    breq    erase_sn    ;      -  EEPROM
    rcall   reset1w     ;  -   iButton
    brbs    T,main_loop
;-----------------------------------------------------------------------
    ldi     R18,0x33    ;   -  
    rcall   write1w
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    rcall   CRC8Init
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    ldi     R19,8
    ldi     XH,high(SerialNum)
    ldi     XL, low(SerialNum)
read_button:    
    rcall   read1w
    st      X+,R18
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    mov     R16,R18
    rcall   CRC8Update
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    dec     R19
    brne    read_button
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    rcall   GetCRC8
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    cpi     R16,0
    brne    main_loop   ;   CRC -   
;-----------------------------------------------------------------------
    ldi     XH,high(SerialNum)
    ldi     XL, low(SerialNum)
    clr     R1
    rcall   check_sn_x  ;       EEPROM
    breq    ok          ;   -  
    sbic    PINB,PB1    ;     ,
    rjmp    fail        ;    
;-----------------------------------------------------------------------
    ldi     XH,high(SerialNum)  ;   -   EEPROM
    ldi     XL, low(SerialNum)
    clr     R1
    rcall   store_sn_x
    rjmp    ok                        
;-----------------------------------------------------------------------
erase_sn:
    rcall   EEFullErase
    rjmp ok
;-----------------------------------------------------------------------
fail:    
    sbi     PORTB,PB0   ;  
    rcall   delay_01    ;  0.1 
    cbi     PORTB,PB0   ;  
    rcall   delay_05    ;  0.5 
    rjmp main_loop
;-----------------------------------------------------------------------
ok:
    sbi     PORTB,PB4   ;  
    rcall   delay_01    ;   0.1  
    cbi     PORTB,PB4   ;  
ok_loop:
    rcall   delay_05    ;   0.5  ,    
    rcall   reset1w
    brbc    T,ok_loop   ;    -    
;-----------------------------------------------------------------------
    rjmp main_loop
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
delay_10:   ; ~1  
    rcall delay_05
;-----------------------------------------------------------------------
delay_05:   
    rcall delay_01
;-----------------------------------------------------------------------
delay_04:
    rcall delay_01
;-----------------------------------------------------------------------
delay_03:
    rcall delay_01
;-----------------------------------------------------------------------
delay_02:
    rcall delay_01
;-----------------------------------------------------------------------
delay_01:   ; ~0.1  
    push ZL ; 2
    push ZH ; 2
    ldi ZL, low(14996)  ; 1
    ldi ZH,high(14996)  ; 1
delay_01_loop:
    sbiw ZL,1           ; 2
    brne delay_01_loop  ; 2/1
    pop ZH  ; 2
    pop ZL  ; 2
    ret     ; 7
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
store_sn_x_loop:
    ldi     R17,8
    add     R1,R17
store_sn_x:
    mov     R17,R1
    cpi     R17,EEPROMEND
    brcc    store_sn_done
    rcall   EERead
    inc     R16
    brne    store_sn_x_loop
;-----------------------------------------------------------------------
store_sn:
    ldi     R19,8
store_sn_loop:
    ld      R16,X+
    rcall   EEWrite   
    inc     R17
    dec     R19
    brne    store_sn_loop
store_sn_done:
    ret
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
check_sn_x:
    movw    R2,XL
    rjmp    check_sn
check_sn_fail:
    movw    XL,R2
    ldi     R17,8
    add     R1,R17
check_sn:
    mov     R17,R1
    cpi     R17,EEPROMEND
    brcc    check_sn_done
    ldi     R19,8
check_sn_loop:
    rcall   EERead
    ld      R18,X+
    cp      R16,R18
    brne    check_sn_fail
    inc     R17
    dec     R19
    brne    check_sn_loop
check_sn_done:
    ret
;-----------------------------------------------------------------------
              