;=======================================================================
;   R0 -  
;   R7 -  
;   R6 -   
;   TX1 -    
;   101-109 -  
;    - 24
;=======================================================================
    .equ TX1, 9
;-----------------------------------------------------------------------
    ajmp start
;-----------------------------------------------------------------------
    .org 0003h
    reti
;-----------------------------------------------------------------------
    .org 000Bh
    ajmp scan
;-----------------------------------------------------------------------
    .org 0013h
    reti
;-----------------------------------------------------------------------
    .org 001Bh
    inc TX1
    reti    
;-----------------------------------------------------------------------
    .org 0023h
    reti
;-----------------------------------------------------------------------
    .org 002Bh
    reti
;=======================================================================
start:
    mov SP,32
;-----------------------------------------------------------------------
    mov R0,#109     ;     (5141)
    mov R7,#9
led_load:
    mov A,#15
    mov @R0,A
    dec R0
    djnz R7,led_load
;-----------------------------------------------------------------------
    mov  R0,#110
    mov  R7,#100
    mov  R6,#10
    mov  TMOD,#01010001b
    mov TH0,#0FFh   ;    - 1 
    mov TL0,#0FFh
    setb ET1
    setb ET0
    setb EA
    setb TR1
    setb TR0
mainloop:
    ljmp mainloop    
;=======================================================================
scan:   ;   /    
    mov TH0,#0F8h   ;  
    mov TL0,#033h
;-----------------------------------------------------------------------
    djnz R7,rtc_ok  ; +1 (    )
    mov  R7,#100    ; +0.5
    djnz R6,rtc_ok  ; +1
;-----------------------------------------------------------------------
;    1 !
;-----------------------------------------------------------------------
    clr TR1         ;    ; +0.5
    clr TR0         ;  
    mov P1,#255     ;  
    jnb TF1,get_number
    clr TF1
    inc TX1
get_number:
    mov 10,TH1
    mov 11,TL1
    lcall shownum   ;         
    mov TH1,#0      ;   
    mov TL1,TH1
    mov TX1,TH1
    mov TH0,#0F8h   ;   
    mov TL0,#033h+3
    mov A,TCON
    orl A,#01010000b
    mov TCON,A      ;     
;-----------------------------------------------------------------------
    mov R6,#10
;    jb  P3.4,rtc_ok
;    mov R6,#100     ;  10        
;-----------------------------------------------------------------------
rtc_ok:    
;-----------------------------------------------------------------------
    dec R0          ;   
    mov A,R0
    add A,#-100
    jnz scan_ok
    mov A,#9
    mov R0,#109
scan_ok:     
    swap A
    mov B,A
    mov A,@R0
    add A,B
    mov P1,A
;-----------------------------------------------------------------------
    reti
;=======================================================================
is_zero:            ;   
    anl A,#15
    jz  is_zero_ok
    mov B,#0
    ret
is_zero_ok:
    mov A,B
    ret    
;=======================================================================
shownum:            ;     
    push PSW
    setb RS0
    clr  RS1
;-----------------------------------------------------------------------
    lcall SUB_BIN24TOBCD4
;-----------------------------------------------------------------------
    mov B,#15       ;     
    mov A,R4        ; 123456789 (318)
    lcall is_zero   ; 1 234 567 
    mov 101,A
    mov A,R5
    swap A
    lcall is_zero
    mov 103,A
    mov A,R5
    lcall is_zero
    mov 104,A
    mov A,R6
    swap A
    lcall is_zero
    mov 105,A
    mov A,R6
    lcall is_zero
    mov 107,A
    mov A,R7
    swap A
    lcall is_zero
    mov 108,A
    mov A,R7
    anl A,#15
    mov 109,A
;-----------------------------------------------------------------------
    pop PSW
    ret
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; -=   www.8052.com =- 
;-----------------------------------------------------------------------
; Convert 24-bit binary to 4-byte BCD format
; It uses Gorner algorithm:
; Num10=(...((0+bitn-1)*2+bitn-2)*2+...bit1)*2+bit0 
; INPUT  : (MSB)R1/R2/R3(LSB)    - bin24
; OUTPUT : (MSB)R4/R5/R6/R7(LSB) - bcd4
; MODIFY : R0,ACC,PSW and destroys bin24
; CODE size: 59 bytes
; TIME: 689...1073(max) machine cycles
; NOTE: no zero check implemented 
 
SUB_BIN24TOBCD4:
; prepare result area
	MOV	R4,#0
	MOV	R5,#0
	MOV	R6,#0
	MOV	R7,#0
	MOV	R0,#24				; number of bits
	AJMP	SUB_BIN24TOBCD4_0
SUB_BIN24TOBCD4_C:
; multiple BCD4 by 2
	MOV	A,R7
	ADD	A,R7
	DA	A
	MOV	R7,A
	MOV	A,R6
	ADDC	A,R6
	DA	A
	MOV	R6,A
	MOV	A,R5
	ADDC	A,R5
	DA	A
	MOV	R5,A
	MOV	A,R4
	ADDC	A,R4
	DA	A
	MOV	R4,A
SUB_BIN24TOBCD4_0:
; roll left bin24
	MOV	A,R3
	RLC	A
	MOV	R3,A
	MOV	A,R2
	RLC	A
	MOV	R2,A
	MOV	A,R1
	RLC	A
	MOV	R1,A
	JNC	SUB_BIN24TOBCD4_1		; bit=0
; bit=1 so increment BCD4 by 1
	MOV	A,#1
	ADD	A,R7
	DA	A
	MOV	R7,A
	CLR	A
	ADDC	A,R6
	DA	A
	MOV	R6,A
	CLR	A
	ADDC	A,R5
	DA	A
	MOV	R5,A
	CLR	A
	ADDC	A,R4
	DA	A
	MOV	R4,A
SUB_BIN24TOBCD4_1:
	DJNZ	R0,SUB_BIN24TOBCD4_C
	RET
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        