unit mouse;

interface
const
  MouseLeft  = 1;
  MouseRight = 2;
  MouseMid   = 4;

var
  ButtonCount,ButtonStatus:byte;
  MouseFlag:boolean;
  MouseX,MouseY:word;

procedure MouseInit(var ButtonCount:byte;var MouseFlag:boolean);
procedure MouseReset;
procedure MouseOn;
procedure MouseOff;
procedure GetMouseStatus(var MouseX,MouseY:word;var ButtonStatus:byte);
procedure SetMouseXY(MouseX,MouseY:word);
procedure GetMouseXYup
(Button:byte;var MouseX,MouseY:word;var ButtonStatus,Clicks:byte);
procedure GetMouseXYdown
(Button:byte;var MouseX,MouseY:word;var ButtonStatus,Clicks:byte);
procedure SetCursorX(Xmin,Xmax:word);
procedure SetCursorY(Ymin,Ymax:word);
procedure SetInvArea(x1,y1,x2,y2:word);
procedure SetTextCursor(AndMask,XorMask:word);
procedure SetGraphCursor(adr:pointer);
function  MouseStatusSize:word;
procedure PushMouse(ms:pointer);
procedure PopMouse(ms:pointer);

implementation
procedure MouseInit(var ButtonCount:byte;var MouseFlag:boolean);assembler;
asm
   push ds
   mov  ax,0
   int  33h
   lds  si,ButtonCount
   mov  [si],bl
   lds  si,MouseFlag
   and  al,1
   mov  [si],al
   pop  ds
end;

procedure MouseReset;assembler;
asm
   mov  ax,21h
   int  33h
end;

procedure MouseOn;assembler;
asm
   mov  ax,1
   int  33h
end;

procedure MouseOff;assembler;
asm
   mov  ax,2
   int  33h
end;

function MouseStatusSize;assembler;
asm
   mov  ax,15h
   int  33h
   mov  ax,bx
end;

procedure PushMouse;assembler;
asm
   les  di,ms
   mov  ax,16h
   int  33h
end;

procedure PopMouse;assembler;
asm
   les  di,ms
   mov  ax,17h
   int  33h
end;

procedure GetMouseStatus(var MouseX,MouseY:word;var ButtonStatus:byte);
assembler;
asm
   push ds
   mov  ax,3
   int  33h
   lds  di,MouseX
   mov  [di],cx
   lds  di,MouseY
   mov  [di],dx
   lds  di,ButtonStatus
   mov  [di],bl
   pop  ds
end;

procedure SetMouseXY(MouseX,MouseY:word);assembler;
asm
   mov  ax,4
   mov  cx,MouseX
   mov  dx,MouseY
   int  33h
end;

procedure GetMouseXYup
(Button:byte;var MouseX,MouseY:word;var ButtonStatus,Clicks:byte);assembler;
asm
   push ds
   mov  ax,5
   mov  bl,Button
   int  33h
   lds  di,MouseX
   mov  [di],cx
   lds  di,MouseY
   mov  [di],dx
   lds  di,ButtonStatus
   mov  [di],al
   lds  di,Clicks
   mov  [di],bl
   pop  ds
end;

procedure GetMouseXYdown
(Button:byte;var MouseX,MouseY:word;var ButtonStatus,Clicks:byte);assembler;
asm
   push ds
   mov  ax,6
   mov  bl,Button
   int  33h
   mov  bl,Button
   int  33h
   lds  di,MouseX
   mov  [di],cx
   lds  di,MouseY
   mov  [di],dx
   lds  di,ButtonStatus
   mov  [di],al
   lds  di,Clicks
   mov  [di],bl
   pop  ds
end;

procedure SetCursorX(Xmin,Xmax:word);assembler;
asm
   mov  ax,7
   mov  cx,Xmin
   mov  dx,Xmax
   int  33h
end;

procedure SetCursorY(Ymin,Ymax:word);assembler;
asm
   mov  ax,8
   mov  cx,Ymin
   mov  dx,Ymax
   int  33h
end;

procedure SetInvArea(x1,y1,x2,y2:word);assembler;
asm
   mov  ax,16
   mov  bx,x1
   mov  cx,y1
   mov  si,x2
   mov  dx,y2
   int  33h
end;

procedure SetTextCursor(AndMask,XorMask:word);assembler;
asm
   mov  ax,10
   mov  cx,AndMask
   mov  dx,XorMask
   int  33h
end;

procedure SetGraphCursor(adr:pointer);assembler;
asm
   mov  ax,9
   mov  si,[bp+4]
   mov  di,[bp+6]
   int  33h
end;

begin
end.
