include         "rforth.inc"
include         "dr.inc"

                org     100h
rforth:

;               sp -   
;               bp -   
;               si -     
;               di -      

spsize          equ     2048    ;  
rpsize          equ     1024    ;   
tbsize          equ     128     ;   

;               

;-----------------------------------------------------------------------
                mov     bx,ds
                xor     cx,cx
                mov     ds,cx
                cli
                mov     ax,[ds:9*4]
                mov     dx,[ds:9*4+2]
                mov     word [cs:int09_old],  ax
                mov     word [cs:int09_old+2],dx
                mov     word [ds:9*4],int9
                mov     [ds:9*4+2],bx
                sti
;-----------------------------------------------------------------------
                mov     ax,3h
                int     10h
;-----------------------------------------------------------------------
                mov     ax,cs
                mov     es,ax
                mov     bp,fnt8x16.value              
                mov     bx,1000h               
                mov     cx,255                 
                xor     dx,dx                  
                mov     ax,1110h
                int     10h
;-----------------------------------------------------------------------
                mov     ax,cs
                mov     ds,ax
                mov     es,ax
;-----------------------------------------------------------------------
                mov     dx,word [dp0.value]
                mov     di,dx
                add     dx,spsize
                mov     sp,dx
                add     dx,rpsize
                mov     bp,dx
                add     dx,16
                mov     word [tib.value],dx
                add     dx,word [tibl.value]
                add     dx,16
                mov     word [fheap.value],dx
                push    word [auto.value]
                call    word [tnest]
                dw      exec,abort

;                

                dw      0

;                

_nest:          newb    nest,''
                dec     bp
                dec     bp
                mov     [bp],si
                pop     si
next:           cld
                lodsw
                jmp     ax
                dw      _nest-$

_next:          dr      4,'',0
                push    word [tnext]
                endb    _next

_exit:          newb    exit,''
                jmp     word [texit]
_exitdflt:                
                mov     si,[bp]
                inc     bp
                inc     bp
                endb    _exit

_tonest:        newb    tonest,'>'
                call    word [tnext]
tnest           dw      nest
                dw      _tonest-$

_tonext:        newb    tonext,'>'
                call    word [tnext]
tnext           dw      next
                dw      _tonext-$

_toexit:        newb    toexit,'>'
                call    word [tnext]
texit           dw      _exitdflt
                dw      _toexit-$

;                

_exec:          newb    exec,''
                ret
                dw      _exec-$

_segm:          newb    segm,''
                push    cs
                endb    _segm

_noop:          newb    noop,''
                endb    _noop

_bran:          newb    bran,''
                add     si,[si]
                endb    _bran

_zbran:         newb    zbran,'?'
                pop     ax
                or      ax,ax
                jnz     zbran1
                add     si,[si]
                jmp     word [tnext]
zbran1:         inc     si
                inc     si
                endb    _zbran

;                

                var     dp0,'0',endvoc
                var     spl_,'>',spsize
                var     sp0,'0',endvoc+spsize
                var     rp0,'0',endvoc+spsize+rpsize
                var     auto,'',hello
                var     state,''
                var     latest,'',_bye
                var     fheap,'',endvoc+spsize+rpsize+tbsize+32
                var     task,'',0fff0h
                var     top,'',0fff0h

;                  

_spat:          newb    spat,'?'
                push    sp
                endb    _spat

_spstor:        newb    spstor,'!'
                pop     sp
                endb    _spstor

_dup:           newb    sdup,'!!'
                pop     ax
                push    ax
                push    ax
                endb    _dup

_ddup:          newb    ddup,'2!!'
                pop     ax
                pop     bx
                push    bx
                push    ax
                push    bx
                push    ax
                endb    _ddup

_drop:          newb    drop,'>>'
                inc     sp
                inc     sp
                endb    _drop

_press:         newb    press,'<<'
                pop     ax
                inc     sp
                inc     sp
                push    ax
                endb    _press

_dpress:        newb    dpress,'<<2'
                pop     ax
                pop     bx
                add     sp,4
                push    bx
                push    ax
                endb    _dpress

_ddrop:         newb    ddrop,'2>>'
                add     sp,4
                endb    _ddrop

_swap:          newb    swap,'(2)'
                pop     ax
                pop     bx
                push    ax
                push    bx
                endb    _swap

_dswap:         newb    dswap,'2(2)'
                pop     ax
                pop     bx
                pop     cx
                pop     dx
                push    bx
                push    ax
                push    dx
                push    cx
                endb    _dswap

_over:          newb    over,'2^'
                mov     bx,sp
                mov     ax,[ss:bx+2]
                push    ax
                endb    _over

_pick:          newb    pick,'^'
                pop     ax
                shl     ax,1
                mov     bx,sp
                sub     bx,ax
                mov     ax,[ss:bx]
                push    ax
                endb    _pick

_rot:           newb    rot,'(3)'
                pop     ax
                pop     bx
                pop     cx
                push    bx
                push    ax
                push    cx
                endb    _rot

_lit:           newb    lit,''
                cld
                lodsw
                push    ax
                endb    _lit

_dlit:          newb    dlit,'2'
                cld
                lodsw
                push    ax
                lodsw
                push    ax
                endb    _dlit

_at:            newb    at_,'?'
                pop     bx
                push    word [bx]
                endb    _at

_cat:           newb    cat,'?'
                pop     bx
                mov     al,[bx]
                xor     ah,ah
                push    ax
                endb    _cat

_dat:           newb    dat,'?'
                pop     bx
                push   word  [bx]
                push   word  [bx+2]
                endb    _dat

_stor:          newb    stor,'!'
                pop     bx
                pop     word [bx]
                endb    _stor

_cstor:         newb    cstor,'!'
                pop     bx
                pop     ax
                mov     [bx],al
                endb    _cstor

_dstor:         newb    dstor,'!'
                pop     bx
                pop     word [bx+2]
                pop     word [bx]
                endb    _dstor

_aat:           newb    aat,'?'
                pop     es
                pop     bx
                push    word [es:bx]
                push    cs
                pop     es
                endb    _aat

_acat:          newb    acat,'?'
                pop     es
                pop     bx
                mov     al,[es:bx]
                xor     ah,ah
                push    ax
                push    cs
                pop     es
                endb    _acat

_astor:         newb    astor,'!'
                pop     es
                pop     bx
                pop     word [es:bx]
                push    cs
                pop     es
                endb    _astor

_acstor:        newb    acstor,'!'
                pop     es
                pop     bx
                pop     ax
                mov     [es:bx],al
                push    cs
                pop     es
                endb    _acstor

_scan:          newb    scan,'*>'
                pop     bx
                inc     word [bx]
                mov     bx,[bx]
                mov     bl,[bx-1]
                xor     bh,bh
                push    bx
                endb    _scan

_dscan:         newb    dscan,'**>'
                pop     bx
                inc     word [bx]
                inc     word [bx]
                mov     bx,[bx]
                push    word [bx-2]
                endb    _dscan

_scans:         newb    scans,'!*>'
                pop     bx
                pop     ax
                inc     word [bx]
                mov     bx,[bx]
                mov     [bx-1],al
                endb    _scans

_dscans:        newb    dscans,'!**>'
                pop     bx
                inc     word [bx]
                inc     word [bx]
                mov     bx,[bx]
                pop     word [bx-2]
                endb    _dscans

_tstack:        newb    tstack,'>[]'
                pop     bx
                dec     word [bx]
                mov     bx,[bx]
                pop     word [bx]
                endb    _tstack

_frstck:        newb    frstck,'[]>'
                pop     bx
                inc     word [bx]
                mov     bx,[bx]
                push    word [bx-2]
                endb    _frstck

_inport:        newb    inport,'>'
                pop     dx
                in      al,dx
                xor     ah,ah
                push    ax
                endb    _inport

_outport:       newb    outport,'>'
                pop     dx
                pop     ax
                out     dx,al
                endb    _outport

;                  

_rpat:          newb    rpat,'?'
                push    bp
                endb    _rpat

_rpstor:        newb    rpstor,'!'
                pop     bp
                endb    _rpstor

_tor:           newb    tor,'>'
                dec     bp
                dec     bp
                pop     word [bp]
                endb    _tor

_fromr:         newb    fromr,'>'
                push    word [bp]
                inc     bp
                inc     bp
                endb    _fromr

_rat:           newb    rat,'?'
                push    word [bp]
                endb    _rat

_rat2:          newb    rat2,'??'
                push    word [bp+2]
                endb    _rat2

_rdrop:         newb    rdrop,'>>'
                inc     bp
                inc     bp
                endb    _rdrop

;                

                cnst    zero,'0',0
                cnst    one,'1',1
                cnst    two,'2',2

_stod:          newb    stod,''
                pop     ax
                cwd
                push    ax
                push    dx
                endb    _stod

_twop:          newb    twop,'2+'
                pop     ax
                add     ax,2
                push    ax
                endb    _twop

_twomul:        newb    twomul,'2*'
                pop     ax
                shl     ax,1
                push    ax
                endb    _twomul

_onep:          newb    onep,'1+'
                pop     ax
                inc     ax
                push    ax
                endb    _onep

_twom:          newb    twom,'2-'
                pop     ax
                sub     ax,2
                push    ax
                endb    _twom

_onem:          newb    onem,'1-'
                pop     ax
                dec     ax
                push    ax
                endb    _onem

_plus:          newb    plus,'+'
                pop     ax
                pop     bx
                add     ax,bx
                push    ax
                endb    _plus

_dplus:         newb    dplus,'+'
                pop     dx
                pop     ax
                pop     cx
                pop     bx
                add     ax,bx
                adc     dx,cx
                push    ax
                push    dx
                endb    _dplus

_umul:          newb    umul,'*'
                pop     ax
                pop     cx
                mul     cx
                push    ax
                push    dx
                endb    _umul

_mmul:          newb    mmul,'*'
                pop     ax
                pop     cx
                imul    cx
                push    ax
                push    dx
                endb    _mmul

_pmul:          newb    pmul,'*'
                pop     cx
                pop     ax
                mul     cx
                mov     bx,ax
                pop     ax
                mul     cx
                add     dx,bx
                push    ax
                push    dx
                endb    _pmul

_smul:          newb    smul,'*'
                pop     ax
                pop     cx
                imul    cx
                push    ax
                endb    _smul

_dmul:          newb    dmul,'*'
                mov     bx,sp
                pop     ax
                mul     word [bx+6]
                mov     cx,ax
                mov     ax,[bx+2]
                mul     word [bx+4]
                add     cx,ax
                pop     ax
                inc     sp
                inc     sp
                pop     bx
                mul     bx
                add     dx,cx
                push    ax
                push    dx
                endb    _dmul

_divmod:        newb    divmod,'/'
                xor     dx,dx
                pop     cx
                pop     ax
                idiv    cx
                push    dx
                push    ax
                endb    _divmod

_sdiv:          newb    sdiv,'/'
                xor     dx,dx
                pop     cx
                pop     ax
                idiv    cx
                push    ax
                endb    _sdiv

_mod:           newf    smod,''
                dw      divmod,drop
                endf    _mod

_muldiv:        newb    muldiv,'*/'
                pop     cx
                pop     bx
                pop     ax
                imul    bx
                idiv    cx
                push    ax
                endb    _muldiv

_minus:         newb    minus,'-'
                pop     bx
                pop     ax
                sub     ax,bx
                push    ax
                endb    _minus

_pstor:         newb    pstor,'+!'
                pop     ax
                pop     bx
                add     [bx],ax
                endb    _pstor

_mstor:         newb    mstor,'-!'
                pop     ax
                pop     bx
                sub     [bx],ax
                endb    _mstor

_incr:          newb    incr,'++'
                pop     bx
                inc     word [bx]
                endb    _incr

_decr:          newb    decr,'--'
                pop     bx
                dec     word [bx]
                endb    _decr

_neg:           newb    sneg,'-'
                pop     ax
                neg     ax
                push    ax
                endb    _neg

_dneg:          newb    dneg,'-'
                pop     ax
                pop     dx
                not     dx
                not     ax
                inc     dx
                adc     ax,0
                push    dx
                push    ax
                endb    _dneg

_udiv:          newb    udiv,'%'
                pop     cx
                pop     dx
                pop     ax
                div     cx
                push    dx
                push    ax
                endb    _udiv

_msmod:         newf    msmod,'%'
                dw      tor,zero,rat,udiv,fromr,swap,tor,udiv,fromr
                endf    _msmod

;                

                cnst    true,'',-1
                cnst    false,'',0
                cnst    yes,'',-1
                cnst    no,'',0

_equal:         newb    equal,'='
                pop     ax
                pop     bx
                cmp     ax,bx
                je      equal1
                push    0
                jmp     word [tnext]
equal1:         push    -1
                endb    _equal

_dequal:        newb    dequal,'='
                pop     ax
                pop     dx
                pop     bx
                pop     cx
                cmp     ax,bx
                jne     dequal1
                cmp     cx,dx
                jne     dequal1
                push    -1
                jmp     word [tnext]
dequal1:        push    0
                endb    _dequal

_ateq:          newb    ateq,'?='
                pop     ax
                pop     bx
                mov     bx,[bx]
                cmp     ax,bx
                je      ateq1
                push    0
                jmp     word [tnext]
ateq1:          push    -1
                endb    _ateq

_cateq:         newb    cateq,'?='
                pop     ax
                pop     bx
                mov     bx,[bx]
                cmp     ax,bx
                je      cateq1
                push    0
                jmp     word [tnext]
cateq1:         push    -1
                endb    _cateq

_atateq:        newb    atateq,'??='
                pop     bx
                mov     ax,[bx]
                pop     bx
                mov     bx,[bx]
                cmp     ax,bx
                je      atateq1
                push    0
                jmp     word [tnext]
atateq1:        push    -1
                endb    _atateq

_catateq:       newb    catateq,'??='
                pop     bx
                mov     ax,[bx]
                pop     bx
                mov     bx,[bx]
                cmp     al,bl
                je      catateq1
                push    0
                jmp     word [tnext]
catateq1:       push    -1
                endb    _catateq

_qequal:        newb    qequal,'=='
                pop     ax
                pop     bx
                cmp     ax,bx
                je      qequal1
                push    bx
                push    0
                jmp     word [tnext]
qequal1:        push    -1
                endb    _qequal

_nequal:        newb    nequal,'<>'
                pop     ax
                pop     bx
                cmp     ax,bx
                jne     nequal1
                push    0
                jmp     word [tnext]
nequal1:        push    -1
                endb    _nequal

_min:           newb    min,''
                pop     ax
                pop     bx
                cmp     ax,bx
                jle     min1
                xchg    ax,bx
min1:           push    ax
                endb    _min

_max:           newb    max,''
                pop     ax
                pop     bx
                cmp     ax,bx
                jge     max1
                xchg    ax,bx
max1:           push    ax
                endb    _max

_invr:          newb    invr,''
                pop     ax
                not     ax
                push    ax
                endb    _invr

_not:           newb    lnot,''
                pop     ax
                or      ax,ax
                jz      lnot1
                push    0
                jmp     word [tnext]
lnot1:          push    -1
                endb    _not

_or:            newb    lor,''
                pop     ax
                pop     bx
                or      ax,bx
                push    ax
                endb    _or

_and:           newb    land,''
                pop     ax
                pop     bx
                and     ax,bx
                push    ax
                endb    _and

_xor:           newb    lxor,'(+)'
                pop     ax
                pop     bx
                xor     ax,bx
                push    ax
                endb    _xor

_less:          newb    less,'<'
                pop     ax
                pop     bx
                cmp     bx,ax
                jl      less1
                push    0
                jmp     word [tnext]
less1:          push    -1
                endb    _less

_big:           newb    big,'>'
                pop     ax
                pop     bx
                cmp     bx,ax
                jg      big1
                push    0
                jmp     word [tnext]
big1:           push    -1
                endb    _big

_ulss:          newb    ulss,'<'
                pop     ax
                pop     bx
                cmp     bx,ax
                jc      ulss1
                push    0
                jmp     word [tnext]
ulss1:          push    -1
                endb    _ulss

_ubig:          newb    ubig,'>'
                pop     ax
                pop     bx
                cmp     ax,bx
                jc      ubig1
                push    0
                jmp     word [tnext]
ubig1:          push    -1
                endb    _ubig

_zless:         newf    zless,'<0'
                dw      zero,less
                endf    _zless

_zbig:          newf    zbig,'>0'
                dw      zero,big
                endf    _zbig

_zequ:          newf    zequ,'=0'
                dw      lnot
                endf    _zequ

_abs:           newf    sabs,'||'
                dw      sdup,zless,zbran,abs1-$,sneg
abs1:           endf    _abs

_dabs:          newf    dabs,'||'
                dw      sdup,zless,zbran,dabs1-$,dneg
dabs1:          endf    _dabs

_rnd:           newb    rnd,''
                mov     dx,ds
                mov     ax,40h
                mov     ds,ax
                add     bx,[ds:6Ch]
                mov     ds,dx
                in      al,41h
                add     bh,al
                in      al,41h
                add     bl,al
                in      al,40h
                add     bh,al
                in      al,40h
                add     bl,al
                in      al,0
                add     ah,al
                in      al,0
                mov     cx,[rnd1]
                add     ax,cx
                and     cx,3
rep             ror     bx,1
                mov     [rnd2],bx
                mul     bx
                add     ax,[rnd2]
                push    ax
                mov     [rnd1],ax
                jmp     word [tnext]
rnd1:           dw      5555
rnd2:           dw      1212
                dw      _rnd-$

;                 

_dpstor:        newb    dpstor,'!'
                pop     di
                endb    _dpstor

_here:          newb    here,''
                push    di
                endb    _here

_neww:          newb    neww,''
                mov     ax,di
                inc     ax
                inc     ax
                push    ax
                endb    _neww

_pad:           newb    pad,''
                mov     ax,di
                add     ax,100
                push    ax
                endb    _pad

_allot:         newb    allot,''
                pop     ax
                add     di,ax
                endb    _allot

_dallot:        newb    dallot,''
                pop     ax
                sub     di,ax
                endb    _dallot

_comma:         newb    comma,','
                pop     ax
                stosw
                endb    _comma

_ccomm:         newb    ccomm,','
                pop     ax
                stosb
                endb    _ccomm

_comp:          newb    comp,'()'
                cld
                lodsw
                stosw
                endb    _comp

_tcod:          newb    tcod,'>'
                pop     bx
                mov     al,[bx]
                xor     ah,ah
                add     bx,ax
                inc     bx
                inc     bx
                push    bx
                endb    _tcod

_tname:         newb    tname,'>'
                pop     bx
                mov     al,32
                dec     bx
tname1:         dec     bx
                cmp     [bx],al
                jnc     tname1
                push    bx
                endb    _tname

;               /

                var     temit,'>(.)',emitb
                var     lns,'',12

                cnst    cr,'',13
                cnst    lf,'',10
                cnst    blank,'',32

;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
_fnt8x16:       dr 9,"816",0
fnt8x16:
                call [tnext]
.value:
                file "8X16.FNT"
                dw _fnt8x16-$               

_fnt8x8:        dr 8,"88",0
fnt8x8:
                call [tnext]
.value:
                file "8X8.FNT"
                dw _fnt8x8-$               

_setvideo:      newb setvideo,"!"
                pop     ax
                xor     ah,ah
                int     10h
                endb _setvideo
                
_setfont:       newb setfont,"!"
                pop     bx
                pop     dx
                pop     es
                push    bp
                shl     bx,8
                mov     bp,dx
                mov     cx,255                 
                xor     dx,dx                  
                mov     ax,1110h
                int     10h
                mov     ax,cs
                pop     bp
                mov     es,ax
                endb _setfont       
                
_rus:           newf rus,"RUS"
                dw lit,3,setvideo,segm,fnt8x16,lit,16,setfont
                endf _rus                            
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;-----------------------------------------------------------------------
CL_EXT          equ     0
CL_KEY          equ     3AH
LS_EXT          equ     0
LS_KEY          equ     2AH
LC_EXT          equ     0
LC_KEY          equ     1DH
LA_EXT          equ     0
LA_KEY          equ     38H
RA_EXT          equ     0E0H
RA_KEY          equ     38H
RC_EXT          equ     0E0H
RC_KEY          equ     1DH
RS_EXT          equ     0
RS_KEY          equ     36H
;-----------------------------------------------------------------------
DEXT_CODE       equ     RC_EXT                  ; DEFAULT SWITCH
DKEY_CODE       equ     RC_KEY                  ; RIGHT CTRL
;-----------------------------------------------------------------------
_int9:          newb    int9,'INT9' ;   CKD! by SkullC0DEr
                push    ds
                push    40h
                pop     ds
                pusha
                in      al,60h
                mov     bx,RUS_LAT
                mov     ah,[cs:bx]
                test    ah,01001000b            ; is ext code alr pressed?
                jnz     int09_5                 ; or not used?
sm_code_2:
                cmp     al,DEXT_CODE            ; is ext code?
                jnz     int09_6
                xor     ah,01000000b            ; set ext code flag
                jmp     int09_7
int09_5:
                xor     ah,01000000b            ; clear ext code flag
sm_code_3:
                cmp     al,DKEY_CODE            ; is switch key pressed?
                jnz     int09_6
                test    ah,00100000b            ; is end code?
                jz      int09_8
                or      ah,00010000b            ; set repeat flag
int09_8:
                or      ah,00100000b            ; set end code flag
                jmp     int09_7
int09_6:
                test    ah,00100000b            ; waiting for end code?
                jz      int09_7
                xor     ah,00100000b            ; clear ext code flag
sm_code_4:
                cmp     al,DKEY_CODE or 80h     ; is end code?
                jnz     int09_7
                test    ah,00010000b            ; repeating?
                jz      int09_9
                xor     ah,00010000b            ; reset repeat flag
                jmp     int09_7
int09_9:
                xor     ah,10000000b            ; switch rus/lat
        ;-setup-nu-val--
int09_7:
                mov     [cs:bx],ah
        ;-decoder-proc--
                mov     si,[ds:1ch]
int09_skip:
                pushf
                db      09ah                    ; call far
int09_old:      db      'hack'
                cmp     si,[ds:1ch]             ; keyboard tail
                jz      int09_ex
                test    ah,10000000b            ; check rus/lat flag
                jz      int09_ex
        ;-decode--------
                mov     ax,[ds:si]
                xor     bx,bx
                sub     ah,3
                cmp     ah,35h-3                ; is in range?
                ja      int09_ex
                cmp     al,20h                  ; no alt or ctrl?
                jbe     int09_ex
                mov     al,[ds:17h]    ; shift flag
                test    al,3                    ; is shift pressed?
                jz      int09_1
                xor     bl,TAB_LEN/2
int09_1:
                cmp     ah,0Eh-3                ; digits?
                jb      int09_2
                test    al,40h                  ; caps locked?
                jz      int09_2
                xor     bl,TAB_LEN/2
int09_2:
                mov     al,ah
                add     bx,KEY_RUS; - TSR_DATA
                xlat    [cs:bx]                 ; parse nu ascii code
                or      al,al
                jz      int09_ex
                cmp     al,0F0h                 ; ''?
                jz      int09_10
                cmp     al,0E0h                 ; ''?
                jnz     int09_4
int09_10:
                mov     byte [ds:si+1],0    ; fuckin' bios :-E~~~
int09_4:
                mov     byte [ds:si],al     ; replace old ascii
int09_ex:
                xor     byte [ds:3Eh],1     ; reset detection flag
                popa
                pop     ds
                iret
;-----------------------------------------------------------------------
RUS_LAT         db      10000000B
; RUSSIAN ---------------
; EXT KEY PRESSED --------
; WAIT FOR END CODE -------
; KEY REPEATED -------------
; EXT KEY NOT USED ----------
;-----------------------------------------------------------------------
KEY_RUS         db      '234567890-=',0,0       ; STANDART
                dr      '',0,0      
                dr      '',0,0,0
                dr      ''
                db      '"#$:,.;()_+',0,0
                dr      '',0,0
                dr      '',0,0,0
                dr      'ި'
TAB_LEN         =       $-KEY_RUS
;-----------------------------------------------------------------------
KEY_UKR         db      '234567890-=',0,0       ; UKRAINIAN
                dr      "'",0,0
                dr      '',0,0,0
                dr      'i'
                db      '"#$:,.;()_+',0,0
                dr      "'",0,0
                dr      'ƪ',0,0,0
                dr      'Iޯ'
;-----------------------------------------------------------------------
                endb    _int9
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

_emitb:         newb    emitb,'(.)'
                pop     bx
                pop     ax
                push    bx
                mov     ah,0eh
                int     10h
                ret
                dw      _emitb-$

_emit:          newb    emit,'.'
                call    word [temit.value]
                endb    _emit

_key:           newb    key,''
                mov     ah,0
                int     16h
                xor     ah,ah
                push    ax
                endb    _key

_keyp:          newb    keyp,'?'
                xor     bx,bx
                mov     ah,1
                int     16h
                jz      _keyp1
                not     bx
_keyp1:         push    bx
                endb    _keyp

_phex:          newb    phex,'.'
                pop     dx
                xor     ax,ax
                mov     al,dh
                shr     al,4
                call    hex1
                mov     al,dh
                and     al,15
                call    hex1
                mov     al,dl
                shr     al,4
                call    hex1
                mov     al,dl
                and     al,15
                call    hex1
                jmp     word [tnext]
hex1:           add     al,90h
                daa
                adc     al,40h
                daa
                push    ax
                call    word [temit.value]
                ret
                dw      _phex-$

_phbt:          newb    phbt,'.'
                pop     ax
                xor     ah,ah
                mov     dl,al
                shr     al,4
                add     al,90h
                daa
                adc     al,40h
                daa
                push    ax
                call    word [temit.value]
                mov     al,dl
                and     al,15
                add     al,90h
                daa
                adc     al,40h
                daa
                push    ax
                call    word [temit.value]
                endb    _phbt

_str:           newb    pstr,'.'
                pop     bx
                push    si
                mov     si,bx
                mov     cl,[si]
                xor     ch,ch
                jcxz    str2
                inc     si
str1:           lodsb
                xor     ah,ah
                push    ax
                call    word [temit.value]
                loop    str1
str2:           pop     si
                endb    _str

_prn:           newb    prn,''
                pop     bx
                push    si
                mov     si,bx
prn1:           lodsb
                or      al,al
                jz      prn2
                xor     ah,ah
                push    ax
                call    word [temit.value]
                jmp     prn1
prn2:           pop     si
                endb    _prn

_prl:           newb    prl,'(.")'
                cld
                lodsb
                mov     cl,al
                xor     ch,ch
_prl1:          lodsb
                xor     ah,ah
                push    ax
                call    word [temit.value]
                loop    _prl1
                endb    _prl

_crlf:          newf    crlf,''
                dw      cr,emit,lf,emit
                endf    _crlf

_space:         newf    spc,''
                dw      blank,emit
                endf    _space

;                     

_xdo:           newb    xdo,'()'
                pop     ax
                sub     bp,2
                pop     word [bp]
                sub     bp,2
                mov     [bp],ax
                endb    _xdo

_xloop:         newb    xloop,'()'
                inc     word [bp]
                mov     ax,[bp]
                cmp     ax,[bp+2]
                jg      xloop1
                add     si,[si]
                jmp     word [tnext]
xloop1:         add     si,2
                add     bp,4
                endb    _xloop

_xuloop:        newb    xuloop,'(||)'
                inc     word [bp]
                mov     ax,[bp]
                cmp     ax,[bp+2]
                jnc     xuloop1
                add     si,[si]
                jmp     word [tnext]
xuloop1:        add     si,2
                add     bp,4
                endb    _xuloop

_xploop:        newb    xploop,'(+)'
                pop     ax
                add     [bp],ax
                cmp     ax,0
                mov     ax,[bp]
                jle     xploop1
                cmp     ax,[bp+2]
                jmp     xploop2
xploop1:        cmp     [bp+2],ax
xploop2:        jg      xploop3
                add     si,[si]
                jmp     word [tnext]
xploop3:        add     si,2
                add     bp,4
                endb    _xploop

_ldo:           newf    ldo,'',immed
                dw      comp,xdo,here
                endf    _ldo

_lloop:         newf    lloop,'',immed
                dw      comp,xloop,here,minus,comma
                endf    _lloop

_uloop:         newf    uloop,'||',immed
                dw      comp,xuloop,here,minus,comma
                endf    _uloop

_ploop:         newf    ploop,'+',immed
                dw      comp,xploop,here,minus,comma
                endf    _ploop

_lif:           newf    lif,'',immed
                dw      comp,zbran,here,zero,comma
                endf    _lif

_lifnot:        newf    lifnot,'_',immed
                dw      comp,lnot,comp,zbran,here,zero,comma
                endf    _lifnot

_lthen:         newf    lthen,'',immed
                dw      here,over,minus,swap,stor
                endf    _lthen

_lelse:         newf    lelse,'',immed
                dw      comp,bran,here,zero,comma,swap,lthen
                endf    _lelse

_beg:           newf    beg,'',immed
                dw      here
                endf    _beg

_until:         newf    until,'?',immed
                dw      comp,zbran,here,minus,comma
                endf    _until

_rept:          newf    repeat_,'',immed
                dw      comp,bran,swap,here,minus,comma,lthen
                endf    _rept

;                

_count:         newb    count,''
                pop     bx
                mov     al,[bx]
                xor     ah,ah
                inc     bx
                push    bx
                push    ax
                endb    _count

_move:          newb    move,'<'
                pop     cx
                mov     dx,si
                mov     bx,di
                pop     di
                pop     si
                cld
rep             movsb
                mov     si,dx
                mov     di,bx
                endb    _move

_bmove:         newb    bmove,'>'
                pop     cx
                mov     dx,si
                mov     bx,di
                pop     di
                pop     si
                add     di,cx
                add     si,cx
                dec     si
                dec     di
                std
rep             movsb
                cld
                mov     si,dx
                mov     di,bx
                endb    _bmove

_amove:         newb    amove,'<<'
                pop     cx
                mov     dx,si
                mov     bx,di
                pop     ds
                pop     di
                pop     es
                pop     si
                cld
rep             movsb
                mov     si,dx
                mov     di,bx
                mov     bx,cs
                mov     ds,bx
                mov     es,bx
                endb    _amove

_abmove:        newb    abmove,'>>'
                pop     cx
                mov     dx,si
                mov     bx,di
                pop     ds
                pop     di
                pop     es
                pop     si
                add     di,cx
                add     si,cx
                dec     si
                dec     di
                std
rep             movsb
                cld
                mov     si,dx
                mov     di,bx
                mov     bx,cs
                mov     ds,bx
                mov     es,bx
                endb    _abmove

_fill:          newb    fill,''
                mov     dx,di
                pop     ax
                pop     cx
                pop     di
                cld
rep             stosb
                mov     di,dx
                endb    _fill

_tasc:          newb    tasc,'>0'
                pop     bx
                mov     cl,[bx]
                xor     ch,ch
                push    si
                push    di
                mov     di,bx
                mov     si,bx
                inc     si
                cld
rep             movsb
                mov     [di],ch
                pop     di
                pop     si
                endb    _tasc

_strl:          newb    strl,'?0'
                mov     bx,di
                pop     dx
                mov     di,dx
                cld
                xor     al,al
strl1:          scasb
                jne     strl1
                dec     di
                sub     di,dx
                push    di
                mov     di,bx
                endb    _strl

_plssz:         newb    plssz,'+0'
                mov     bx,si
                mov     dx,di
                pop     si
                pop     di
                cld
                xor     ax,ax
plssz1:         scasb
                jne     plssz1
                dec     di
plssz2:         lodsb
                stosb
                or      al,al
                jnz     plssz2
                mov     si,bx
                mov     di,dx
                endb    _plssz

_estrz:         newb    estrz,'=0'
                mov     dx,di
                mov     bx,si
                pop     si
                pop     di
estrz1:         lodsb
                scasb
                jne     estrz2
                or      al,al
                jnz     estrz1
                push    -1
                jmp     estrz3
estrz2:         push    0
estrz3:         mov     di,dx
                mov     si,bx
                endb    _estrz

_estr:          newb    estr,'='
                push    bp
                mov     bp,sp
                push    si
                push    di
                mov     si,[bp+2]
                mov     di,[bp+4]
                mov     cl,[si]
                xor     ch,ch
                cmpsb
                jne     estrf
                jcxz    estrt
repe            cmpsb
                jne     estrf
estrt:          mov     ax,-1
                jmp     estrq
estrf:          xor     ax,ax
estrq:          pop     di
                pop     si
                pop     bp
                add     sp,4
                push    ax
                endb    _estr

_lstr:          newb    lstr,'(")'
                push    si
                cld
                lodsb
                xor     ah,ah
                add     si,ax
                endb    _lstr

_astr:          newb    astr,'(")'
                push    si
                xchg    di,si
                cld
                xor     al,al
astr1:          scasb
                jne     astr1
                xchg    di,si
                endb    _astr

_qw:            newf    qw,'"',immed
                dw      blank,wrd,neww,onep,cat
                dw      state,at_,zbran,qw1-$
                dw      comp,lit,comma
qw1:            endf    _qw

_dqw:           newf    dqw,'."',immed
                dw      lit,34,wrd,state,at_,zbran,dqw1-$
                dw      comp,prl,here,cat,onep,allot,exit
dqw1:           dw      neww,pstr
                endf    _dqw

_qwot:          newf    qwot,'"',immed
                dw      lit,34,wrd,state,at_,zbran,qwot1-$
                dw      comp,lstr,here,cat,onep,allot,exit
qwot1:          dw      neww,fheap,at_,neww,cat,onep,move,fheap,at_
                endf    _qwot

_aqwot:         newf    aqwot,'"',immed
                dw      lit,34,wrd,state,at_,zbran,aqwot1-$
                dw      comp,astr,here,sdup,cat,onep,allot,tasc,exit
aqwot1:         dw      neww,onep,fheap,at_,neww,cat,onep,move,fheap,at_
                endf    _aqwot

_prnl:          newf    prnl,'.?'
                dw      zbran,prnl1-$,prl
                nstr    ''
                dw      exit
prnl1:          dw      prl
                nstr    ''
                endf    _prnl

;               / 

                var     base,'',10
                var     dpl,''

_emits:         newf    emits,''
                dw      sdup,zbig,lnot,zbran,emits2-$
                dw      ddrop,exit
emits2:         dw      one,xdo
emits1:         dw      sdup,emit,xloop,emits1-$
                dw      drop
                endf    _emits

_spaces:        newf    spcs,''
                dw      sdup,zbig,lnot,zbran,spcs2-$
                dw      drop,exit
spcs2:          dw      one,xdo
spcs1:          dw      spc,xloop,spcs1-$
                endf    _spaces

_decim:         newf    decim,''
                dw      lit,10,base,stor
                endf    _decim

_hex:           newf    hex,''
                dw      lit,16,base,stor
                endf    _hex

_isdig:         newb    isdig,'?'
                pop     ax
                pop     cx
                sub     cx,30h
                jl      isdig1
                cmp     cx,9
                jle     isdig2
                sub     cx,7
                cmp     cx,10
                jl      isdig1
isdig2:         cmp     cx,ax
                jge     isdig1
                push    cx
                push    0
                push    -1
                jmp     word [tnext]
isdig1:         push    0
                endb    _isdig

_pref:          newb    pref,'?'
                pop     cx
                pop     bx
                xor     ax,ax
                cmp     byte [bx],'+'
                jne     pref1
                mov     cx,10
                jmp     pref4
pref1:          cmp     byte [bx],'-'
                jne     pref2
                mov     cx,10
                not     ax
                jmp     pref4
pref2:          cmp     byte [bx],'#'
                jne     pref3
                mov     cx,16
                jmp     pref4
pref3:          cmp     byte [bx],39
                jne     pref5
                mov     cx,2
pref4:          inc     bx
pref5:          push    bx
                push    cx
                push    ax
                endb    _pref

_numb:          newf    numb,''
                dw      false,dpl,stor,base,at_,pref
                dw      tor,tor,here,stor,zero,zero
numb3:          dw      here,scan,sdup,zbran,numb1-$
                dw      lit,'.',qequal,zbran,numb5-$
                dw      dpl,at_,lnot,zbran,numb2-$
                dw      true,dpl,stor,bran,numb3-$
numb5:          dw      rat,isdig,zbran,numb2-$
                dw      dswap,rat,pmul,dplus,bran,numb3-$
numb2:          dw      ddrop,rdrop,rdrop,false,exit
numb1:          dw      drop,rdrop,fromr,zbran,numb4-$,dneg
numb4:          dw      true
                endf    _numb

_hold:          newb    hold,'>'
                mov     bx,[di]
                pop     ax
                dec     bx
                mov     [bx],al
                mov     [di],bx
                endb    _hold

_bdigs:         newf    bdigs,'<#'
                dw      pad,here,stor
                endf    _bdigs

_edigs:         newf    edigs,'#>'
                dw      ddrop,pad,here,at_,minus,hold
                endf    _edigs

_sgn:           newf    sgn,''
                dw      rot,zless,zbran,sgn1-$
                dw      lit,'-',hold
sgn1:           endf    _sgn

_dig:           newf    dig,'#'
                dw      base,at_,msmod,rot,lit,9,over
                dw      less,zbran,dig1-$,lit,7,plus
dig1:           dw      lit,30h,plus,hold
                endf    _dig

_digs:          newf    digs,'##'
digs1:          dw      dig,ddup,lor,lnot,zbran,digs1-$
                endf    _digs

_ddr:           newf    ddr,'..>'
                dw      tor,swap,over,dabs,bdigs,digs,sgn,edigs
                dw      here,at_,sdup,cat,fromr,swap,minus
                dw      spcs,pstr
                endf    _ddr

_ddz:           newf    ddz,'0..'
                dw      tor,swap,over,dabs,bdigs,digs,sgn,edigs
                dw      here,at_,sdup,cat,fromr,swap,minus
                dw      lit,'0',swap,emits,pstr
                endf    _ddz

_ddot:          newf    ddot,'..'
                dw      zero,ddr
                endf    _ddot

_dr:            newf    drr,'.>'
                dw      tor,stod,fromr,ddr
                endf    _dr

_dz:            newf    dz,'0.'
                dw      tor,stod,fromr,ddz
                endf    _dz

_dot:           newf    dot,'.'
                dw      stod,ddot
                endf    _dot

_udot:          newf    udot,'|.|'
                dw      zero,ddot
                endf    _udot

;                

                var     exterr,'+',noop

_err:           newf    error,''
                dw      exterr,at_,exec,crlf,prl
                nstr    ' N '
                dw      dot,abort
                endf    _err

_noram:         newf    noram,'-'
                dw      crlf,prl
                nstr    ' '
                dw      lit,3,error
                endf    _noram

_ntf:           newf    ntf,''
                dw      crlf,nwrd,prl
                nstr    '  !'
                dw      one,error
                endf    _ntf

_nwrd:          newf    nwrd,''
                dw      prl
                nstr    ' '
                dw      neww,pstr
                endf    _nwrd

;                  

                cnst    cjmp,'jmp[]',26ffh
                cnst    ccall,'call[]',16ffh
                cnst    cpush,'push[]',68h

                var     chng,'',false
                var     flet,'1'

_lbr:           newf    lbr,'[',immed
                dw      false,state,stor
                endf    _lbr

_rbr:           newf    rbr,']'
                dw      true,state,stor
                endf    _rbr

_prev:          newb    prev,'>'
                pop     bx
                dec     bx
                dec     bx
                mov     ax,[bx]
                or      ax,ax
                jz      prev1
                add     ax,bx
prev1:          push    ax
                endb    _prev

_find:          newf    find,''
                dw      latest,at_
find2:          dw      sdup,zbran,find1-$
                dw      sdup,neww,estr,zbran,find3-$
                dw      tcod,true,exit
find3:          dw      prev,bran,find2-$
find1:          endf    _find

_prep:          newf    prep,''
                dw      blank,wrd,neww,cat,sdup,zbran,prep1-$
                dw      lit,16,min,neww,cstor
                dw      find,zbran,prep2-$
                dw      drop,chng,at_,zbran,prep2-$
                dw      crlf,prl
                nstr    '    '
                dw      zero,error
prep2:          dw      latest,at_,here,minus,here,stor
                dw      neww,latest,stor
                dw      neww,cat,onep,twop,allot,true
prep1:          endf    _prep

_colon:         newf    colon,':',immed
                dw      prep,zbran,col1-$
                dw      blank,latest,at_,onep,sdup,cat,flet,cstor,cstor
                dw      one,ccomm,ccall,comma,tonest,comma,rbr
col1:           endf    _colon

_semi:          newf    semi,';',immed
                dw      comp,exit,flet,cat,latest,at_,onep,cstor,lbr
                endf    _semi

_crea:          newf    crea,''
                dw      prep,zbran,crea1-$
                dw      zero,ccomm,ccall,comma,tonext,comma
crea1:          endf    _crea

_nvar:          newf    nvar,''
                dw      crea,two,allot
                endf    _nvar

_dvar:          newf    dvar,':'
                dw      crea,lit,4,allot
                endf    _dvar

_nconst:        newf    nconst,''
                dw      prep,zbran,const1-$
                dw      zero,ccomm,cpush,ccomm,comma
                dw      cjmp,comma,tonext,comma
const1:         endf    _nconst

_dconst:        newf    dconst,':'
                dw      prep,zbran,dconst1-$
                dw      zero,ccomm,swap,cpush,ccomm,comma
                dw      cpush,ccomm,comma
                dw      cjmp,comma,tonext,comma
dconst1:        endf    _dconst

_imm:           newf    imm,''
                dw      latest,at_,tcod,onem,sdup,cat
                dw      lit,80h,lor,swap,stor
                endf    _imm

_qimm:          newf    qimm,'?'
                dw      sdup,onem,cat,lit,80h,land
                endf    _qimm

_xdoes:         newf    xdoes,'()'
                dw      fromr,latest,at_,tcod,twop,stor
                endf    _xdoes

_does:          newf    does,':',immed
                dw      comp,xdoes,neww,comma,ccall,comma,tonest,comma
                endf    _does

_recurs:        newf    recurs,'',immed
                dw      latest,at_,tcod,comma
                endf    _recurs

_atrstor:       newf    atrstor,'!'
                dw      onem,cstor
                endf    _atrstor

_atr:           newf    atr,'?'
                dw      onem,cat
                endf    _atr

;                  

                cnst    rd_,'_',0
                cnst    wr,'_',1
                cnst    rw_,'_/',2
                cnst    frmst,'_',0
                cnst    frmcur,'',1
                cnst    frmend,'_',2

_ofile:         newb    ofile,'_'
                pop     ax
                mov     ah,3dh
                pop     dx
                int     21h
                mov     bx,0
                jc      ofile1
                push    ax
                not     bx
ofile1:         push    bx
                endb    _ofile

_cfile:         newb    cfile,'_'
                pop     bx
                mov     ah,3eh
                int     21h
                mov     bx,0
                jc      cfile1
                not     bx
cfile1:         push    bx
                endb    _cfile

_nfile:         newb    nfile,'_'
                pop     cx
                pop     dx
                mov     ah,3ch
                int     21h
                mov     bx,0
                jc      nfile1
                push    ax
                not     bx
nfile1:         push    bx
                endb    _nfile

_wfile:         newb    wfile,'_'
                pop     cx
                pop     ds
                pop     dx
                pop     bx
                mov     ah,40h
                int     21h
                mov     bx,cs
                mov     ds,bx
                mov     bx,0
                jc      wfile1
                not     bx
                push    ax
wfile1:         push    bx
                endb    _wfile

_rfile:         newb    rfile,'_'
                pop     cx
                pop     ds
                pop     dx
                pop     bx
                mov     ah,3fh
                int     21h
                mov     bx,cs
                mov     ds,bx
                mov     bx,0
                jc      rfile1
                push    ax
                not     bx
rfile1:         push    bx
                endb    _rfile

_sfile:         newb    sfile,'*'
                pop     ax
                mov     ah,42h
                pop     cx
                pop     dx
                pop     bx
                int     21h
                mov     bx,0
                jc      sfile1
                push    ax
                push    dx
                not     bx
sfile1:         push    bx
                endb    _sfile

_dfile:         newb    dfile,'_'
                pop     dx
                mov     ah,41h
                int     21h
                mov     bx,0
                jc      dfile1
                not     bx
dfile1:         push    bx
                endb    _dfile

_ffile:         newb    ffile,'?'
                pop     dx
                pop     cx
                mov     ah,4eh
                int     21h
                mov     bx,0
                jc      ffile1
                not     bx
ffile1:         push    bx
                endb    _ffile

_fnext:         newb    fnext,'??'
                mov     ah,2fh
                int     21h
                mov     dx,es
                mov     ds,dx
                mov     dx,bx
                mov     ah,4fh
                int     21h
                mov     bx,cs
                mov     ds,bx
                mov     es,bx
                mov     bx,0
                jc      fnext1
                not     bx
fnext1:         push    bx
                endb    _fnext

;                

                var     tib,''
                var     tibl,'',tbsize
                var     tibp,'>'
                var     wrdp,'>'

_bword:         newb    bword,'()'
                push    bp
                mov     bp,sp
                push    si
                push    di
                mov     ah,[bp+6]
                mov     si,[bp+4]
                mov     si,[si]
                mov     bx,[bp+2]
                mov     di,bx
                inc     di
                mov     dx,0d0ah
bword1:         lodsb
                or      al,al
                jz      bword3
                cmp     al,ah
                je      bword1
                cmp     al,dh
                je      bword1
                cmp     al,dl
                je      bword1
bword2:         stosb
                lodsb
                or      al,al
                jz      bword3
                cmp     al,ah
                je      bword3
                cmp     al,dh
                je      bword3
                cmp     al,dl
                jne     bword2
bword3:         mov     byte [di],0
                dec     di
                sub     di,bx
                mov     ax,di
                mov     [bx],al
                mov     bx,[bp+4]
                mov     [bx],si
                pop     di
                pop     si
                pop     bp
                add     sp,6
                endb    _bword

_word:          newf    wrd,''
                dw      wrdp,neww,bword
                endf    _word

_fnd:           newf    fnd,39,immed  ; '
                dw      blank,wrd,find,lnot,zbran,fnd1-$
                dw      ntf
fnd1:           endf    _fnd

_compa:         newf    compa,'::'
                dw      fnd,comma
                endf    _compa

_compi:         newf    compi,'[::]',immed
                dw      compa
                endf    _compi

_compw:         newf    compw,''
                dw      fnd,comp,comp,comma
                endf    _compw

_comps:         newf    comps,'[]',immed
                dw      compw
                endf    _comps

                var     extint,'+',false

_inter:         newf    inter,''
                dw      wrdp,stor
inter1:         dw      blank,wrd,neww,cat,lnot,zbran,inter2-$,exit
inter2:         dw      find,zbran,inter3-$
                dw      qimm,zbran,inter4-$
inter5:         dw      exec,bran,inter1-$
inter4:         dw      state,at_,zbran,inter5-$
                dw      comma,bran,inter1-$
inter3:         dw      neww,onep,numb,zbran,inter6-$
                dw      dpl,at_,lnot,zbran,inter7-$,drop
inter7:         dw      state,at_,zbran,inter1-$
                dw      dpl,at_,zbran,inter8-$
                dw      swap,comp,lit,comma
inter8:         dw      comp,lit,comma,bran,inter1-$
inter6:         dw      extint,at_,exec,lnot,zbran,inter1-$
                dw      ntf
                dw      _inter-$

_query:         newf    query,''
                dw      onem,over,plus,tor,sdup,tibp,stor
query1:         dw      key,sdup,blank,less,zbran,query2-$
                dw      lit,8,qequal,zbran,query3-$
                dw      tibp,at_,over,big,zbran,query1-$
                dw      tibp,decr
                dw      lit,8,sdup,emit,blank,emit,emit,bran,query1-$
query3:         dw      cr,qequal,zbran,query4-$
                dw      zero,tibp,at_,stor,rdrop,drop,exit
query4:         dw      lnot,zbran,query1-$
                dw      key,drop,bran,query1-$
query2:         dw      tibp,at_,sdup,rat,less,zbran,query5-$
                dw      sdup,onep,tibp,stor,over,emit,stor,bran,query1-$
query5:         dw      ddrop,bran,query1-$
                endf    _query

_quit:          newf    quit,''
quit1:          dw      rp0,at_,rpstor
                dw      state,at_,zbran,quit2-$
                dw      lit,16,bran,quit3-$
quit2:          dw      crlf,lit,'>'
quit3:          dw      emit,blank,emit
                dw      tib,at_,tibl,at_,query
                dw      tib,at_,cat,zbran,quit1-$
                dw      crlf,tib,at_,inter,bran,quit1-$
                dw      _quit-$

_hello:         newf    hello,''
                dw      crlf,prl
                nstr    '##################',13,10
                dw      prl
                nstr    '# - 286 #',13,10
                dw      prl
                nstr    '##################',13,10
                endf    _hello

_abort:         newf    abort,''
                dw      sp0,at_,spstor,lbr,top,at_,task,stor,quit
                dw      _abort-$

                var     fence,'',_bye

_prot:          newf    prot,''
                dw      fnd,tname,fence,stor
                endf    _prot

_forget:        newf    forget,''
                dw      blank,wrd,neww,latest,at_
forget3:        dw      fence,at_,qequal,zbran,forget1-$
                dw      drop,crlf,nwrd,prl
                nstr    ' !'
                dw      two,error
forget1:        dw      sdup,zbran,forget2-$
                dw      sdup,neww,estr,tor,press,sdup,prev
                dw      fromr,zbran,forget3-$
                dw      latest,stor,twom,dpstor,exit
forget2:        dw      drop,ntf
                dw      _forget-$

_undo:          newf    undo,''
                dw      latest,at_,fence,at_,qequal,zbran,undo1-$
                dw      crlf,prl
                nstr    '  !'
                dw      two,error
undo1:          dw      sdup,prev,latest,stor,twom,dpstor
                endf    _undo

_qname:         newf    qname,'?'
                dw      tname,pstr
                endf    _qname

_vlist:         newf    vlist,''
                dw      zero,neww,stor,latest,at_
vlist1:         dw      lns,at_,onem,tor,zero,tor
vlist2:         dw      zero,qequal,zbran,vlist3-$
                dw      rdrop,rdrop,crlf,neww,at_,dot,prl
                nstr    '   '
                dw      exit
vlist3:         dw      crlf,sdup,pstr,neww,one,pstor,prev
                dw      fromr,onep,rat,qequal,zbran,vlist4-$
                dw      rdrop,key,lit,27,equal,zbran,vlist1-$
                dw      crlf,exit
vlist4:         dw      tor,bran,vlist2-$
                dw      _vlist-$

_comm1:         newf    comm1,'(',immed
                dw      lit,')',wrd
                endf    _comm1

_comm2:         newf    comm2,'\',immed
                dw      lit,cr,wrd
                endf    _comm2

_saveb:         newb    saveb,'()'
                pop     dx
                mov     ah,3ch
                mov     cx,0
                int     21h
                jc      saveb1
                mov     bx,ax
                mov     dx,100h
                mov     cx,di
                sub     cx,dx
                mov     ah,40h
                int     21h
                jc      saveb2
                cmp     ax,cx
                jne     saveb2
                mov     ah,3eh
                int     21h
                jc      saveb1
                push    -1
                jmp     word [tnext]
saveb2:         mov     ah,3eh
                int     21h
saveb1:         push    0
                endb    _saveb

_save:          newf    save,''
                dw      blank,wrd,neww,cat,zbran,save1-$
                dw      here,dp0,stor,neww,onep,sdup,astr
                db      '.com',0
                dw      plssz,saveb,lnot,zbran,save1-$
                dw      prl
                nstr    13,10,'  !'
save1:          endf    _save

_bload:         newb    bload,'()'
                pop     bx
                pop     cx
                pop     dx
                mov     ax,3d00h
                int     21h
                jc      bload1
                mov     dx,bx
                mov     bx,ax
                mov     ah,3fh
                int     21h
                mov     dx,ax
                pushf
                mov     ah,3eh
                int     21h
                popf
                jc      bload1
                push    dx
                push    -1
                jmp     word [tnext]
bload1:         push    0
                endb    _bload

_run:           newf    run,''
                dw      blank,wrd,neww,cat,zbran,run2-$
                dw      neww,onep,lit,1024,top,at_,over,minus
                dw      sdup,tor,bload,lnot,zbran,run1-$
                dw      prl
                nstr    13,10,'  !'
                dw      abort
run1:           dw      rat,plus,zero,swap,stor,fromr,inter,abort
run2:           endf    _run

_nauto:         newf    nauto,':'
                dw      fnd,auto,stor
                endf    _nauto

_bye:           newb    bye,'...'
                xor     cx,cx
                mov     ds,cx
                cli
                mov     ax,[cs:int09_old]  
                mov     dx,[cs:int09_old+2]
                mov     word [ds:9*4],ax
                mov     [ds:9*4+2],dx
                sti
                mov     ax,3h
                int     10h
                int     20h
endvoc=$
latest         equ     bye

