INCLUDE         RFORTH.INC

                .MODEL TINY
                .286
                .CODE
                ORG     100H
RFORTH:

;               SP - 㪠⥫ ⥪ ࠬ஢
;               BP - 㪠⥫ ⥪ ⮢
;               SI - 㪠⥫  ᫥饥 믮塞 ᫮
;               DI - 㪠⥫   ᢮  ᫮

SPSIZE          EQU     2048
RPSIZE          EQU     1024
TBSIZE          EQU     70

;               

                MOV     DX,WORD PTR [DP0+4]
                MOV     DI,DX
                ADD     DX,SPSIZE
                MOV     SP,DX
                ADD     DX,RPSIZE
                MOV     BP,DX
                ADD     DX,16
                MOV     WORD PTR [TIB+4],DX
                ADD     DX,WORD PTR [TIBL+4]
                ADD     DX,16
                MOV     WORD PTR [HEAP+4],DX
                MOV     AX,WORD PTR [AUTO+4]
                PUSH    AX
                CALL    WORD PTR [TNEST]
                DW      EXEC,ABORT

;                

                DW      0

;                

_NEST:          NEWB    NEST,''
                DEC     BP
                DEC     BP
                MOV     [BP],SI
                POP     SI
NEXT:           CLD
                LODSW
                JMP     AX
                DW      _NEST-$

_NEXT           DB      4,'',0
                PUSH    OFFSET NEXT
                ENDB    _NEXT

_EXIT:          NEWB    EXIT,''
                JMP     WORD PTR [TEXIT]
                MOV     SI,[BP]
                INC     BP
                INC     BP
                ENDB    _EXIT

_TONEST:        NEWB    TONEST,'>'
                CALL    WORD PTR [TNEXT]
TNEST           DW      OFFSET NEST
                DW      _TONEST-$

_TONEXT:        NEWB    TONEXT,'>'
                CALL    WORD PTR [TNEXT]
TNEXT           DW      OFFSET NEXT
                DW      _TONEXT-$

_TOEXIT:        NEWB    TOEXIT,'>'
                CALL    WORD PTR [TNEXT]
TEXIT           DW      OFFSET EXIT+4
                DW      _TOEXIT-$

;                

_EXEC:          NEWB    EXEC,''
                RET
                DW      _EXEC-$

_SEGM:          NEWB    SEGM,''
                PUSH    CS
                ENDB    _SEGM

_NOOP:          NEWB    NOOP,''
                ENDB    _NOOP

_BRAN:          NEWB    BRAN,''
                ADD     SI,[SI]
                ENDB    _BRAN

_ZBRAN:         NEWB    ZBRAN,'?'
                POP     AX
                OR      AX,AX
                JNZ     ZBRAN1
                ADD     SI,[SI]
                JMP     WORD PTR [TNEXT]
ZBRAN1:         INC     SI
                INC     SI
                ENDB    _ZBRAN

;                

                VAR     DP0,'0',ENDVOC
                VAR     SPL,'>',SPSIZE
                VAR     SP0,'0',ENDVOC+SPSIZE
                VAR     RP0,'0',ENDVOC+SPSIZE+RPSIZE
                VAR     AUTO,'',HELLO
                VAR     STATE,''
                VAR     LATEST,'',_BYE
                VAR     HEAP,'',ENDVOC+SPSIZE+RPSIZE+TBSIZE+32
                VAR     TASK,'',0FFF0H
                VAR     TOP,'',0FFF0H

;                  

_SPAT:          NEWB    SPAT,'?'
                PUSH    SP
                ENDB    _SPAT

_SPSTOR:        NEWB    SPSTOR,'!'
                POP     SP
                ENDB    _SPSTOR

_DUP:           NEWB    SDUP,'!!'
                POP     AX
                PUSH    AX
                PUSH    AX
                ENDB    _DUP

_DDUP:          NEWB    DDUP,'2!!'
                POP     AX
                POP     BX
                PUSH    BX
                PUSH    AX
                PUSH    BX
                PUSH    AX
                ENDB    _DDUP

_DROP:          NEWB    DROP,'>>'
                INC     SP
                INC     SP
                ENDB    _DROP

_PRESS:         NEWB    PRESS,'<<'
                POP     AX
                INC     SP
                INC     SP
                PUSH    AX
                ENDB    _PRESS

_DPRESS:        NEWB    DPRESS,'<<2'
                POP     AX
                POP     BX
                ADD     SP,4
                PUSH    BX
                PUSH    AX
                ENDB    _DPRESS

_DDROP:         NEWB    DDROP,'2>>'
                ADD     SP,4
                ENDB    _DDROP

_SWAP:          NEWB    SWAP,'(2)'
                POP     AX
                POP     BX
                PUSH    AX
                PUSH    BX
                ENDB    _SWAP

_DSWAP:         NEWB    DSWAP,'2(2)'
                POP     AX
                POP     BX
                POP     CX
                POP     DX
                PUSH    BX
                PUSH    AX
                PUSH    DX
                PUSH    CX
                ENDB    _DSWAP

_OVER:          NEWB    OVER,'2^'
                MOV     BX,SP
                MOV     AX,SS:[BX+2]
                PUSH    AX
                ENDB    _OVER

_PICK:          NEWB    PICK,'^'
                POP     AX
                SHL     AX,1
                MOV     BX,SP
                SUB     BX,AX
                MOV     AX,SS:[BX]
                PUSH    AX
                ENDB    _PICK

_ROT:           NEWB    ROT,'(3)'
                POP     AX
                POP     BX
                POP     CX
                PUSH    BX
                PUSH    AX
                PUSH    CX
                ENDB    _ROT

_LIT:           NEWB    LIT,''
                CLD
                LODSW
                PUSH    AX
                ENDB    _LIT

_DLIT:          NEWB    DLIT,'2'
                CLD
                LODSW
                PUSH    AX
                LODSW
                PUSH    AX
                ENDB    _DLIT

_AT:            NEWB    AT,'?'
                POP     BX
                PUSH    [BX]
                ENDB    _AT

_CAT:           NEWB    CAT,'?'
                POP     BX
                MOV     AL,[BX]
                XOR     AH,AH
                PUSH    AX
                ENDB    _CAT

_DAT:           NEWB    DAT,'?'
                POP     BX
                PUSH    [BX]
                PUSH    [BX+2]
                ENDB    _DAT

_STOR:          NEWB    STOR,'!'
                POP     BX
                POP     [BX]
                ENDB    _STOR

_CSTOR:         NEWB    CSTOR,'!'
                POP     BX
                POP     AX
                MOV     [BX],AL
                ENDB    _CSTOR

_DSTOR:         NEWB    DSTOR,'!'
                POP     BX
                POP     [BX+2]
                POP     [BX]
                ENDB    _DSTOR

_AAT:           NEWB    AAT,'?'
                POP     ES
                POP     BX
                PUSH    ES:[BX]
                PUSH    CS
                POP     ES
                ENDB    _AAT

_ACAT:          NEWB    ACAT,'?'
                POP     ES
                POP     BX
                MOV     AL,ES:[BX]
                XOR     AH,AH
                PUSH    AX
                PUSH    CS
                POP     ES
                ENDB    _ACAT

_ASTOR:         NEWB    ASTOR,'!'
                POP     ES
                POP     BX
                POP     ES:[BX]
                PUSH    CS
                POP     ES
                ENDB    _ASTOR

_ACSTOR:        NEWB    ACSTOR,'!'
                POP     ES
                POP     BX
                POP     AX
                MOV     ES:[BX],AL
                PUSH    CS
                POP     ES
                ENDB    _ACSTOR

_SCAN:          NEWB    SCAN,'*>'
                POP     BX
                INC     WORD PTR [BX]
                MOV     BX,[BX]
                MOV     BL,[BX-1]
                XOR     BH,BH
                PUSH    BX
                ENDB    _SCAN

_DSCAN:         NEWB    DSCAN,'**>'
                POP     BX
                INC     WORD PTR [BX]
                INC     WORD PTR [BX]
                MOV     BX,[BX]
                PUSH    [BX-2]
                ENDB    _DSCAN

_SCANS:         NEWB    SCANS,'!*>'
                POP     BX
                POP     AX
                INC     WORD PTR [BX]
                MOV     BX,[BX]
                MOV     [BX-1],AL
                ENDB    _SCANS

_DSCANS:        NEWB    DSCANS,'!**>'
                POP     BX
                INC     WORD PTR [BX]
                INC     WORD PTR [BX]
                MOV     BX,[BX]
                POP     [BX-2]
                ENDB    _DSCANS

_TSTACK:        NEWB    TSTACK,'>[]'
                POP     BX
                DEC     WORD PTR [BX]
                MOV     BX,[BX]
                POP     [BX]
                ENDB    _TSTACK

_FRSTCK:        NEWB    FRSTCK,'[]>'
                POP     BX
                INC     WORD PTR [BX]
                MOV     BX,[BX]
                PUSH    [BX-2]
                ENDB    _FRSTCK

_INPORT:        NEWB    INPORT,'>'
                POP     DX
                IN      AL,DX
                XOR     AH,AH
                PUSH    AX
                ENDB    _INPORT

_OUTPORT:       NEWB    OUTPORT,'>'
                POP     DX
                POP     AX
                OUT     DX,AL
                ENDB    _OUTPORT

;                  

_RPAT:          NEWB    RPAT,'?'
                PUSH    BP
                ENDB    _RPAT

_RPSTOR:        NEWB    RPSTOR,'!'
                POP     BP
                ENDB    _RPSTOR

_TOR:           NEWB    TOR,'>'
                DEC     BP
                DEC     BP
                POP     [BP]
                ENDB    _TOR

_FROMR:         NEWB    FROMR,'>'
                PUSH    [BP]
                INC     BP
                INC     BP
                ENDB    _FROMR

_RAT:           NEWB    RAT,'?'
                PUSH    [BP]
                ENDB    _RAT

_RAT2:          NEWB    RAT2,'??'
                PUSH    [BP+4]
                ENDB    _RAT2

_RDROP:         NEWB    RDROP,'>>'
                INC     BP
                INC     BP
                ENDB    _RDROP

;                

                CNST    ZERO,'0',0
                CNST    ONE,'1',1
                CNST    TWO,'2',2

_STOD:          NEWB    STOD,''
                POP     AX
                CWD
                PUSH    AX
                PUSH    DX
                ENDB    _STOD

_TWOP:          NEWB    TWOP,'2+'
                POP     AX
                ADD     AX,2
                PUSH    AX
                ENDB    _TWOP

_TWOMUL:        NEWB    TWOMUL,'2*'
                POP     AX
                SHL     AX,1
                PUSH    AX
                ENDB    _TWOMUL

_ONEP:          NEWB    ONEP,'1+'
                POP     AX
                INC     AX
                PUSH    AX
                ENDB    _ONEP

_TWOM:          NEWB    TWOM,'2-'
                POP     AX
                SUB     AX,2
                PUSH    AX
                ENDB    _TWOM

_ONEM:          NEWB    ONEM,'1-'
                POP     AX
                DEC     AX
                PUSH    AX
                ENDB    _ONEM

_PLUS:          NEWB    PLUS,'+'
                POP     AX
                POP     BX
                ADD     AX,BX
                PUSH    AX
                ENDB    _PLUS

_DPLUS:         NEWB    DPLUS,'+'
                POP     DX
                POP     AX
                POP     CX
                POP     BX
                ADD     AX,BX
                ADC     DX,CX
                PUSH    AX
                PUSH    DX
                ENDB    _DPLUS

_UMUL:          NEWB    UMUL,'*'
                POP     AX
                POP     CX
                MUL     CX
                PUSH    AX
                PUSH    DX
                ENDB    _UMUL

_MMUL:          NEWB    MMUL,'*'
                POP     AX
                POP     CX
                IMUL    CX
                PUSH    AX
                PUSH    DX
                ENDB    _MMUL

_PMUL:          NEWB    PMUL,'*'
                POP     CX
                POP     AX
                MUL     CX
                MOV     BX,AX
                POP     AX
                MUL     CX
                ADD     DX,BX
                PUSH    AX
                PUSH    DX
                ENDB    _PMUL

_SMUL:          NEWB    SMUL,'*'
                POP     AX
                POP     CX
                IMUL    CX
                PUSH    AX
                ENDB    _SMUL

_DMUL:          NEWB    DMUL,'*'
                MOV     BX,SP
                POP     AX
                MUL     WORD PTR [BX+6]
                MOV     CX,AX
                MOV     AX,[BX+2]
                MUL     WORD PTR [BX+4]
                ADD     CX,AX
                POP     AX
                INC     SP
                INC     SP
                POP     BX
                MUL     BX
                ADD     DX,CX
                PUSH    AX
                PUSH    DX
                ENDB    _DMUL

_DIVMOD:        NEWB    DIVMOD,'/'
                XOR     DX,DX
                POP     CX
                POP     AX
                IDIV    CX
                PUSH    DX
                PUSH    AX
                ENDB    _DIVMOD

_SDIV:          NEWB    SDIV,'/'
                XOR     DX,DX
                POP     CX
                POP     AX
                IDIV    CX
                PUSH    AX
                ENDB    _SDIV

_MOD:           NEWF    SMOD,''
                DW      DIVMOD,DROP
                ENDF    _MOD

_MULDIV:        NEWB    MULDIV,'*/'
                POP     CX
                POP     BX
                POP     AX
                IMUL    BX
                IDIV    CX
                PUSH    AX
                ENDB    _MULDIV

_MINUS:         NEWB    MINUS,'-'
                POP     BX
                POP     AX
                SUB     AX,BX
                PUSH    AX
                ENDB    _MINUS

_PSTOR:         NEWB    PSTOR,'+!'
                POP     AX
                POP     BX
                ADD     [BX],AX
                ENDB    _PSTOR

_MSTOR:         NEWB    MSTOR,'-!'
                POP     AX
                POP     BX
                SUB     [BX],AX
                ENDB    _MSTOR

_INCR:          NEWB    INCR,'++'
                POP     BX
                INC     WORD PTR [BX]
                ENDB    _INCR

_DECR:          NEWB    DECR,'--'
                POP     BX
                DEC     WORD PTR [BX]
                ENDB    _DECR

_NEG:           NEWB    SNEG,'-'
                POP     AX
                NEG     AX
                PUSH    AX
                ENDB    _NEG

_DNEG:          NEWB    DNEG,'-'
                POP     AX
                POP     DX
                NOT     DX
                NOT     AX
                INC     DX
                ADC     AX,0
                PUSH    DX
                PUSH    AX
                ENDB    _DNEG

_UDIV:          NEWB    UDIV,'%'
                POP     CX
                POP     DX
                POP     AX
                DIV     CX
                PUSH    DX
                PUSH    AX
                ENDB    _UDIV

_MSMOD:         NEWF    MSMOD,'%'
                DW      TOR,ZERO,RAT,UDIV,FROMR,SWAP,TOR,UDIV,FROMR
                ENDF    _MSMOD

;                

                CNST    TRUE,'',-1
                CNST    FALSE,'',0
                CNST    YES,'',-1
                CNST    NO,'',0

_EQUAL:         NEWB    EQUAL,'='
                POP     AX
                POP     BX
                CMP     AX,BX
                JE      EQUAL1
                PUSH    0
                JMP     WORD PTR [TNEXT]
EQUAL1:         PUSH    -1
                ENDB    _EQUAL

_DEQUAL:        NEWB    DEQUAL,'='
                POP     AX
                POP     DX
                POP     BX
                POP     CX
                CMP     AX,BX
                JNE     DEQUAL1
                CMP     CX,DX
                JNE     DEQUAL1
                PUSH    -1
                JMP     WORD PTR [TNEXT]
DEQUAL1:        PUSH    0
                ENDB    _DEQUAL

_ATEQ:          NEWB    ATEQ,'?='
                POP     AX
                POP     BX
                MOV     BX,[BX]
                CMP     AX,BX
                JE      ATEQ1
                PUSH    0
                JMP     WORD PTR [TNEXT]
ATEQ1:          PUSH    -1
                ENDB    _ATEQ

_CATEQ:         NEWB    CATEQ,'?='
                POP     AX
                POP     BX
                MOV     BX,[BX]
                CMP     AX,BX
                JE      CATEQ1
                PUSH    0
                JMP     WORD PTR [TNEXT]
CATEQ1:         PUSH    -1
                ENDB    _CATEQ

_ATATEQ:        NEWB    ATATEQ,'??='
                POP     BX
                MOV     AX,[BX]
                POP     BX
                MOV     BX,[BX]
                CMP     AX,BX
                JE      ATATEQ1
                PUSH    0
                JMP     WORD PTR [TNEXT]
ATATEQ1:        PUSH    -1
                ENDB    _ATATEQ

_CATATEQ:       NEWB    CATATEQ,'??='
                POP     BX
                MOV     AX,[BX]
                POP     BX
                MOV     BX,[BX]
                CMP     AL,BL
                JE      CATATEQ1
                PUSH    0
                JMP     WORD PTR [TNEXT]
CATATEQ1:       PUSH    -1
                ENDB    _CATATEQ

_QEQUAL:        NEWB    QEQUAL,'=='
                POP     AX
                POP     BX
                CMP     AX,BX
                JE      QEQUAL1
                PUSH    BX
                PUSH    0
                JMP     WORD PTR [TNEXT]
QEQUAL1:        PUSH    -1
                ENDB    _QEQUAL

_NEQUAL:        NEWB    NEQUAL,'<>'
                POP     AX
                POP     BX
                CMP     AX,BX
                JNE     NEQUAL1
                PUSH    0
                JMP     WORD PTR [TNEXT]
NEQUAL1:        PUSH    -1
                ENDB    _NEQUAL

_MIN:           NEWB    MIN,''
                POP     AX
                POP     BX
                CMP     AX,BX
                JLE     MIN1
                XCHG    AX,BX
MIN1:           PUSH    AX
                ENDB    _MIN

_MAX:           NEWB    MAX,''
                POP     AX
                POP     BX
                CMP     AX,BX
                JGE     MAX1
                XCHG    AX,BX
MAX1:           PUSH    AX
                ENDB    _MAX

_INVR:          NEWB    INVR,''
                POP     AX
                NOT     AX
                PUSH    AX
                ENDB    _INVR

_NOT:           NEWB    LNOT,''
                POP     AX
                OR      AX,AX
                JZ      LNOT1
                PUSH    0
                JMP     WORD PTR [TNEXT]
LNOT1:          PUSH    -1
                ENDB    _NOT

_OR:            NEWB    LOR,''
                POP     AX
                POP     BX
                OR      AX,BX
                PUSH    AX
                ENDB    _OR

_AND:           NEWB    LAND,''
                POP     AX
                POP     BX
                AND     AX,BX
                PUSH    AX
                ENDB    _AND

_XOR:           NEWB    LXOR,'(+)'
                POP     AX
                POP     BX
                XOR     AX,BX
                PUSH    AX
                ENDB    _XOR

_LESS:          NEWB    LESS,'<'
                POP     AX
                POP     BX
                CMP     BX,AX
                JL      LESS1
                PUSH    0
                JMP     WORD PTR [TNEXT]
LESS1:          PUSH    -1
                ENDB    _LESS

_BIG:           NEWB    BIG,'>'
                POP     AX
                POP     BX
                CMP     BX,AX
                JG      BIG1
                PUSH    0
                JMP     WORD PTR [TNEXT]
BIG1:           PUSH    -1
                ENDB    _BIG

_ULSS:          NEWB    ULSS,'<'
                POP     AX
                POP     BX
                CMP     BX,AX
                JC      ULSS1
                PUSH    0
                JMP     WORD PTR [TNEXT]
ULSS1:          PUSH    -1
                ENDB    _ULSS

_UBIG:          NEWB    UBIG,'>'
                POP     AX
                POP     BX
                CMP     AX,BX
                JC      UBIG1
                PUSH    0
                JMP     WORD PTR [TNEXT]
UBIG1:          PUSH    -1
                ENDB    _UBIG

_ZLESS:         NEWF    ZLESS,'<0'
                DW      ZERO,LESS
                ENDF    _ZLESS

_ZBIG:          NEWF    ZBIG,'>0'
                DW      ZERO,BIG
                ENDF    _ZBIG

_ZEQU:          NEWF    ZEQU,'=0'
                DW      LNOT
                ENDF    _ZEQU

_ABS:           NEWF    SABS,'||'
                DW      SDUP,ZLESS,ZBRAN,ABS1-$,SNEG
ABS1:           ENDF    _ABS

_DABS:          NEWF    DABS,'||'
                DW      SDUP,ZLESS,ZBRAN,DABS1-$,DNEG
DABS1:          ENDF    _DABS

_RND:           NEWB    RND,''
                MOV     DX,DS
                MOV     AX,40H
                MOV     DS,AX
                ADD     BX,DS:[6CH]
                MOV     DS,DX
                IN      AL,41H
                ADD     BH,AL
                IN      AL,41H
                ADD     BL,AL
                IN      AL,40H
                ADD     BH,AL
                IN      AL,40H
                ADD     BL,AL
                IN      AL,0
                ADD     AH,AL
                IN      AL,0
                MOV     CX,WORD PTR RND1
                ADD     AX,CX
                AND     CX,3
REP             ROR     BX,1
                MOV     WORD PTR RND2,BX
                MUL     BX
                ADD     AX,WORD PTR RND2
                PUSH    AX
                MOV     WORD PTR RND1,AX
                JMP     WORD PTR [TNEXT]
RND1:           DW      5555
RND2:           DW      1212
                DW      _RND-$

;                 

_DPSTOR:        NEWB    DPSTOR,'!'
                POP     DI
                ENDB    _DPSTOR

_HERE:          NEWB    HERE,''
                PUSH    DI
                ENDB    _HERE

_NEWW:          NEWB    NEWW,''
                MOV     AX,DI
                INC     AX
                INC     AX
                PUSH    AX
                ENDB    _NEWW

_PAD:           NEWB    PAD,''
                MOV     AX,DI
                ADD     AX,100
                PUSH    AX
                ENDB    _PAD

_ALLOT:         NEWB    ALLOT,''
                POP     AX
                ADD     DI,AX
                ENDB    _ALLOT

_DALLOT:        NEWB    DALLOT,''
                POP     AX
                SUB     DI,AX
                ENDB    _DALLOT

_COMMA:         NEWB    COMMA,','
                POP     AX
                STOSW
                ENDB    _COMMA

_CCOMM:         NEWB    CCOMM,','
                POP     AX
                STOSB
                ENDB    _CCOMM

_COMP:          NEWB    COMP,'()'
                CLD
                LODSW
                STOSW
                ENDB    _COMP

_TCOD:          NEWB    TCOD,'>'
                POP     BX
                MOV     AL,[BX]
                XOR     AH,AH
                ADD     BX,AX
                INC     BX
                INC     BX
                PUSH    BX
                ENDB    _TCOD

_TNAME:         NEWB    TNAME,'>'
                POP     BX
                MOV     AL,32
                DEC     BX
TNAME1:         DEC     BX
                CMP     [BX],AL
                JNC     TNAME1
                PUSH    BX
                ENDB    _TNAME

;               /

                VAR     TEMIT,'>(.)',EMITB
                VAR     LNS,'',12

                CNST    CR,'',13
                CNST    LF,'',10
                CNST    BLANK,'',32

_EMITB:         NEWB    EMITB,'(.)'
                POP     BX
                POP     AX
                PUSH    BX
                MOV     AH,0EH
                INT     10H
                RET
                DW      _EMITB-$

_EMIT:          NEWB    EMIT,'.'
                CALL    WORD PTR [TEMIT]+4
                ENDB    _EMIT

_KEY:           NEWB    KEY,''
                MOV     AH,0
                INT     16H
                XOR     AH,AH
                PUSH    AX
                ENDB    _KEY

_KEYP:          NEWB    KEYP,'?'
                XOR     BX,BX
                MOV     AH,1
                INT     16H
                JZ      _KEYP1
                NOT     BX
_KEYP1:         PUSH    BX
                ENDB    _KEYP

_PHEX:          NEWB    PHEX,'.'
                POP     DX
                XOR     AX,AX
                MOV     AL,DH
                SHR     AL,4
                CALL    HEX1
                MOV     AL,DH
                AND     AL,15
                CALL    HEX1
                MOV     AL,DL
                SHR     AL,4
                CALL    HEX1
                MOV     AL,DL
                AND     AL,15
                CALL    HEX1
                JMP     WORD PTR [TNEXT]
HEX1:           ADD     AL,90H
                DAA
                ADC     AL,40H
                DAA
                PUSH    AX
                CALL    WORD PTR [TEMIT]+4
                RET
                DW      _PHEX-$

_PHBT:          NEWB    PHBT,'.'
                POP     AX
                XOR     AH,AH
                MOV     DL,AL
                SHR     AL,4
                ADD     AL,90H
                DAA
                ADC     AL,40H
                DAA
                PUSH    AX
                CALL    WORD PTR [TEMIT]+4
                MOV     AL,DL
                AND     AL,15
                ADD     AL,90H
                DAA
                ADC     AL,40H
                DAA
                PUSH    AX
                CALL    WORD PTR [TEMIT]+4
                ENDB    _PHBT

_STR:           NEWB    PSTR,'.'
                POP     BX
                PUSH    SI
                MOV     SI,BX
                MOV     CL,[SI]
                XOR     CH,CH
                JCXZ    STR2
                INC     SI
STR1:           LODSB
                XOR     AH,AH
                PUSH    AX
                CALL    WORD PTR [TEMIT]+4
                LOOP    STR1
STR2:           POP     SI
                ENDB    _STR

_PRN:           NEWB    PRN,''
                POP     BX
                PUSH    SI
                MOV     SI,BX
PRN1:           LODSB
                OR      AL,AL
                JZ      PRN2
                XOR     AH,AH
                PUSH    AX
                CALL    WORD PTR [TEMIT]+4
                JMP     PRN1
PRN2:           POP     SI
                ENDB    _PRN

_PRL:           NEWB    PRL,'(.")'
                CLD
                LODSB
                MOV     CL,AL
                XOR     CH,CH
_PRL1:          LODSB
                XOR     AH,AH
                PUSH    AX
                CALL    WORD PTR [TEMIT]+4
                LOOP    _PRL1
                ENDB    _PRL

_CRLF:          NEWF    CRLF,''
                DW      CR,EMIT,LF,EMIT
                ENDF    _CRLF

_SPACE:         NEWF    SPC,''
                DW      BLANK,EMIT
                ENDF    _SPACE

;                     

_XDO:           NEWB    XDO,'()'
                POP     AX
                SUB     BP,2
                POP     [BP]
                SUB     BP,2
                MOV     [BP],AX
                ENDB    _XDO

_XLOOP:         NEWB    XLOOP,'()'
                INC     WORD PTR [BP]
                MOV     AX,[BP]
                CMP     AX,[BP+2]
                JG      XLOOP1
                ADD     SI,[SI]
                JMP     WORD PTR [TNEXT]
XLOOP1:         ADD     SI,2
                ADD     BP,4
                ENDB    _XLOOP

_XULOOP:        NEWB    XULOOP,'(||)'
                INC     WORD PTR [BP]
                MOV     AX,[BP]
                CMP     AX,[BP+2]
                JNC     XULOOP1
                ADD     SI,[SI]
                JMP     WORD PTR [TNEXT]
XULOOP1:        ADD     SI,2
                ADD     BP,4
                ENDB    _XULOOP

_XPLOOP:        NEWB    XPLOOP,'(+)'
                POP     AX
                ADD     [BP],AX
                CMP     AX,0
                MOV     AX,[BP]
                JLE     XPLOOP1
                CMP     AX,[BP+2]
                JMP     XPLOOP2
XPLOOP1:        CMP     [BP+2],AX
XPLOOP2:        JG      XPLOOP3
                ADD     SI,[SI]
                JMP     WORD PTR [TNEXT]
XPLOOP3:        ADD     SI,2
                ADD     BP,4
                ENDB    _XPLOOP

_LDO:           NEWF    LDO,'',IMMED
                DW      COMP,XDO,HERE
                ENDF    _LDO

_LLOOP:         NEWF    LLOOP,'',IMMED
                DW      COMP,XLOOP,HERE,MINUS,COMMA
                ENDF    _LLOOP

_ULOOP:         NEWF    ULOOP,'||',IMMED
                DW      COMP,XULOOP,HERE,MINUS,COMMA
                ENDF    _ULOOP

_PLOOP:         NEWF    PLOOP,'+',IMMED
                DW      COMP,XPLOOP,HERE,MINUS,COMMA
                ENDF    _PLOOP

_LIF:           NEWF    LIF,'',IMMED
                DW      COMP,ZBRAN,HERE,ZERO,COMMA
                ENDF    _LIF

_LIFNOT:        NEWF    LIFNOT,'_',IMMED
                DW      COMP,LNOT,COMP,ZBRAN,HERE,ZERO,COMMA
                ENDF    _LIFNOT

_LTHEN:         NEWF    LTHEN,'',IMMED
                DW      HERE,OVER,MINUS,SWAP,STOR
                ENDF    _LTHEN

_LELSE:         NEWF    LELSE,'',IMMED
                DW      COMP,BRAN,HERE,ZERO,COMMA,SWAP,LTHEN
                ENDF    _LELSE

_BEG:           NEWF    BEG,'',IMMED
                DW      HERE
                ENDF    _BEG

_UNTIL:         NEWF    UNTIL,'?',IMMED
                DW      COMP,ZBRAN,HERE,MINUS,COMMA
                ENDF    _UNTIL

_REPT:          NEWF    REPEAT,'',IMMED
                DW      COMP,BRAN,SWAP,HERE,MINUS,COMMA,LTHEN
                ENDF    _REPT

;                

_COUNT:         NEWB    COUNT,''
                POP     BX
                MOV     AL,[BX]
                XOR     AH,AH
                INC     BX
                PUSH    BX
                PUSH    AX
                ENDB    _COUNT

_MOVE:          NEWB    MOVE,'<'
                POP     CX
                MOV     DX,SI
                MOV     BX,DI
                POP     DI
                POP     SI
                CLD
REP             MOVSB
                MOV     SI,DX
                MOV     DI,BX
                ENDB    _MOVE

_BMOVE:         NEWB    BMOVE,'>'
                POP     CX
                MOV     DX,SI
                MOV     BX,DI
                POP     DI
                POP     SI
                ADD     DI,CX
                ADD     SI,CX
                DEC     SI
                DEC     DI
                STD
REP             MOVSB
                CLD
                MOV     SI,DX
                MOV     DI,BX
                ENDB    _BMOVE

_AMOVE:         NEWB    AMOVE,'<<'
                POP     CX
                MOV     DX,SI
                MOV     BX,DI
                POP     DS
                POP     DI
                POP     ES
                POP     SI
                CLD
REP             MOVSB
                MOV     SI,DX
                MOV     DI,BX
                MOV     BX,CS
                MOV     DS,BX
                MOV     ES,BX
                ENDB    _AMOVE

_ABMOVE:        NEWB    ABMOVE,'>>'
                POP     CX
                MOV     DX,SI
                MOV     BX,DI
                POP     DS
                POP     DI
                POP     ES
                POP     SI
                ADD     DI,CX
                ADD     SI,CX
                DEC     SI
                DEC     DI
                STD
REP             MOVSB
                CLD
                MOV     SI,DX
                MOV     DI,BX
                MOV     BX,CS
                MOV     DS,BX
                MOV     ES,BX
                ENDB    _ABMOVE

_FILL:          NEWB    FILL,''
                MOV     DX,DI
                POP     AX
                POP     CX
                POP     DI
                CLD
REP             STOSB
                MOV     DI,DX
                ENDB    _FILL

_TASC:          NEWB    TASC,'>0'
                POP     BX
                MOV     CL,[BX]
                XOR     CH,CH
                PUSH    SI
                PUSH    DI
                MOV     DI,BX
                MOV     SI,BX
                INC     SI
                CLD
REP             MOVSB
                MOV     [DI],CH
                POP     DI
                POP     SI
                ENDB    _TASC

_STRL:          NEWB    STRL,'?0'
                MOV     BX,DI
                POP     DX
                MOV     DI,DX
                CLD
                XOR     AL,AL
STRL1:          SCASB
                JNE     STRL1
                DEC     DI
                SUB     DI,DX
                PUSH    DI
                MOV     DI,BX
                ENDB    _STRL

_PLSSZ:         NEWB    PLSSZ,'+0'
                MOV     BX,SI
                MOV     DX,DI
                POP     SI
                POP     DI
                CLD
                XOR     AX,AX
PLSSZ1:         SCASB
                JNE     PLSSZ1
                DEC     DI
PLSSZ2:         LODSB
                STOSB
                OR      AL,AL
                JNZ     PLSSZ2
                MOV     SI,BX
                MOV     DI,DX
                ENDB    _PLSSZ

_ESTRZ:         NEWB    ESTRZ,'=0'
                MOV     DX,DI
                MOV     BX,SI
                POP     SI
                POP     DI
ESTRZ1:         LODSB
                SCASB
                JNE     ESTRZ2
                OR      AL,AL
                JNZ     ESTRZ1
                PUSH    -1
                JMP     ESTRZ3
ESTRZ2:         PUSH    0
ESTRZ3:         MOV     DI,DX
                MOV     SI,BX
                ENDB    _ESTRZ

_ESTR:          NEWB    ESTR,'='
                PUSH    BP
                MOV     BP,SP
                PUSH    SI
                PUSH    DI
                MOV     SI,[BP+2]
                MOV     DI,[BP+4]
                MOV     CL,[SI]
                XOR     CH,CH
                CMPSB
                JNE     ESTRF
                JCXZ    ESTRT
REPE            CMPSB
                JNE     ESTRF
ESTRT:          MOV     AX,-1
                JMP     ESTRQ
ESTRF:          XOR     AX,AX
ESTRQ:          POP     DI
                POP     SI
                POP     BP
                ADD     SP,4
                PUSH    AX
                ENDB    _ESTR

_LSTR:          NEWB    LSTR,'(")'
                PUSH    SI
                CLD
                LODSB
                XOR     AH,AH
                ADD     SI,AX
                ENDB    _LSTR

_ASTR:          NEWB    ASTR,'(")'
                PUSH    SI
                XCHG    DI,SI
                CLD
                XOR     AL,AL
ASTR1:          SCASB
                JNE     ASTR1
                XCHG    DI,SI
                ENDB    _ASTR

_QW:            NEWF    QW,'"',IMMED
                DW      BLANK,WRD,NEWW,ONEP,CAT
                DW      STATE,AT,ZBRAN,QW1-$
                DW      COMP,LIT,COMMA
QW1:            ENDF    _QW

_DQW:           NEWF    DQW,'."',IMMED
                DW      LIT,34,WRD,STATE,AT,ZBRAN,DQW1-$
                DW      COMP,PRL,HERE,CAT,ONEP,ALLOT,EXIT
DQW1:           DW      NEWW,PSTR
                ENDF    _DQW

_QWOT:          NEWF    QWOT,'"',IMMED
                DW      LIT,34,WRD,STATE,AT,ZBRAN,QWOT1-$
                DW      COMP,LSTR,HERE,CAT,ONEP,ALLOT,EXIT
QWOT1:          DW      NEWW,HEAP,AT,NEWW,CAT,ONEP,MOVE,HEAP,AT
                ENDF    _QWOT

_AQWOT:         NEWF    AQWOT,'"',IMMED
                DW      LIT,34,WRD,STATE,AT,ZBRAN,AQWOT1-$
                DW      COMP,ASTR,HERE,SDUP,CAT,ONEP,ALLOT,TASC,EXIT
AQWOT1:         DW      NEWW,ONEP,HEAP,AT,NEWW,CAT,ONEP,MOVE,HEAP,AT
                ENDF    _AQWOT

_PRNL:          NEWF    PRNL,'.?'
                DW      ZBRAN,PRNL1-$,PRL
                NSTR    ''
                DW      EXIT
PRNL1:          DW      PRL
                NSTR    ''
                ENDF    _PRNL

;               / 

                VAR     BASE,'',10
                VAR     DPL,''

_EMITS:         NEWF    EMITS,''
                DW      SDUP,ZBIG,LNOT,ZBRAN,EMITS2-$
                DW      DDROP,EXIT
EMITS2:         DW      ONE,XDO
EMITS1:         DW      SDUP,EMIT,XLOOP,EMITS1-$
                DW      DROP
                ENDF    _EMITS

_SPACES:        NEWF    SPCS,''
                DW      SDUP,ZBIG,LNOT,ZBRAN,SPCS2-$
                DW      DROP,EXIT
SPCS2:          DW      ONE,XDO
SPCS1:          DW      SPC,XLOOP,SPCS1-$
                ENDF    _SPACES

_DECIM:         NEWF    DECIM,''
                DW      LIT,10,BASE,STOR
                ENDF    _DECIM

_HEX:           NEWF    HEX,''
                DW      LIT,16,BASE,STOR
                ENDF    _HEX

_ISDIG:         NEWB    ISDIG,'?'
                POP     AX
                POP     CX
                SUB     CX,30H
                JL      ISDIG1
                CMP     CX,9
                JLE     ISDIG2
                SUB     CX,7
                CMP     CX,10
                JL      ISDIG1
ISDIG2:         CMP     CX,AX
                JGE     ISDIG1
                PUSH    CX
                PUSH    0
                PUSH    -1
                JMP     WORD PTR [TNEXT]
ISDIG1:         PUSH    0
                ENDB    _ISDIG

_PREF:          NEWB    PREF,'?'
                POP     CX
                POP     BX
                XOR     AX,AX
                CMP     BYTE PTR [BX],'+'
                JNE     PREF1
                MOV     CX,10
                JMP     PREF4
PREF1:          CMP     BYTE PTR [BX],'-'
                JNE     PREF2
                MOV     CX,10
                NOT     AX
                JMP     PREF4
PREF2:          CMP     BYTE PTR [BX],'#'
                JNE     PREF3
                MOV     CX,16
                JMP     PREF4
PREF3:          CMP     BYTE PTR [BX],39
                JNE     PREF5
                MOV     CX,2
PREF4:          INC     BX
PREF5:          PUSH    BX
                PUSH    CX
                PUSH    AX
                ENDB    _PREF

_NUMB:          NEWF    NUMB,''
                DW      FALSE,DPL,STOR,BASE,AT,PREF
                DW      TOR,TOR,HERE,STOR,ZERO,ZERO
NUMB3:          DW      HERE,SCAN,SDUP,ZBRAN,NUMB1-$
                DW      LIT,'.',QEQUAL,ZBRAN,NUMB5-$
                DW      DPL,AT,LNOT,ZBRAN,NUMB2-$
                DW      TRUE,DPL,STOR,BRAN,NUMB3-$
NUMB5:          DW      RAT,ISDIG,ZBRAN,NUMB2-$
                DW      DSWAP,RAT,PMUL,DPLUS,BRAN,NUMB3-$
NUMB2:          DW      DDROP,RDROP,RDROP,FALSE,EXIT
NUMB1:          DW      DROP,RDROP,FROMR,ZBRAN,NUMB4-$,DNEG
NUMB4:          DW      TRUE
                ENDF    _NUMB

_HOLD:          NEWB    HOLD,'>'
                MOV     BX,[DI]
                POP     AX
                DEC     BX
                MOV     [BX],AL
                MOV     [DI],BX
                ENDB    _HOLD

_BDIGS:         NEWF    BDIGS,'<#'
                DW      PAD,HERE,STOR
                ENDF    _BDIGS

_EDIGS:         NEWF    EDIGS,'#>'
                DW      DDROP,PAD,HERE,AT,MINUS,HOLD
                ENDF    _EDIGS

_SGN:           NEWF    SGN,''
                DW      ROT,ZLESS,ZBRAN,SGN1-$
                DW      LIT,'-',HOLD
SGN1:           ENDF    _SGN

_DIG:           NEWF    DIG,'#'
                DW      BASE,AT,MSMOD,ROT,LIT,9,OVER
                DW      LESS,ZBRAN,DIG1-$,LIT,7,PLUS
DIG1:           DW      LIT,30H,PLUS,HOLD
                ENDF    _DIG

_DIGS:          NEWF    DIGS,'##'
DIGS1:          DW      DIG,DDUP,LOR,LNOT,ZBRAN,DIGS1-$
                ENDF    _DIGS

_DDR:           NEWF    DDR,'..>'
                DW      TOR,SWAP,OVER,DABS,BDIGS,DIGS,SGN,EDIGS
                DW      HERE,AT,SDUP,CAT,FROMR,SWAP,MINUS
                DW      SPCS,PSTR
                ENDF    _DDR

_DDZ:           NEWF    DDZ,'0..'
                DW      TOR,SWAP,OVER,DABS,BDIGS,DIGS,SGN,EDIGS
                DW      HERE,AT,SDUP,CAT,FROMR,SWAP,MINUS
                DW      LIT,'0',SWAP,EMITS,PSTR
                ENDF    _DDZ

_DDOT:          NEWF    DDOT,'..'
                DW      ZERO,DDR
                ENDF    _DDOT

_DR:            NEWF    DR,'.>'
                DW      TOR,STOD,FROMR,DDR
                ENDF    _DR

_DZ:            NEWF    DZ,'0.'
                DW      TOR,STOD,FROMR,DDZ
                ENDF    _DZ

_DOT:           NEWF    DOT,'.'
                DW      STOD,DDOT
                ENDF    _DOT

_UDOT:          NEWF    UDOT,'|.|'
                DW      ZERO,DDOT
                ENDF    _UDOT

;                

                VAR     EXTERR,'+',NOOP

_ERR:           NEWF    ERROR,''
                DW      EXTERR,AT,EXEC,CRLF,PRL
                NSTR    '  '
                DW      DOT,ABORT
                ENDF    _ERR

_NORAM:         NEWF    NORAM,'-'
                DW      CRLF,PRL
                NSTR    ' '
                DW      LIT,3,ERROR
                ENDF    _NORAM

_NTF:           NEWF    NTF,''
                DW      CRLF,NWRD,PRL
                NSTR    '  !'
                DW      ONE,ERROR
                ENDF    _NTF

_NWRD:          NEWF    NWRD,''
                DW      PRL
                NSTR    ' '
                DW      NEWW,PSTR
                ENDF    _NWRD

;                  

                CNST    CJMP,'JMP[]',26FFH
                CNST    CCALL,'CALL[]',16FFH
                CNST    CPUSH,'PUSH[]',68H

                VAR     CHNG,'',FALSE
                VAR     FLET,'1'

_LBR:           NEWF    LBR,'[',IMMED
                DW      FALSE,STATE,STOR
                ENDF    _LBR

_RBR:           NEWF    RBR,']'
                DW      TRUE,STATE,STOR
                ENDF    _RBR

_PREV:          NEWB    PREV,'>'
                POP     BX
                DEC     BX
                DEC     BX
                MOV     AX,[BX]
                OR      AX,AX
                JZ      PREV1
                ADD     AX,BX
PREV1:          PUSH    AX
                ENDB    _PREV

_FIND:          NEWF    FIND,''
                DW      LATEST,AT
FIND2:          DW      SDUP,ZBRAN,FIND1-$
                DW      SDUP,NEWW,ESTR,ZBRAN,FIND3-$
                DW      TCOD,TRUE,EXIT
FIND3:          DW      PREV,BRAN,FIND2-$
FIND1:          ENDF    _FIND

_PREP:          NEWF    PREP,''
                DW      BLANK,WRD,NEWW,CAT,SDUP,ZBRAN,PREP1-$
                DW      LIT,16,MIN,NEWW,CSTOR
                DW      FIND,ZBRAN,PREP2-$
                DW      DROP,CHNG,AT,ZBRAN,PREP2-$
                DW      CRLF,PRL
                NSTR    '    '
                DW      ZERO,ERROR
PREP2:          DW      LATEST,AT,HERE,MINUS,HERE,STOR
                DW      NEWW,LATEST,STOR
                DW      NEWW,CAT,ONEP,TWOP,ALLOT,TRUE
PREP1:          ENDF    _PREP

_COLON:         NEWF    COLON,':',IMMED
                DW      PREP,ZBRAN,COL1-$
                DW      BLANK,LATEST,AT,ONEP,SDUP,CAT,FLET,CSTOR,CSTOR
                DW      ONE,CCOMM,CCALL,COMMA,TONEST,COMMA,RBR
COL1:           ENDF    _COLON

_SEMI:          NEWF    SEMI,';',IMMED
                DW      COMP,EXIT,FLET,CAT,LATEST,AT,ONEP,CSTOR,LBR
                ENDF    _SEMI

_CREA:          NEWF    CREA,''
                DW      PREP,ZBRAN,CREA1-$
                DW      ZERO,CCOMM,CCALL,COMMA,TONEXT,COMMA
CREA1:          ENDF    _CREA

_NVAR:          NEWF    NVAR,''
                DW      CREA,TWO,ALLOT
                ENDF    _NVAR

_DVAR:          NEWF    DVAR,':'
                DW      CREA,LIT,4,ALLOT
                ENDF    _DVAR

_NCONST:        NEWF    NCONST,''
                DW      PREP,ZBRAN,CONST1-$
                DW      ZERO,CCOMM,CPUSH,CCOMM,COMMA
                DW      CJMP,COMMA,TONEXT,COMMA
CONST1:         ENDF    _NCONST

_DCONST:        NEWF    DCONST,':'
                DW      PREP,ZBRAN,DCONST1-$
                DW      ZERO,CCOMM,SWAP,CPUSH,CCOMM,COMMA
                DW      CPUSH,CCOMM,COMMA
                DW      CJMP,COMMA,TONEXT,COMMA
DCONST1:        ENDF    _DCONST

_IMM:           NEWF    IMM,''
                DW      LATEST,AT,TCOD,ONEM,SDUP,CAT
                DW      LIT,80H,LOR,SWAP,STOR
                ENDF    _IMM

_QIMM:          NEWF    QIMM,'?'
                DW      SDUP,ONEM,CAT,LIT,80H,LAND
                ENDF    _QIMM

_XDOES:         NEWF    XDOES,'()'
                DW      FROMR,LATEST,AT,TCOD,TWOP,STOR
                ENDF    _XDOES

_DOES:          NEWF    DOES,':',IMMED
                DW      COMP,XDOES,NEWW,COMMA,CCALL,COMMA,TONEST,COMMA
                ENDF    _DOES

_RECURS:        NEWF    RECURS,'',IMMED
                DW      LATEST,AT,TCOD,COMMA
                ENDF    _RECURS

_ATRSTOR:       NEWF    ATRSTOR,'!'
                DW      ONEM,CSTOR
                ENDF    _ATRSTOR

_ATR:           NEWF    ATR,'?'
                DW      ONEM,CAT
                ENDF    _ATR

;                  

                CNST    RD,'_',0
                CNST    WR,'_',1
                CNST    RW,'_/',2
                CNST    FRMST,'_',0
                CNST    FRMCUR,'',1
                CNST    FRMEND,'_',2

_OFILE:         NEWB    OFILE,'_'
                POP     AX
                MOV     AH,3DH
                POP     DX
                INT     21H
                MOV     BX,0
                JC      OFILE1
                PUSH    AX
                NOT     BX
OFILE1:         PUSH    BX
                ENDB    _OFILE

_CFILE:         NEWB    CFILE,'_'
                POP     BX
                MOV     AH,3EH
                INT     21H
                MOV     BX,0
                JC      CFILE1
                NOT     BX
CFILE1:         PUSH    BX
                ENDB    _CFILE

_NFILE:         NEWB    NFILE,'_'
                POP     CX
                POP     DX
                MOV     AH,3CH
                INT     21H
                MOV     BX,0
                JC      NFILE1
                PUSH    AX
                NOT     BX
NFILE1:         PUSH    BX
                ENDB    _NFILE

_WFILE:         NEWB    WFILE,'_'
                POP     CX
                POP     DS
                POP     DX
                POP     BX
                MOV     AH,40H
                INT     21H
                MOV     BX,CS
                MOV     DS,BX
                MOV     BX,0
                JC      WFILE1
                NOT     BX
                PUSH    AX
WFILE1:         PUSH    BX
                ENDB    _WFILE

_RFILE:         NEWB    RFILE,'_'
                POP     CX
                POP     DS
                POP     DX
                POP     BX
                MOV     AH,3FH
                INT     21H
                MOV     BX,CS
                MOV     DS,BX
                MOV     BX,0
                JC      RFILE1
                PUSH    AX
                NOT     BX
RFILE1:         PUSH    BX
                ENDB    _RFILE

_SFILE:         NEWB    SFILE,'*'
                POP     AX
                MOV     AH,42H
                POP     CX
                POP     DX
                POP     BX
                INT     21H
                MOV     BX,0
                JC      SFILE1
                PUSH    AX
                PUSH    DX
                NOT     BX
SFILE1:         PUSH    BX
                ENDB    _SFILE

_DFILE:         NEWB    DFILE,'_'
                POP     DX
                MOV     AH,41H
                INT     21H
                MOV     BX,0
                JC      DFILE1
                NOT     BX
DFILE1:         PUSH    BX
                ENDB    _DFILE

_FFILE:         NEWB    FFILE,'?'
                POP     DX
                POP     CX
                MOV     AH,4EH
                INT     21H
                MOV     BX,0
                JC      FFILE1
                NOT     BX
FFILE1:         PUSH    BX
                ENDB    _FFILE

_FNEXT:         NEWB    FNEXT,'??'
                MOV     AH,2FH
                INT     21H
                MOV     DX,ES
                MOV     DS,DX
                MOV     DX,BX
                MOV     AH,4FH
                INT     21H
                MOV     BX,CS
                MOV     DS,BX
                MOV     ES,BX
                MOV     BX,0
                JC      FNEXT1
                NOT     BX
FNEXT1:         PUSH    BX
                ENDB    _FNEXT

;                

                VAR     TIB,''
                VAR     TIBL,'',TBSIZE
                VAR     TIBP,'>'
                VAR     WRDP,'>'

_BWORD:         NEWB    BWORD,'()'
                PUSH    BP
                MOV     BP,SP
                PUSH    SI
                PUSH    DI
                MOV     AH,[BP+6]
                MOV     SI,[BP+4]
                MOV     SI,[SI]
                MOV     BX,[BP+2]
                MOV     DI,BX
                INC     DI
                MOV     DX,0D0AH
BWORD1:         LODSB
                OR      AL,AL
                JZ      BWORD3
                CMP     AL,AH
                JE      BWORD1
                CMP     AL,DH
                JE      BWORD1
                CMP     AL,DL
                JE      BWORD1
BWORD2:         STOSB
                LODSB
                OR      AL,AL
                JZ      BWORD3
                CMP     AL,AH
                JE      BWORD3
                CMP     AL,DH
                JE      BWORD3
                CMP     AL,DL
                JNE     BWORD2
BWORD3:         MOV     BYTE PTR [DI],0
                DEC     DI
                SUB     DI,BX
                MOV     AX,DI
                MOV     [BX],AL
                MOV     BX,[BP+4]
                MOV     [BX],SI
                POP     DI
                POP     SI
                POP     BP
                ADD     SP,6
                ENDB    _BWORD

_WORD:          NEWF    WRD,''
                DW      WRDP,NEWW,BWORD
                ENDF    _WORD

_FND:           NEWF    FND,39,IMMED  ; '
                DW      BLANK,WRD,FIND,LNOT,ZBRAN,FND1-$
                DW      NTF
FND1:           ENDF    _FND

_COMPA:         NEWF    COMPA,'::'
                DW      FND,COMMA
                ENDF    _COMPA

_COMPI:         NEWF    COMPI,'[::]',IMMED
                DW      COMPA
                ENDF    _COMPI

_COMPW:         NEWF    COMPW,''
                DW      FND,COMP,COMP,COMMA
                ENDF    _COMPW

_COMPS:         NEWF    COMPS,'[]',IMMED
                DW      COMPW
                ENDF    _COMPS

                VAR     EXTINT,'+',FALSE

_INTER:         NEWF    INTER,''
                DW      WRDP,STOR
INTER1:         DW      BLANK,WRD,NEWW,CAT,LNOT,ZBRAN,INTER2-$,EXIT
INTER2:         DW      FIND,ZBRAN,INTER3-$
                DW      QIMM,ZBRAN,INTER4-$
INTER5:         DW      EXEC,BRAN,INTER1-$
INTER4:         DW      STATE,AT,ZBRAN,INTER5-$
                DW      COMMA,BRAN,INTER1-$
INTER3:         DW      NEWW,ONEP,NUMB,ZBRAN,INTER6-$
                DW      DPL,AT,LNOT,ZBRAN,INTER7-$,DROP
INTER7:         DW      STATE,AT,ZBRAN,INTER1-$
                DW      DPL,AT,ZBRAN,INTER8-$
                DW      SWAP,COMP,LIT,COMMA
INTER8:         DW      COMP,LIT,COMMA,BRAN,INTER1-$
INTER6:         DW      EXTINT,AT,EXEC,LNOT,ZBRAN,INTER1-$
                DW      NTF
                DW      _INTER-$

_QUERY:         NEWF    QUERY,''
                DW      ONEM,OVER,PLUS,TOR,SDUP,TIBP,STOR
QUERY1:         DW      KEY,SDUP,BLANK,LESS,ZBRAN,QUERY2-$
                DW      LIT,8,QEQUAL,ZBRAN,QUERY3-$
                DW      TIBP,AT,OVER,BIG,ZBRAN,QUERY1-$
                DW      TIBP,DECR
                DW      LIT,8,SDUP,EMIT,BLANK,EMIT,EMIT,BRAN,QUERY1-$
QUERY3:         DW      CR,QEQUAL,ZBRAN,QUERY4-$
                DW      ZERO,TIBP,AT,STOR,RDROP,DROP,EXIT
QUERY4:         DW      LNOT,ZBRAN,QUERY1-$
                DW      KEY,DROP,BRAN,QUERY1-$
QUERY2:         DW      TIBP,AT,SDUP,RAT,LESS,ZBRAN,QUERY5-$
                DW      SDUP,ONEP,TIBP,STOR,OVER,EMIT,STOR,BRAN,QUERY1-$
QUERY5:         DW      DDROP,BRAN,QUERY1-$
                ENDF    _QUERY

_QUIT:          NEWF    QUIT,''
QUIT1:          DW      RP0,AT,RPSTOR
                DW      STATE,AT,ZBRAN,QUIT2-$
                DW      LIT,16,BRAN,QUIT3-$
QUIT2:          DW      CRLF,LIT,'>'
QUIT3:          DW      EMIT,BLANK,EMIT
                DW      TIB,AT,TIBL,AT,QUERY
                DW      TIB,AT,CAT,ZBRAN,QUIT1-$
                DW      CRLF,TIB,AT,INTER,BRAN,QUIT1-$
                DW      _QUIT-$

_HELLO:         NEWF    HELLO,''
                DW      CRLF,PRL
                NSTR    '',13,10
                DW      PRL
                NSTR    ' - 286 ',13,10
                DW      PRL
                NSTR    '',13,10
                ENDF    _HELLO

_ABORT:         NEWF    ABORT,''
                DW      SP0,AT,SPSTOR,LBR,TOP,AT,TASK,STOR,QUIT
                DW      _ABORT-$

                VAR     FENCE,'',_BYE

_PROT:          NEWF    PROT,''
                DW      FND,TNAME,FENCE,STOR
                ENDF    _PROT

_FORGET:        NEWF    FORGET,''
                DW      BLANK,WRD,NEWW,LATEST,AT
FORGET3:        DW      FENCE,AT,QEQUAL,ZBRAN,FORGET1-$
                DW      DROP,CRLF,NWRD,PRL
                NSTR    ' !'
                DW      TWO,ERROR
FORGET1:        DW      SDUP,ZBRAN,FORGET2-$
                DW      SDUP,NEWW,ESTR,TOR,PRESS,SDUP,PREV
                DW      FROMR,ZBRAN,FORGET3-$
                DW      LATEST,STOR,TWOM,DPSTOR,EXIT
FORGET2:        DW      DROP,NTF
                DW      _FORGET-$

_UNDO:          NEWF    UNDO,''
                DW      LATEST,AT,FENCE,AT,QEQUAL,ZBRAN,UNDO1-$
                DW      CRLF,PRL
                NSTR    '  !'
                DW      TWO,ERROR
UNDO1:          DW      SDUP,PREV,LATEST,STOR,TWOM,DPSTOR
                ENDF    _UNDO

_QNAME:         NEWF    QNAME,'?'
                DW      TNAME,PSTR
                ENDF    _QNAME

_VLIST:         NEWF    VLIST,''
                DW      ZERO,NEWW,STOR,LATEST,AT
VLIST1:         DW      LNS,AT,ONEM,TOR,ZERO,TOR
VLIST2:         DW      ZERO,QEQUAL,ZBRAN,VLIST3-$
                DW      RDROP,RDROP,CRLF,NEWW,AT,DOT,PRL
                NSTR    '   '
                DW      EXIT
VLIST3:         DW      CRLF,SDUP,PSTR,NEWW,ONE,PSTOR,PREV
                DW      FROMR,ONEP,RAT,QEQUAL,ZBRAN,VLIST4-$
                DW      RDROP,KEY,LIT,27,EQUAL,ZBRAN,VLIST1-$
                DW      CRLF,EXIT
VLIST4:         DW      TOR,BRAN,VLIST2-$
                DW      _VLIST-$

_COMM1:         NEWF    COMM1,'(',IMMED
                DW      LIT,')',WRD
                ENDF    _COMM1

_COMM2:         NEWF    COMM2,'\',IMMED
                DW      LIT,CR,WRD
                ENDF    _COMM2

_SAVEB:         NEWB    SAVEB,'()'
                POP     DX
                MOV     AH,3CH
                MOV     CX,0
                INT     21H
                JC      SAVEB1
                MOV     BX,AX
                MOV     DX,100H
                MOV     CX,DI
                SUB     CX,DX
                MOV     AH,40H
                INT     21H
                JC      SAVEB2
                CMP     AX,CX
                JNE     SAVEB2
                MOV     AH,3EH
                INT     21H
                JC      SAVEB1
                PUSH    -1
                JMP     WORD PTR [TNEXT]
SAVEB2:         MOV     AH,3EH
                INT     21H
SAVEB1:         PUSH    0
                ENDB    _SAVEB

_SAVE:          NEWF    SAVE,''
                DW      BLANK,WRD,NEWW,CAT,ZBRAN,SAVE1-$
                DW      HERE,DP0,STOR,NEWW,ONEP,SDUP,ASTR
                DB      '.COM',0
                DW      PLSSZ,SAVEB,LNOT,ZBRAN,SAVE1-$
                DW      PRL
                NSTR    13,10,'  !'
SAVE1:          ENDF    _SAVE

_BLOAD:         NEWB    BLOAD,'()'
                POP     BX
                POP     CX
                POP     DX
                MOV     AX,3D00H
                INT     21H
                JC      BLOAD1
                MOV     DX,BX
                MOV     BX,AX
                MOV     AH,3FH
                INT     21H
                MOV     DX,AX
                PUSHF
                MOV     AH,3EH
                INT     21H
                POPF
                JC      BLOAD1
                PUSH    DX
                PUSH    -1
                JMP     WORD PTR [TNEXT]
BLOAD1:         PUSH    0
                ENDB    _BLOAD

_RUN:           NEWF    RUN,''
                DW      BLANK,WRD,NEWW,CAT,ZBRAN,RUN2-$
                DW      NEWW,ONEP,LIT,1024,TOP,AT,OVER,MINUS
                DW      SDUP,TOR,BLOAD,LNOT,ZBRAN,RUN1-$
                DW      PRL
                NSTR    13,10,'  !'
                DW      ABORT
RUN1:           DW      RAT,PLUS,ZERO,SWAP,STOR,FROMR,INTER,ABORT
RUN2:           ENDF    _RUN

_NAUTO:         NEWF    NAUTO,':'
                DW      FND,AUTO,STOR
                ENDF    _NAUTO

_BYE:           NEWB    BYE,'...'
                INT     20H

ENDVOC          EQU     $
LATEST_         EQU     _BYE

                END     RFORTH
