; FORTH
; INTERPRETER

INCLUDE "8080.INC"

RKS_START 0

RPN:  LXI  D, 227FH
SPN:  LXI  SP,237FH
START:JMP  ABOR
      DW   0

      DB   4,'NEST',0
      CALL NEXT
NEST: XCHG
      DCX  H
      MOV  M,D
      DCX  H
      MOV  M,E
      XCHG
      POP  H

NEXT: MOV  A,M
      INX  H
      PUSH H
      MOV  H,M
      MOV  L,A
      XTHL
      INX  H
      RET
      DW   NEST-9

NEXT_:DB   4,'NEXT',0
      LXI  B,NEXT
      PUSH B
      PUSH B
      RET
      DW   NEXT_

      DB   4,'EXIT',0
      CALL NEXT
EXIT: XCHG
      MOV  E,M
      INX  H
      MOV  D,M
      INX  H
      XCHG
      JMP  NEXT
      DW   EXIT-9

      DB   7,'EXECUTE',0
EXEC: RET
      DW   EXEC-9

      DB   4,'TRUE',0
TRUE: LXI  B,-1
      PUSH B
      JMP  NEXT
      DW   TRUE-6

      DB   5,'FALSE',0
FALS: LXI  B,0
      PUSH B
      JMP  NEXT
      DW   FALS-7

      DB   1,'0',0
ZERO: LXI  B,0
      PUSH B
      JMP  NEXT
      DW   ZERO-3

      DB   1,'1',0
ONE:  LXI  B,1
      PUSH B
      JMP  NEXT
      DW   ONE-3

      DB   1,'2',0
TWO:  LXI  B,2
      PUSH B
      JMP  NEXT
      DW   TWO-3

      DB   2,'BL',0
BL_: LXI  B,32
      PUSH B
      JMP  NEXT
      DW   BL_-4

      DB   6,'BRANCH',0
BRAN: MOV  C,M
      INX  H
      MOV  B,M
      DCX  H
      DAD  B
      JMP  NEXT
      DW   BRAN-8

      DB   7,'?BRANCH',0
ZBRAN:POP  B
      MOV  A,B
      ORA  C
      JZ   BRAN
      INX  H
      INX  H
      JMP  NEXT
      DW   ZBRAN-9

      DB   6,'(EMIT)',0
XEMIT:JMP  0C809H
      DW   XEMIT-8

      DB   5,'(KEY)',0
XKEY: JMP  0C803H
      DW   XKEY-7

      DB   6,'(?KEY)',0
XKEYS:JMP  0C812H
      DW   XKEYS-8

      DB   3,'BYE',0
BYE:  JMP  0C800H
      DW   BYE-5

      DB   2,'DP',0
DP_:  CALL NEXT
      DW   FIN,DP_-4

      DB   4,'LAST',0
LAST: CALL NEXT
      DW   FINW,LAST-6

      DB   3,'IPS',0
      CALL NEXT
IPS:  DW   0,IPS-8

      DB   3,'RPS',0
      CALL NEXT
RPS:  DW   0,RPS-8

      DB   2,'S0',0
S0:   CALL AT_
      DW   SPN+1,S0-4

      DB   2,'R0',0
R0:   CALL AT_
      DW   RPN+1,R0-4

      DB   3,'BLK',0
BLK:  CALL NEXT
      DW   0,BLK-5

      DB   5,'STATE',0
STAT: CALL NEXT
      DW   0,STAT-7

      DB   3,'TIB',0
TIB:  CALL NEXT
      DW   23A0H,TIB-5

      DB   3,'>IN',0
INP:  CALL NEXT
      DW   0,INP-5

      DB   3,'HLD',0
HLD:  CALL NEXT
      DW   0,HLD-5

      DB   4,'SPAN',0
SPAN: CALL NEXT
      DW   0,SPAN-6

      DB   5,'BLOCK',0
BLOCK:CALL NEST
      DW   LIT,3000H
      DW   EXIT,BLOCK-7

      DB   3,'LIT',0
LIT:  MOV  C,M
      INX  H
      MOV  B,M
      INX  H
      PUSH B
      JMP  NEXT
      DW   LIT-5

      DB   1,'@',0
AT_:  XTHL
      MOV  A,M
      INX  H
      MOV  H,M
      MOV  L,A
      XTHL
      JMP  NEXT
      DW   AT_-3

      DB   2,'C@',0
CAT:  POP  B
      LDAX B
      MOV  C,A
      MVI  B,0
      PUSH B
      JMP  NEXT
      DW   CAT-4

      DB   1,'!',0
STOR: POP  B
      XTHL
      MOV  A,L
      STAX B
      INX  B
      MOV  A,H
      STAX B
      POP  H
      JMP  NEXT
      DW   STOR-3

      DB   2,'C!',0
CSTR: POP  B
      XTHL
      MOV  A,L
      STAX B
      POP  H
      JMP  NEXT
      DW   CSTR-4

      DB   5,'CMOVE',0
CMOV: SHLD IPS
      XCHG
      SHLD RPS
      POP  B
      POP  D
      POP  H
      MOV  A,C
      ORA  B
      JZ   CMOV1
CMOV2:MOV  A,M
      STAX D
      INX  H
      INX  D
      DCX  B
      MOV  A,B
      ORA  C
      JNZ  CMOV2
CMOV1:LHLD RPS
      XCHG
      LHLD IPS
      JMP  NEXT
      DW   CMOV-7

      DB   2,'R@',0
RAT:  XCHG
      MOV  C,M
      INX  H
      MOV  B,M
      DCX  H
      XCHG
      PUSH B
      JMP  NEXT
      DW   RAT-4

      DB   2,'R>',0
FROMR:XCHG
      MOV  C,M
      INX  H
      MOV  B,M
      INX  H
      XCHG
      PUSH B
      JMP  NEXT
      DW   FROMR-4

      DB   2,'>R',0
TOR:  POP  B
      XCHG
      DCX  H
      MOV  M,B
      DCX  H
      MOV  M,C
      XCHG
      JMP  NEXT
      DW   TOR-4

      DB   5,'RDROP',0
RDRP: INX  D
      INX  D
      JMP  NEXT
      DW   RDRP-7

      DB   4,'DROP',0
DROP: INX  SP
      INX  SP
      JMP  NEXT
      DW   DROP-6

      DB   5,'2DROP',0
DROP2:INX  SP
      INX  SP
      INX  SP
      INX  SP
      JMP  NEXT
      DW   DROP2-7

      DB   5,'PRESS',0
PRESS:POP  B
      INX  SP
      INX  SP
      PUSH B
      JMP  NEXT
      DW   PRESS-7

      DB   4,'S->D',0
STOD: POP  PSW
      DCX  SP
      DCX  SP
      ORA  A
      JM   TRUE
      JMP  FALS
      DW   STOD-6

      DB   3,'DUP',0
DUP_: POP  B
      PUSH B
      PUSH B
      JMP  NEXT
      DW   DUP_-5

      DB   4,'-DUP',0
DDUP: POP  B
      PUSH B
      MOV  A,B
      ORA  C
      JZ   NEXT
      PUSH B
      JMP  NEXT
      DW   DDUP-6

      DB   4,'OVER',0
OVR:  SHLD IPS
      POP  B
      POP  H
      PUSH H
      PUSH B
      PUSH H
      LHLD IPS
      JMP  NEXT
      DW   OVR-6

      DB   3,'ROT',0
ROT:  SHLD IPS
      POP  B
      POP  H
      XTHL
      PUSH B
      PUSH H
      LHLD IPS
      JMP  NEXT
      DW   ROT-5

      DB   4,'SWAP',0
SWAP: SHLD IPS
      POP  H
      XTHL
      PUSH H
      LHLD IPS
      JMP  NEXT
      DW   SWAP-6

      DB   5,'2SWAP',0
SWAP2:SHLD IPS
      XCHG
      SHLD RPS
      POP  B
      POP  H
      POP  D
      XTHL
      PUSH B
      PUSH H
      PUSH D
      LHLD RPS
      XCHG
      LHLD IPS
      JMP  NEXT
      DW   SWAP2-7

      DB   2,'OR',0
OR_:  POP  B
      XTHL
      MOV  A,B
      ORA  H
      MOV  H,A
      MOV  A,C
      ORA  L
      MOV  L,A
      XTHL
      JMP  NEXT
      DW   OR_-4

      DB   3,'XOR',0
XOR_: POP  B
      XTHL
      MOV  A,B
      XRA  H
      MOV  H,A
      MOV  A,C
      XRA  L
      MOV  L,A
      XTHL
      JMP  NEXT
      DW   XOR_-5

      DB   3,'AND',0
AND_: POP  B
      XTHL
      MOV  A,B
      ANA  H
      MOV  H,A
      MOV  A,C
      ANA  L
      MOV  L,A
      XTHL
      JMP  NEXT
      DW   AND_-5

      DB   2,'1+',0
ONEP: POP  B
      INX  B
      PUSH B
      JMP  NEXT
      DW   ONEP-4

      DB   2,'1-',0
ONEM: POP  B
      DCX  B
      PUSH B
      JMP  NEXT
      DW   ONEM-4

      DB   2,'2+',0
TWOP: POP  B
      INX  B
      INX  B
      PUSH B
      JMP  NEXT
      DW   TWOP-4

      DB   2,'2-',0
TWOM: POP  B
      DCX  B
      DCX  B
      PUSH B
      JMP  NEXT
      DW   TWOM-4

      DB   1,'+',0
PLUS: POP  B
      XTHL
      DAD  B
      XTHL
      JMP  NEXT
      DW   PLUS-3

      DB   2,'+!',0
PSTR: CALL NEST
      DW   DUP_,TOR,AT_,PLUS
      DW   FROMR,STOR,EXIT
      DW   PSTR-4

      DB   1,'-',0
MINU: POP  B
      XTHL
      MOV  A,L
      SUB  C
      MOV  L,A
      MOV  A,H
      SBB  B
      MOV  H,A
      XTHL
      JMP  NEXT
      DW   MINU-3

      DB   2,'D+',0
DPLUS:SHLD IPS
      XCHG
      SHLD RPS
      POP  B
      POP  D
      POP  H
      XTHL
      DAD  D
      XTHL
      RAL
      DAD  B
      RAR
      JNC  DPLU1
      INX  H
DPLU1:PUSH H
      LHLD RPS
      XCHG
      LHLD IPS
      JMP  NEXT
      DW   DPLUS-4

      DB   4,'DNEG',0
DNEG: POP  B
      XTHL
      MOV  A,C
      CMA
      MOV  C,A
      MOV  A,B
      CMA
      MOV  B,A
      MOV  A,L
      CMA
      MOV  L,A
      MOV  A,H
      CMA
      MOV  H,A
      INX  H
      MOV  A,L
      ORA  H
      JNZ  DNEG1
      INX  B
DNEG1:XTHL
      PUSH B
      JMP  NEXT
      DW   DNEG-6

      DB   2,'D-',0
DMINU:CALL NEST
      DW   DNEG,DPLUS
      DW   EXIT,DMINU-4

      DB   4,'DABS',0
DABS: CALL NEST
      DW   DUP_,ZLES,ZBRAN
      DW   DABS1-$,DNEG
DABS1:DW   EXIT,DABS-6

      DB   3,'UM*',0
UMX:  SHLD IPS
      XCHG
      SHLD RPS
      LXI  D,0
      POP  B
      POP  H
      MVI  A,16
UMX1: DAD  H
      XCHG
      JNC  UMX3
      DAD  H
      JNC  UMX2
      INX  D
UMX2: DAD  B
      JNC  UMX4
      INX  D
      JMP  UMX4
UMX3: DAD  H
      JNC  UMX4
      INX  D
UMX4: XCHG
      DCR  A
      JNZ  UMX1
      PUSH D
      PUSH H
      LHLD RPS
      XCHG
      LHLD IPS
      JMP  NEXT
      DW   UMX-5

      DB   6,'UM/MOD',0
UMD:  SHLD IPS
      XCHG
      SHLD RPS
      POP  B
      POP  H
      XTHL
      XCHG
      LXI  H,0
      MVI  A,33
UMD1: DCR  A
      JZ   UMD6
      XCHG
      DAD  H
      XCHG
      RAL
      XTHL
      DAD  H
      RAR
      JNC  UMD2
      INX  H
UMD2: XTHL
      DAD  H
      RAL
      JNC  UMD3
      INX  H
UMD3: ORA  A
      RAR
      PUSH H
      PUSH PSW
      MOV  A,L
      SUB  C
      MOV  L,A
      MOV  A,H
      SBB  B
      MOV  H,A
      JNC  UMD4
      POP  PSW
      JC   UMD5
      POP  H
      JMP  UMD1
UMD4: POP  PSW
UMD5: INX  SP
      INX  SP
      INX  D
      JMP  UMD1
UMD6: XTHL
      PUSH D
      PUSH H
      LHLD RPS
      XCHG
      LHLD IPS
      JMP  NEXT
      DW   UMD-8

      DB   5,'ISDIG',0
ISD:  POP  B
      MOV  A,C
      SUI  30H
      CPI  10
      JM   IS1
      SUI  7
IS1:  POP  B
      CMP  C
      JM   FALS
      MOV  C,A
      MVI  B,0
      PUSH B
      JMP  TRUE
      DW   ISD-7

      DB   4,'2DUP',0
TDUP: SHLD IPS
      POP  H
      POP  B
      PUSH B
      PUSH H
      PUSH B
      PUSH H
      LHLD IPS
      JMP  NEXT
      DW   TDUP-6

      DB   2,'0=',0
ZEQU: POP  B
      MOV  A,B
      ORA  C
      JZ   TRUE
      JMP  FALS
      DW   ZEQU-4

      DB   2,'0<',0
ZBIG: XTHL
      DCX  H
      DAD  H
      POP  H
      JNC  TRUE
      JMP  FALS
      DW   ZBIG-4

      DB   2,'0>',0
ZLES: POP  PSW
      RAL
      JC   TRUE
      JMP  FALS
      DW   ZLES-4

      DB   1,'>',0
BIG:  CALL NEST
      DW   MINU,ZBIG
      DW   EXIT,BIG-3

      DB   1,'<',0
LES_: CALL NEST
      DW   MINU,ZLES
      DW   EXIT,LES_-3

      DB   1,'=',0
EQV:  CALL NEST
      DW   MINU,ZEQU,EXIT
      DW   EQV-3

      DB   3,'KEY',0
KEY:  CALL XKEY
      MOV  C,A
      MVI  B,0
      PUSH B
      JMP  NEXT
      DW   KEY-5

      DB   6,'EXPECT',0
EXPE: POP  B
      XTHL
      PUSH D
      MOV  B,C
      MOV  D,C
EXP1: CALL XKEY
      CPI  20H
      JM   EXP2
      MOV  C,A
      DCR  B
      JNZ  EXP3
      INR  B
      JMP  EXP1
EXP3: MOV  M,C
      INX  H
      CALL XEMIT
      JMP  EXP1
EXP2: CPI  0DH
      JNZ  EXP4
      MVI  M,0
      MOV  A,D
      SUB  B
      STA  SPAN+3
      POP  D
      POP  H
      JMP  NEXT
EXP4: CPI  8
      JNZ  EXP1
      INR  B
      MOV  A,D
      CMP  B
      JP   EXP5
      DCR  B
      JMP  EXP1
EXP5: MVI  C,8
      CALL XEMIT
      MVI  C,20H
      CALL XEMIT
      MVI  C,8
      CALL XEMIT
      DCX  H
      JMP  EXP1
      DW   EXPE-8

      DB   4,'EMIT',0
EMIT: POP  B
      CALL XEMIT
      JMP  NEXT
      DW   EMIT-6


      DB   2,'CR',0
CR:   CALL NEST
      DW   LIT,13,EMIT
      DW   LIT,10,EMIT
      DW   EXIT,CR-4

      DB   5,'*COMP',0
SCOMP:POP  B
      XTHL
      LDAX B
      CMP  M
      JNZ  SCOM1
      PUSH D
      MOV  E,M
      INR  E
SCOM3:DCR  E
      JZ   SCOM2
      INX  H
      INX  B
      LDAX B
      CMP  M
      JZ   SCOM3
      POP  D
SCOM1:POP  H
      JMP  FALS
SCOM2:POP  D
      POP  H
      JMP  TRUE
      DW   SCOMP-7

      DB   3,'SP@',0
SPAT: PUSH H
      LXI  H,2
      DAD  SP
      XTHL
      JMP  NEXT
      DW   SPAT-5

      DB   3,'SP!',0
SPST: PUSH H
      POP  B
      LHLD SPN+1
      SPHL
      PUSH B
      POP  H
      JMP  NEXT
      DW   SPST-5

      DB   3,'RP@',0
RPAT: PUSH D
      JMP  NEXT
      DW   RPAT-5

      DB   3,'RP!',0
RPST: XCHG
      LHLD RPN+1
      XCHG
      JMP  NEXT
      DW   RPST-5

      DB   4,'BASE',0
BASE: CALL NEXT
      DW   10
      DW   BASE-6

      DB   7,'DECIMAL',0
DEC_: CALL NEST
      DW   LIT,10,BASE,STOR
      DW   EXIT,DEC_-9

      DB   3,'HEX',0
HEX:  CALL NEST
      DW   LIT,16,BASE,STOR
      DW   EXIT,HEX-5

      DB   3,'MIN',0
MIN:  CALL NEST
      DW   TDUP,BIG,ZBRAN
      DW   MIN1-$,SWAP
MIN1: DW   DROP,EXIT,MIN-5

      DB   3,'MAX',0
MAX:  CALL NEST
      DW   TDUP,LES_,ZBRAN
      DW   MAX1-$,SWAP
MAX1: DW   DROP,EXIT,MAX-5

      DB   4,'HERE',0
HERE: CALL NEST
      DW   DP_,AT_,EXIT
      DW   HERE-6

      DB   3,'NEW',0
NEW:  CALL NEST
      DW   DP_,AT_,TWOP
      DW   EXIT,NEW-5

      DB   3,'PAD',0
PAD:  CALL NEST
      DW   HERE,LIT,44
      DW   PLUS,EXIT,PAD-5

      DB   5,'ALLOT',0
ALLOT:CALL NEST
      DW   DP_,PSTR
      DW   EXIT,ALLOT-7

      DB   6,'LATEST',0
LATE: CALL NEST
      DW   LAST,AT_,EXIT
      DW   LATE-8

      DB   3,'LFA',0
LFA:  POP  B
      DCX  B
      DCX  B
      PUSH B
      JMP  NEXT
      DW   LFA-5

      DB   3,'CFA',0
CFA:  XTHL
      MOV  C,M
      MVI  B,0
      DAD  B
      INX  H
      INX  H
      XTHL
      JMP  NEXT
      DW   CFA-5

      DB   3,'PFA',0
PFA:  XTHL
      MOV  A,M
      ADI  5
      ADD  L
      MOV  L,A
      XRA  A
      ADC  H
      MOV  H,A
      XTHL
      JMP  NEXT
      DW   PFA-5

      DB   3,'NFA',0
NFA:  XTHL
      DCX  H
N1:   DCX  H
      MVI  A,1FH
      CMP  M
      JP   N1
      XTHL
      JMP  NEXT
      DW   NFA-5

      DB   5,'COUNT',0
COUNT:CALL NEST
      DW   DUP_,ONEP,SWAP,CAT
      DW   EXIT,COUNT-7

      DB   4,'TYPE',0
TYPE: POP  B
      MOV  B,C
      INR  B
      XTHL
T0:   DCR  B
      JZ   T1
      MOV  C,M
      CALL XEMIT
      INX  H
      JMP  T0
T1:   POP  H
      JMP  NEXT
      DW   TYPE-6

      DB   5,'PRINT',0
PRINT:CALL NEST
      DW   COUNT,TYPE,EXIT
      DW   PRINT-7

      DB   7,'ENCLOSE',0
ENCL: SHLD IPS
      POP  B
      POP  H
      PUSH H
      MOV  A,H
      CMA
      MOV  H,A
      MOV  A,L
      CMA
      MOV  L,A
      INX  H
      SHLD RPS
      POP  H
      DAD  B
      POP  B
      MVI  B,0
      PUSH H
      DCX  H
ENCL1:INX  H
      MOV  A,M
      ORA  A
      JZ   ENCL3
      CPI  20H
      JM   ENCL1
      CMP  C
      JZ   ENCL1
      INX  SP
      INX  SP
      PUSH H
ENCL2:INR  B
      INX  H
      MOV  A,M
      CPI  20H
      JM   ENCL3
      CMP  C
      JNZ  ENCL2
      INX  H
ENCL3:DCX  H
      MOV  C,B
      MVI  B,0
      PUSH B
      MOV  B,H
      MOV  C,L
      LHLD RPS
      DAD  B
      INX  H
      PUSH H
      LHLD IPS
      JMP  NEXT
      DW   ENCL-9

      DB   4,'WORD',0
WORD_:CALL NEST
      DW   BLK,AT_,DDUP,ZBRAN
      DW   WOR1-$,BLOCK,BRAN
      DW   WOR2-$
WOR1: DW   TIB,AT_
WOR2: DW   INP,AT_,ENCL,INP,STOR
      DW   DUP_,NEW,CSTR
      DW   NEW,ONEP,SWAP
      DW   CMOV,EXIT,WORD_-6

      DB   4,'(.")',0
PDOT: CALL NEST
      DW   RAT,COUNT,DUP_,ONEP
      DW   FROMR,PLUS,TOR,TYPE
      DW   EXIT,PDOT-6

      DB   5,'SPACE',0
SPACE:CALL NEST
      DW   BL_,EMIT,EXIT
      DW   SPACE-7

      DB   5,'ERRNO',0
ERRNO:CALL NEXT
      DW   -1,ERRNO-7

      DB   3,'.ID',0
ID:   CALL NEST
      DW   NEW,PRINT,EXIT
      DW   ID-5

      DB   5,'ERROR',0
ERR:  CALL NEST
      DW   ERRNO,STOR,RPST,SPST
      DW   ERRNO,AT_,CR
      DW   DUP_,ZEQU,ZBRAN
      DW   ERR1-$,ID,PDOT
      DB   11,' NOT FOUND.'
      DW   ABOR
ERR1: DW   ONEM,DUP_,ZEQU,ZBRAN
      DW   ERR2-$,ID,PDOT
      DB   10,'COMP ONLY!'
      DW   ABOR
ERR2: DW   ONEM,DUP_,ZEQU,ZBRAN
      DW   ERR3-$,ID,PDOT
      DB   10,'EXEC ONLY!'
      DW   ABOR
ERR3: DW   ONEM,DUP_,ZEQU,ZBRAN
      DW   ERR4-$,ID,PDOT
      DB   9,'NOT PAIR!'
      DW   ABOR
ERR4: DW   ONEM,DUP_,ZEQU,ZBRAN
      DW   ERR5-$,PDOT
      DB   13,'STACK DAMAGE!'
      DW   ABOR
ERR5: DW   ONEM,ZEQU,ZBRAN
      DW   ERR6-$,PDOT
      DB   12,'DIV BY ZERO!'
      DW   ABOR
ERR6: DW   PDOT
      DB   6,'ERROR!'
      DW   ABOR,ERR-7

      DB   6,'?STACK',0
QSP:  CALL NEST
      DW   S0,AT_,SPAT,MINU
      DW   ZBIG,TOR,SPAT
      DW   R0,AT_,MINU,ZBIG
      DW   FROMR,AND_,ZBRAN
      DW   QSP1-$,EXIT
QSP1: DW   LIT,4,ERR,QSP-8

      DB   1,'[',0
LBR:  CALL NEST
      DW   FALS,STAT,STOR
      DW   EXIT,LBR-3

      DB   1,']',0
RBR:  CALL NEST
      DW   TRUE,STAT,STOR
      DW   EXIT,RBR-3

      DB   5,'QUERY',0
QUER: CALL NEST
      DW   TIB,AT_,LIT,40,EXPE
      DW   ZERO,INP,STOR,CR
      DW   EXIT,QUER-7

      DB   4,'FIND',0
FIND: CALL NEST
      DW   BL_,WORD_
      DW   NEW,TOR,LATE
FIN1: DW   DUP_,RAT,SCOMP,ZBRAN
      DW   FIN2-$,TRUE
      DW   RDRP,EXIT
FIN2: DW   LFA,AT_,DUP_,ZEQU
      DW   ZBRAN,FIN1-$
      DW   RDRP,EXIT,FIND-6

      DB   3,'DPL',0
DPL:  CALL NEXT
      DW   -1,DPL-5

      DB   5,'NCHAR',0
NCH:  POP  B
      XTHL
      MOV  A,M
      INX  H
      XTHL
      DCX  B
      PUSH B
      MOV  C,A
      MVI  B,0
      PUSH B
      JMP  NEXT
      DW   NCH-7

      DB   6,'?NHEAD',0
NHD:  POP  B
      MOV  A,C
      CPI  '-'
      JZ   NHD1
      CPI  '+'
      JZ   NHD2
      CPI  27H
      JZ   NHD3
      CPI  '&'
      JZ   NHD4
      DCX  SP
      DCX  SP
      JMP  FALS
NHD1: LXI  B,10
      PUSH B
      LXI  B,-1
      JMP  NHD6
NHD2: LXI  B,10
      JMP  NHD5
NHD3: LXI  B,2
      JMP  NHD5
NHD4: LXI  B,16
NHD5: PUSH B
      LXI  B,0
NHD6: PUSH B
      JMP  TRUE
      DW   NHD-8

      DB   4,'NERR',0
NERR: CALL NEST
      DW   DROP2,DROP2,RDRP
      DW   RDRP,FROMR,BASE,STOR
      DW   FALS,EXIT,NERR-6

      DB   6,'NUMBER',0
NUMB: CALL NEST
      DW   BASE,AT_,TOR,FALS
      DW   TOR,TRUE,DPL,STOR
      DW   ZERO,ZERO,ROT
      DW   COUNT,NCH,NHD,ZBRAN
      DW   NUM1-$,RDRP,TOR
      DW   BASE,STOR,NCH,OVR
      DW   ZLES,ZBRAN,NUM1-$
      DW   DROP,NERR
NUM1: DW   DUP_,LIT,'.',EQV
      DW   ZBRAN,NUM2-$,DROP
      DW   DUP_,DPL,STOR,BRAN
      DW   NUM4-$
NUM2: DW   ISD,ZBRAN,NUM3-$
      DW   TOR,SWAP2,BASE,AT_,UMX
      DW   DROP,SWAP,BASE,AT_,UMX
      DW   ROT,ZERO,DPLUS,SWAP2
      DW   BRAN,NUM4-$
NUM3: DW   NERR
NUM4: DW   DDUP,ZBRAN,NUM5-$
      DW   NCH,BRAN,NUM1-$
NUM5: DW   DROP,FROMR,ZBRAN
      DW   NUM6-$,DNEG
NUM6: DW   FROMR,BASE,STOR,TRUE
      DW   EXIT,NUMB-8

      DB   1,',',0
COM:  CALL NEST
      DW   HERE,STOR,TWO,ALLOT
      DW   EXIT,COM-3

      DB   2,'C,',0
CCOM: CALL NEST
      DW   HERE,CSTR,ONE,ALLOT
      DW   EXIT,CCOM-4

      DB   7,'LITERAL',0
LITR: CALL NEST
      DW   LIT,LIT,COM,COM
      DW   EXIT,LITR-9

      DB   8,'DLITERAL',0
DLIT: CALL NEST
      DW   SWAP,LITR,LITR
      DW   EXIT,DLIT-10

      DB   9,'INTERPRET',0
INTER:CALL NEST
INT_1:DW   FIND,ZBRAN
      DW   INT_2-$,CFA,EXEC
      DW   BRAN,INT_1-$
INT_2:DW   NEW,CAT,ZBRAN
      DW   INT_3-$,CR
      DW   ZERO,ERR
INT_3:DW   EXIT,INTER-11

      DB   4,'QUIT',0
QUIT: CALL NEST
      DW   ZERO,BLK,STOR,LBR
QUI:  DW   RPST,CR,PDOT
      DB   8,'FORTH > '
      DW   QUER,CR
      DW   INTER,STAT,AT_,ZEQU
      DW   ZBRAN,QUI-$,PDOT
      DB   3,' OK'
      DW   BRAN,QUI-$,QUIT-6

      DB   5,'ABORT',0
ABOR: CALL NEST
      DW   SPST,DEC_,CR,PDOT
      DB   13,'FORTH IS HERE'
      DW   CR,QUIT,ABOR-7

      DB   6,'CREATE',0
CREAT:CALL NEST
      DW   BL_,WORD_,LATE,COM
      DW   HERE,DUP_,LAST,STOR
      DW   CAT,LIT,16
      DW   MIN,TWOP,ALLOT
      DW   ZERO,CCOM,LIT,0CDH
      DW   CCOM,LIT,NEXT,COM
      DW   EXIT,CREAT-8

      DB   4,'HOLD',0
HOLD: CALL NEST
      DW   HLD,AT_,ONEM,DUP_
      DW   HLD,STOR,CSTR
      DW   EXIT,HOLD-6

      DB   2,'<#',0
BDIG: CALL NEST
      DW   PAD,HLD,STOR,EXIT
      DW   BDIG-4

      DB   1,'#',0
DIG:  CALL NEST
      DW   BASE,AT_,UMD,ROT
      DW   LIT,9,OVR,LES_,ZBRAN
      DW   DIG1-$,LIT,7,PLUS
DIG1: DW   LIT,30H,PLUS,HOLD
      DW   EXIT,DIG-3

      DB   2,'S#',0
SDIG: CALL NEST
SDIG1:DW   DIG,TDUP,OR_,ZEQU
      DW   ZBRAN,SDIG1-$
      DW   EXIT,SDIG-4

      DB   2,'#>',0
EDIG: CALL NEST
      DW   DROP2,HLD,AT_,PAD
      DW   OVR,MINU,EXIT,EDIG-4

      DB   4,'SIGN',0
SIGN: CALL NEST
      DW   ROT,ZLES,ZBRAN
      DW   SIGN1-$,LIT,'-',HOLD
SIGN1:DW   EXIT,SIGN-6

      DB   2,'D.',0
DDOT: CALL NEST
      DW   SWAP,OVR,DABS,BDIG
      DW   SDIG,SIGN,EDIG,TYPE
      DW   EXIT,DDOT-4

      DB   1,'.',0
DOT:  CALL NEST
      DW   STOD,DDOT,EXIT,DOT-3

      DB   2,'U.',0
UDOT: CALL NEST
      DW   ZERO,DDOT,EXIT,UDOT-4

FINW: DB   5,'VLIST',0
VLI:  CALL NEST
      DW   CR,LATE,DUP_,ZERO,TOR
      DW   LIT,16,BASE,STOR
V1:   DW   DUP_,UDOT,FROMR,ONEP
      DW   TOR,DUP_,BL_,EMIT,COUNT
      DW   TYPE,CR,LFA,AT_,DDUP
      DW   ZEQU,ZBRAN,V1-$
      DW   DEC_,CR,FROMR,DOT,PDOT
      DB   12,' WORDS FOUND'
      DW   CR,EXIT,VLI-7
FIN:

RKS_END