.486
.model flat, stdcall
option casemap:none
;----------------------------------------
include windows.inc

uselib MACRO libname
       include    libname.inc
       includelib libname.lib
   ENDM

      uselib kernel32
      uselib user32
      uselib masm32
      uselib debug
;----------------------------------------

WndProc PROTO :DWORD,:DWORD,:DWORD,:DWORD

D_MAIN		EQU 1000
E_CELL		EQU 1100

.data

XX		db "X",0
NoMore	db "  !",0
Found	db "!",0

ncomb	db -1,-2 	;     
		db -2,-1	;   
		db -2, 1
		db -1, 2
		db  1, 2
		db  2, 1
		db  2,-1
		db  1,-2

scomb	db  0,0,0,1,0,2,0,3	;   
		db      1,1,1,2,1,3
		db			2,2,2,3
		db				3,3

moves	dd 0

runa	dd	offset SolvComb
runb	dd  offset combs
runf	db  0
							
.data?

hInstance	DD ?
hWin		dd ?
cnode		dd ?
cstrt		dd ?
combs		dd 64 dup (?)

.code
start:
    invoke GetModuleHandle, NULL
    mov hInstance, eax
    invoke DialogBoxParam,hInstance,D_MAIN,0,ADDR WndProc,0
	invoke ExitProcess,NULL

WndProc proc hWnd:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
	.if uMsg == WM_CLOSE
		invoke EndDialog,hWnd,NULL
	.elseif uMsg == WM_TIMER
		.if runf
			mov edi,runb
			call   [runa]
		.endif
	.elseif uMsg == WM_INITDIALOG
		invoke SetTimer,hWnd,1,10000,0
		mov eax,hWnd
		mov hWin,eax
		call InitSearch
	.elseif uMsg == WM_COMMAND
	    .if wParam == IDCANCEL
			invoke EndDialog,hWnd,NULL
	    .elseif wParam == IDOK
			mov runf,1
			mov edi,runb
			call   [runa]
	    .endif
	.endif
	
	xor eax,eax
	Ret
WndProc EndP

SolvComb proc
	call NewComb
	jc sc_badcell
	call AlreadyBeen
	jc sc_badcell
	inc moves
	add edi,4
	and eax,0FFFFh
	mov dword ptr [edi],eax
	inc cnode
	cmp cnode,64
	jl SolvComb
	invoke KillTimer,hWin,1
	call ClearBoard
	call ShowBoard
    invoke MessageBox,hWin,ADDR Found,NULL,NULL
    mov runf,0
	ret
sc_badcell:
    inc byte ptr [edi+2]
    cmp byte ptr [edi+2],8
    jl SolvComb
	test moves,0FFFFh
	jnz sc_cont
	mov runb,edi
	mov runa,offset sc_cont
    call ClearBoard
    call ShowBoard
    invoke SetDlgItemInt,hWin,1200,moves,0
    ret
sc_cont:    
    sub edi,4
    dec cnode
    jnz sc_badcell
    invoke MessageBox,hWin,ADDR NoMore,NULL,NULL
	Ret
SolvComb EndP

NewComb proc				;     [edi]
	push ebx				;   ,
	xor ebx,ebx				;  
	mov bl,byte ptr [edi+2]	; .
	add bl,bl				;      -
	add ebx,offset ncomb	;   .
	mov ax,word ptr [edi]
	add al,byte ptr [ebx]
	stc
	js nc_exit
	cmp al,8
	cmc
	jc nc_exit
	add ah,byte ptr [ebx+1]
	stc
	js nc_exit
	cmp ah,8
	cmc
nc_exit:
	pop ebx		
	ret
NewComb endp

AlreadyBeen proc	        ; ,    ?
	mov esi,offset combs	;   -   .
ab_cont:
	cmp ax,word ptr [esi]
	stc
	je ab_exit
	cmp esi,edi
	clc
	je ab_exit
	add esi,4
	jmp ab_cont
ab_exit:	
	Ret
AlreadyBeen EndP

ClearBoard proc ;  
    mov ecx,64
cb_cont:
    mov eax,E_CELL-1
    add eax,ecx
	push ecx
	invoke SetDlgItemText,hWin,eax,NULL
	pop ecx
	loop cb_cont    
	Ret
ClearBoard EndP

ShowBoard proc ;    
	mov esi,offset combs
	mov ecx,1
sb_cont:
	mov ax,word ptr [esi]
	shl ah,3
	add	al,ah
	and eax,3Fh
	add eax,E_CELL
	push ecx
	invoke SetDlgItemInt,hWin,eax,ecx,0
	pop ecx
	add esi,4
    inc ecx
	cmp ecx,cnode
	jng sb_cont
	Ret
ShowBoard EndP

InitSearch proc
	mov edi,offset combs
	mov cnode,1
	mov dword ptr [edi],0
	Ret
InitSearch EndP

end start