;=======================================================================
format PE CONSOLE           
;=======================================================================
include 'win32a.inc'    ;*
include "combstr.inc"   ; some handy stuff 
;-----------------------------------------------------------------------
MAX_PARAMS = 2
MIN_PARAMS = 2
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
section '.code' code readable executable
;-----------------------------------------------------------------------
entry $
;-----------------------------------------------------------------------
    invoke GetCommandLine
    stdcall GetParameter,eax        ; skip exe name
    stdcall GetParameter,edx        ; get first parameter
    jnz @F                          ; optimized checking
    mov edx,err0
    jmp error                       ; empty commandline - help screen
@@:
    mov [iname],eax
    cmp byte [edx],0
    mov byte [edx],0
    je  @F
    inc edx
    stdcall GetParameter,edx        ; get extra parameter
    jnz cmderror                    ; has some extra parameters - error
@@:    
;-----------------------------------------------------------------------
;   Opening filenames
;-----------------------------------------------------------------------
    invoke PathUnquoteSpaces,[iname]
;-----------------------------------------------------------------------
    invoke CreateFile,[iname],GENERIC_READ,FILE_SHARE_READ,0,\
                              OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0
    cmp eax,[ihand]
    mov edx,err2
    je  error
    mov [ihand],eax    
;-----------------------------------------------------------------------
    invoke GetFileSize,eax,0
    mov [fsize],eax
;-----------------------------------------------------------------------
CHAR_SIZE equ 512           ; 1 - for byte, 2 - for word, 4 - for dword
;-----------------------------------------------------------------------
;   Reading
;-----------------------------------------------------------------------
next:
    invoke ReadFile,[ihand],ibuff,CHAR_SIZE,cnt,0
    cmp [cnt],CHAR_SIZE
    mov edx,err2
    jne error
;-----------------------------------------------------------------------
;   Processing
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    cmp [flag],0
    jne @F
    cmp word [ibuff],0AA55h
    mov edx,err_signature
    jne error
    inc [flag]
    movzx eax,byte [ibuff + 2]
    mov [cycle],eax
    sal eax,9           ; *512
    mov [romsize],eax
    cmp eax,[fsize]
    mov edx,err_size
    ja  error
    CSNew 256
    CSAdd image_size
    CSAddDec [romsize]
    CSAddChar " ","("
    CSAddHex [romsize]
    CSAddChar "h",")"
    CSEnd
    CSBuff esi
    sub edi,esi
    invoke GetStdHandle,STD_OUTPUT_HANDLE
    invoke WriteFile,eax,esi,edi,cnt,0
    CSFree
@@:
    mov edi,ibuff
    mov ecx,512
    mov al,[sum]
@@:
    add al,[edi]
    inc edi
    loop @B    
    mov [sum],al
    dec [cycle]
    jnz next
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    CSNew 256
    CSAdd image_sum
    movzx eax,[sum]
    mov [cnt],eax   ; halt on non-zero
    CSAddHex 
    CSAddChar "h"
    CSEnd
    CSBuff esi
    sub edi,esi
    invoke GetStdHandle,STD_OUTPUT_HANDLE
    invoke WriteFile,eax,esi,edi,cnt,0
    CSFree
;-----------------------------------------------------------------------
    CSNew 256
    CSAdd correction
    movzx eax,[sum]
    neg al
    CSAddHex 
    CSAddChar "h"
    CSAddCR
    CSEnd
    CSBuff esi
    sub edi,esi
    invoke GetStdHandle,STD_OUTPUT_HANDLE
    invoke WriteFile,eax,esi,edi,cnt,0
    CSFree
    movzx eax,[sum]
    mov [cnt],eax   ; halt on non-zero
    jmp done
;-----------------------------------------------------------------------
cmderror:               ; error in commandline
    mov edx,err1    
;-----------------------------------------------------------------------
error:                  ; in edx - pointer to error message
    push 0
    push cnt
    push edx
    invoke lstrlen,edx
    pop  edx
    push eax
    push edx
    invoke GetStdHandle,STD_ERROR_HANDLE
    invoke WriteFile,eax
    mov [cnt],1
;-----------------------------------------------------------------------
done:
    cmp [ihand],INVALID_HANDLE_VALUE
    je  @F
    invoke CloseHandle,[ihand]
@@:
    invoke ExitProcess,[cnt]
;-----------------------------------------------------------------------
    CSSupport
;-----------------------------------------------------------------------
include "cmdparse.inc" 
include "a2i.inc"
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
section '.data' data readable writeable
err1    db 13,10,"Error in the commandline",13,10
err0    db 13,10,"Checks sum for rom extension image" 
        db 13,10,"Usage: bios_sum <input_file>"
crlf    db 13,10,0
err2    db 13,10,"Error reading file",13,10,0
;err3    db 13,10,"Error writing file",13,10,0
;-----------------------------------------------------------------------
err_signature   db 13,10,"Error: Image has no 55AA signature",0
err_size        db 13,10,"Error: Image size exceeds file size",0
image_size      db 13,10,"Image size: ",0
image_sum       db 13,10,"Image sum:  ",0 
correction      db 13,10,"Correction: ",0
;-----------------------------------------------------------------------
sum     db 0
;-----------------------------------------------------------------------
        align 4
ihand   dd INVALID_HANDLE_VALUE
cnt     dd 0
flag    dd 0
cycle   dd ?
romsize dd ?
fsize   dd ?
iname   dd ?
ibuff   rb 512
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
include "idata.inc"
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
