;=======================================================================
proc GetParameter pString ; v.1.0
;-----------------------------------------------------------------------
;   searches for the beginning of the parameter in string, 
;   skipping leading tabs and spaces, then searches for the end
;   of this parameter, terminated with zero, space or tab.
;   returns pointer to start of parameter in eax,
;   pointer to first byte after parameter in edx,
;   and length of parameter in ecx.
;   spaces and tabs inside quotes not processed as dividers.
;   if there is no parameters eax will be equal to edx and point to
;   termination zero, ecx will be zero, ZF will be on.
;   passed string will not be changed.
;-----------------------------------------------------------------------
    push esi
    mov esi,[pString]
;-----------------------------------------------------------------------
.search_start:
    mov edx,esi
    lodsb
    cmp al,20h
    je  .search_start
    cmp al,9
    je  .search_start
    or  al,al
    jz  .done
;-----------------------------------------------------------------------
    mov ah,20h
    mov ch,'"'
    jmp @F
.search_loop:
    lodsb
@@:
    or  al,al
    jz  .done
    cmp al,9
    jne .not_tab
    mov al,20h
.not_tab:    
    cmp al,ah
    je  .found
    cmp al,ch
    jne .search_loop
    mov ah,ch           
    jmp .search_loop
.found:
    cmp ah,ch
    mov ah,20h
    je  .search_loop     
;-----------------------------------------------------------------------
.done:
    dec esi
    mov eax,edx
    mov ecx,esi
    mov edx,esi
    sub ecx,eax
    pop esi 
    ret  
;-----------------------------------------------------------------------
endp
;=======================================================================
;                   
;=======================================================================
proc ParseCmdLine pCmd,pBuff,sBuff ; v.1.1
;-----------------------------------------------------------------------
;   splits passed string to segments devided by spaces or tabs.
;   returns pointers to the starts of segments in array,
;   ends of segments will be terminated with zero - 
;   passed string will be modified.
;   spaces and tabs inside quotes not processed as dividers.
;   fills buffer (indexes in dwords): 
;   buffer[0] - number of parameters including exe name
;   buffer[1] - pointer to parameter[0] - should be executable name
;   buffer[2] - pointer to 1st parameter
;   buffer[x] - pointer to x-1 parameter
;   sBuff - size of buffer in dwords
;   if buffer size = 0 - error, return non-zero
;   if buffer size insuficient to fit all parameters - stop processing
;       and return non-zero
;   on success returns zero
;-----------------------------------------------------------------------
    push esi
    push edi
    push ebx
;-----------------------------------------------------------------------
    mov ebx,[pBuff]
    cmp [sBuff],0
    je  .done_bad
    mov esi,[pCmd]
    lea edi,[ebx + 4]
;-----------------------------------------------------------------------
    mov dword [ebx],0   
;-----------------------------------------------------------------------
.search_start:
    lodsb
    cmp al,20h
    je  .search_start
    cmp al,9
    je  .search_start
    or  al,al
    jz  .done
;-----------------------------------------------------------------------
    dec [sBuff]
    jz  .done_bad
    dec  esi
    inc dword [ebx]
    mov [edi],esi
    add edi,4
;-----------------------------------------------------------------------
    mov ah,20h
    mov ch,'"'
.search_end:
    lodsb
    or  al,al
    jz  .done
    cmp al,9
    jne .not_tab
    mov al,20h
.not_tab:    
    cmp al,ah
    je  .found
    cmp al,ch
    jne .search_end
    mov ah,ch           
    jmp .search_end
.found:
    cmp ah,ch
    mov ah,20h
    je  .search_end     
;-----------------------------------------------------------------------
    mov byte [esi - 1],0
    jmp .search_start
;-----------------------------------------------------------------------
.done_bad:
    mov eax,1
    jmp @F
.done:
    xor eax,eax
@@:
    pop ebx
    pop edi
    pop esi 
    ret  
;-----------------------------------------------------------------------
endp
;=======================================================================
                   