;=======================================================================
format PE GUI 4.0
;=======================================================================
include 'win32w.inc'            ;*
include 'encoding\win1251.inc'  ;*
include 'rc.inc'                ;*
;-----------------------------------------------------------------------
INVALID_SET_FILE_POINTER equ -1
;-----------------------------------------------------------------------
IDI_MAIN    equ 30
hMain       equ of.hwndOwner
hInstance   equ of.hInstance
;=======================================================================
section '.code' code readable executable

entry $

    invoke Out32,0x37A,0
    invoke GetModuleHandle,0
    mov [hInstance],eax
    invoke DialogBoxParam,eax,D_MAIN,0,dlg_proc,0
    invoke ExitProcess,0
;=======================================================================
proc dlg_proc hWnd, uMsg, wParam, lParam
;-----------------------------------------------------------------------
    local _offset:  dd ?
    local _count:   dd ?
    local _adr:     dd ?
    local _str:     rb 8
;-----------------------------------------------------------------------
    cmp [uMsg],WM_CLOSE
    jne @F
.end_dlg:
    invoke EndDialog,[hWnd],0
.exit_true:
    mov eax,TRUE
    ret
@@:
;-----------------------------------------------------------------------
    cmp [uMsg],WM_INITDIALOG
    jne @F
    mov eax,[hWnd]
    mov [hMain],eax
    invoke LoadIcon,[hInstance],IDI_MAIN
    invoke SendMessage,[hWnd],WM_SETICON,ICON_SMALL,eax
    jmp .exit_true
@@:    
;-----------------------------------------------------------------------
;    cmp [uMsg],?? << add new message
;    jne @F
;    
;    jmp .exit_true
;@@:    
;-----------------------------------------------------------------------
    cmp [uMsg],WM_COMMAND
    jne .exit_false
    cmp [wParam],B_CAN
    je .end_dlg
;-----------------------------------------------------------------------
    cmp [wParam],B_READ
    jne @F
    call .get_params
    jc  .exit_true
    stdcall rom_read,rom_buff,[_adr],[_count]
    invoke GetDlgItemText,[hWnd],E_FILE,rom_file,260
    stdcall write_file,rom_file,rom_buff,[_offset],[_count]
    or  eax,eax
    mov ecx,fwrite_ok
    mov edx,fwrite_fail
    mov eax,0
    cmovnz ecx,edx
    mov edx,MB_ICONERROR
    cmovnz eax,edx
    invoke MessageBox,[hWnd],ecx,prom,eax    
    jmp .exit_true
@@:
;-----------------------------------------------------------------------
    cmp [wParam],B_WRITE
    jne @F
    ;-------------------------------------------------------------------
    call .get_params
    jc  .exit_true
    invoke GetDlgItemText,[hWnd],E_FILE,rom_file,260
    stdcall read_file,rom_file,rom_buff,[_offset],[_count]
    or  eax,eax
    jz  .write
    invoke MessageBox,[hWnd],fread_fail,0,MB_ICONERROR
    jmp .exit_true
.write:    
    invoke MessageBox,[hWnd],write_ready,prom,MB_YESNO or MB_DEFBUTTON2
    cmp eax,IDYES
    jne .exit_true
    invoke IsDlgButtonChecked,[hWnd],C_EMU
    or  eax,eax
    jnz .emu_write
    stdcall rom_write,rom_buff,[_adr],[_count]
.w_compare:    
    stdcall rom_compare,rom_buff,[_adr],[_count]
    or  eax,eax
    mov ecx,write_ok
    mov edx,write_fail
    mov eax,0
    cmovnz ecx,edx
    mov edx,MB_ICONERROR
    cmovnz eax,edx
    invoke MessageBox,[hWnd],ecx,prom,eax    
    jmp .exit_true
;-----------------------------------------------------------------------
.emu_write:
    invoke MessageBox,[hWnd],emu_start,prom,MB_ICONEXCLAMATION
    stdcall emu_write,rom_buff,[_adr],[_count]
    invoke MessageBox,[hWnd],emu_finish,prom,MB_ICONEXCLAMATION
    jmp .w_compare
@@:
;-----------------------------------------------------------------------
    cmp [wParam],B_COMPARE
    jne @F
    call .get_params
    jc  .exit_true
    invoke GetDlgItemText,[hWnd],E_FILE,rom_file,260
    stdcall read_file,rom_file,rom_buff,[_offset],[_count]
    or  eax,eax
    jz  .compare
    invoke MessageBox,[hWnd],fread_fail,0,MB_ICONERROR
    jmp .exit_true
.compare: 
    stdcall rom_compare,rom_buff,[_adr],[_count]
    or  eax,eax
    mov ecx,_match
    mov edx,not_match
    mov eax,0
    cmovnz ecx,edx
    mov edx,MB_ICONERROR
    cmovnz eax,edx
    invoke MessageBox,[hWnd],ecx,prom,eax    
    jmp .exit_true
@@:
;-----------------------------------------------------------------------
    cmp [wParam],B_TEST
    jne @F
    invoke MessageBox,[hWnd],no_rom,prom,\
           MB_YESNO or MB_ICONEXCLAMATION or MB_DEFBUTTON2
    cmp eax,IDYES
    jne .exit_true
    call rom_timer_test
    or  eax,eax
    jz  .timer_error
    invoke Out32,0x37A,4    ;PRG
    invoke MessageBox,[hWnd],hi_on,prom,MB_ICONEXCLAMATION
    invoke Out32,0x37A,0
    jmp .exit_true
.timer_error:
    invoke MessageBox,[hWnd],timer_err,prom,MB_ICONERROR    
    jmp .exit_true
@@:
;-----------------------------------------------------------------------
    cmp [wParam],C_EXPERT
    jne @F
    invoke SendMessage,[lParam],BM_GETCHECK,0,0
    or  eax,eax
    mov ecx,SW_HIDE
    mov edx,SW_SHOW
    cmovnz ecx,edx
    mov [wParam],ecx
    invoke GetDlgItem,[hWnd],E_FSTART
    invoke ShowWindow,eax,[wParam]
    invoke GetDlgItem,[hWnd],L_FSTART
    invoke ShowWindow,eax,[wParam]
    invoke GetDlgItem,[hWnd],E_RSTART
    invoke ShowWindow,eax,[wParam]
    invoke GetDlgItem,[hWnd],L_RSTART
    invoke ShowWindow,eax,[wParam]
    invoke GetDlgItem,[hWnd],E_BLOCK
    invoke ShowWindow,eax,[wParam]
    invoke GetDlgItem,[hWnd],L_BLOCK
    invoke ShowWindow,eax,[wParam]
    jmp .exit_true
@@:
;-----------------------------------------------------------------------
    cmp [wParam],B_CHECK
    jne @F
    call rom_check
    or  eax,eax
    mov ecx,clear
    mov edx,not_clear
    mov eax,0
    cmovnz ecx,edx
    mov edx,MB_ICONERROR
    cmovnz eax,edx
    invoke MessageBox,[hWnd],ecx,prom,eax    
    jmp .exit_true
@@:
;-----------------------------------------------------------------------
    cmp [wParam],B_FILE
    jne @F
    invoke GetDlgItemText,[hWnd],E_FILE,rom_file,1024
    invoke GetOpenFileName,of
    or  eax,eax
    jz  .exit_true
    invoke SetDlgItemText,[hWnd],E_FILE,rom_file
    jmp .exit_true
@@:
;-----------------------------------------------------------------------
;    cmp [wParam],?? ; << add new command
;    jne @F
;    jmp .exit_true
;@@:
;-----------------------------------------------------------------------
.exit_false:
    xor eax,eax
    ret
;-----------------------------------------------------------------------
.get_params:
    invoke IsDlgButtonChecked,[hWnd],C_EXPERT
    or  eax,eax
    jnz @F
    mov [_offset],0
    mov [_adr],0
    mov [_count],800h
    or  eax,eax
    retn
@@:    
    mov eax,E_FSTART
    call .get_number
    jc  .get_param_err
    mov [_offset],ecx
    mov eax,E_RSTART
    call .get_number
    jc  .get_param_err
    mov [_adr],ecx
    mov eax,E_BLOCK
    call .get_number
    jc  .get_param_err
    jecxz .get_param_err1
    mov [_count],ecx
    add ecx,[_adr]
    cmp ecx,2048
    ja  .get_param_err1
    or  eax,eax
    retn
.get_param_err1:
    invoke MessageBox,[hWnd],param_error,0,MB_ICONERROR
.get_param_err:
    stc
    retn        
;-----------------------------------------------------------------------
.get_number:
    push esi
    lea esi,[_str]
    invoke GetDlgItemTextA,[hWnd],eax,esi,8
    or  eax,eax
    jz  .get_number_err
    cmp eax,7
    jae .get_number_err
    xor eax,eax
    xor ecx,ecx
.next:
    lodsb
    or  al,al
    je  .done
    cmp al,"F"
    ja  .get_number_err
    cmp al,"A"
    jb  .digit
    sub al,"A"-10
    jmp .valid
.digit:
    cmp al,"9"
    ja  .get_number_err    
    sub al,"0"
    js  .get_number_err
.valid:
    shl ecx,4
    add cl,al
    jmp .next   
.done:
    xor eax,eax
    pop esi
    retn    
.get_number_err:
    pop esi
    invoke MessageBox,[hWnd],param_error,0,MB_ICONERROR
    stc
    retn            
;-----------------------------------------------------------------------
endp
;=======================================================================
include "romprog.inc"
include "fileop.inc"
;=======================================================================
include 'idata.inc'
include  'data.inc'
;=======================================================================
section '.rsrc' resource data readable
;-----------------------------------------------------------------------
  directory \
    RT_ICON,icons,\
    RT_GROUP_ICON,group_icons,\
    RT_DIALOG,dialogs
;-----------------------------------------------------------------------
  resource icons,\
    1,LANG_NEUTRAL,icon_data

  resource group_icons,\
    IDI_MAIN,LANG_NEUTRAL,main_icon
;-----------------------------------------------------------------------
include "dialogs.tab" ;*
;-----------------------------------------------------------------------
  icon main_icon,icon_data,'573RF2.ico'
;-----------------------------------------------------------------------
include "dialogs.dat" ;*
;======================================================================= 
