;=======================================================================
CLK     EQU  1
OE      EQU  2
PRG     EQU  4
CE      EQU  8
DIR     EQU 32 + 128
;=======================================================================
;
;=======================================================================
proc adr_reset
;-----------------------------------------------------------------------
    invoke Out32,0x37A,OE
    invoke Out32,0x37A,OE or CLK
    invoke Out32,0x37A,OE
    invoke Out32,0x37A,0
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc adr_step count
;-----------------------------------------------------------------------
    inc [count]
    jmp .start
.step:
    invoke Out32,0x37A,0
    invoke Out32,0x37A,CLK
    invoke Out32,0x37A,0
.start:
    dec [count]
    jnz .step
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc byte_read
    invoke Out32,0x37A,DIR or OE or CE
    invoke Inp32,0x378
    push eax
    invoke Out32,0x37A,0
    pop eax
	ret
endp
;=======================================================================
;
;=======================================================================
proc rom_read _dest,_adr,_count
;-----------------------------------------------------------------------
    push edi
    push esi
    mov edi,[_dest]
    mov esi,[_count]
    call adr_reset
    stdcall adr_step,[_adr]
@@:
    call byte_read
    stosb
    stdcall adr_step,1
    dec esi
    jnz @B
    pop esi
    pop edi
;-----------------------------------------------------------------------
	ret
endp
;=======================================================================
;
;=======================================================================
proc rom_compare _dest,_adr,_count
;-----------------------------------------------------------------------
    push edi
    push esi
    mov edi,[_dest]
    mov esi,[_count]
    call adr_reset
    stdcall adr_step,[_adr]
@@:
    call byte_read
    cmp [edi],al
    jne @F
    stdcall adr_step,1
    inc edi
    dec esi
    jnz @B
    xor eax,eax
    pop esi
    pop edi
	ret
@@:
    or  eax,-1
    pop esi
    pop edi
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc rom_check
;-----------------------------------------------------------------------
    push esi
    mov esi,2048
    call adr_reset
@@:
    call byte_read
    inc al
    jnz @F
    stdcall adr_step,1
    dec esi
    jnz @B
    mov eax,esi
@@:
    movzx eax,al
    pop esi
;-----------------------------------------------------------------------
	ret
endp
;=======================================================================
;
;=======================================================================
proc rom_write _dest,_adr,_count
;-----------------------------------------------------------------------
    push edi
    push esi
    mov edi,[_count]
    mov esi,[_dest]
    call adr_reset
    stdcall adr_step,[_adr]
    invoke Out32,0x37A,CE
    invoke Out32,0x37A,CE or PRG
.next:
    lodsb
    movzx eax,al
    invoke Out32,0x378,eax
    invoke Out32,0x37A,PRG
.wloop:
    invoke Inp32,0x379
    test al,80h
    jz  .wloop
    invoke Out32,0x37A,CE or PRG or CLK
    invoke Out32,0x37A,CE or PRG
    dec edi
    jnz .next
    invoke Out32,0x37A,0
;-----------------------------------------------------------------------
	pop esi
	pop edi
	ret
endp
;=======================================================================
;
;=======================================================================
proc emu_write _dest,_adr,_count
;-----------------------------------------------------------------------
    push edi
    push esi
    mov edi,[_count]
    mov esi,[_dest]
    call adr_reset
    stdcall adr_step,[_adr]
@@:
    lodsb
    movzx eax,al
    invoke Out32,0x378,eax
    invoke Out32,0x37A,CE
    invoke Out32,0x37A,OE or CE
    invoke Out32,0x37A,CE
    invoke Out32,0x37A,0
    stdcall adr_step,1
    dec edi
    jnz @B
    pop esi
    pop edi
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc rom_timer_test ; eax=0 -   
;-----------------------------------------------------------------------
    push esi
    xor esi,esi
    invoke Out32,0x37A,CE
    invoke Out32,0x37A,CE or PRG
    invoke Out32,0x37A,PRG
    mov esi,20000
.wloop:
    invoke Inp32,0x379
    test al,80h
    jnz .done
    dec esi
    jnz .wloop
.done:    
    mov eax,esi
    pop esi        
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
