;=======================================================================
proc am_write,_byte
;-----------------------------------------------------------------------
    stdcall reg_write,R_DATA,[_byte]
;-----------------------------------------------------------------------
    mov eax,B_OE OR B_DE
    mov edx,B_OE OR B_CS OR B_PGM
    mov ecx,B_OE OR B_CS
;-----------------------------------------------------------------------
    or  al,[vpp_on]
    or  dl,[vpp_on]
    or  cl,[vpp_on]
;-----------------------------------------------------------------------
    or  al,[addr_x]
    or  dl,[addr_x]
    or  cl,[addr_x]
;-----------------------------------------------------------------------
    push eax
    push edx
    push ecx
;-----------------------------------------------------------------------
    stdcall reg_write,R_CTRL
    stdcall reg_write,R_CTRL
    stdcall reg_write,R_CTRL
;-----------------------------------------------------------------------
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc am_read
;-----------------------------------------------------------------------
    movzx eax,[addr_x]
    or  eax,B_DE or B_CS 
    or  al,[vpp_on]
    stdcall reg_write,R_CTRL,eax
    invoke Out32,0x37A,0
    invoke Inp32,0x379
    and  eax,0F0h
    shr eax,4
    push eax
    invoke Out32,0x37A,P_ALF
    invoke Inp32,0x379
    and  eax,0F0h
    pop edx
    or  edx,eax
    push edx
    movzx eax,[addr_x]
    or  eax,B_DE or B_OE 
    or  al,[vpp_on]
    stdcall reg_write,R_CTRL,eax
    pop eax
;-----------------------------------------------------------------------
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc _am_id
;-----------------------------------------------------------------------
    mov [vpp_on],VPP_ON
    stdcall am_write,0FFh
    stdcall reg_write,R_ADRL,0
    stdcall am_write,90h
    stdcall am_read
    push eax
    stdcall reg_write,R_ADRL,1
    stdcall am_read
    push eax
    mov [vpp_on],0
    stdcall am_write,0FFh
    pop edx
    pop eax
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc am_id
;-----------------------------------------------------------------------
    push edi
    push esi
    mov edi,buffer
    call _am_id
    push edx
    CSAddHex
    CSAddCR
    pop eax
    CSAddHex
    CSEnd
    invoke MessageBox,[hMain],buffer,device_id,0
	pop esi
	pop edi
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc am_byte_write _byte
;-----------------------------------------------------------------------
    push edi
    mov edi,26
@@:
    dec edi
    jz  @F
    stdcall am_write,40h
    stdcall am_write,[_byte]
    ;  10 
    invoke Inp32,0x379
    invoke Inp32,0x379
    invoke Inp32,0x379
    ;
    stdcall am_write,0C0h
    ;  6 
    invoke Inp32,0x379
    invoke Inp32,0x379
    invoke Inp32,0x379
    ;
    stdcall am_read
    cmp al,byte [_byte]
    jne @B
@@:    
    or  edi,edi
    pop edi
    setz al
    movzx eax,al
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc am_erase
;-----------------------------------------------------------------------
    push esi
    push ebx
    call prog_reset_vpp
    mov [event],status_er
    mov esi,[rom_size]
    jmp .start
.next_byte:
    dec esi
    jz  .erase
    call addr_step
.start:    
    stdcall am_read
    or  eax,eax
    jz  .next_byte
    stdcall am_byte_write,0
    push eax
    stdcall am_write,0FFh
    pop  eax
    or eax,eax
    jz  .next_byte
.fail:
    invoke MessageBox,[hMain],erase_err,prom,MB_ICONERROR
    mov esi,1
    jmp .done        
.erase:
    call prog_reset_vpp
    mov esi,[rom_size]
    mov ebx,1001
.next_erase:
    dec ebx
    jz  .fail
    stdcall am_write,20h
    stdcall am_write,20h
    invoke Sleep,10
.check_ff:
    stdcall am_write,0A0h
    ;  6 
    invoke Inp32,0x379
    invoke Inp32,0x379
    invoke Inp32,0x379
    stdcall am_read
    inc al
    jnz .next_erase
    dec esi
    jz  .done_ok
    call addr_step
    jmp .check_ff
.done_ok:
    invoke MessageBox,[hMain],erase_done,prom,0
.done:
    mov [event],0
    call prog_reset
    mov eax,esi
    pop ebx
    pop esi
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc am_check
;-----------------------------------------------------------------------
    mov [event],status_ch
    stdcall prog_check,0,[rom_size],0FFh
    or  eax,eax
    mov ecx,clear
    mov edx,0
    jz  @F
    mov ecx,not_clear
    mov edx,MB_ICONINFORMATION
@@:
    invoke MessageBox,[hMain],ecx,prom,edx
    mov [event],0
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc am_block_write,_buffer,_addr,_size
;-----------------------------------------------------------------------
    mov eax,[_addr]
    and eax,7FFFFh
    mov dword [addr_l],eax
    push edi
    push esi
    mov [vpp_on],VPP_ON
    mov edi,[_size]
    mov esi,[_buffer]
;-----------------------------------------------------------------------
    stdcall reg_write,R_ADRL,[_addr]
    stdcall reg_write,R_ADRH,[_addr+1]
;-----------------------------------------------------------------------
    push 1
.next_byte:
    pop ecx
    lodsb
    stdcall am_byte_write,eax
    or  eax,eax
    push eax
    jnz .done
	stdcall addr_step
	dec edi
	jnz .next_byte
;-----------------------------------------------------------------------
.done:
    call prog_reset
    pop eax
	pop esi
	pop edi
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
