;=======================================================================
proc at_write,_addr,_byte
;-----------------------------------------------------------------------
    stdcall reg_write,R_DATA,[_byte]
    stdcall reg_write,R_ADRL,[_addr]
    stdcall reg_write,R_ADRH,[_addr + 1]
;-----------------------------------------------------------------------
    stdcall reg_write,R_CTRL,B_OE OR B_CS
    stdcall reg_write,R_CTRL,B_OE OR B_CS OR B_PGM
    stdcall reg_write,R_CTRL,B_OE OR B_DE
;-----------------------------------------------------------------------
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc at_write_sector,_addr,_buffer,_size
;-----------------------------------------------------------------------
    local hProc: dd ?
    local _sect: dd ?
    local step1: dd ?
    local step2: dd ?
    local step3: dd ?
;-----------------------------------------------------------------------
    push esi
    push edi
    push ebx
;-----------------------------------------------------------------------
    mov ecx,[_size]
    mov esi,[_buffer]
    sub esp,ecx
    mov edi,esp   
    mov [_sect],esp
    rep movsb
;-----------------------------------------------------------------------
    invoke GetCurrentProcess
    mov [hProc],eax
    invoke SetPriorityClass,eax,HIGH_PRIORITY_CLASS
;-----------------------------------------------------------------------
    mov eax,[_addr]
    and eax,07FFFFh
    mov dword [addr_l],eax
    movzx edi,ah
    movzx ebx,[addr_x]
    mov eax,B_OE OR B_CS
    mov ecx,B_OE OR B_CS OR B_PGM
    mov edx,B_OE OR B_DE
    or  eax,ebx
    or  ecx,ebx
    or  edx,ebx
    mov [step1],eax
    mov [step2],ecx
    mov [step3],edx
;-----------------------------------------------------------------------
    mov esi,[_sect]
    mov ebx,[_size]    
;-----------------------------------------------------------------------
    stdcall at_write,05555h,0AAh
    stdcall at_write,02AAAh,055h
    stdcall at_write,05555h,080h
    stdcall at_write,05555h,0AAh
    stdcall at_write,02AAAh,055h
    stdcall at_write,05555h,020h
;-----------------------------------------------------------------------
    stdcall reg_write,R_ADRL,[_addr]
    stdcall reg_write,R_ADRH,edi
;-----------------------------------------------------------------------
@@:
    lodsb
    stdcall reg_write,R_DATA,eax
    stdcall reg_write,R_CTRL,[step1]
    stdcall reg_write,R_CTRL,[step2]
    stdcall reg_write,R_CTRL,[step3]
    stdcall addr_step
    dec ebx
    jnz @B
;-----------------------------------------------------------------------
    invoke SetPriorityClass,[hProc],NORMAL_PRIORITY_CLASS
;-----------------------------------------------------------------------
    invoke Sleep,[atmel_data.delay]
;-----------------------------------------------------------------------
    add esp,[_size]
    pop ebx
    pop edi
    pop esi
;-----------------------------------------------------------------------
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc _at_id
;-----------------------------------------------------------------------
    stdcall at_write,05555h,0AAh
    stdcall at_write,02AAAh,055h
    stdcall at_write,05555h,090h
    invoke Sleep,10
;-----------------------------------------------------------------------
    stdcall reg_write,R_ADRL,0
    stdcall prog_read_byte
    push eax
;-----------------------------------------------------------------------
    stdcall reg_write,R_ADRL,1
    stdcall prog_read_byte
    push eax
;-----------------------------------------------------------------------
    stdcall at_write,05555h,0AAh
    stdcall at_write,02AAAh,055h
    stdcall at_write,05555h,0F0h
    invoke Sleep,10
;-----------------------------------------------------------------------
    pop edx
    pop eax
;-----------------------------------------------------------------------
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc _at_detect_lockout
;-----------------------------------------------------------------------
    stdcall at_write,05555h,0AAh
    stdcall at_write,02AAAh,055h
    stdcall at_write,05555h,090h
    invoke Sleep,10
;-----------------------------------------------------------------------
    stdcall reg_write,R_ADRL,2
    stdcall prog_read_byte
    push eax
;-----------------------------------------------------------------------
    stdcall reg_write,R_ADRL,0F2h
    stdcall reg_write,R_ADRH,0FFh
    stdcall prog_read_byte
    push eax
;-----------------------------------------------------------------------
    stdcall at_write,05555h,0AAh
    stdcall at_write,02AAAh,055h
    stdcall at_write,05555h,0F0h
    invoke Sleep,10
;-----------------------------------------------------------------------
    pop edx
    pop eax
;-----------------------------------------------------------------------
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc at_unlock_boot
;-----------------------------------------------------------------------

    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc at_id
;-----------------------------------------------------------------------
    invoke DialogBoxParam,[hInstance],D_AT_ID,[hMain],at_dlgproc,0
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc at_dlgproc hWnd,uMsg,wParam,lParam
;-----------------------------------------------------------------------
    cmp [uMsg],WM_CLOSE
    jne @F
.exit_can:
    invoke EndDialog,[hWnd],0
.exit_true:
    mov eax,TRUE
    ret
@@:
;-----------------------------------------------------------------------
    cmp [uMsg],WM_INITDIALOG
    jne @F
    push edi
    push esi
    mov edi,buffer
    call _at_id
    push edx
    CSAddHex
    CSEnd
    invoke SetDlgItemText,[hWnd],L_DEVID,buffer
    mov edi,buffer
    pop eax
    CSAddHex
    CSEnd
    invoke SetDlgItemText,[hWnd],L_VENDID,buffer
    jmp .exit_true
@@:
;-----------------------------------------------------------------------
    cmp [uMsg],WM_COMMAND
    jne .exit_false
    cmp [wParam],B_CAN
    je  .exit_can
;-----------------------------------------------------------------------
    cmp [wParam],B_SETSDP
    jne @F
    mov eax,[rom_type]
    mov eax,[eax + FLASHDATA.data]
    dec eax
    mov [wParam],eax
    stdcall reg_write,R_ADRH,0
    invoke GetCurrentProcess
    mov [uMsg],eax
    invoke SetPriorityClass,eax,HIGH_PRIORITY_CLASS
    stdcall at_write,05555h,0AAh
    stdcall at_write,02AAAh,055h
    stdcall at_write,05555h,0A0h
.setsdp:    
    stdcall reg_write,R_ADRL,[wParam]
    stdcall reg_write,R_DATA,-1
    stdcall reg_write,R_CTRL,B_OE OR B_CS
    stdcall reg_write,R_CTRL,B_OE OR B_CS OR B_PGM
    stdcall reg_write,R_CTRL,B_OE OR B_DE
    sub [wParam],1
    jns .setsdp
    invoke SetPriorityClass,[uMsg],NORMAL_PRIORITY_CLASS
    invoke Sleep,[atmel_data.delay]
    jmp .exit_true
@@:
;-----------------------------------------------------------------------
    cmp [wParam],B_DROPSDP
    jne @F
    mov eax,[rom_type]
    mov eax,[eax + FLASHDATA.data]
    dec eax
    mov [wParam],eax
    stdcall reg_write,R_ADRH,0
    invoke GetCurrentProcess
    mov [uMsg],eax
    invoke SetPriorityClass,eax,HIGH_PRIORITY_CLASS
    stdcall at_write,05555h,0AAh
    stdcall at_write,02AAAh,055h
    stdcall at_write,05555h,080h
    stdcall at_write,05555h,0AAh
    stdcall at_write,02AAAh,055h
    stdcall at_write,05555h,020h
    jmp .setsdp    
@@:
;-----------------------------------------------------------------------
    cmp [wParam],B_OK
    jne .exit_false

.exit_false:        
	xor eax,eax
.exit:	
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc at_block_write,_buffer,_addr,_size
;-----------------------------------------------------------------------
    mov eax,[atmel_data.sector]
    mov edx,[_addr]
    dec eax
    and edx,eax
    jz  @F
    invoke MessageBox,[hMain],param_error,prom,MB_ICONERROR
    mov eax,1
    ret ;      
;-----------------------------------------------------------------------
@@:
    stdcall at_write_sector,[_addr],[_buffer],[atmel_data.sector]
    mov eax,[atmel_data.sector]
    add [_buffer],eax
    add [_addr],eax
    sub [_size],eax
    jg  @B
;-----------------------------------------------------------------------
    xor eax,eax
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc at_256block_write,_buffer,_addr,_size
;-----------------------------------------------------------------------
    mov eax,256
    mov edx,[_addr]
    dec eax
    and edx,eax
    jz  @F
    invoke MessageBox,[hMain],param_error,prom,MB_ICONERROR
    mov eax,1
    ret ;      
;-----------------------------------------------------------------------
@@:
    stdcall at_write_sector,[_addr],[_buffer],256
    mov eax,256
    add [_buffer],eax
    add [_addr],eax
    sub [_size],eax
    jg  @B
;-----------------------------------------------------------------------
    xor eax,eax
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc ee_block_write,_buffer,_addr,_size
;-----------------------------------------------------------------------
    mov eax,[atmel_data.sector]
    mov edx,[_addr]
    dec eax
    and edx,eax
    jz  @F
    invoke MessageBox,[hMain],param_error,prom,MB_ICONERROR
    mov eax,1
    ret ;      
;-----------------------------------------------------------------------
@@:
    stdcall ee_write_sector,[_addr],[_buffer],[atmel_data.sector]
    mov eax,[atmel_data.sector]
    add [_buffer],eax
    add [_addr],eax
    sub [_size],eax
    jg  @B
;-----------------------------------------------------------------------
    xor eax,eax
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc ee_write_sector,_addr,_buffer,_size
;-----------------------------------------------------------------------
    local step1: dd ?
    local step2: dd ?
    local step3: dd ?
    local hProc: dd ?
;-----------------------------------------------------------------------
    invoke GetCurrentProcess
    mov [hProc],eax
    invoke SetPriorityClass,eax,HIGH_PRIORITY_CLASS
;-----------------------------------------------------------------------
    push esi
    push edi
    push ebx
;-----------------------------------------------------------------------
    mov eax,[_addr]
    and eax,07FFFFh
    mov dword [addr_l],eax
    movzx edi,ah
    movzx ebx,[addr_x]
    mov eax,B_OE OR B_CS
    mov ecx,B_OE OR B_CS OR B_PGM
    mov edx,B_OE OR B_DE
    or  eax,ebx
    or  ecx,ebx
    or  edx,ebx
    mov [step1],eax
    mov [step2],ecx
    mov [step3],edx
;-----------------------------------------------------------------------
    mov esi,[_buffer]
    mov ebx,[_size]    
;-----------------------------------------------------------------------
    stdcall reg_write,R_ADRL,[_addr]
    stdcall reg_write,R_ADRH,edi
;-----------------------------------------------------------------------
@@:
    lodsb
    stdcall reg_write,R_DATA,eax
    stdcall reg_write,R_CTRL,[step1]
    stdcall reg_write,R_CTRL,[step2]
    stdcall reg_write,R_CTRL,[step3]
    stdcall addr_step
    dec ebx
    jnz @B
;-----------------------------------------------------------------------
    invoke SetPriorityClass,[hProc],NORMAL_PRIORITY_CLASS
;-----------------------------------------------------------------------
    invoke Sleep,[ee_data.delay]
;-----------------------------------------------------------------------
    pop ebx
    pop edi
    pop esi
;-----------------------------------------------------------------------
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc ee_erase
;-----------------------------------------------------------------------
    invoke MessageBox,[hMain],q_erase,prom,MB_ICONASTERISK or MB_YESNO
    cmp eax,IDYES
    jne .done
    invoke SetWindowText,[hStatus],status_er
;-----------------------------------------------------------------------
    stdcall at_write,05555h,0AAh
    stdcall at_write,02AAAh,055h
    stdcall at_write,05555h,080h
    stdcall at_write,05555h,0AAh
    stdcall at_write,02AAAh,055h
    stdcall at_write,05555h,010h
    invoke Sleep,50
;-----------------------------------------------------------------------
.done:
    invoke SetWindowText,[hStatus],erase_done
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
