;=======================================================================
proc at49_chip_erase
;-----------------------------------------------------------------------
    stdcall at_write,05555h,0AAh
    stdcall at_write,02AAAh,055h
    stdcall at_write,05555h,080h
    stdcall at_write,05555h,0AAh
    stdcall at_write,02AAAh,055h
    stdcall at_write,05555h,010h
    invoke Sleep,10000
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc at49_sector_erase,_addr
;-----------------------------------------------------------------------
    and [_addr],7FFFFh
    mov edx,B_OE OR B_DE
    mov ecx,B_OE OR B_CS OR B_PGM
    mov eax,B_OE OR B_CS
    or  dl,byte [_addr + 2] 
    or  cl,byte [_addr + 2] 
    or  al,byte [_addr + 2]  
    push edx
    push ecx
    push eax
;-----------------------------------------------------------------------
    stdcall at_write,05555h,0AAh
    stdcall at_write,02AAAh,055h
    stdcall at_write,05555h,080h
    stdcall at_write,05555h,0AAh
    stdcall at_write,02AAAh,055h
    movzx eax,byte [_addr]
    stdcall reg_write,R_ADRL,eax
    movzx eax,byte [_addr + 1]
    stdcall reg_write,R_ADRH,eax
    stdcall reg_write,R_DATA,030h
    stdcall reg_write,R_CTRL
    stdcall reg_write,R_CTRL
    stdcall reg_write,R_CTRL
    invoke Sleep,10000
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc at49_byte_write,_byte
;-----------------------------------------------------------------------
    mov edx,B_OE OR B_DE
    mov ecx,B_OE OR B_CS OR B_PGM
    mov eax,B_OE OR B_CS
    or  dl,[addr_x] 
    or  cl,[addr_x] 
    or  al,[addr_x]  
    push edx
    push ecx
    push eax
    stdcall at_write,05555h,0AAh
    stdcall at_write,02AAAh,055h
    stdcall at_write,05555h,0A0h
    movzx eax,[addr_l]
    stdcall reg_write,R_ADRL,eax
    movzx eax,[addr_h]
    stdcall reg_write,R_ADRH,eax
    stdcall reg_write,R_DATA,[_byte]
    stdcall reg_write,R_CTRL
    stdcall reg_write,R_CTRL
    stdcall reg_write,R_CTRL
    ;  10 
    invoke Inp32,0x379
    invoke Inp32,0x379
    invoke Inp32,0x379
    ;
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc at49_block_write,_buffer,_addr,_size
;-----------------------------------------------------------------------
    mov eax,[_addr]
    and eax,7FFFFh
    mov dword [addr_l],eax
    push edi
    push esi
    mov edi,[_size]
    mov esi,[_buffer]
;-----------------------------------------------------------------------
.next_byte:
    lodsb
    stdcall at49_byte_write,eax
	stdcall addr_step
	dec edi
	jnz .next_byte
;-----------------------------------------------------------------------
.done:
    stdcall at_write,0,0F0h
    call prog_reset
    xor eax,eax
	pop esi
	pop edi
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc at49_erase
;-----------------------------------------------------------------------
    local _status: rw 128
;-----------------------------------------------------------------------
	push ebx
	push edi
	push esi
    invoke SetWindowText,[hStatus],status_er
	invoke DialogBoxParam,[hInstance],D_BLOCK,[hMain],at49_blocks,0
    cmp eax,-1
    je  .done
    cmp eax,-2
    jne @F
    call at49_chip_erase
    jmp .done
@@:
    stdcall at49_sector_erase,eax    
.done:
    stdcall at_write,0,0F0h
    invoke SetWindowText,[hStatus],0
    pop esi
    pop edi
	pop ebx
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc at49_blocks hWnd,uMsg,wParam,lParam
;-----------------------------------------------------------------------
    cmp [uMsg],WM_CLOSE
    jne @F
.exit_can:
    invoke EndDialog,[hWnd],-1
.exit_true:
    mov eax,TRUE
    ret
@@:
;-----------------------------------------------------------------------
    cmp [uMsg],WM_INITDIALOG
    jne @F
    invoke SendDlgItemMessage,[hWnd],R_WHOLE,BM_SETCHECK,1,0
    jmp .exit_true
@@:
;-----------------------------------------------------------------------
    cmp [uMsg],WM_COMMAND
    jne .exit_false
    cmp [wParam],B_CAN
    je  .exit_can
;-----------------------------------------------------------------------
    cmp [wParam],R_WHOLE
    jne @F
    invoke GetDlgItem,[hWnd],E_BLOCK
    invoke EnableWindow,eax,FALSE
    jmp .exit_false
@@:    
;-----------------------------------------------------------------------
    cmp [wParam],R_BLOCK
    jne @F
    invoke GetDlgItem,[hWnd],E_BLOCK
    invoke EnableWindow,eax,TRUE
    jmp .exit_false
@@:    
;-----------------------------------------------------------------------
    cmp [wParam],B_OK
    jne .exit_false
    invoke IsDlgButtonChecked,[hWnd],R_WHOLE
    or  eax,eax
    mov eax,-2
    jnz @F    
    invoke GetDlgItemTextA,[hWnd],E_BLOCK,buffer,16
    stdcall get_hex_number,buffer
    jc  .error
@@:
    invoke EndDialog,[hWnd],eax
.exit_false:        
	xor eax,eax
.exit:	
	ret
.error:
    invoke MessageBox,[hWnd],number_err,0,MB_ICONERROR
	jmp .exit_false
;-----------------------------------------------------------------------
endp
;=======================================================================
