;=======================================================================
P3.1    equ 40h
XTAL    equ 20h
P3.2    equ 10h
P3.3    equ 08h
P3.4    equ 04h
P3.5    equ 02h
P3.7    equ 01h 
;-----------------------------------------------------------------------
AT89_PROG   equ P3.2
AT89_WRITE  equ P3.4 or P3.5 or P3.7
AT89_ERASE  equ P3.3
AT89_READ   equ P3.2 or P3.5 or P3.7
AT89_ID     equ P3.2
;=======================================================================
;
;=======================================================================
proc at89_write,buffer,_adr,_count
;-----------------------------------------------------------------------
    invoke SetWindowText,[hStatus],status_wr
    push ebx
    push esi
    mov ebx,[_count]
    mov esi,[buffer]
    stdcall reg_write,R_ADRL,AT89_READ
    stdcall reg_write,R_CTRL,B_DE
    stdcall reg_write,R_CTRL,B_DE or B_OE
;-----------------------------------------------------------------------
    cmp [_adr],0
    je  @F
    stdcall at89_skip,[_adr]
@@:
    stdcall reg_write,R_ADRL,AT89_WRITE or AT89_PROG
;-----------------------------------------------------------------------
    stdcall reg_write,R_CTRL,VPP_ON or B_CS or B_OE
;-----------------------------------------------------------------------
@@:
    lodsb
    stdcall reg_write,R_DATA,eax
    stdcall reg_write,R_ADRL,AT89_WRITE 
    stdcall reg_write,R_ADRL,AT89_WRITE or AT89_PROG
    invoke Sleep,3
    stdcall reg_write,R_ADRL,AT89_WRITE or AT89_PROG or XTAL 
    stdcall reg_write,R_ADRL,AT89_WRITE or AT89_PROG
    dec ebx
    jnz @B
;-----------------------------------------------------------------------
    stdcall reg_write,R_CTRL,B_DE or B_CS or B_OE
;-----------------------------------------------------------------------
    xor eax,eax
    pop esi
    pop ebx
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc at89_comp,buffer,_adr,_count
;-----------------------------------------------------------------------
    invoke SetWindowText,[hStatus],status_ch
    push ebx
    push esi
    mov ebx,[_count]
    mov esi,[buffer]
    stdcall reg_write,R_ADRL,AT89_READ
    stdcall reg_write,R_CTRL,B_DE
    stdcall reg_write,R_CTRL,B_DE or B_OE
;-----------------------------------------------------------------------
    cmp [_adr],0
    je  @F
    stdcall at89_skip,[_adr]
@@:
    stdcall prog_read_data
    cmp al,[esi]
    jne @F
    stdcall reg_write,R_ADRL,AT89_READ or XTAL
    stdcall reg_write,R_ADRL,AT89_READ
    inc esi
    dec ebx
    jnz @B
    xor eax,eax
@@:    
;-----------------------------------------------------------------------
    pop esi
    pop ebx
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc at89_check
;-----------------------------------------------------------------------
    invoke SetWindowText,[hStatus],status_ch
    push ebx
    mov ebx,[rom_size]
    stdcall reg_write,R_ADRL,AT89_READ
    stdcall reg_write,R_CTRL,B_DE
    stdcall reg_write,R_CTRL,B_DE or B_OE
;-----------------------------------------------------------------------
@@:
    stdcall prog_read_data
    inc al
    mov eax,MB_ICONINFORMATION
    mov ecx,not_clear
    jnz @F
    stdcall reg_write,R_ADRL,AT89_READ or XTAL
    stdcall reg_write,R_ADRL,AT89_READ
    dec ebx
    jnz @B
    xor eax,eax
    mov ecx,clear
@@:    
;-----------------------------------------------------------------------
    invoke MessageBox,[hMain],ecx,prom,eax
    invoke SetWindowText,[hStatus],check_done
    pop ebx
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc at89_read,buffer,_adr,_count
;-----------------------------------------------------------------------
    push ebx
    push edi
    mov ebx,[_count]
    mov edi,[buffer]
    stdcall reg_write,R_ADRL,AT89_READ
    stdcall reg_write,R_CTRL,B_DE
    stdcall reg_write,R_CTRL,B_DE or B_OE
;-----------------------------------------------------------------------
    cmp [_adr],0
    je  @F
    stdcall at89_skip,[_adr]
@@:
;-----------------------------------------------------------------------
    stdcall prog_read_data
    stosb
    stdcall reg_write,R_ADRL,AT89_READ or XTAL
    stdcall reg_write,R_ADRL,AT89_READ
    dec ebx
    jnz @B
;-----------------------------------------------------------------------
    pop edi
    pop ebx
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc at89_skip,num
;-----------------------------------------------------------------------
    cmp [num],0
    je  .done
@@:
    stdcall reg_write,R_ADRL,AT89_READ or XTAL
    stdcall reg_write,R_ADRL,AT89_READ
    dec [num]
    jnz @B
.done:
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc at89_erase
;-----------------------------------------------------------------------
    invoke SetWindowText,[hStatus],status_er
    stdcall reg_write,R_CTRL,B_DE
    stdcall reg_write,R_CTRL,B_DE or B_OE
    stdcall reg_write,R_CTRL,B_DE or B_OE or VPP_ON
    stdcall reg_write,R_ADRL,AT89_ERASE or AT89_PROG
    stdcall reg_write,R_ADRL,AT89_ERASE
    invoke Sleep,10
    stdcall reg_write,R_ADRL,AT89_ERASE or AT89_PROG
    stdcall reg_write,R_CTRL,B_DE or B_OE
    invoke SetWindowText,[hStatus],erase_done
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc at89_id
;-----------------------------------------------------------------------
    push edi
    push esi
    mov edi,buffer
    stdcall reg_write,R_CTRL,B_DE
    stdcall reg_write,R_CTRL,B_DE or B_OE
    stdcall reg_write,R_ADRL,AT89_ID
    stdcall prog_read_data
    CSAddHex
    CSAddCR
    stdcall reg_write,R_ADRL,AT89_ID or XTAL
    stdcall reg_write,R_ADRL,AT89_ID
    stdcall prog_read_data
    CSAddHex
    CSAddCR
    stdcall reg_write,R_ADRL,AT89_ID or XTAL
    stdcall reg_write,R_ADRL,AT89_ID
    stdcall prog_read_data
    CSAddHex
    CSEnd
    invoke MessageBox,[hMain],buffer,device_id,0
	pop esi
	pop edi
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
