;=======================================================================
section '.data' data readable writeable
;-----------------------------------------------------------------------
rom_size    dd 1024*128
rom_type    dd flashdata
event       dd 0
checked     dd 0
;-----------------------------------------------------------------------
of OPENFILENAME \
    sizeof.OPENFILENAME,,,f_filter,,,,filename,1024,,,\
    cur_dir,,OFN_HIDEREADONLY
;-----------------------------------------------------------------------
flashdata:
    FLASHDATA chips.in_1,128*1024,\
        in_ini,in_id,0,in_check,in_block_write,in_erase,0,1
    FLASHDATA chips.in_2,128*1024,\
        in_ini,in_id,0,in_check,in_block_write,in_erase,0,2
;    FLASHDATA chips.in_3,64*1024,\
;        0,am_id,0,am_check,am_block_write,am_erase,0,0   
    FLASHDATA chips.at_1,128*1024,\
        0,at_id,0,0,at_block_write,0,0,128   
    FLASHDATA chips.at_5,512*1024,\
        0,at_id,0,0,at_256block_write,0,0,256   
    FLASHDATA chips.at_6,64*1024,\
        0,at_id,0,am_check,at49_block_write,at49_erase,0,0   
    FLASHDATA chips.at_2,256*1024,\
        0,at_id,0,am_check,at49_block_write,at49_erase,0,0   
    FLASHDATA chips.t2313,2*1024,\
        0,t2313_id,t2313_rd_flash,t2313_check,t2313_wr_flash,\
        t2313_erase,t2313_cmp_flash,16   
    FLASHDATA chips.t2313e,128,\
        0,t2313_id,t2313_rd_eeprom,t2313_check_e,t2313_wr_eeprom,\
        t2313_erase_e,t2313_cmp_eeprom,4   
    FLASHDATA chips.at_3,2*1024,\
        0,at89_id,at89_read,at89_check,at89_write,at89_erase,at89_comp,0   
    FLASHDATA chips.at_4,4*1024,\
        0,at89_id,at89_read,at89_check,at89_write,at89_erase,at89_comp,0   
    FLASHDATA chips.am_1,128*1024,\
        0,am_id,0,am_check,am_block_write,am_erase,0,0   
    FLASHDATA chips.ee_1,64*1024,\
        0,at_id,0,am_check,ee_block_write,ee_erase,0,128   
    dd 0 
;-----------------------------------------------------------------------
intel_data:
.block_a:   dd 0,0
.block_b:   dd 0,0
.block_c:   dd 0,0
.block_d:   dd 0,0
.name:      dd 0,0
.b:         du "02000h",0,0,"03000h",0,0,"04000h",0,0
.t:         du "1C000h",0,0,"1D000h",0,0,"1E000h",0,0
;-----------------------------------------------------------------------
chips:
.in_1:      du "i28F001BX-T",0
.in_2:      du "i28F001BX-B",0
;.in_3:      du "i28F512",0
.at_1:      du "AT29C010A",0
.at_6:      du "AT49F512",0
.at_2:      du "AT49F002",0
.at_3:      du "AT89C2051/2052",0
.at_4:      du "AT89C4051/4052",0
.at_5:      du "AT29C040A",0
.am_1:      du "AM28F001",0
.ee_1:      du "W29EE512",0
.t2313:     du "ATTINY2313 - FLASH",0
.t2313e:    du "ATTINY2313 - EEPROM",0
;-----------------------------------------------------------------------
            align 4
atmel_data:
.sector:    dd 128
.delay:     dd 50
.dev        dd 0
;-----------------------------------------------------------------------
ee_data:
.delay:     dd 50
;-----------------------------------------------------------------------
cur_dir     du ".\",0
f_filter    du "  (*.bin,*.rom)",0
            du "*.bin;*.rom",0
            du " ",0
            du "*.*",0
            du 0
;-----------------------------------------------------------------------
prom        du "",0
device_id   du " ",0
no_rom      du "    !",13,10
            du "?",0
hi_on       du "  !",13,10
            du " ''  .",0
clear       du " ...",0
not_clear   du "  !",0
_match      du " !",0
not_match   du " !",0
write_ready du "   ",13,10
            du "  ''   .",0
write_done  du "  .",13,10
            du "   ",13,10
            du "  ",0
write_ok    du "  !",0
write_fail  du " !",0
            du "  ",13,10
            du "  !",0
fread_fail  du "  !",0
fwrite_fail du "   !",0 
fwrite_ok   du "    !",0 
param_error du "  !",0
emu_start   du "   ",0
emu_finish  du "   ",0
timer_err   du "  !",0
timer_chk   du "     ",0
not_checked du "   !",13,10
            du "?",0
timer_fail  du "  !",0    
not_impl    du "    !",0 
erase_err   du " !",0   
erase_done  du " ...",0
check_done  du " ...",0    
number_err  du " !",0
q_erase     du " ?",0
q_sure      du " ?",0
odd_msg     du "     !",0
avr_erase_e du " EEPROM      FLASH",0
;-----------------------------------------------------------------------
status_wr   du ": ",0
status_rd   du ": ",0
status_ch   du ": ",0
status_er   du ": ",0
;=======================================================================
align 4
;-----------------------------------------------------------------------
hStatus     dd ?
addr_l      db ?
addr_h      db ?
addr_x      db ?
vpp_on      db ?
filename    rw 260
buffer      rb 1024*512
status      rw 128
blocks_data rd 32
;=======================================================================
