;=======================================================================
proc in_write,_byte
;-----------------------------------------------------------------------
    stdcall reg_write,R_DATA,[_byte]
;-----------------------------------------------------------------------
    mov eax,B_OE OR B_DE
    mov edx,B_OE OR B_CS OR B_PGM
    mov ecx,B_OE OR B_CS
;-----------------------------------------------------------------------
    or  al,[vpp_on]
    or  dl,[vpp_on]
    or  cl,[vpp_on]
;-----------------------------------------------------------------------
    or  al,[addr_x]
    or  dl,[addr_x]
    or  cl,[addr_x]
;-----------------------------------------------------------------------
    push eax
    push edx
    push ecx
;-----------------------------------------------------------------------
    stdcall reg_write,R_CTRL
    stdcall reg_write,R_CTRL
    stdcall reg_write,R_CTRL
;-----------------------------------------------------------------------
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc in_read
;-----------------------------------------------------------------------
    movzx eax,[addr_x]
    or  eax,B_DE or B_CS 
    or  al,[vpp_on]
    stdcall reg_write,R_CTRL,eax
    invoke Out32,0x37A,0
    invoke Inp32,0x379
    and  eax,0F0h
    shr eax,4
    push eax
    invoke Out32,0x37A,P_ALF
    invoke Inp32,0x379
    and  eax,0F0h
    pop edx
    or  edx,eax
    push edx
    movzx eax,[addr_x]
    or  eax,B_DE or B_OE 
    or  al,[vpp_on]
    stdcall reg_write,R_CTRL,eax
    pop eax
;-----------------------------------------------------------------------
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc _in_id
;-----------------------------------------------------------------------
    stdcall reg_write,R_ADRL,0
    stdcall in_write,90h
    stdcall in_read
    push eax
    stdcall reg_write,R_ADRL,1
    stdcall in_read
    push eax
    stdcall in_write,0FFh
    pop edx
    pop eax
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc in_id
;-----------------------------------------------------------------------
    push edi
    push esi
    mov edi,buffer
    call _in_id
    push edx
    CSAddHex
    CSAddCR
    pop eax
    CSAddHex
    CSEnd
    invoke MessageBox,[hMain],buffer,device_id,0
	pop esi
	pop edi
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc in_block_erase _addr
;-----------------------------------------------------------------------
    local cnt: DWORD
;-----------------------------------------------------------------------
    mov [cnt],10
    mov [vpp_on],VPP_ON
    stdcall in_write,50h
    stdcall reg_write,R_ADRL,[_addr]
    stdcall reg_write,R_ADRH,[_addr+1]
    mov al,byte [_addr+2]
    and al,3
    mov [addr_x],al
    stdcall in_write,20h
    stdcall in_write,0D0h
@@:
    invoke Sleep,1000
    stdcall in_write,70h
    stdcall in_read
    test al,80h
    jnz  @F
    dec [cnt]
    mov eax,-1
    jnz @B
@@:    
    and eax,111000b
    push eax
    mov [vpp_on],0
    mov ecx,B_OE OR B_CS
    movzx eax,[addr_x]
    or  eax,B_DE or B_OE 
    stdcall reg_write,R_CTRL,eax
    stdcall in_write,0FFh
    pop eax
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc in_block_write,_buffer,_addr,_size
;-----------------------------------------------------------------------
    mov eax,[_addr]
    and eax,7FFFFh
    mov dword [addr_l],eax
    push edi
    push esi
    mov [vpp_on],VPP_ON
    mov edi,[_size]
    mov esi,[_buffer]
;-----------------------------------------------------------------------
    stdcall in_write,50h
    stdcall reg_write,R_ADRL,[_addr]
    stdcall reg_write,R_ADRH,[_addr+1]
    push 1
;-----------------------------------------------------------------------
.next_byte:
    pop ecx
    stdcall in_write,40h
    lodsb
    stdcall in_write,eax
@@:    
    stdcall in_write,70h
    stdcall in_read
    test al,80h
    jz  @B
	and eax,11000b
	push eax
	stdcall addr_step
	dec edi
	jnz .next_byte
;-----------------------------------------------------------------------
    mov [vpp_on],0
    stdcall in_write,0FFh
	pop eax
	pop esi
	pop edi
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc in_erase
;-----------------------------------------------------------------------
    local _status: rw 128
;-----------------------------------------------------------------------
	push ebx
	push edi
	push esi
    invoke SetWindowText,[hStatus],0
	invoke DialogBoxParam,[hInstance],D_BLOCKS,[hMain],in_blocks,0
	or  eax,eax
	jz  .done
    mov ebx,blocks_data
.next:
    cmp dword [ebx+4],0
    je  .done
    lea edi,[_status]
    push edi
    CSAdd status_er
    CSAddHex [ebx]
    CSAddChar "h"
    CSEnd
    invoke SetWindowText,[hStatus]
    stdcall in_block_erase,[ebx]
    or  eax,eax
    jnz .done_err
    add ebx,8
    jmp .next
.done_err:
    invoke MessageBox,[hMain],erase_err,0,MB_ICONERROR
.done:
    invoke SetWindowText,[hStatus],0
    pop esi
    pop edi
	pop ebx
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc in_check
;-----------------------------------------------------------------------
    stdcall in_write,0FFh
	push ebx
    mov [event],status_ch
    invoke SetWindowText,[hStatus],0
	invoke DialogBoxParam,[hInstance],D_BLOCKS,[hMain],in_blocks,1
	or  eax,eax
	jz  .done
    mov ebx,blocks_data
.next:
    cmp dword [ebx+4],0
    je  .done
    stdcall prog_check,[ebx],[ebx+4],0FFh
    or  eax,eax
    jnz .done_err
    add ebx,8
    jmp .next
.done_err:
    invoke MessageBox,[hMain],not_clear,0,MB_ICONERROR
.done:
    mov [event],0
    invoke SetWindowText,[hStatus],check_done
	pop ebx
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc in_blocks hWnd,uMsg,wParam,lParam
;-----------------------------------------------------------------------
    cmp [uMsg],WM_CLOSE
    jne @F
.exit_can:
    invoke EndDialog,[hWnd],0
.exit_true:
    mov eax,TRUE
    ret
@@:
;-----------------------------------------------------------------------
    cmp [uMsg],WM_INITDIALOG
    jne @F
    mov dword [blocks_data],0
    mov dword [blocks_data+4],0
    invoke SetDlgItemText,[hWnd],L_TYPE,[intel_data.name]
    mov eax,[intel_data.name + 4]
    push eax
    add eax,16
    push eax
    add eax,16
    push eax
    invoke SetDlgItemText,[hWnd],R_BLOCK_3
    invoke SetDlgItemText,[hWnd],R_BLOCK_2
    invoke SetDlgItemText,[hWnd],R_BLOCK_1
    invoke SendDlgItemMessage,[hWnd],R_BLOCK_0,BM_SETCHECK,[lParam],0
    invoke SendDlgItemMessage,[hWnd],R_BLOCK_1,BM_SETCHECK,[lParam],0
    invoke SendDlgItemMessage,[hWnd],R_BLOCK_2,BM_SETCHECK,[lParam],0
    invoke SendDlgItemMessage,[hWnd],R_BLOCK_3,BM_SETCHECK,[lParam],0
    jmp .exit_true
@@:
;-----------------------------------------------------------------------
    cmp [uMsg],WM_COMMAND
    jne .exit_false
    cmp [wParam],B_CAN
    je  .exit_can
    cmp [wParam],B_OK
    jne .exit_false
    push edi
    mov  edi,blocks_data
    invoke SendDlgItemMessage,[hWnd],R_BLOCK_0,BM_GETCHECK,0,0
    or  eax,eax
    jz  @F
    mov eax,[intel_data.block_a]
    mov edx,[intel_data.block_a + 4]
    mov dword [edi],eax
    mov dword [edi+4],edx
    add edi,8
@@:    
    invoke SendDlgItemMessage,[hWnd],R_BLOCK_1,BM_GETCHECK,0,0
    or  eax,eax
    jz  @F
    mov eax,[intel_data.block_a]
    mov edx,[intel_data.block_a + 4]
    mov dword [edi],eax
    mov dword [edi+4],edx
    add edi,8
@@:    
    invoke SendDlgItemMessage,[hWnd],R_BLOCK_2,BM_GETCHECK,0,0
    or  eax,eax
    jz  @F
    mov eax,[intel_data.block_a]
    mov edx,[intel_data.block_a + 4]
    mov dword [edi],eax
    mov dword [edi+4],edx
    add edi,8
@@:    
    invoke SendDlgItemMessage,[hWnd],R_BLOCK_3,BM_GETCHECK,0,0
    or  eax,eax
    jz  @F
    mov eax,[intel_data.block_a]
    mov edx,[intel_data.block_a + 4]
    mov dword [edi],eax
    mov dword [edi+4],edx
    add edi,8
@@:    
    mov dword [edi],0
    mov dword [edi+4],0
    invoke EndDialog,[hWnd],1
    pop  edi     
.exit_false:        
	xor eax,eax
.exit:	
	ret
	
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc in_ini,_data
;-----------------------------------------------------------------------
    mov eax,[_data]
    mov edx,[eax + FLASHDATA.title]
    mov ecx,[eax + FLASHDATA.data]
    mov [intel_data.name],edx
;-----------------------------------------------------------------------
    dec ecx
    jnz @F
    mov dword [intel_data.block_a + 4],112*1024
    mov dword [intel_data.block_b],1C000h
    mov dword [intel_data.block_b + 4],4*1024
    mov dword [intel_data.block_c],1D000h
    mov dword [intel_data.block_c + 4],4*1024
    mov dword [intel_data.block_d],1E000h
    mov dword [intel_data.block_d + 4],8*1024
    mov dword [intel_data.name + 4],intel_data.t
    jmp .done
@@:
;-----------------------------------------------------------------------
    dec ecx
    jnz @F
    mov dword [intel_data.block_a + 4],8*1024
    mov dword [intel_data.block_b],2000h
    mov dword [intel_data.block_b + 4],4*1024
    mov dword [intel_data.block_c],3000h
    mov dword [intel_data.block_c + 4],4*1024
    mov dword [intel_data.block_d],4000h
    mov dword [intel_data.block_d + 4],112*1024
    mov dword [intel_data.name + 4],intel_data.b
    jmp .done
@@:
;-----------------------------------------------------------------------
.done:
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
