;=======================================================================
format PE GUI 4.0
;=======================================================================
include 'encoding\win1251.inc'  ;*
include 'win32w.inc'            ;*
include 'rc.inc'                ;*
include 'bv.inc'                ;*
include "paradef.inc"           ;*
include "ucombstr.inc"
;-----------------------------------------------------------------------
INVALID_SET_FILE_POINTER equ -1
;-----------------------------------------------------------------------
IDI_MAIN    equ 30
hMain       equ of.hwndOwner
hInstance   equ of.hInstance
;=======================================================================
section '.code' code readable executable

entry $

    call prog_reset
    invoke GetModuleHandle,0
    mov [hInstance],eax
    invoke DialogBoxParam,eax,D_MAIN,0,dlg_proc,0
    invoke ExitProcess,0
;=======================================================================
proc dlg_proc hWnd, uMsg, wParam, lParam
;-----------------------------------------------------------------------
    local _offset:  dd ?
    local _count:   dd ?
    local _adr:     dd ?
    local _str:     rb 8
;-----------------------------------------------------------------------
    cmp [uMsg],WM_CLOSE
    jne @F
.end_dlg:
    invoke EndDialog,[hWnd],0
.exit_true:
    mov eax,TRUE
    ret
@@:
;-----------------------------------------------------------------------
    cmp [uMsg],WM_INITDIALOG
    jne @F
    mov eax,[hWnd]
    mov [hMain],eax
    invoke LoadIcon,[hInstance],IDI_MAIN
    invoke SendMessage,[hWnd],WM_SETICON,ICON_SMALL,eax
    invoke GetDlgItem,[hWnd],S_BAR
    mov [hStatus],eax
    invoke GetDlgItem,[hWnd],CB_SIZE
    push eax
    stdcall cb_fill_chip,eax,flashdata
    pop eax
    invoke SendMessage,eax,CB_SETCURSEL,0,0
    mov eax,[flashdata + FLASHDATA.init]
    or  eax,eax
    jz  .init_done
    stdcall eax,flashdata
.init_done:
    mov eax,[flashdata + FLASHDATA.size]
    mov [rom_size],eax  
    jmp .exit_true
@@:    
;-----------------------------------------------------------------------
;    cmp [uMsg],?? << add new message
;    jne @F
;    
;    jmp .exit_true
;@@:    
;-----------------------------------------------------------------------
    cmp [uMsg],WM_COMMAND
    jne .exit_false
    cmp [wParam],B_CAN
    je .end_dlg
;-----------------------------------------------------------------------
    cmp [wParam],B_READ
    jne @F
    mov ecx,FLASHDATA.read
    cmp [rom_size],0
    je  .function
    call .get_params
    jc  .exit_true
    mov [event],status_rd
    mov ecx,prog_read
    mov eax,[rom_type]
    or  eax,eax
    jz  .default_read
    mov eax,[eax + FLASHDATA.read]
    or  eax,eax
    jz  .default_read
    mov ecx,eax
.default_read:    
    stdcall ecx,buffer,[_adr],[_count]
    mov [event],0
    invoke GetDlgItemText,[hWnd],E_FILE,filename,260
    stdcall write_file,filename,buffer,[_offset],[_count]
    or  eax,eax
    mov ecx,fwrite_ok
    mov edx,fwrite_fail
    mov eax,0
    cmovnz ecx,edx
    mov edx,MB_ICONERROR
    cmovnz eax,edx
    invoke MessageBox,[hWnd],ecx,prom,eax    
    jmp .exit_true
@@:
;-----------------------------------------------------------------------
    cmp [wParam],B_WRITE
    jne @F
    ;-------------------------------------------------------------------
    mov eax,[rom_type]
    or  eax,eax
    je  .function_err
    mov eax,[eax+FLASHDATA.write]
    or  eax,eax
    je  .function_err
    mov [uMsg],eax
    ;-------------------------------------------------------------------
    cmp [checked],0
    jne .write_start
    invoke MessageBox,[hWnd],not_checked,prom,\
                        MB_YESNO or MB_DEFBUTTON2 or MB_ICONEXCLAMATION
    cmp eax,IDYES
    jne .exit_true
    mov [checked],1
.write_start:    
    call .get_params
    jc  .exit_true
    invoke GetDlgItemText,[hWnd],E_FILE,filename,260
    stdcall read_file,filename,buffer,[_offset],[_count]
    or  eax,eax
    jz  .write
    invoke MessageBox,[hWnd],fread_fail,0,MB_ICONERROR
    jmp .exit_true
.write:    
    mov [event],status_wr
    stdcall [uMsg],buffer,[_adr],[_count] 
    or  eax,eax
    mov [event],0
    mov eax,MB_ICONERROR
    mov ecx,write_fail
    jnz .write_message
    mov [event],status_ch
    mov ecx,prog_compare
    mov eax,[rom_type]
    or  eax,eax
    jz  .default_write_compare
    mov eax,[eax + FLASHDATA.comp]
    or  eax,eax
    jz  .default_write_compare
    mov ecx,eax
.default_write_compare:        
    stdcall ecx,buffer,[_adr],[_count]
    mov [event],0
    push eax
    pop eax
    or  eax,eax
    mov ecx,write_ok
    mov edx,write_fail
    mov eax,0
    cmovnz ecx,edx
    mov edx,MB_ICONERROR
    cmovnz eax,edx
.write_message:    
    invoke MessageBox,[hWnd],ecx,prom,eax    
    jmp .exit_true
@@:
;-----------------------------------------------------------------------
    cmp [wParam],B_COMPARE
    jne @F
    call .get_params
    jc  .exit_true
    invoke GetDlgItemText,[hWnd],E_FILE,filename,260
    stdcall read_file,filename,buffer,[_offset],[_count]
    or  eax,eax
    jz  .compare
    invoke MessageBox,[hWnd],fread_fail,0,MB_ICONERROR
    jmp .exit_true
.compare: 
    mov [event],status_ch
    mov ecx,prog_compare
    mov eax,[rom_type]
    or  eax,eax
    jz  .default_compare
    mov eax,[eax + FLASHDATA.comp]
    or  eax,eax
    jz  .default_compare
    mov ecx,eax
.default_compare:        
    stdcall ecx,buffer,[_adr],[_count]
    mov [event],0
    or  eax,eax
    mov ecx,_match
    mov edx,not_match
    mov eax,0
    cmovnz ecx,edx
    mov edx,MB_ICONERROR
    cmovnz eax,edx
    invoke MessageBox,[hWnd],ecx,prom,eax    
    jmp .exit_true
@@:
;-----------------------------------------------------------------------
    cmp [wParam],B_TEST
    jne @F
    invoke MessageBox,[hWnd],no_rom,prom,\
           MB_YESNO or MB_ICONEXCLAMATION or MB_DEFBUTTON2
    cmp eax,IDYES
    jne .exit_true
    call timer_cycles
    cmp eax,99999
    jae .timer_fail
    CSNew 64
    CSAddDec
    CSEnd
    lea ecx,[esp + 4]
    invoke MessageBox,[hWnd],ecx,timer_chk,0
    CSFree
    stdcall reg_write,R_CTRL,B_DE or B_OE or VPP_ON
    invoke MessageBox,[hWnd],hi_on,prom,MB_ICONEXCLAMATION
    stdcall reg_write,R_CTRL,B_DE or B_OE
    mov [checked],1
    jmp .exit_true
.timer_fail:
    invoke MessageBox,[hWnd],timer_fail,prom,MB_ICONERROR
    jmp .exit_true
@@:
;-----------------------------------------------------------------------
    cmp [wParam],C_EXPERT
    jne @F
    invoke SendMessage,[lParam],BM_GETCHECK,0,0
    or  eax,eax
    mov ecx,SW_HIDE
    mov edx,SW_SHOW
    cmovnz ecx,edx
    mov [wParam],ecx
    invoke GetDlgItem,[hWnd],E_FSTART
    invoke ShowWindow,eax,[wParam]
    invoke GetDlgItem,[hWnd],L_FSTART
    invoke ShowWindow,eax,[wParam]
    invoke GetDlgItem,[hWnd],E_RSTART
    invoke ShowWindow,eax,[wParam]
    invoke GetDlgItem,[hWnd],L_RSTART
    invoke ShowWindow,eax,[wParam]
    invoke GetDlgItem,[hWnd],E_BLOCK
    invoke ShowWindow,eax,[wParam]
    invoke GetDlgItem,[hWnd],L_BLOCK
    invoke ShowWindow,eax,[wParam]
    jmp .exit_true
@@:
;-----------------------------------------------------------------------
    cmp [wParam],B_CHECK
    mov ecx,FLASHDATA.check
    je  .function
;-----------------------------------------------------------------------
    cmp [wParam],B_ERASE
    mov ecx,FLASHDATA.erase
    je  .function
;-----------------------------------------------------------------------
    cmp [wParam],B_ID
    mov ecx,FLASHDATA.id
    je  .function
;-----------------------------------------------------------------------
    cmp [wParam],B_FILE
    jne @F
    invoke GetDlgItemText,[hWnd],E_FILE,filename,1024
    invoke GetOpenFileName,of
    or  eax,eax
    jz  .exit_true
    invoke SetDlgItemText,[hWnd],E_FILE,filename
    stdcall GetFileSizeName,filename
    jz  .exit_true
    push edi
    push esi
    mov edi,filename
    CSAddHex
    CSEnd
    invoke SetDlgItemText,[hWnd],E_BLOCK,filename
    pop esi
    pop edi
    jmp .exit_true
@@:
;-----------------------------------------------------------------------
    cmp [wParam],CB_SIZE or (CBN_SELCHANGE shl 16); 
    jne @F
    invoke SendMessage,[lParam],CB_GETCURSEL,0,0
    cmp eax,CB_ERR
    je  .exit_true
    invoke SendMessage,[lParam],CB_GETITEMDATA,eax,0
    mov [rom_type],eax
    mov edx,[eax + FLASHDATA.init]
    or  edx,edx
    jz  .sel_done
    stdcall edx,eax
.sel_done:
    mov eax,[rom_type]
    push [eax + FLASHDATA.size]
    pop [rom_size] 
    jmp .exit_true
@@:
;-----------------------------------------------------------------------
;    cmp [wParam],?? ; << add new command
;    jne @F
;    jmp .exit_true
;@@:
;-----------------------------------------------------------------------
.exit_false:
    xor eax,eax
    ret
;-----------------------------------------------------------------------
.get_params:
    invoke IsDlgButtonChecked,[hWnd],C_EXPERT
    or  eax,eax
    jnz @F
    mov ecx,[rom_size]
    mov [_offset],0
    mov [_adr],0
    mov [_count],ecx
    or  eax,eax
    retn
@@:    
    mov eax,E_FSTART
    call .get_number
    jc  .get_param_err
    mov [_offset],ecx
    mov eax,E_RSTART
    call .get_number
    jc  .get_param_err
    mov [_adr],ecx
    mov eax,E_BLOCK
    call .get_number
    jc  .get_param_err
    jecxz .get_param_err1
    mov [_count],ecx
    add ecx,[_adr]
    cmp ecx,[rom_size]
    ja  .get_param_err1
    or  eax,eax
    retn
.get_param_err1:
    invoke MessageBox,[hWnd],param_error,0,MB_ICONERROR
.get_param_err:
    stc
    retn        
;-----------------------------------------------------------------------
.get_number:
    push esi
    lea esi,[_str]
    invoke GetDlgItemTextA,[hWnd],eax,esi,8
    or  eax,eax
    jz  .get_number_err
    cmp eax,7
    jae .get_number_err
    xor eax,eax
    xor ecx,ecx
.next:
    lodsb
    or  al,al
    je  .done
    cmp al,"F"
    ja  .get_number_err
    cmp al,"A"
    jb  .digit
    sub al,"A"-10
    jmp .valid
.digit:
    cmp al,"9"
    ja  .get_number_err    
    sub al,"0"
    js  .get_number_err
.valid:
    shl ecx,4
    add cl,al
    jmp .next   
.done:
    xor eax,eax
    pop esi
    retn    
.get_number_err:
    pop esi
    invoke MessageBox,[hWnd],param_error,0,MB_ICONERROR
    stc
    retn            
.function:
    mov eax,[rom_type]
    or  eax,eax
    je  .function_err
    mov eax,[eax+ecx]
    or  eax,eax
    je  .function_err
    call eax
    jmp .exit_true
.function_err:
    invoke MessageBox,[hWnd],not_impl,0,MB_ICONINFORMATION
    jmp .exit_true
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc get_hex_number _buff ; CF=1 - ,  -> eax
;-----------------------------------------------------------------------
    push esi
    mov esi,[_buff]
    xor eax,eax
    xor ecx,ecx
.next:
    lodsb
    or  al,al
    je  .done
    cmp al,"F"
    ja  .get_number_err
    cmp al,"A"
    jb  .digit
    sub al,"A"-10
    jmp .valid
.digit:
    cmp al,"9"
    ja  .get_number_err    
    sub al,"0"
    js  .get_number_err
.valid:
    shl ecx,4
    add cl,al
    jmp .next   
.done:
    or eax,eax
    mov eax,ecx
    pop esi
    ret    
.get_number_err:
    pop esi
    stc
    ret            
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc cb_fill_chip hWnd, chiptab
;-----------------------------------------------------------------------
    push edi
    mov edi,[chiptab]
@@:
    cmp dword [edi],0
    je  @F
    invoke SendMessage,[hWnd],CB_ADDSTRING,0,[edi]
    invoke SendMessage,[hWnd],CB_SETITEMDATA,eax,edi
    add edi,sizeof.FLASHDATA
    jmp @B
@@:
    pop edi
    ret    
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc cb_fill_str hWnd, strtab
;-----------------------------------------------------------------------
    push edi
    mov edi,[strtab]
@@:
    cmp word [edi],0
    je  @F
    invoke SendMessage,[hWnd],CB_ADDSTRING,0,edi
    mov ecx,127
    xor eax,eax
    repne scasw
    jmp @B
@@:
    pop edi
    ret    
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc byte_set_checkboxes,_byte,hWnd,chk0,chk1,chk2,chk3,chk4,chk5,chk6,chk7
    push ebx
    push esi
    xor ebx,ebx
    mov esi,[_byte]
    shr esi,1
    setc bl
    invoke SendDlgItemMessage,[hWnd],[chk0],BM_SETCHECK,ebx,0
    shr esi,1
    setc bl
    invoke SendDlgItemMessage,[hWnd],[chk1],BM_SETCHECK,ebx,0
    shr esi,1
    setc bl
    invoke SendDlgItemMessage,[hWnd],[chk2],BM_SETCHECK,ebx,0
    shr esi,1
    setc bl
    invoke SendDlgItemMessage,[hWnd],[chk3],BM_SETCHECK,ebx,0
    shr esi,1
    setc bl
    invoke SendDlgItemMessage,[hWnd],[chk4],BM_SETCHECK,ebx,0
    shr esi,1
    setc bl
    invoke SendDlgItemMessage,[hWnd],[chk5],BM_SETCHECK,ebx,0
    shr esi,1
    setc bl
    invoke SendDlgItemMessage,[hWnd],[chk6],BM_SETCHECK,ebx,0
    shr esi,1
    setc bl
    invoke SendDlgItemMessage,[hWnd],[chk7],BM_SETCHECK,ebx,0
    pop esi
    pop ebx
	ret
endp
;=======================================================================
;
proc byte_get_checkboxes,hWnd,chk0,chk1,chk2,chk3,chk4,chk5,chk6,chk7
    push ebx
    xor ebx,ebx
    invoke SendDlgItemMessage,[hWnd],[chk0],BM_GETCHECK,0,0
    shr al,1
    rcr bl,1
    invoke SendDlgItemMessage,[hWnd],[chk1],BM_GETCHECK,0,0
    shr al,1
    rcr bl,1
    invoke SendDlgItemMessage,[hWnd],[chk2],BM_GETCHECK,0,0
    shr al,1
    rcr bl,1
    invoke SendDlgItemMessage,[hWnd],[chk3],BM_GETCHECK,0,0
    shr al,1
    rcr bl,1
    invoke SendDlgItemMessage,[hWnd],[chk4],BM_GETCHECK,0,0
    shr al,1
    rcr bl,1
    invoke SendDlgItemMessage,[hWnd],[chk5],BM_GETCHECK,0,0
    shr al,1
    rcr bl,1
    invoke SendDlgItemMessage,[hWnd],[chk6],BM_GETCHECK,0,0
    shr al,1
    rcr bl,1
    invoke SendDlgItemMessage,[hWnd],[chk7],BM_GETCHECK,0,0
    shr al,1
    rcr bl,1
    mov eax,ebx
    pop ebx
	ret
endp
;=======================================================================
;
;=======================================================================
include "romprog.inc"
include "fileop.inc"
include "at29c010.inc"
include "at49f002.inc"
include "i28f001bx.inc"
include "am28f010.inc"
include "at89c2051.inc"
include "t2313.inc"
;=======================================================================
UCSSupport
;=======================================================================
include 'idata.inc' ;*
include  'data.inc'
;=======================================================================
section '.rsrc' resource data readable
;-----------------------------------------------------------------------
  directory \
    RT_ICON,icons,\
    RT_GROUP_ICON,group_icons,\
    RT_DIALOG,dialogs,\
    RT_VERSION,versions
;-----------------------------------------------------------------------
  resource icons,\
    1,LANG_NEUTRAL,icon_data

  resource group_icons,\
    IDI_MAIN,LANG_NEUTRAL,main_icon

  resource versions,\
    1,LANG_NEUTRAL,version
;-----------------------------------------------------------------------
include "dialogs.tab" ;*
;-----------------------------------------------------------------------
  icon main_icon,icon_data,'573RF2.ico'
;-----------------------------------------------------------------------
include "dialogs.dat" ;*
;-----------------------------------------------------------------------
versioninfo version,VOS__WINDOWS32,VFT_APP,VFT2_UNKNOWN,\
                                   LANG_RUSSIAN+SUBLANG_DEFAULT,0,\
        'FileDescription','FLASH PROGRAMMER',\
        'LegalCopyright','Freeware',\
        'CompanyName','http://shoorick.org.ua',\
        'FileVersion',<MAIN_VERSION,".",SUB_VERSION,".",BUILD_VERSION>,\
        'ProductVersion',<MAIN_VERSION,".",SUB_VERSION>,\
        'OriginalFilename','PARAFLSH.EXE'
;======================================================================= 
