;=======================================================================
XTAL            equ 20h
T2313_OE        equ 10h
T2313_WR        equ 08h
T2313_BS1       equ 04h
T2313_PAGEL     equ 04h
T2313_XA0       equ 02h
T2313_XA1       equ 01h 
T2313_BS2       equ 01h 
T2313_OEWR      equ 18h
;-----------------------------------------------------------------------
AVR_ERASE       equ 10000000b
AVR_WR_FUSES    equ 01000000b
AVR_WR_LOCK     equ 00100000b
AVR_WR_FLASH    equ 00010000b
AVR_WR_EEPROM   equ 00010001b
AVR_RD_ID       equ 00001000b
AVR_RD_FUSES    equ 00000100b
AVR_RD_FLASH    equ 00000010b
AVR_RD_EEPROM   equ 00000011b
;=======================================================================
;
;=======================================================================
proc t2313_enter
    push ebx
    mov bl,3
    stdcall reg_write,R_CTRL,B_DE
    stdcall reg_write,R_ADRL,T2313_OE
.clock:
    stdcall reg_write,R_ADRL,T2313_OE or XTAL
    stdcall reg_write,R_ADRL,T2313_OE
    dec bl
    jnz .clock
    invoke Sleep,1
    stdcall reg_write,R_CTRL,B_DE or VPP_ON
    stdcall reg_write,R_CTRL,B_DE or B_OE or VPP_ON
    invoke Sleep,1
    stdcall reg_write,R_ADRL,T2313_OEWR
	pop ebx
	ret
endp
;=======================================================================
;
;=======================================================================
proc t2313_load_command,.command
    stdcall reg_write,R_DATA,[.command]
    stdcall reg_write,R_CTRL,B_OE or VPP_ON
    stdcall reg_write,R_ADRL,T2313_OEWR or T2313_XA1
    stdcall reg_write,R_ADRL,T2313_OEWR or T2313_XA1 or XTAL
    stdcall reg_write,R_ADRL,T2313_OEWR or T2313_XA1
    stdcall reg_write,R_ADRL,T2313_OEWR
	ret
endp
;=======================================================================
;
;=======================================================================
proc t2313_load_data,_byte
    stdcall reg_write,R_DATA,[_byte]
    stdcall reg_write,R_ADRL,T2313_OEWR or T2313_XA0
    stdcall reg_write,R_ADRL,T2313_OEWR or T2313_XA0 or XTAL
    stdcall reg_write,R_ADRL,T2313_OEWR or T2313_XA0
	ret
endp
;=======================================================================
;
;=======================================================================
proc t2313_load_addr_low_byte,.byte
    stdcall reg_write,R_DATA,[.byte]
    stdcall reg_write,R_ADRL,T2313_OEWR  
    stdcall reg_write,R_ADRL,T2313_OEWR or XTAL
    stdcall reg_write,R_ADRL,T2313_OEWR  
	ret
endp
;=======================================================================
;
;=======================================================================
proc t2313_load_addr_high_byte,.byte
    stdcall reg_write,R_DATA,[.byte]
    stdcall reg_write,R_ADRL,T2313_OEWR or T2313_BS1
    stdcall reg_write,R_ADRL,T2313_OEWR or T2313_BS1 or XTAL
    stdcall reg_write,R_ADRL,T2313_OEWR or T2313_BS1
    stdcall reg_write,R_ADRL,T2313_OEWR
	ret
endp
;=======================================================================
;
;=======================================================================
proc t2313_read_byte,flags
    or [flags],T2313_WR
    stdcall reg_write,R_CTRL,B_DE or B_OE or VPP_ON
    stdcall reg_write,R_ADRL,[flags]
    stdcall prog_read_data
    push eax
    stdcall reg_write,R_ADRL,T2313_OEWR
    stdcall reg_write,R_CTRL,B_OE or VPP_ON
    pop eax
	ret
endp
;=======================================================================
;
;=======================================================================
proc t2313_write_fuse,_fuse,flags
    stdcall t2313_load_data,[_fuse]
    push ebx
    mov ebx,[flags]
    or  ebx,T2313_OE or T2313_WR
    stdcall reg_write,R_ADRL,ebx
    and ebx,not T2313_WR
    stdcall reg_write,R_ADRL,ebx
    or  ebx,T2313_WR
    stdcall reg_write,R_ADRL,ebx
    invoke Sleep,10
    stdcall reg_write,R_ADRL,T2313_OEWR
	pop ebx
	ret
endp
;=======================================================================
;
;=======================================================================
proc t2313_read_id_byte,_addr,flags
    stdcall t2313_load_addr_low_byte,[_addr]
    stdcall t2313_read_byte,[flags]
	ret
endp
;=======================================================================
;
;=======================================================================
proc t2313_id
;-----------------------------------------------------------------------
    invoke DialogBoxParam,[hInstance],D_T2313,[hMain],d2313,0
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc t2313_erase
;-----------------------------------------------------------------------
    call t2313_enter
    stdcall t2313_load_command,AVR_ERASE
    stdcall reg_write,R_ADRL,T2313_OEWR
    stdcall reg_write,R_ADRL,T2313_OE
    stdcall reg_write,R_ADRL,T2313_OEWR
    invoke Sleep,20
    invoke SetWindowText,[hStatus],erase_done
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc d2313,hWnd,uMsg,lParam,wParam
;-----------------------------------------------------------------------
    cmp [uMsg],WM_CLOSE
    jne @F
.end_dlg:
    invoke EndDialog,[hWnd],0
.exit_true:
    mov eax,TRUE
    ret
@@:
;-----------------------------------------------------------------------
    cmp [uMsg],WM_INITDIALOG
    jne @F
    call t2313_enter
    call .read_fuses
	jmp .exit_true
@@:
;-----------------------------------------------------------------------
    cmp [uMsg],WM_COMMAND
    jne .exit_false
    cmp [lParam],B_OK
    je  .end_dlg
    cmp [lParam],B_CAN
    je  .end_dlg
;-----------------------------------------------------------------------
    cmp [lParam],B_WR_FUSES
    jne @F
;-----------------------------------------------------------------------
    stdcall t2313_load_command,AVR_WR_FUSES
;-----------------------------------------------------------------------
    stdcall byte_get_checkboxes,[hWnd],C_FUSE_00,\
                                       C_FUSE_01,\
                                       C_FUSE_02,\
                                       C_FUSE_03,\
                                       C_FUSE_04,\
                                       C_FUSE_05,\
                                       C_FUSE_06,\
                                       C_FUSE_07
    stdcall t2313_write_fuse,eax,0
;-----------------------------------------------------------------------
    stdcall byte_get_checkboxes,[hWnd],C_FUSE_10,\
                                       C_FUSE_11,\
                                       C_FUSE_12,\
                                       C_FUSE_13,\
                                       C_FUSE_14,\
                                       C_FUSE_15,\
                                       C_FUSE_16,\
                                       C_FUSE_17
    stdcall t2313_write_fuse,eax,T2313_BS1
;-----------------------------------------------------------------------
    stdcall byte_get_checkboxes,[hWnd],C_FUSE_20,\
                                       C_FUSE_21,\
                                       C_FUSE_22,\
                                       C_FUSE_23,\
                                       C_FUSE_24,\
                                       C_FUSE_25,\
                                       C_FUSE_26,\
                                       C_FUSE_27
    stdcall t2313_write_fuse,eax,T2313_BS2
;-----------------------------------------------------------------------
    call .read_fuses    
;-----------------------------------------------------------------------
@@:    
;-----------------------------------------------------------------------
    cmp [lParam],B_WR_LOCKS
    jne .exit_false
    invoke MessageBox,[hWnd],q_sure,prom,\
                        MB_YESNO or MB_DEFBUTTON2 or MB_ICONEXCLAMATION
;-----------------------------------------------------------------------
.exit_false:
    xor eax,eax
	ret
;-----------------------------------------------------------------------
.read_fuses:
    push edi
    push esi
    mov edi,buffer
;-----------------------------------------------------------------------
    stdcall t2313_load_command,AVR_RD_ID
;-----------------------------------------------------------------------
    stdcall t2313_read_id_byte,0,0
    CSAddHex
    CSAddChar "-"
    stdcall t2313_read_id_byte,1,0
    CSAddHex
    CSAddChar "-"
    stdcall t2313_read_id_byte,2,0
    CSAddHex
    CSEnd
;-----------------------------------------------------------------------
    invoke SetDlgItemText,[hWnd],E_ID,buffer    
;-----------------------------------------------------------------------
    mov edi,buffer
    stdcall t2313_read_id_byte,0,T2313_BS1
    CSAddHex
    CSEnd
;-----------------------------------------------------------------------
    invoke SetDlgItemText,[hWnd],E_OSCCAL,buffer    
;-----------------------------------------------------------------------
    stdcall t2313_load_command,AVR_RD_FUSES
;-----------------------------------------------------------------------
    stdcall t2313_read_byte,0
    stdcall byte_set_checkboxes,eax,[hWnd],C_FUSE_00,\
                                           C_FUSE_01,\
                                           C_FUSE_02,\
                                           C_FUSE_03,\
                                           C_FUSE_04,\
                                           C_FUSE_05,\
                                           C_FUSE_06,\
                                           C_FUSE_07
;-----------------------------------------------------------------------
    stdcall t2313_read_byte,T2313_BS1 or T2313_BS2
    stdcall byte_set_checkboxes,eax,[hWnd],C_FUSE_10,\
                                           C_FUSE_11,\
                                           C_FUSE_12,\
                                           C_FUSE_13,\
                                           C_FUSE_14,\
                                           C_FUSE_15,\
                                           C_FUSE_16,\
                                           C_FUSE_17
;-----------------------------------------------------------------------
    stdcall t2313_read_byte,T2313_BS2
    stdcall byte_set_checkboxes,eax,[hWnd],C_FUSE_20,\
                                           C_FUSE_21,\
                                           C_FUSE_22,\
                                           C_FUSE_23,\
                                           C_FUSE_24,\
                                           C_FUSE_25,\
                                           C_FUSE_26,\
                                           C_FUSE_27
;-----------------------------------------------------------------------
    stdcall t2313_read_byte,T2313_BS1
    stdcall byte_set_checkboxes,eax,[hWnd],C_LOCK_0,\
                                           C_LOCK_1,\
                                           C_LOCK_2,\
                                           C_LOCK_3,\
                                           C_LOCK_4,\
                                           C_LOCK_5,\
                                           C_LOCK_6,\
                                           C_LOCK_7
;-----------------------------------------------------------------------
	pop esi
	pop edi
    retn
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc t2313_check
;-----------------------------------------------------------------------
    push edi
    push esi
    push ebx
    mov edi,[rom_size]
    shr edi,1
    mov esi,not_clear
    xor ebx,ebx
;-----------------------------------------------------------------------
    call t2313_enter
    stdcall t2313_load_command,AVR_RD_FLASH
.next_high:
    movzx ecx,bh
    stdcall t2313_load_addr_high_byte,ecx
.next_low:
    movzx ecx,bl
    stdcall t2313_load_addr_low_byte,ecx
    stdcall t2313_read_byte,0
    inc al
    mov eax,MB_ICONINFORMATION
    jnz .done
    stdcall t2313_read_byte,T2313_BS1
    inc al
    jnz .done
    mov eax,MB_ICONINFORMATION
    dec edi
    jz  .done_ok
    inc bl
    jnc .next_low
    inc bh
    jmp .next_high
;-----------------------------------------------------------------------
.done_ok:
    xor eax,eax
    mov esi,clear
.done:    
    invoke MessageBox,[hMain],esi,prom,eax
    pop ebx
    pop esi
    pop edi
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc t2313_rd_flash,_buffer,_adr,_count
;-----------------------------------------------------------------------
    push edi
    mov edi,[_buffer]
    shr [_adr],1
    jc  .done_err
    shr [_count],1
    jc  .done_err
    jz  .done
;-----------------------------------------------------------------------
    call t2313_enter
    stdcall t2313_load_command,AVR_RD_FLASH
.next_high:
    movzx ecx,byte [_adr + 1]
    stdcall t2313_load_addr_high_byte,ecx
.next_low:
    movzx ecx,byte [_adr]
    stdcall t2313_load_addr_low_byte,ecx
    stdcall t2313_read_byte,0
    stosb
    stdcall t2313_read_byte,T2313_BS1
    stosb
    dec [_count]
    jz  .done
    add byte [_adr],1
    jnc .next_low
    inc byte [_adr + 1]
    jmp .next_high
;-----------------------------------------------------------------------
.done_err:
    call odd
;-----------------------------------------------------------------------
.done:    
    pop edi
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc t2313_cmp_flash,_buffer,_adr,_count
;-----------------------------------------------------------------------
    push edi
    mov edi,[_buffer]
    shr [_adr],1
    jc  .done_err
    shr [_count],1
    jc  .done_err
    jz  .done
;-----------------------------------------------------------------------
    call t2313_enter
    stdcall t2313_load_command,AVR_RD_FLASH
.next_high:
    movzx ecx,byte [_adr + 1]
    stdcall t2313_load_addr_high_byte,ecx
.next_low:
    movzx ecx,byte [_adr]
    stdcall t2313_load_addr_low_byte,ecx
    stdcall t2313_read_byte,0
    sub al,[edi]
    jne .done
    inc edi
    stdcall t2313_read_byte,T2313_BS1
    sub al,[edi]
    jne .done
    inc edi
    dec [_count]
    jz  .done
    add byte [_adr],1
    jnc .next_low
    inc byte [_adr + 1]
    jmp .next_high
;-----------------------------------------------------------------------
.done_err:
    call odd
;-----------------------------------------------------------------------
.done:    
    movzx eax,al
    pop edi
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc t2313_wr_flash,_buffer,_adr,_count
;-----------------------------------------------------------------------
    push esi
    push edi
    push ebx
    mov esi,[_buffer]
    mov ebx,[_adr]
    shr ebx,1
    jc  .done_err
    shr [_count],1
    jc  .done_err
    jz  .done
    test ebx,15
    jz  @F
    invoke MessageBox,[hMain],param_error,prom,MB_ICONERROR
    jmp .done_err
@@:
;-----------------------------------------------------------------------
    call t2313_enter
    stdcall t2313_load_command,AVR_WR_FLASH
    dec ebx
.next_page:
    mov edi,16
.next_word:
    inc ebx
    movzx ecx,bl
    stdcall t2313_load_addr_low_byte,ecx
    lodsb
    stdcall t2313_load_data,eax
    lodsb
    stdcall reg_write,R_DATA,eax
    stdcall reg_write,R_ADRL,T2313_OEWR or T2313_XA0 or T2313_BS1
    stdcall reg_write,R_ADRL,T2313_OEWR or T2313_XA0 or T2313_BS1 or XTAL
    stdcall reg_write,R_ADRL,T2313_OEWR or T2313_XA0 or T2313_BS1
    stdcall reg_write,R_ADRL,T2313_OEWR \
                              or T2313_XA0 or T2313_BS1 or T2313_PAGEL
    stdcall reg_write,R_ADRL,T2313_OEWR or T2313_XA0 or T2313_BS1
    stdcall reg_write,R_ADRL,T2313_OEWR
    dec [_count]
    jz  @F
    dec edi
    jnz .next_word
@@:
    movzx ecx,bh
    stdcall t2313_load_addr_high_byte,ecx
    stdcall reg_write,R_ADRL,T2313_OE
    stdcall reg_write,R_ADRL,T2313_OEWR
    invoke Sleep,10
    cmp [_count],0
    jne .next_page
    jmp .done
;-----------------------------------------------------------------------
.done_err:
    call odd
;-----------------------------------------------------------------------
.done:    
    pop ebx
    pop edi
    pop esi
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc t2313_rd_eeprom,_buffer,_adr,_count
;-----------------------------------------------------------------------
    push edi
    mov edi,[_buffer]
;-----------------------------------------------------------------------
    call t2313_enter
    stdcall t2313_load_command,AVR_RD_EEPROM
.next_high:
    movzx ecx,byte [_adr + 1]
    stdcall t2313_load_addr_high_byte,ecx
.next_low:
    movzx ecx,byte [_adr]
    stdcall t2313_load_addr_low_byte,ecx
    stdcall t2313_read_byte,0
    stosb
    dec [_count]
    jz  .done
    add byte [_adr],1
    jnc .next_low
    inc byte [_adr + 1]
    jmp .next_high
;-----------------------------------------------------------------------
.done:    
    pop edi
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc t2313_check_e
;-----------------------------------------------------------------------
    push ebx
    push esi
    push edi
    xor ebx,ebx
    mov esi,not_clear
    mov edi,[rom_size]
;-----------------------------------------------------------------------
    call t2313_enter
    stdcall t2313_load_command,AVR_RD_EEPROM
.next_high:
    movzx ecx,bh
    stdcall t2313_load_addr_high_byte,ecx
.next_low:
    movzx ecx,bl
    stdcall t2313_load_addr_low_byte,ecx
    stdcall t2313_read_byte,0
    inc al
    mov eax,MB_ICONINFORMATION
    jnz .done
    dec edi
    jz  .done_ok
    inc bl
    jnz .next_low
    inc bh
    jmp .next_high
;-----------------------------------------------------------------------
.done_ok:
    mov esi,clear
    xor eax,eax
.done:    
    invoke MessageBox,[hMain],esi,prom,eax
    pop edi
    pop esi
    pop ebx
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc t2313_cmp_eeprom,_buffer,_adr,_count
;-----------------------------------------------------------------------
    push edi
    mov edi,[_buffer]
;-----------------------------------------------------------------------
    call t2313_enter
    stdcall t2313_load_command,AVR_RD_EEPROM
.next_high:
    movzx ecx,byte [_adr + 1]
    stdcall t2313_load_addr_high_byte,ecx
.next_low:
    movzx ecx,byte [_adr]
    stdcall t2313_load_addr_low_byte,ecx
    stdcall t2313_read_byte,0
    sub al,[edi]
    jnz .done
    inc edi
    dec [_count]
    jz  .done
    add byte [_adr],1
    jnc .next_low
    inc byte [_adr + 1]
    jmp .next_high
;-----------------------------------------------------------------------
.done:    
    movzx eax,al
    pop edi
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc t2313_wr_eeprom,_buffer,_adr,_count
;-----------------------------------------------------------------------
    push esi
    push edi
    push ebx
    mov esi,[_buffer]
    mov ebx,[_adr]
    test ebx,3
    jz  @F
    invoke MessageBox,[hMain],param_error,prom,MB_ICONERROR
    jmp .done_err
@@:
;-----------------------------------------------------------------------
    call t2313_enter
    stdcall t2313_load_command,AVR_WR_EEPROM
    dec ebx
.next_page:
    movzx ecx,bh
    stdcall t2313_load_addr_high_byte,ecx
    mov edi,4
.next_word:
    inc ebx
    movzx ecx,bl
    stdcall t2313_load_addr_low_byte,ecx
    lodsb
    stdcall t2313_load_data,eax
    stdcall reg_write,R_ADRL,T2313_OEWR or T2313_XA0
    stdcall reg_write,R_ADRL,T2313_OEWR or T2313_XA0 or T2313_PAGEL
    stdcall reg_write,R_ADRL,T2313_OEWR or T2313_XA0
    stdcall reg_write,R_ADRL,T2313_OEWR
    dec [_count]
    jz  @F
    dec edi
    jnz .next_word
@@:
    stdcall reg_write,R_ADRL,T2313_OE
    stdcall reg_write,R_ADRL,T2313_OEWR
    invoke Sleep,10
    cmp [_count],0
    jne .next_page
    jmp .done
;-----------------------------------------------------------------------
.done_err:
    call odd
;-----------------------------------------------------------------------
.done:    
    pop ebx
    pop edi
    pop esi
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc odd
    invoke MessageBox,[hMain],odd_msg,0,MB_ICONERROR
    ret
endp
;=======================================================================
;
;=======================================================================
proc t2313_erase_e
    invoke MessageBox,[hMain],avr_erase_e,prom,MB_ICONINFORMATION
	ret
endp
