;=======================================================================
proc prog_reset
;-----------------------------------------------------------------------
    xor eax,eax
    mov dword [addr_l],eax
    stdcall reg_write,R_CTRL,B_DE or B_OE
    stdcall reg_write,R_DATA,-1
    stdcall reg_write,R_ADRH,0
    stdcall reg_write,R_ADRL,0
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc addr_step
;-----------------------------------------------------------------------
;         
;   0-15    ,   , 
;  16-17 -    , 
;       
;-----------------------------------------------------------------------
    local status: rw 128
;-----------------------------------------------------------------------
    movzx eax,[addr_l] ;  0-7
    add al,1
    pushf
    mov [addr_l],al
    stdcall reg_write,R_ADRL,eax
    popf
    jnc @F
    movzx eax,[addr_h] ;  8-15
    add al,1
    pushf
    mov [addr_h],al
    stdcall reg_write,R_ADRH,eax
    popf
    jnc @F
    movzx eax,[addr_x] ;  16-17 (   )
    inc al
    and al,3
    mov [addr_x],al
@@:    
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    cmp [event],0           ;  ""    ;
    je  @F                  ;++++++++++++++++++++++++++++++++++++++++;
    test word [addr_l],0FFh
    jnz @F
    push edi
    push esi
    lea  edi,[status]
    push edi
    CSAdd [event]
    mov eax,dword [addr_l]
    and eax,3FFFFh
    CSAddHex
    CSAddChar "h"
    CSEnd
    invoke SetWindowText,[hStatus]
    pop esi
    pop edi
@@:    
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc reg_write _reg,_data ;     
;-----------------------------------------------------------------------
    invoke Out32,[lpt_data],[_data]
    mov ecx,P_STB
    mov eax,[_reg]
    or  ecx,eax
    push eax
    push ecx
    push eax
    invoke Out32,[lpt_ctrl]
    invoke Out32,[lpt_ctrl]
    invoke Out32,[lpt_ctrl]     
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc prog_write _buffer,_addr,_size,_pulses,_fix ;   
;-----------------------------------------------------------------------
    stdcall reg_write,R_CTRL,VPP_ON or B_OE ;  VPP
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    mov  ecx,VPP_ON or B_OE      ;    PGM  CS 
    or   ecx,[CS_bit]
    stdcall reg_write,R_CTRL,ecx ;  VPP
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;-----------------------------------------------------------------------
    push edi
    push esi
    push ebx
    mov edx,[_addr]
    and edx,3FFFFh
    mov dword [addr_l],edx ;      
    movzx edi,dh
    stdcall reg_write,R_ADRL,edx ;   
    stdcall reg_write,R_ADRH,edi ;  
    mov edi,[_size]         ;    
    mov esi,[_buffer]       ;    
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
@@:                         ;   
    mov ebx,[_pulses]       ;    
    movzx eax,byte [esi]    ;    
    stdcall reg_write,R_DATA,eax ; 
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.pulse:
    movzx eax,[addr_x]  ;   16  17 
    and eax,3           ;     
    push eax            ;   -  16  17 
    or  eax,VPP_ON or B_OE          ; VPP , OE, CS, PGM = 1
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    or  eax,[CS_bit]
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    stdcall reg_write,R_CTRL,eax  
;-----------------------------------------------------------------------
    invoke Out32,[lpt_ctrl],T_START      ;  :
    invoke Out32,[lpt_ctrl],0            ;  0  CS  PGM 
;-----------------------------------------------------------------------
.timer_wait:                        ;  
    invoke Inp32,[lpt_status]
    and eax,T_CHECK
    jnz .timer_wait
;-----------------------------------------------------------------------
    pop eax                         ;   
    mov ecx,eax                     ;     -  16  17 
    or  eax,VPP_ON or B_DE or B_CS  ;   
    or  ecx,VPP_ON or B_OE          ;    
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    or  ecx,[CS_bit]
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    push ecx              ;   -     
    stdcall reg_write,R_CTRL,eax    ;   
    invoke Out32,[lpt_ctrl],0
    invoke Inp32,[lpt_status]
    and  eax,0F0h                   ;   
    shr eax,4
    push eax
    invoke Out32,[lpt_ctrl],P_ALF
    invoke Inp32,[lpt_status]
    and  eax,0F0h                   ;   
    pop edx
    or  eax,edx
    cmp al,[esi]        ;     
    pop eax
    pushf               ;   -   
    stdcall reg_write,R_CTRL,eax    ;    
    popf
    je  .fix            ;   -   
    dec ebx
    jnz .pulse          ;   -  
    mov edi,-1
    jmp .done           ;     
;-----------------------------------------------------------------------
.fix:                           ;  
    mov ebx,[_fix]
    or  ebx,ebx
    jz  .next                   ;  0 -  
.fix_loop:
    invoke Out32,[lpt_ctrl],T_START  ;  
    invoke Out32,[lpt_ctrl],0
;-----------------------------------------------------------------------
.fix_wait:
    invoke Inp32,[lpt_status]
    and eax,T_CHECK
    jnz .fix_wait
;-----------------------------------------------------------------------
    dec ebx                     ;   
    jnz .fix_loop
.next:    
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    call addr_step  ;     
    inc esi         ;     
    dec edi         ;    
    jnz @B
;-----------------------------------------------------------------------
.done:
    stdcall prog_reset    
    mov eax,edi     ;     - edi=0,  - 
    pop ebx
    pop esi
    pop edi   
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc prog_read _buffer,_addr,_size
;-----------------------------------------------------------------------
    push edi
    push esi
    mov edx,[_addr]
    and edx,3FFFFh
    mov dword [addr_l],edx ;      
    movzx edi,dh    
    stdcall reg_write,R_ADRL,edx ;   
    stdcall reg_write,R_ADRH,edi ;  
    mov esi,[_size]   ;    
    mov edi,[_buffer] ;    
@@:
    movzx eax,[addr_x]
    or  eax,B_DE or B_CS 
    stdcall reg_write,R_CTRL,eax
    invoke Out32,[lpt_ctrl],0
    invoke Inp32,[lpt_status]
    and  eax,0F0h
    shr eax,4
    push eax
    invoke Out32,[lpt_ctrl],P_ALF
    invoke Inp32,[lpt_status]
    and  eax,0F0h
    pop edx
    or  eax,edx
    stosb
    movzx eax,[addr_x]
    or  eax,B_DE or B_OE 
    stdcall reg_write,R_CTRL,eax
    call addr_step
    dec esi
    jnz @B
    pop esi
    pop edi   
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc prog_compare _buffer,_addr,_size
;-----------------------------------------------------------------------
    push edi
    push esi
    mov edx,[_addr]
    and edx,3FFFFh
    mov dword [addr_l],edx ;      
    movzx edi,dl
    stdcall reg_write,R_ADRL,edx ;   
    stdcall reg_write,R_ADRH,edi ;  
    mov esi,[_size]   ;    
    mov edi,[_buffer] ;    
@@:
    movzx eax,[addr_x]
    or  eax,B_DE or B_CS 
    stdcall reg_write,R_CTRL,eax
    invoke Out32,[lpt_ctrl],0
    invoke Inp32,[lpt_status]
    and  eax,0F0h
    shr eax,4
    push eax
    invoke Out32,[lpt_ctrl],P_ALF
    invoke Inp32,[lpt_status]
    and  eax,0F0h
    pop edx
    or  eax,edx
    cmp [edi],al
    jne @F
    movzx eax,[addr_x]
    or  eax,B_DE or B_OE 
    stdcall reg_write,R_CTRL,eax
    call addr_step
    inc edi
    dec esi
    jnz @B
    xor eax,eax
    pop esi
    pop edi   
    ret
@@:
    or  eax,-1
    pop esi
    pop edi
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc prog_check _size
;-----------------------------------------------------------------------
    push esi
    stdcall prog_reset    
    mov esi,[_size]
@@:
    movzx eax,[addr_x]
    or eax,B_DE or B_CS
    stdcall reg_write,R_CTRL,eax
    invoke Out32,[lpt_ctrl],0
    invoke Inp32,[lpt_status]
    and  eax,0F0h
    shr eax,4
    push eax
    invoke Out32,[lpt_ctrl],P_ALF
    invoke Inp32,[lpt_status]
    and  eax,0F0h
    pop edx
    or  eax,edx
    cmp al,0FFh
    jne .done
    movzx eax,[addr_x]
    or eax,B_DE or B_OE 
    stdcall reg_write,R_CTRL,eax
    call addr_step
    dec esi
    jnz @B
.done:
    mov eax,esi
    pop esi
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc timer_cycles
;-----------------------------------------------------------------------
    push ebx
    push edi
    xor ebx,ebx
    mov edi,100000+1
    invoke Out32,[lpt_ctrl],T_START
    invoke Out32,[lpt_ctrl],0
@@:
    invoke Inp32,[lpt_status]
    inc ebx
    dec edi
    jz  @F
    and eax,T_CHECK
    jnz  @B
@@:    
    mov eax,ebx
    dec eax
    pop edi
    pop ebx
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc prog_write_rf2 _buffer,_addr,_size,_pulses,_fix ;    2716
;-----------------------------------------------------------------------
    stdcall reg_write,R_CTRL,          B_OE or B_CS ; 
    stdcall reg_write,R_CTRL,VPP_ON or B_OE or B_CS ;  VPP
;-----------------------------------------------------------------------
    push edi
    push esi
    push ebx
    mov edx,[_addr]
    and edx,0FFFFh
    mov dword [addr_l],edx ;      
    movzx edi,dh
    stdcall reg_write,R_ADRL,edx ;   
    stdcall reg_write,R_ADRH,edi ;  
    mov edi,[_size]         ;    
    mov esi,[_buffer]       ;    
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.next_byte:                 ;   
    mov ebx,[_pulses]       ;    
    movzx eax,byte [esi]    ;    
    stdcall reg_write,R_DATA,eax ; 
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.pulse:
    stdcall reg_write,R_CTRL,VPP_ON or B_OE ;  :
    invoke Sleep,2                          ;  1  CS 
    stdcall reg_write,R_CTRL,VPP_ON or B_OE or B_CS ; 
;-----------------------------------------------------------------------
    stdcall reg_write,R_CTRL,VPP_ON or B_CS ; 
    invoke Out32,[lpt_ctrl],0
    invoke Inp32,[lpt_status]
    and  eax,0F0h                   ;   
    shr eax,4
    push eax
    invoke Out32,[lpt_ctrl],P_ALF
    invoke Inp32,[lpt_status]
    and  eax,0F0h                   ;   
    pop edx
    or  eax,edx
    cmp al,[esi]        ;     
    pushf               ;   -   
    stdcall reg_write,R_CTRL,VPP_ON or B_OE or B_CS ; 
    popf
    je  .fix            ;   -   
    dec ebx
    jnz .pulse          ;   -  
    mov edi,-1
    jmp .done           ;     
;-----------------------------------------------------------------------
.fix:                           ;  
    mov ebx,[_fix]
    or  ebx,ebx
    jz  .next                   ;  0 -  
.fix_loop:
    stdcall reg_write,R_CTRL,VPP_ON or B_OE ;  :
    invoke Sleep,2                          ;  1  CS 
    stdcall reg_write,R_CTRL,VPP_ON or B_OE or B_CS ; 
;-----------------------------------------------------------------------
    dec ebx                     ;   
    jnz .fix_loop
.next:    
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    call addr_step  ;     
    inc esi         ;     
    dec edi         ;    
    jnz .next_byte
;-----------------------------------------------------------------------
.done:
    stdcall reg_write,R_CTRL,          B_OE or B_CS ; 
    stdcall prog_reset    
    mov eax,edi     ;     - edi=0,  - 
    pop ebx
    pop esi
    pop edi   
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
