;=======================================================================
proc read_file _name,_buff,_offset,_count
;-----------------------------------------------------------------------
    local rcount: dd ?
;-----------------------------------------------------------------------
    invoke CreateFile,[_name],GENERIC_READ,FILE_SHARE_READ,0,\
                              OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0
    cmp eax,INVALID_HANDLE_VALUE
    je  @F
    mov [_name],eax
    invoke SetFilePointer,eax,[_offset],0,FILE_BEGIN
    cmp eax,INVALID_SET_FILE_POINTER
    lea ecx,[rcount]
    je  @F
    invoke ReadFile,[_name],[_buff],[_count],ecx,0
    invoke CloseHandle,[_name]  
    mov ecx,[rcount]
    xor eax,eax                                              
    cmp [_count],ecx
    setne al
@@:
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc write_file _name,_buff,_count
;-----------------------------------------------------------------------
    local rcount: dd ?
;-----------------------------------------------------------------------
    invoke CreateFile,[_name],GENERIC_WRITE,0,0,CREATE_ALWAYS,\
                                                FILE_ATTRIBUTE_NORMAL,0
    cmp eax,INVALID_HANDLE_VALUE
    je  @F
    mov [_name],eax
;    invoke SetFilePointer,eax,[_offset],0,FILE_BEGIN
;    cmp eax,INVALID_SET_FILE_POINTER
    lea ecx,[rcount]
;    je  @F
    invoke WriteFile,[_name],[_buff],[_count],ecx,0
    invoke CloseHandle,[_name]  
    mov ecx,[rcount]
    xor eax,eax                                              
    cmp [_count],ecx
    setne al
@@:
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc GetFileSizeName lpFileName ; ZF=1 if fail
;-----------------------------------------------------------------------
    local wfd: rb sizeof.WIN32_FIND_DATA 
;-----------------------------------------------------------------------
    lea ecx,[wfd]
    invoke FindFirstFile,[lpFileName],ecx
    cmp eax,INVALID_HANDLE_VALUE
    je @F
;-----------------------------------------------------------------------
    pushf
    invoke FindClose,eax
    mov edx,dword [wfd + WIN32_FIND_DATA.nFileSizeHigh]
    mov eax,dword [wfd + WIN32_FIND_DATA.nFileSizeLow]
    popf
;-----------------------------------------------------------------------
@@:
    ret
endp
;=======================================================================
