;=======================================================================
format PE GUI 4.0
;=======================================================================
include 'win32a.inc'    ;*
include 'rc.inc'        ;*
include 'bv.inc'        ;*
;-----------------------------------------------------------------------
INVALID_SET_FILE_POINTER equ -1
;-----------------------------------------------------------------------
IDI_MAIN    equ 30
hMain       equ of.hwndOwner
hInstance   equ of.hInstance
;=======================================================================
section '.code' code readable executable

entry $

    invoke GetModuleHandle,0
    mov [hInstance],eax
    invoke DialogBoxParam,eax,D_MAIN,0,dlg_proc,0
    invoke ExitProcess,0

;=======================================================================
proc dlg_proc hWnd, uMsg, wParam, lParam
    cmp [uMsg],WM_CLOSE
    jne @F
.end_dlg:
    invoke EndDialog,[hWnd],0
.exit_true:
    mov eax,TRUE
    ret
@@:
;-----------------------------------------------------------------------
    cmp [uMsg],WM_INITDIALOG
    jne @F
    mov eax,[hWnd]
    mov [hMain],eax
    invoke LoadIcon,[hInstance],IDI_MAIN
    invoke SendMessage,[hWnd],WM_SETICON,ICON_SMALL,eax
    jmp .exit_true
@@:    
;-----------------------------------------------------------------------
    cmp [uMsg],WM_COMMAND
    jne .exit_false
    cmp [wParam],B_CAN
    je .end_dlg
;-----------------------------------------------------------------------
    cmp [wParam],C_4
    jne @F
    invoke SendMessage,[lParam],BM_GETCHECK,0,0
    and eax,1
    mov [c_4],al
    push eax
    push eax
    push eax
    push eax
    invoke GetDlgItem,[hWnd],E_ROM_3
    invoke EnableWindow,eax
    invoke GetDlgItem,[hWnd],E_ROM_4
    invoke EnableWindow,eax
    invoke GetDlgItem,[hWnd],B_ROM_3
    invoke EnableWindow,eax
    invoke GetDlgItem,[hWnd],B_ROM_4
    invoke EnableWindow,eax
    jmp .exit_true
@@:
;-----------------------------------------------------------------------
    cmp [wParam],B_SPLIT
    jne @F
    invoke RtlZeroMemory,buff0,2048*1024
    invoke GetDlgItemText,[hWnd],E_ROM,filename,260
    stdcall GetFileSizeName,filename
    mov ecx,error_rd
    jz  .file_error
    or  eax,eax
    jz  .file_error
    cmp eax,1024*1024
    ja  .file_error
    push eax
    shr eax,1
    adc eax,0
    cmp [c_4],0
    je  .split_size_ok
    shr eax,1
    adc eax,0
.split_size_ok:    
    mov [rom_size],eax
    stdcall read_file,filename,buff0,0
    mov ecx,error_rd
    or  eax,eax
    jnz .file_error
    push esi
    push edi
    mov esi,buff0
    mov edi,buff1
    mov ecx,[rom_size]
    inc ecx
.split_loop:
    dec ecx
    jz  .split_done
    lodsb
    stosb
    lodsb
    mov [edi + buff2 - buff1 - 1],al
    cmp [c_4],0
    je  .split_loop
    lodsb
    mov [edi + buff3 - buff1 - 1],al
    lodsb
    mov [edi + buff4 - buff1 - 1],al
    jmp .split_loop
.split_done:  
    pop edi
    pop esi
    invoke GetDlgItemText,[hWnd],E_ROM_1,filename,260
    stdcall write_file,filename,buff1,[rom_size]
    or  eax,eax
    mov ecx,error_wr
    jnz .file_error
    invoke GetDlgItemText,[hWnd],E_ROM_2,filename,260
    stdcall write_file,filename,buff2,[rom_size]
    or  eax,eax
    mov ecx,error_wr
    jnz .file_error
    cmp [c_4],0
    mov ecx,finished
    je  .message
    invoke GetDlgItemText,[hWnd],E_ROM_3,filename,260
    stdcall write_file,filename,buff3,[rom_size]
    or  eax,eax
    mov ecx,error_wr
    jnz .file_error
    invoke GetDlgItemText,[hWnd],E_ROM_4,filename,260
    stdcall write_file,filename,buff4,[rom_size]
    or  eax,eax
    mov ecx,error_wr
    jnz .file_error
    mov ecx,finished
    jmp .message
@@:
;-----------------------------------------------------------------------
    cmp [wParam],B_MERGE
    jne @F
    invoke RtlZeroMemory,buff0,2048*1024
    invoke GetDlgItemText,[hWnd],E_ROM_1,filename,260
    stdcall GetFileSizeName,filename
    mov ecx,error_rd
    jz  .file_error
    or  eax,eax
    jz  .file_error
    cmp [c_4],0
    mov ecx,256*1024
    jne .merge_size_ok
    add ecx,ecx
.merge_size_ok:    
    cmp eax,ecx
    ja  .file_error
    mov [rom_size],eax
    stdcall read_file,filename,buff1,0,[rom_size]
    or  eax,eax
    mov ecx,error_rd
    jnz .file_error
    invoke GetDlgItemText,[hWnd],E_ROM_2,filename,260
    stdcall read_file,filename,buff2,0,[rom_size]
    or  eax,eax
    mov ecx,error_rd
    jnz .file_error
    cmp [c_4],0
    je .merge_read_ok
    invoke GetDlgItemText,[hWnd],E_ROM_3,filename,260
    or  eax,eax
    stdcall read_file,filename,buff3,0,[rom_size]
    mov ecx,error_rd
    jnz .file_error
    invoke GetDlgItemText,[hWnd],E_ROM_4,filename,260
    or  eax,eax
    stdcall read_file,filename,buff4,0,[rom_size]
    mov ecx,error_rd
    jnz .file_error
.merge_read_ok:
    push edi
    push esi
    mov edi,buff0
    mov esi,buff1
    mov ecx,[rom_size]
    inc ecx
.merge_loop:
    dec ecx
    jz  .merge_done
    lodsb
    stosb
    mov al,[esi + buff2 - buff1 - 1]
    stosb
    cmp [c_4],0
    je  .merge_loop
    mov al,[esi + buff3 - buff1 - 1]
    stosb
    mov al,[esi + buff4 - buff1 - 1]
    stosb
    jmp .merge_loop
.merge_done:
    pop esi
    pop edi
    invoke GetDlgItemText,[hWnd],E_ROM,filename,260
    mov eax,[rom_size]
    add eax,eax
    cmp [c_4],0
    je  .merge_write
    add eax,eax
.merge_write:    
    stdcall write_file,filename,buff0,eax
    or  eax,eax
    mov ecx,error_wr
    jnz .file_error
    mov ecx,finished
    jmp .message
@@:
;-----------------------------------------------------------------------
    cmp [wParam],B_ROM 
    mov eax,E_ROM
    je  .rom_file
    cmp [wParam],B_ROM_1 
    mov eax,E_ROM_1
    je  .rom_file
    cmp [wParam],B_ROM_2 
    mov eax,E_ROM_2
    je  .rom_file
    cmp [wParam],B_ROM_3 
    mov eax,E_ROM_3
    je  .rom_file
    cmp [wParam],B_ROM_4 
    mov eax,E_ROM_4
    je  .rom_file
;-----------------------------------------------------------------------
.exit_false:
    xor eax,eax
    ret
.file_error:
    invoke MessageBox,[hWnd],ecx,filename,MB_ICONERROR
    jmp .exit_true    
.message:
    invoke MessageBox,[hWnd],ecx,romsplit,0
    jmp .exit_true    
.rom_file:
    mov [wParam],eax
    invoke GetDlgItemText,[hWnd],eax,filename,260
    invoke GetOpenFileName,of
    or  eax,eax
    jz  .exit_true
    invoke SetDlgItemText,[hWnd],[wParam],filename
    jmp .exit_true    
endp
;=======================================================================
include "fileop.inc"
;=======================================================================
include 'idata.inc'
include  'data.inc'
;=======================================================================
section '.rsrc' resource data readable
;-----------------------------------------------------------------------
  directory \
    RT_ICON,icons,\
    RT_GROUP_ICON,group_icons,\
    RT_DIALOG,dialogs,\
    RT_VERSION,versions
;-----------------------------------------------------------------------
  resource icons,\
    1,LANG_NEUTRAL,icon_data

  resource group_icons,\
    IDI_MAIN,LANG_NEUTRAL,main_icon

  resource versions,\
    1,LANG_NEUTRAL,version
;-----------------------------------------------------------------------
include "dialogs.tab" ;*
;-----------------------------------------------------------------------
  icon main_icon,icon_data,'573RF2.ico'
;-----------------------------------------------------------------------
include "dialogs.dat" ;*
;-----------------------------------------------------------------------
versioninfo version,VOS__WINDOWS32,VFT_APP,VFT2_UNKNOWN,\
                                   LANG_ENGLISH+SUBLANG_DEFAULT,0,\
        'FileDescription','ROM IMAGE SPLITTER',\
        'LegalCopyright','Freeware',\
        'CompanyName','http://shoorick.ho.ua',\
        'FileVersion',<MAIN_VERSION,".",SUB_VERSION,".",BUILD_VERSION>,\
        'ProductVersion',<MAIN_VERSION,".",SUB_VERSION>,\
        'OriginalFilename','ROMSPLIT.EXE'
;=======================================================================

