;=======================================================================
proc prog_reset
;-----------------------------------------------------------------------
    xor eax,eax
    mov dword [addr_l],eax
    stdcall reg_write,R_CTRL,B_DE or B_OE
    stdcall reg_write,R_DATA,-1
    stdcall reg_write,R_ADRH,A11 ; A11    WE !!!!!
    stdcall reg_write,R_ADRL,0
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc addr_step
;-----------------------------------------------------------------------
    movzx eax,[addr_l]
    add al,1
    pushf
    mov [addr_l],al
    stdcall reg_write,R_ADRL,eax
    popf
    jnc @F
    movzx eax,[addr_h]
    add al,1
    mov [addr_h],al
    or al,A11             ; A11    WE !!!!!!!
    stdcall reg_write,R_ADRH,eax
@@:
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc reg_write _reg,_data
;-----------------------------------------------------------------------
    invoke Out32,0x378,[_data]
    mov ecx,P_STB
    mov eax,[_reg]
    or  ecx,eax
    push eax
    push ecx
    push eax
    invoke Out32,0x37A
    invoke Out32,0x37A
    invoke Out32,0x37A     
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc prog_write _buffer,_addr,_size,_delay
;-----------------------------------------------------------------------
    push edi
    push esi
    mov edx,[_addr]
    and edx,7FFh
    mov dword [addr_l],edx ;      
    movzx edi,dh
    or  edi,A11
    stdcall reg_write,R_ADRL,edx ;   
    stdcall reg_write,R_ADRH,edi ;  
    mov edi,[_size]   ;    
    mov esi,[_buffer] ;    
@@:
    lodsb
    stdcall reg_write,R_DATA,eax ; 
    stdcall reg_write,R_CTRL,B_CS or B_OE
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    movzx eax,[addr_h] ; A11    WE !!!!!!!
    and eax,not A11
    stdcall reg_write,R_ADRH,eax 
    movzx eax,[addr_h] 
    or  eax,A11
    stdcall reg_write,R_ADRH,eax 
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    stdcall reg_write,R_CTRL,B_DE or B_OE
    invoke Sleep,[_delay]
    call addr_step
    dec edi
    jnz @B
    pop esi
    pop edi   
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc prog_read _buffer,_addr,_size
;-----------------------------------------------------------------------
    push edi
    push esi
    mov edx,[_addr]
    and edx,7FFh
    mov dword [addr_l],edx ;      
    movzx edi,dl    
    or edi,A11
    stdcall reg_write,R_ADRL,edx ;   
    stdcall reg_write,R_ADRH,edi ;  
    mov esi,[_size]   ;    
    mov edi,[_buffer] ;    
@@:
    stdcall reg_write,R_CTRL,B_DE or B_CS
    invoke Out32,0x37A,0
    invoke Inp32,0x379
    and  eax,0F0h
    shr eax,4
    push eax
    invoke Out32,0x37A,P_ALF
    invoke Inp32,0x379
    and  eax,0F0h
    pop edx
    or  eax,edx
    stosb
    stdcall reg_write,R_CTRL,B_DE or B_OE 
    call addr_step
    dec esi
    jnz @B
    pop esi
    pop edi   
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc prog_compare _buffer,_addr,_size
;-----------------------------------------------------------------------
    push edi
    push esi
    mov edx,[_addr]
    and edx,7FFh
    mov dword [addr_l],edx ;      
    movzx edi,dl
    or  edi,A11
    stdcall reg_write,R_ADRL,edx ;   
    stdcall reg_write,R_ADRH,edi ;  
    mov esi,[_size]   ;    
    mov edi,[_buffer] ;    
@@:
    stdcall reg_write,R_CTRL,B_DE or B_CS
    invoke Out32,0x37A,0
    invoke Inp32,0x379
    and  eax,0F0h
    shr eax,4
    push eax
    invoke Out32,0x37A,P_ALF
    invoke Inp32,0x379
    and  eax,0F0h
    pop edx
    or  eax,edx
    cmp [edi],al
    jne @F
    stdcall reg_write,R_CTRL,B_DE or B_OE 
    call addr_step
    inc edi
    dec esi
    jnz @B
    xor eax,eax
    pop esi
    pop edi   
	ret
@@:
    or  eax,-1
    pop esi
    pop edi
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
