;=======================================================================
macro CASE var,[val,lab] {
    cmp var,val
    je  lab }
;=======================================================================
include "avlstruc.inc"
;-----------------------------------------------------------------------
struct DATA_CONTEXT
    size          dd ?
    vers          dd ?
    pa_dict       dd ? ;  
    hMain         dd ? ;   
    hStatus       dd ? ;   
    phLast        dd ? ;       
    phDict        dd ? ;       ()
    phText        dd ? ;        ()
    phTran        dd ? ;      ()
    pcmd_block    dd ? ; <>0 -  
    plist         dd ? ; <>0 -  
    plist_handler dd ? ;       
    hList         dd ? ;  
    ptran         dd ? ; <>0 -   
    pignore_spaces dd ?;  
    pxchar_c      dd ? ;   
    pxchar_f      dd ? ; -    
    pxchar_l      dd ? ;   
    pxchar_d      dd ? ;    
    pfull_text    dd ? ;      . 
ends    
;-----------------------------------------------------------------------
struct FUNC_CONTEXT
    size          dd ?
    vers          dd ? 
    pavl_new_tree dd ? ;   -
    pavl_insert   dd ? ; /   - 
    pavl_search   dd ? ;    -
    pavl_enum     dd ? ;    -
    pindex_insert dd ? ; /   
    pindex_search dd ? ;    
    pindex_enum_words dd ?;     
    pdict_init    dd ? ;  
    pdict_remove  dd ? ;  
    pdict_reidx   dd ? ;  
    pdict_search  dd ? ;    
    pdict_combo   dd ? ;    
    pload_art_list dd ?;     
    ptermometer   dd ? ;     
    pEditGetSel   dd ? ;       
    pRTrim        dd ? ;   
    pRemoveTags   dd ? ;    
    pContinued    dd ? ;        
ends
;-----------------------------------------------------------------------
struct DICT
    flag    dd ? ; 
    size    dd ? ;    
    hdsl    dd ? ;   
    index   dd ? ;   
ends
;-----------------------------------------------------------------------
DICT_LOADED = 1
DICT_ACTIVE = 2
DICT.ndsl   equ sizeof.DICT ;   
;-----------------------------------------------------------------------
struct FOUND_ITEM
    dict    dd ?
    hand    dd ?
    start   dd ?
    size    dd ?
ends    
;-----------------------------------------------------------------------
struct BKRS_TREE
    root    dd ? 
    next    dd ? 
    data    dd ? 
    amax    dd ? ;   
    arts    dd ? ;  
    wrds    dd ? ;  
    res3    dd ?
    res4    dd ?
ends
;-----------------------------------------------------------------------
struct BKRS_NODE
    avl     AVL_NODE
    entry   dd ? ;   
    next    dd ? ;   
ends   
;-----------------------------------------------------------------------
struct BKRS_ENTRY
    next    dd ? ;  
    start   dd ? ;   
    size    dd ? ;   
ends 
;-----------------------------------------------------------------------
BKRS_TREE.data_size = (sizeof.BKRS_NODE - sizeof.AVL_NODE) shr 2
;-----------------------------------------------------------------------
macro BKRS_INIT __index__ {
    mov [__index__ + BKRS_TREE.root],0
    mov [__index__ + BKRS_TREE.next],sizeof.BKRS_TREE
    mov [__index__ + BKRS_TREE.data],\
                              (sizeof.BKRS_NODE - sizeof.AVL_NODE) shr 2
}    
;=======================================================================
if 0
    invoke DefWindowProc
end if
;=======================================================================
macro m2m _dst,_src {
    push _src
    pop  _dst }
;=======================================================================
macro mrm _dst,_src,_reg ; not mine idea + mine improvement ;)
{
  if _reg eq
    mov eax,_src
    mov _dst,eax
  else
    mov _reg,_src
    mov _dst,_reg
  end if
}
;=======================================================================
macro deb
{	
    local ..nodeb
if defined DEBUG_VERSION
 if DEBUG_VERSION
    pusha
	invoke IsDebuggerPresent
	test eax,eax
	popa
	jz ..nodeb
	int3
  ..nodeb:
 end if
else
    pusha
	invoke IsDebuggerPresent
	test eax,eax
	popa
	jz ..nodeb
	int3
  ..nodeb:
end if  
}
;=======================================================================
PM_GETDICT  = 1001
PM_SHOWLIST = 1002
PM_SHOWTRAN = 1003
;-----------------------------------------------------------------------
IDM_WINL    = 703 ;   
IDM_WINTR   = 704 ;   
;-----------------------------------------------------------------------
