;=======================================================================
format PE CONSOLE           
;=======================================================================
include 'win32a.inc'    ;*
include "combstr.inc"   ; some handy stuff 
include "ucombstr.inc"  ; some handy stuff 
;-----------------------------------------------------------------------
CP_ACP          equ 0       ; default to ANSI code page
CP_OEMCP        equ 1       ; default to OEM  code page
CP_MACCP        equ 2       ; default to MAC  code page
CP_THREAD_ACP   equ 3       ; current thread's ANSI code page
CP_SYMBOL       equ 42      ; SYMBOL translations
CP_UTF7         equ 65000   ; UTF-7 translation
CP_UTF8         equ 65001   ; UTF-8 translation
;-----------------------------------------------------------------------
MAX_PARAMS = 2
MIN_PARAMS = 2
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
section '.code' code readable executable
;-----------------------------------------------------------------------
entry $
;-----------------------------------------------------------------------
    invoke GetCommandLine
    stdcall GetParameter,eax        ; skip exe name
    stdcall GetParameter,edx        ; get first parameter
    jnz @F                          ; optimized checking
    mov edx,err0
    jmp error                       ; empty commandline - help screen
@@:
    mov [iname],eax
    cmp byte [edx],0
    mov byte [edx],0
    je  cmderror                    ; no more parameters - error
    inc edx
    stdcall GetParameter,edx        ; get second parameter
    jz  cmderror                    ; no  second parameter - error
    mov [oname],eax
    cmp byte [edx],0
    mov byte [edx],0
    jne @F
    stdcall GetParameter,edx        ; get extra parameter
    jnz cmderror                    ; has some extra parameters - error
@@:    
;-----------------------------------------------------------------------
;   Opening filenames
;-----------------------------------------------------------------------
    invoke PathUnquoteSpaces,[iname]
    invoke PathUnquoteSpaces,[oname]
;-----------------------------------------------------------------------
    invoke CreateFile,[iname],GENERIC_READ,FILE_SHARE_READ,0,\
                              OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0
    cmp eax,[ihand]
    mov edx,err2
    je  error
    mov [ihand],eax    
;-----------------------------------------------------------------------
    invoke CreateFile,[oname],GENERIC_WRITE,0,0,\
                              CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,0
    cmp eax,[ohand]
    mov edx,err3
    je  error
    mov [ohand],eax    
;-----------------------------------------------------------------------
    invoke WriteFile,eax,bom,2,cnt,0
    mov edx,err3
    cmp [cnt],2
    jne error
;-----------------------------------------------------------------------
;   Reading
;-----------------------------------------------------------------------
next:
    stdcall GetLine,[ihand],ibuff,1024
    test eax,eax
    jz  done
;-----------------------------------------------------------------------
;   Processing
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    sub edx,ibuff
    invoke MultiByteToWideChar,CP_UTF8,0,ibuff,edx,obuff,1024
    mov word [obuff + eax*2],0
    cmp word [obuff],"#"
    je  skip
;-----------------------------------------------------------------------
    xor eax,eax
    mov esi,obuff
    mov edi,fbuff
@@:
    lodsw
    or  eax,eax
    jz  next
    cmp eax," "
    je  @B
@@:
    stosw       ;  
    lodsw    
    or  eax,eax
    jz  next
    cmp eax," "
    jne @B
    mov dword [edi],000A000Dh
    mov word  [edi + 4],0
    mov edi,fbuff
    stdcall PutLine,[ohand],edi
    invoke lstrcpy,ibuff,edi
;-----------------------------------------------------------------------
    xor eax,eax
@@:
    lodsw
    or  eax,eax
    jz  next
    cmp eax," "
    je  @B
@@:
    stosw       ;  
    lodsw    
    or  eax,eax
    jz  next
    cmp eax," "
    jne @B
    mov dword [edi],000A000Dh
    mov word  [edi + 4],0
    mov edi,fbuff
    invoke lstrcmp,ibuff,edi
    or  eax,eax
    jz  @F
    stdcall PutLine,[ohand],edi
@@:    
;-----------------------------------------------------------------------
    xor eax,eax
    mov edi,fbuff
    mov word [edi],9 
    add edi,2
    lodsw
@@:
    or  eax,eax
    jz  next
    cmp eax,"[" ; 
    jne @B    
@@:
    lodsw
    or  eax,eax
    jz  next
    cmp eax,"]"
    je @F
    stosw
    jmp @B
@@:
    mov dword [edi],000A000Dh
    mov word  [edi + 4],0
    mov edi,fbuff
    stdcall PutLine,[ohand],edi
;-----------------------------------------------------------------------
    mov edi,fbuff
    cmp word [esi],"/"
    jne solution
    add esi,2
solution:    
    cmp word [esi - 2],0 ;  
    je  next
    xor eax,eax
    mov word [edi],9 
    add edi,2
@@:
    lodsw
    or  eax,eax
    je  @F
    cmp eax,"/"
    je  @F
    stosw
    jmp @B
@@:    
    mov dword [edi],000A000Dh
    mov word  [edi + 4],0
    mov edi,fbuff
    stdcall PutLine,[ohand],edi
    jmp solution
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
skip:
    mov dword [eax*2 + obuff],000A000Dh
    mov word  [eax*2 + obuff + 4],0
    stdcall PutLine,[ohand],obuff
    test eax,eax
    jz  next    
    mov edx,err3
    jmp error           ; error writing to file
;-----------------------------------------------------------------------
cmderror:               ; error in commandline
    mov edx,err1    
;-----------------------------------------------------------------------
error:                  ; in edx - pointer to error message
    push 0
    push cnt
    push edx
    invoke lstrlen,edx
    pop  edx
    push eax
    push edx
    invoke GetStdHandle,STD_ERROR_HANDLE
    invoke WriteFile,eax
    mov [cnt],1
;-----------------------------------------------------------------------
done:
    cmp [ihand],INVALID_HANDLE_VALUE
    je  @F
    invoke CloseHandle,[ihand]
@@:
    cmp [ohand],INVALID_HANDLE_VALUE
    je  @F
    invoke CloseHandle,[ohand]
@@:
    invoke ExitProcess,[cnt]
;=======================================================================
;
;=======================================================================
proc GetLine h_file,buffer,limit ; eol - any 0D/0A combination
;-----------------------------------------------------------------------
    local cnt dd ?
    local tot dd ?
;-----------------------------------------------------------------------
    push edi
    push esi
    mov  edi,[buffer]
    mov  [tot],0
    add  [limit],edi
    lea  esi,[cnt]
    dec  edi
.next:    
    inc  edi
    cmp  edi,[limit]
    jae  .done
    invoke ReadFile,[h_file],edi,1,esi,0 
    cmp [cnt],0
    je  .done
    inc [tot]
    cmp byte [edi],10
    je  @F
    cmp byte [edi],13
    jne .next
@@:
    invoke ReadFile,[h_file],edi,1,esi,0 
    cmp [cnt],0
    je  .done
    inc [tot]
    cmp byte [edi],13
    je  .done
    cmp byte [edi],10
    je  .done
    invoke SetFilePointer,[h_file],-1,-1,FILE_CURRENT
    dec [tot]
.done:
    mov byte [edi],0
    mov eax, [tot]  ; eax = number of bytes, read from file
    mov edx,edi     ; edx = pointer to line termination 0
    pop esi
    pop edi
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc PutLine,h_file,buffer ; eol should be already added! UNICODE !!!
;-----------------------------------------------------------------------
    local cnt dd ?
;-----------------------------------------------------------------------
    push esi
    push edi
    mov  edx,[buffer]
    xor  ecx,ecx
    xor  eax,eax
    mov  edi,edx
    dec  ecx
    lea  esi,[cnt]
    repne scasw
    sub  edi,edx
    dec  edi 
    dec  edi   
    invoke WriteFile,[h_file],edx,edi,esi,0
    mov  eax,edi
    pop  edi
    pop  esi
    sub  eax,[cnt]
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
    CSSupport
;-----------------------------------------------------------------------
include "cmdparse.inc" 
include "a2i.inc"
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
section '.data' data readable writeable
bom     dw 0FEFFh
err1    db 13,10,"Error in the commandline"
err0    db 13,10,"Usage: cedict2dsl.exe cedict_ts.u8 cedict_ts.dsl"
crlf    db 13,10,0
err2    db 13,10,"Error reading file",13,10,0
err3    db 13,10,"Error writing file",13,10,0
;-----------------------------------------------------------------------
        align 4
ihand   dd INVALID_HANDLE_VALUE
ohand   dd INVALID_HANDLE_VALUE
cnt     dd 0
iname   dd ?
oname   dd ?
ibuff   rb 1024
obuff   rw 1024+4
fbuff   rw 1024+4
arg     rd 2
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
include "idata.inc"
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
