;=======================================================================
proc avl_new_tree avl_tree,_data ;  -    
;-----------------------------------------------------------------------
    mov eax,[avl_tree]
    mov ecx,[_data]
    mov dword [eax + AVL_TREE.root],0
    mov dword [eax + AVL_TREE.next],sizeof.AVL_TREE
    mov dword [eax + AVL_TREE.data],ecx
    mov dword [eax + AVL_TREE.temp],0
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc avl_insert avl_tree, pstart, value ; /
;-----------------------------------------------------------------------
    local drop: DWORD
    local res:  DWORD
;-----------------------------------------------------------------------
    push ebx
    push edi
    push esi
;-----------------------------------------------------------------------
    mov [drop],esp
    push 0                  
;-----------------------------------------------------------------------
    mov ebx,[avl_tree]
    mov edi,[pstart]
    mov eax,[value]
;-----------------------------------------------------------------------
    align 4
;-----------------------------------------------------------------------
.search:
    cmp dword [ebx + edi],0
    je  .new
    push edi
    mov edi,[ebx + edi]
    cmp eax,[ebx + edi + AVL_NODE.value]
    jg  .above
    jl  .below
    mov [res],edi
    jmp .drop
;-----------------------------------------------------------------------
    align 4
;-----------------------------------------------------------------------
.above:
    add edi,AVL_NODE.above
    push 1
    jmp .search
;-----------------------------------------------------------------------
    align 4
;-----------------------------------------------------------------------
.below:
    add edi,AVL_NODE.below
    push -1
    jmp .search
;-----------------------------------------------------------------------
.new:
    mov esi,[ebx + AVL_TREE.next]
    mov ecx,[ebx + AVL_TREE.data]
    mov [ebx + edi],esi
    mov [res],esi
    lea edi,[ebx + esi]
    add ecx,3
    stosd
    xor eax,eax
    rep stosd
    sub edi,ebx
    mov [ebx + AVL_TREE.next],edi
;-----------------------------------------------------------------------
    align 4
;-----------------------------------------------------------------------
.balance:
    pop edx
    or  edx,edx
    jz  .done
    pop edi
    mov esi,[ebx + edi]
    mov ecx,[ebx + esi + AVL_NODE.balance]
    cmp ecx,edx
    je  .rotate
    add ecx,edx
    mov eax,esi
    mov [ebx + esi + AVL_NODE.balance],ecx
    jnz .balance
    jmp .drop
;-----------------------------------------------------------------------
.rotate:
    cmp ecx,[ebx + eax + AVL_NODE.balance]
    jne .LR_RL
    or  ecx,ecx
    mov [ebx + edi],eax
    mov [ebx + eax + AVL_NODE.balance],0
    mov [ebx + esi + AVL_NODE.balance],0
    jns .LL
;-----------------------------------------------------------------------
;RR:    
    mov edx,[ebx + eax + AVL_NODE.above]
    mov [ebx + esi + AVL_NODE.below],edx
    mov [ebx + eax + AVL_NODE.above],esi
    jmp .drop
;-----------------------------------------------------------------------
.LL:
    mov edx,[ebx + eax + AVL_NODE.below]
    mov [ebx + esi + AVL_NODE.above],edx
    mov [ebx + eax + AVL_NODE.below],esi
    jmp .drop
;-----------------------------------------------------------------------
.LR_RL:
    or  ecx,ecx
    jns .LR
;-----------------------------------------------------------------------
;RL:
    mov ecx,[ebx + eax + AVL_NODE.above]
    mov [ebx + edi],ecx
    mov edx,[ebx + ecx + AVL_NODE.above]
    mov edi,[ebx + ecx + AVL_NODE.below]
    mov [ebx + esi + AVL_NODE.below],edx
    mov [ebx + eax + AVL_NODE.above],edi
    mov [ebx + ecx + AVL_NODE.below],eax
    mov [ebx + ecx + AVL_NODE.above],esi
    cmp [ebx + ecx + AVL_NODE.balance],0
    mov [ebx + ecx + AVL_NODE.balance],0
    setg cl
    setl dl
    neg  cl
    jmp .flags
;-----------------------------------------------------------------------
.LR:        
    mov ecx,[ebx + eax + AVL_NODE.below]
    mov [ebx + edi],ecx
    mov edx,[ebx + ecx + AVL_NODE.below]
    mov edi,[ebx + ecx + AVL_NODE.above]
    mov [ebx + esi + AVL_NODE.above],edx
    mov [ebx + eax + AVL_NODE.below],edi
    mov [ebx + ecx + AVL_NODE.above],eax
    mov [ebx + ecx + AVL_NODE.below],esi
    cmp [ebx + ecx + AVL_NODE.balance],0
    mov [ebx + ecx + AVL_NODE.balance],0
    setg dl
    setl cl
    neg  dl
;-----------------------------------------------------------------------
.flags:
    movsx ecx,cl
    movsx edx,dl
    mov [ebx + eax + AVL_NODE.balance],ecx
    mov [ebx + esi + AVL_NODE.balance],edx
;-----------------------------------------------------------------------
.drop:
    mov esp,[drop]
;-----------------------------------------------------------------------
.done:
    mov eax,[res]
    pop esi
    pop edi
    pop ebx 
    ret   
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc avl_search avl_tree, pstart, value ;  
;-----------------------------------------------------------------------
    push ebx
    push edi
;-----------------------------------------------------------------------
    mov eax,[value]
    mov ebx,[avl_tree]
    mov edi,[pstart]
;-----------------------------------------------------------------------
    align 4
;-----------------------------------------------------------------------
.next:
    mov edi,[ebx + edi]
    or  edi,edi
    jz  .done
    cmp eax,[ebx + edi + AVL_NODE.value]
    jg  .above
    jl  .below
;-----------------------------------------------------------------------
.done:
    mov eax,edi
    pop edi
    pop ebx
    ret
;-----------------------------------------------------------------------
    align 4
;-----------------------------------------------------------------------
.above:
    add edi,AVL_NODE.above
    jmp .next
;-----------------------------------------------------------------------
    align 4
;-----------------------------------------------------------------------
.below:
    add edi,AVL_NODE.below
    jmp .next    
;-----------------------------------------------------------------------
endp
;=======================================================================
