;=======================================================================
proc dict_init _name
;-----------------------------------------------------------------------
    local h_idx dd ?
    local h_dsl dd ?
    local s_dsl dd ?
    local s_idx dd ?
;-----------------------------------------------------------------------
    push ebx
    push esi
    push edi
    xor  ebx,ebx
;-----------------------------------------------------------------------
    invoke SendMessage,[hDict],EM_REPLACESEL,0,loading
    invoke SendMessage,[hDict],EM_REPLACESEL,0,[_name]
    invoke SendMessage,[hDict],EM_REPLACESEL,0,crlf
    invoke PathFileExists,[_name]
    or  eax,eax
    jz  .done ;   
;-----------------------------------------------------------------------
    mov esi,[_name]
    mov edi,b_buff
@@:
    cmp word [esi],0
    movsw
    jne @B
    invoke PathRemoveExtension,b_buff
    invoke PathAddExtension,b_buff,_idx   
    invoke PathFileExists,b_buff
    test eax,eax
    jz  .new_idx
;-----------------------------------------------------------------------
    invoke CreateFile,b_buff,GENERIC_READ,FILE_SHARE_READ,0,\
                                 OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0
    cmp eax,INVALID_HANDLE_VALUE
    mov [h_idx],eax
    je  .done ;                                
    invoke GetFileSize,eax,0
    cmp eax,sizeof.BKRS_TREE
    ja  @F
    invoke CloseHandle,[h_idx]
    jmp .new_idx
@@:    
    mov [s_idx],eax
    add eax,4096*2
    and eax,-4096
    mov esi,eax
    invoke VirtualAlloc,0,eax,MEM_COMMIT,PAGE_READWRITE
    or  eax,eax
    mov ebx,eax
    jnz @F
    invoke CloseHandle,[h_idx]
    jmp .done ;    
@@:
    mov [ebx + DICT.flag],0
    mov [ebx + DICT.size],esi
    lea edi,[ebx + DICT.ndsl]
    mov esi,[_name]
@@:
    cmp word [esi],0
    movsw
    jne @B
    add edi, 4
    and edi,-4
    lea ecx,[s_idx]
    mov esi,[s_idx]
    invoke ReadFile,[h_idx],edi,[s_idx],ecx,0
    invoke CloseHandle,[h_idx]
    cmp esi,[s_idx]
    je  @F
.error_release_mem:
    invoke VirtualFree,ebx,0,MEM_RELEASE
    xor ebx,ebx
    xor eax,eax
    jmp .done
@@:    
    sub edi,ebx
    mov [ebx + DICT.index],edi
    invoke CreateFile,[_name],GENERIC_READ,\
                                 FILE_SHARE_READ or FILE_SHARE_WRITE,0,\
                                 OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0
    cmp eax,INVALID_HANDLE_VALUE
    mov [ebx + DICT.hdsl],eax
    je  .error_release_mem  ;                               
    jmp .done
;-----------------------------------------------------------------------
.new_idx:
    invoke SendMessage,[hDict],EM_REPLACESEL,0,indexing
    invoke CreateFile,[_name],GENERIC_READ,\
                                 FILE_SHARE_READ or FILE_SHARE_WRITE,0,\
                                 OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0
    cmp eax,INVALID_HANDLE_VALUE
    mov [h_dsl],eax
    je  .done   ;                              
    invoke GetFileSize,eax,0
    or  eax,eax
    jnz @F
.error_close_dsl:
    invoke CloseHandle,[h_dsl]
    jmp .done
@@:
    mov [s_dsl],eax
    mov ecx,1024*1024 ;     -  !
    add eax, 4096
    and eax,-4096
    cmp eax,ecx
    cmovae esi,eax
    cmovb  esi,ecx
    invoke VirtualAlloc,0,esi,MEM_RESERVE,PAGE_READWRITE
    or  eax,eax
    jz  .error_close_dsl ;    
    mov ebx,eax
    invoke VirtualAlloc,eax,4096,MEM_COMMIT,PAGE_READWRITE
    or  eax,eax
    jnz @F
    invoke VirtualFree,ebx,0,MEM_RELEASE
    xor ebx,ebx ;    
    jmp .error_close_dsl
@@:
    mov eax,[h_dsl]
    mov [ebx + DICT.flag],0
    mov [ebx + DICT.size],4096
    mov [ebx + DICT.hdsl],eax
    lea edi,[ebx + DICT.ndsl]
    mov esi,[_name]
@@:
    cmp word [esi],0
    movsw
    jne @B
    mov [edi + BKRS_TREE.root],0
    mov [edi + BKRS_TREE.next],sizeof.BKRS_TREE
    mov [edi + BKRS_TREE.data],BKRS_TREE.data_size
    sub edi,ebx
    mov [ebx + DICT.index],edi
    stdcall build_dsl_index,ebx,termometer
    or  eax,eax
    jz  @F
    cmp eax,-1
    jne .error_alloc
    invoke SendMessage,[hDict],EM_REPLACESEL,0,error.getline
    jmp .done_2
.error_alloc:    
    invoke SendMessage,[hDict],EM_REPLACESEL,0,error.badalloc
    jmp .done_2
@@:    
    lea eax,[ebx + edi]
    stdcall tree_save,eax,b_buff
.done_2:
    mov eax,ebx
    jmp .done    
;-----------------------------------------------------------------------
.done:
    mov eax,ebx
    pop edi
    pop esi
    pop ebx
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc dict_search _dict,_string
;-----------------------------------------------------------------------
    push ebx
    push edi
    mov ebx,[_dict]
    mov edi,ebx
    add ebx,[ebx + DICT.index]
    stdcall index_search,ebx,[_string]
    or  eax,eax
    jz  @F
    add ebx,eax
    sub eax,eax
    mov ecx,[ebx + BKRS_NODE.size]
    jecxz @F
    mov edx,[ebx + BKRS_NODE.start]    
    mov eax,[edi + DICT.hdsl]
@@:
    pop edi
    pop ebx
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc put_info p_dict
;-----------------------------------------------------------------------
    push ebx
    mov ebx,[p_dict]
    UCSLoad r_buff
    UCSAdd dict_info
    mov eax,[ebx + DICT.index]
    UCSAddDec [ebx + eax + BKRS_TREE.wrds]
    UCSAdd dict_info.articles
    mov eax,[ebx + DICT.index]
    UCSAddDec [ebx + eax + BKRS_TREE.arts]
    UCSAddCR
    UCSEnd
    UCSRestore
    invoke SendMessage,[hDict],EM_REPLACESEL,0,r_buff
    pop ebx
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc termometer part16
;-----------------------------------------------------------------------
    push 0
    mov edx,edi
    sub esp,32
    mov edi,esp
    mov ecx,[part16]
    jecxz @F
    mov ax,2588h
    rep stosw
@@:
    mov ecx,16
    sub ecx,[part16]
    jecxz @F
    mov ax,2584h
    rep stosw
@@:
    mov edi,edx
    invoke SetWindowText,[hStatus],esp
    invoke UpdateWindow,[hMain]
    ret           
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc dict_remove pp_dict
;-----------------------------------------------------------------------
    push edi
    push esi
    mov edi,[pp_dict]
    mov eax,[edi]
    or  eax,eax
    je  .done
;-----------------------------------------------------------------------
    mov esi,[edi]
    invoke CloseHandle,[esi + DICT.hdsl]
    invoke VirtualFree,esi,0,MEM_RELEASE
    lea esi,[edi + 4]
@@:
    cmp dword [esi],0
    movsd
    jne @B    
    mov eax,1
;-----------------------------------------------------------------------
.done:
    pop esi
    pop edi
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc dict_reidx pp_dict
;-----------------------------------------------------------------------
    mov [cmd_block],1
    mov [list_handler],0
    invoke EnableWindow,[hDict],FALSE
    invoke SendMessage,[hDict],WM_ENABLE,TRUE,0
    invoke SetWindowText,[hDict],0
    invoke SendMessage,[hList],LB_RESETCONTENT,0,0
    invoke SendMessage,[hDict],EM_REPLACESEL,0,reindex
    mov ebx,[pp_dict]
    or  ebx,ebx    
    jnz .exact
    mov ebx,a_dict - 4
.next:
    add ebx,4
    cmp dword [ebx],0
    je  .done
    mov esi,[ebx]
    add esi,DICT.ndsl
    invoke lstrcpy,a_buff,esi
    invoke PathRemoveExtension,a_buff
    invoke PathAddExtension,a_buff,_idx
    invoke DeleteFile,a_buff
    stdcall dict_init,esi
    or  eax,eax
    jz  .next
    mov esi,[ebx]
    mov [ebx],eax
    stdcall put_info,eax
    invoke CloseHandle,[esi + DICT.hdsl]
    invoke VirtualFree,esi,0,MEM_RELEASE
    jmp .next
.exact:
    mov esi,[ebx]
    add esi,DICT.ndsl
    invoke lstrcpy,a_buff,esi
    invoke PathRemoveExtension,a_buff
    invoke PathAddExtension,a_buff,_idx
    invoke DeleteFile,a_buff
    stdcall dict_init,esi
    or  eax,eax
    jz  .done
    mov esi,[ebx]
    mov [ebx],eax
    stdcall put_info,eax
    invoke CloseHandle,[esi + DICT.hdsl]
    invoke VirtualFree,esi,0,MEM_RELEASE
;-----------------------------------------------------------------------
.done:
    invoke EnableWindow,[hDict],TRUE
    mov [cmd_block],0
    invoke ExitThread,0
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc dict_by_name _name ;    
;-----------------------------------------------------------------------
    push ebx
    push edi
    mov ebx,a_dict - 4
.next:
    add ebx,4
    mov edi,[ebx]
    or  edi,edi
    jz  .done
    add edi,DICT.ndsl
    invoke lstrcmpi,[_name],edi
    or  eax,eax
    jnz .next
    mov edi,ebx
.done:
    mov eax,edi
    pop edi
    pop ebx
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc dict_open _name
;-----------------------------------------------------------------------
    mov [cmd_block],1
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    invoke PathFindFileName,[_name]
    mov [_name],eax
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    stdcall dict_by_name,[_name]
    or  eax,eax
    jz  @F
    push eax
    invoke MessageBox,[hMain],error.dict_exists,[_name],\
                                         MB_ICONEXCLAMATION or MB_YESNO
    pop edx
    cmp eax,IDYES
    jne .done
    stdcall dict_reidx,edx
    jmp .done
@@:
    invoke EnableWindow,[hDict],FALSE
    invoke SendMessage,[hDict],WM_ENABLE,TRUE,0
    invoke SetWindowText,[hDict],0
    mov ecx,63
    mov edi,a_dict
    xor eax,eax
    repne scasd
    je  @F
    invoke MessageBox,[hMain],error.dict_full,0,0
    jmp .done
@@:
    stdcall dict_init,[_name]
    or  eax,eax
    jnz @F
    invoke MessageBox,[hMain],error.dict_init,0,0
    jmp .done
@@:
    mov [edi - 4],eax
    mov dword [edi],0
    push eax
    stdcall put_info
.done:
    invoke EnableWindow,[hDict],TRUE
    mov [cmd_block],0
    invoke ExitThread,0
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc dict_menu _all ; 0 - , -1 - ,    
;-----------------------------------------------------------------------
    push ebx
    push edi
    push esi
    xor edi,edi
    mov esi,a_dict
    mov eax,-1
    cmp dword [esi],edi
    je  .done
    invoke CreatePopupMenu
    mov ebx,eax
    cmp [_all],1
    jne @f
    invoke InsertMenu,ebx,-1,MF_BYPOSITION,101,vse
    invoke InsertMenu,ebx,-1,MF_BYPOSITION,edi,edi
@@:
    invoke InsertMenu,ebx,-1,MF_BYPOSITION,100,cancel
    invoke InsertMenu,ebx,-1,MF_BYPOSITION,edi,edi
    lodsd
    add edi,102
.next:
    add eax,DICT.ndsl
    invoke InsertMenu,ebx,-1,MF_BYPOSITION,edi,eax
    lodsd
    inc edi
    or  eax,eax
    jne .next
    invoke GetWindowRect,[hMain],rc
    mov eax,[rc + RECT.left]
    mov edx,[rc + RECT.top]
    add eax,eax
    add edx,edx
    add eax,[rc + RECT.right]
    add edx,[rc + RECT.bottom]
    shr eax,1
    shr edx,1
    invoke TrackPopupMenu,ebx,TPM_CENTERALIGN or TPM_VCENTERALIGN or \
                   TPM_RETURNCMD or TPM_NONOTIFY,eax,edx,0,[hMain],0
    push ebx
    mov ebx,eax
    invoke DestroyMenu
    mov eax,-1
    or  ebx,ebx
    jz  .done
    sub ebx,100
    jz  .done
    dec ebx
    mov eax,ebx
    jz  .done  
    dec ebx
    lea eax,[a_dict + ebx*4]
.done:
    pop esi
    pop edi
    pop ebx
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
