;=======================================================================
proc load_file _name
;-----------------------------------------------------------------------
    local cnt   dd ?
    local mem   dd ?
;-----------------------------------------------------------------------
    push edi
    push esi
    invoke CreateFile,[_name],GENERIC_READ,FILE_SHARE_READ,0,\
                       OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0
    cmp eax,INVALID_HANDLE_VALUE
    mov esi,eax
    je  .done
    invoke GetFileSize,esi,0
    or  eax,eax
    mov edi,eax
    je  .done_close
    add eax,2
    invoke LocalAlloc,LMEM_MOVEABLE,eax
    mov [mem],eax
    invoke LocalLock,eax
    push eax
    lea ecx,[cnt]
    mov word [eax + edi],0
    invoke ReadFile,esi,eax,edi,ecx,0
    invoke LocalUnlock
    cmp edi,[cnt]
    je  .done_close
    invoke LocalFree,[mem]
    mov [mem],INVALID_HANDLE_VALUE
.done_close:
    invoke CloseHandle,esi
    mov eax,[mem]    
.done:    
    pop esi
    pop edi
    ret                       
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc save_file _name,_buff,_size,_bom
;-----------------------------------------------------------------------
    push edi
    push esi
    xor eax,eax
    mov esi,[_buff]
    cmp word [esi],BOM
    jne @F
    mov [_bom],0
@@:    
    mov edi,[_size]
    add edi,edi
    jnz @F
    mov edi,esi
    mov ecx,-1
    repne scasw
    sub edi,[_buff]
    sub edi,2
@@:    
    invoke CreateFile,[_name],GENERIC_WRITE,0,0,CREATE_ALWAYS,\
                              FILE_ATTRIBUTE_NORMAL,0
    cmp eax,INVALID_HANDLE_VALUE
    je  .done
    mov esi,eax
    cmp [_bom],0
    je  @F
    lea ecx,[_name]
    invoke WriteFile,esi,bom,2,ecx,0
    cmp [_name],2
    je  @F
    mov edi,-1
    jmp .close
@@:
    lea ecx,[_name]
    invoke WriteFile,esi,[_buff],edi,ecx,0
    invoke SetEndOfFile,esi
    sub edi,[_name]
.close:
    invoke CloseHandle,esi
    mov eax,edi
.done:
    pop esi
    pop edi
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc append_file _name,_buff,_size
;-----------------------------------------------------------------------
    push edi
    push esi
    mov esi,[_buff]
    mov edi,[_size]
    cmp word [esi],BOM
    jne @F
    add esi,2
    sub edi,2
@@:    
    add edi,edi
    jnz @F
    mov edi,esi
    mov ecx,-1
    repne scasw
    sub edi,[_buff]
    sub edi,2
@@:    
    invoke CreateFile,[_name],GENERIC_WRITE,FILE_SHARE_READ,0,\
                              OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0
    cmp eax,INVALID_HANDLE_VALUE
    je  .done
    mov esi,eax
    invoke SetFilePointer,eax,0,0,FILE_END
    lea ecx,[_name]
    invoke WriteFile,esi,[_buff],edi,ecx,0
    sub edi,[_name]
.close:
    invoke CloseHandle,esi
    mov eax,edi
.done:
    pop esi
    pop edi
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc SaveEdit,_edit,_file
;-----------------------------------------------------------------------
    invoke SendMessage,[_edit],WM_GETTEXTLENGTH,0,0
    push eax
    invoke SendMessage,[_edit],EM_GETHANDLE,0,0
    invoke LocalLock,eax
    or   eax,eax
    pop  edx
    jz   @F
    push eax
    stdcall save_file,[_file],eax,edx,1
    pop  edx
    push eax
    invoke LocalUnlock,edx
    pop  eax
    ret    
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc AppendToFile,_edit,_file
;-----------------------------------------------------------------------
    invoke SendMessage,[_edit],WM_GETTEXTLENGTH,0,0
    push eax
    invoke SendMessage,[_edit],EM_GETHANDLE,0,0
    invoke LocalLock,eax
    or   eax,eax
    pop  edx
    jz   @F
    push eax
    stdcall append_file,[_file],eax,edx,1
    pop  edx
    push eax
    invoke LocalUnlock,edx
    pop  eax
    ret    
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc LoadEdit,_edit,_file
;-----------------------------------------------------------------------
    stdcall load_file,[_file]
    cmp eax,INVALID_HANDLE_VALUE
    je  @F
    push 0
    push eax
    invoke SendMessage,[_edit],EM_GETHANDLE,0,0
    mov [_file],eax
    invoke SendMessage,[_edit],EM_SETHANDLE
    invoke LocalFree,[_file] 
    xor eax,eax
@@:
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
