;=======================================================================
proc index_insert bkrs_tree,pword ;
;-----------------------------------------------------------------------
    push ebx
    push esi
    push edi
;-----------------------------------------------------------------------
    mov ebx,[bkrs_tree]
    mov esi,[pword]
    xor edi,edi
    xor eax,eax
;-----------------------------------------------------------------------
.next:
    movzx ecx,word [esi]
    inc esi
    inc esi
    jecxz .done
    mov eax,ecx
    XCHAR
    stdcall avl_insert,ebx,edi,eax
    lea edi,[eax + BKRS_NODE.next]
    jmp .next
;-----------------------------------------------------------------------
.done:  
    pop edi
    pop esi
    pop ebx
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc index_search bkrs_tree,pword ;
;-----------------------------------------------------------------------
    push ebx
    push esi
    push edi
;-----------------------------------------------------------------------
    mov ebx,[bkrs_tree]
    mov esi,[pword]
    xor edi,edi
    xor eax,eax
;-----------------------------------------------------------------------
.next:
    movzx ecx,word [esi]
    inc esi
    inc esi
    jecxz .done
    mov eax,ecx
    XCHAR
    stdcall avl_search,ebx,edi,eax
    or  eax,eax
    je  .done
    lea edi,[eax + BKRS_NODE.next]
    jmp .next
;-----------------------------------------------------------------------
.done:  
    pop edi
    pop esi
    pop ebx
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc index_enum_words _index,_callbk,_user
;-----------------------------------------------------------------------
    local buff  rw 80
    local limit dd ?
    local drop  dd ?
;-----------------------------------------------------------------------
    push ebx
    push esi
    push edi
;-----------------------------------------------------------------------
    mov [drop],esp
    mov ebx,[_index]
    lea edi,[buff]
    lea ecx,[buff + 79*2]
    mov esi,[ebx]
    mov [limit],ecx
    call .next
;-----------------------------------------------------------------------
.done:
    mov esp,[drop]
    pop edi
    pop esi
    pop ebx
    ret    
;-----------------------------------------------------------------------
    align 4
.next:
    or  esi,esi
    jz  .no_next
    push [ebx + esi + AVL_NODE.above]
    push esi
    mov esi,[ebx + esi + AVL_NODE.below]
    call .next
    pop esi
    movzx eax,word [ebx + esi + AVL_NODE.value]
    push [ebx + esi + BKRS_NODE.next]
    cmp  [ebx + esi + BKRS_NODE.size],0
    mov  [edi],eax
    je  .skip
    lea ecx,[buff]
    stdcall [_callbk],[_user],ecx ; edi -    
    or  eax,eax                   ; bx -   
    jnz .done                     ; esi -      
.skip:                            
    pop esi                                    
    or  esi,esi
    je  .skip_2
    cmp edi,[limit] ;   79   
    jae .skip_2
    add edi,2
    call .next
    sub edi,2
.skip_2:    
    pop esi
    call .next    
.no_next:
    retn
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc tree_save _tree,_name
;-----------------------------------------------------------------------
    invoke CreateFile,[_name],GENERIC_WRITE,FILE_SHARE_READ,0,\
                        CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,0
    cmp eax,INVALID_HANDLE_VALUE
    je  .done
    push eax
    mov ecx,[_tree]
    lea edx,[_name]
    invoke WriteFile,eax,ecx,[ecx + AVL_TREE.next],edx,0
    invoke SetEndOfFile,[esp]
    invoke CloseHandle
    mov ecx,[_tree]
    mov edx,[_name]
    cmp edx,[ecx + AVL_TREE.next]
    setne al
    movzx eax,al
.done:
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;    
;=======================================================================
proc tree_load _tree,_name 
;-----------------------------------------------------------------------
    local handle dd ?
;-----------------------------------------------------------------------
    invoke CreateFile,[_name],GENERIC_READ,FILE_SHARE_READ,0,\
                       OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0
    cmp eax,INVALID_HANDLE_VALUE
    je  .done
    lea edx,[_name]
    mov [handle],eax
    invoke GetFileSize,eax,edx
    cmp eax,0
    je  .done_2
    mov edx,eax
    mov eax,[_name]
    or  eax,eax
    jnz .done
    mov ecx,[_tree]
    lea eax,[_name]
    push edx
    invoke ReadFile,[handle],ecx,edx,eax,0
    invoke CloseHandle,[handle]
    pop edx
    cmp edx,[_name]
.done_2:
    setne al
    movzx eax,al
.done:
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
       