;=======================================================================
proc build_dsl_index p_dict,term ; 
;-----------------------------------------------------------------------
;  :
;  0 - 
; -1 -       
;  ? -    :     
;-----------------------------------------------------------------------
    local a_start   dd ? ;  
    local drop      dd ?
    local more      dd ?
    local a_count   dd ?
    local w_count   dd ?
    local a_max     dd ?
    local h_text    dd ?
    local p_index   dd ?
    local err       dd ?
;-----------------------------------------------------------------------
    local fileblock dd ?
    local currentbk dd ?
    local blocks    dd ?
;-----------------------------------------------------------------------
    push edi
    push esi
    push ebx
;-----------------------------------------------------------------------
    mov esi,[p_dict]
    mov [drop],esp
    xor ebx,ebx
    mov eax,[esi + DICT.index]
    add eax,esi
    mov [p_index],eax
    mov [blocks],ebx
    mov [currentbk],ebx
    mrm [h_text],[esi + DICT.hdsl],edx
;-----------------------------------------------------------------------
    invoke SetFilePointer,edx,ebx,ebx,FILE_BEGIN ; ?   ?
    cmp [term],ebx
    je  @F
    stdcall [term],ebx
@@:    
    invoke GetFileSize,[h_text],0
    shr eax,4
    mov [fileblock],eax
    mov [a_count],ebx
    mov [w_count],ebx
    mov [a_max],ebx
    mov [err],ebx
;-----------------------------------------------------------------------
    mov esi,1       ; 1 -  -     
    mov [more],esi  
.next_line:
    stdcall GetLineX,[h_text],r_buff,16 * 1024
    mov [err],ecx
    or  ecx,ecx
    jnz .done       ;  -1:   !    
    mov ecx,ebx 
    add ebx,eax   
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    cmp [term],0
    je  @F
    mov edi,[currentbk] ; 
    add edi,eax
    cmp edi,[fileblock]
    jb  @F
    inc [blocks]
    sub edi,[fileblock]
    pusha
    stdcall [term],[blocks]
    popa
@@:
    mov [currentbk],edi    
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    cmp eax,2
    jae @F
    or  esi,esi
    mov [more],esi
    jnz .done
    jmp .put_art_end
@@:
;-----------------------------------------------------------------------
    or  esi,esi
    jz  .get_art_end  
    js  .get_comm_end
.next_line_check:
    cmp word [r_buff],"#"
    je  .next_line
    cmp dword [r_buff],7B007Bh ; "{{"
    je  .comment_start
    cmp esi,1
    movzx eax,word [r_buff]
    jne .get_next_word
;-----------------------------------------------------------------------
    or  eax,eax             ;   
    jz  .next_line
    cmp eax,9
    je  .next_line
    cmp eax,32
    je  .next_line
;-----------------------------------------------------------------------
    mov [a_start],ecx       ;   
    mov esp,[drop]
    push 0
.add_new_word:              ;    
    stdcall RTrim,r_buff    ;   
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    sub eax,r_buff - 4      ;     
    mov edi,[p_dict]
    mov ecx,sizeof.BKRS_NODE shr 1
    mul ecx                 ; eax -   
;-----------------------------------------------------------------------
    mov edx,[edi + DICT.index]
    add eax,edx
    add eax,[edi + edx + BKRS_TREE.next]
    cmp eax,[edi + DICT.size]
    jb  @F
    and eax,-4096
    add eax,4096
    mov [err],ebx
    push eax
    invoke VirtualAlloc,edi,eax,MEM_COMMIT,PAGE_READWRITE
    or  eax,eax
    pop eax
    jz  .done               ;   !
    mov [edi + DICT.size],eax
    mov [err],0
@@:    
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    stdcall index_insert,[p_index],r_buff
    push eax
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    add eax,[p_index]
    cmp [eax + BKRS_NODE.size],0
    je  @F ;       
    call parser_dublicate
@@:    
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    mov esi,2
    jmp .next_line
;-----------------------------------------------------------------------
.comment_start:
    mov esi,-1
.get_comm_end:              ; 
    mov edi,r_buff
@@:
    movzx eax,word [edi]
    or  eax,eax
    jz  @F
    add edi,2
    cmp eax,0FEFFh 
    je  @B
    cmp eax,"}"
    jne @B
    cmp word [edi],"}"
    jne @B      
    mov esi,1
@@:
    jmp .next_line    
;-----------------------------------------------------------------------
.get_next_word:             ;      
    or  eax,eax
    jz  @F
    cmp eax,9
    je  @F
    cmp eax,32
    jne .add_new_word       ;  
@@:
    xor esi,esi             ;   
    jmp .next_line        
;-----------------------------------------------------------------------
.get_art_end:               ;    
    movzx eax, word [r_buff]
    or  eax,eax
    jz  .next_line
    cmp eax,9
    je  .next_line
    cmp eax,32
    je  .next_line
.put_art_end:               ;    
    mov edx,[a_start]
    mov eax,ecx
    mov esi,1
    sub eax,edx
@@:
    pop edi 
    or  edi,edi
    jz  @F
    add edi,[p_index]
    mov [edi + BKRS_NODE.start],edx          
    mov [edi + BKRS_NODE.size],eax
    inc [w_count]
    jmp @B
@@:
    inc [a_count]
    cmp [a_max],eax
    jae @F
    mov [a_max],eax
@@:    
    cmp [more],0
    jne .next_line_check
;-----------------------------------------------------------------------
.done:
    invoke SetWindowText,[hStatus],0
    mov ebx,[p_index] ; ?
    mov eax,[a_count]
    mov edx,[w_count]
    mov ecx,[a_max]
    mov [ebx + BKRS_TREE.arts],eax
    mov [ebx + BKRS_TREE.wrds],edx
    mov [ebx + BKRS_TREE.amax],ecx
    mov eax,[err] 
    mov esp,[drop]
    pop ebx
    pop esi
    pop edi
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc parser_dublicate
;-----------------------------------------------------------------------
    pusha
    invoke SendMessage,[hDict],EM_REPLACESEL,0,error.parser_dup
    invoke SendMessage,[hDict],EM_REPLACESEL,0,r_buff
    invoke SendMessage,[hDict],EM_REPLACESEL,0,crlf
    popa
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
    