;=======================================================================
proc RunUserFromList
;-----------------------------------------------------------------------
    cmp [user_list],0
    jne @F
    invoke MessageBox,[hMain],error.user_empty,0,0
    ret
@@:
    push ebx
    push edi
    push esi
    mov edi,[user_list]
    invoke CreatePopupMenu
    mov ebx,eax
    invoke InsertMenu,ebx,-1,MF_BYPOSITION,1,cancel
    invoke InsertMenu,ebx,-1,MF_BYPOSITION,0,0
.next:
    mov ecx,-1
    xor eax,eax
    mov esi,edi
    repne scasw
    mov ecx,edi
    sub ecx,[user_list]
    invoke InsertMenu,ebx,-1,MF_BYPOSITION,ecx,esi
    mov ecx,-1
    xor eax,eax
    repne scasw
    cmp word [edi],0
    jne .next
    invoke GetWindowRect,[hMain],rc
    mov eax,[rc + RECT.left]
    mov edx,[rc + RECT.top]
    add eax,eax
    add edx,edx
    add eax,[rc + RECT.right]
    add edx,[rc + RECT.bottom]
    shr eax,1
    shr edx,1
    invoke TrackPopupMenu,ebx,TPM_CENTERALIGN or TPM_VCENTERALIGN or \
                   TPM_RETURNCMD or TPM_NONOTIFY,eax,edx,0,[hMain],0
    push ebx
    mov ebx,eax
    invoke DestroyMenu
    or  ebx,ebx
    jz  .done
    cmp ebx,1
    jz  .done
    add ebx,[user_list]
    stdcall RunUserFunction,ebx
.done:
    pop esi
    pop edi
    pop ebx
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc RunUserFunction _dll
;-----------------------------------------------------------------------
    local hDLL dd ?
;-----------------------------------------------------------------------
    invoke LoadLibrary,[_dll]
    mov [hDLL],eax
    or  eax,eax
    mov edx,error.user_dll
    jz  .done_err
    invoke GetProcAddress,eax,user_func
    or  eax,eax
    mov edx,error.user_bad
    jz  .done_err
    pusha
    mov [user_drop],esp
    stdcall eax,data_context,func_context
    mov esp,[user_drop]
    popa
    jmp .done
.done_err:
    invoke MessageBox,[hMain],edx,[_dll],MB_ICONERROR    
.done:
    cmp [hDLL],0
    je  @F
    invoke FreeLibrary,[hDLL]
@@:    
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
