;=======================================================================
format PE GUI 4.0
;-----------------------------------------------------------------------
include 'win32w.inc'            ;*
include 'encoding\WIN1251.INC'  ;*
include 'avlstruc.inc'          ;*
include 'bv.inc'                ;*
include 'def.inc'
include 'win32.inc'             ;*
include 'ucombstr.inc'          ;*
include 'rc.inc'                ;*
;=======================================================================
;
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
section '.code' code readable executable
;=======================================================================
UCSSupport
;-----------------------------------------------------------------------
entry $
;-----------------------------------------------------------------------
    mov [a_dict],0
;-----------------------------------------------------------------------
    invoke GetCurrentDirectory,260,f_dir
;-----------------------------------------------------------------------
    invoke GetModuleHandle,0
	mov	[wc.hInstance],eax
    invoke LoadAccelerators,[wc.hInstance],IDA_MAIN
    mov [hAcc],eax
    invoke LoadIcon,[wc.hInstance],IDI_MAIN
	mov	[wc.hIcon],eax
	invoke LoadCursor,0,IDC_ARROW
	mov	[wc.hCursor],eax
	mov	[zc.hCursor],eax
	invoke RegisterClass,wc
	invoke RegisterClass,zc
	invoke LoadMenu,[wc.hInstance],IDM_MAIN
	mov [hMenu],eax
	invoke CreateWindowEx,0,_class,_title,\
        WS_VISIBLE+WS_OVERLAPPEDWINDOW + DS_CENTER,\
        20,20,600,400,NULL,eax,[wc.hInstance],NULL
;-----------------------------------------------------------------------
msg_loop:
    invoke GetMessage,msg,NULL,0,0
    or  eax,eax
    jz  exit
    invoke TranslateAccelerator,[hMain],[hAcc],msg
    or  eax,eax
    jnz @F
    invoke TranslateMessage,msg
@@:
    invoke DispatchMessage,msg
    jmp	msg_loop
exit:
	invoke ExitProcess,[msg.wParam]
	invoke InitCommonControls
;=======================================================================
;
;=======================================================================
proc WindowProc hWnd,uMsg,wParam,lParam
;-----------------------------------------------------------------------
    mov eax,[uMsg]
	CASE eax,\
	WM_CREATE,     .wm_create,     \
	WM_SIZE,       .wm_size,       \
	WM_SETFOCUS,   .wm_setfocus,   \
	WM_COMMAND,    .wm_command,    \
	WM_DESTROY,    .wm_destroy
;-----------------------------------------------------------------------
.defwndproc:
	leave
	jmp [DefWindowProc]
;-----------------------------------------------------------------------
.wm_create:
	mov eax,[hWnd]
	mov [hMain],eax
;-----------------------------------------------------------------------
	invoke CreateWindowEx,WS_EX_CLIENTEDGE,_status,0,STATUS_STYLE,\
	                       0,0,0,0,[hWnd],0,[wc.hInstance],NULL
	or	eax,eax
	jz	.failed
	mov	[hStatus],eax
	invoke CreateWindowEx,WS_EX_CLIENTEDGE,_list,0,LIST_STYLE,0,0,0,0,\
	                       [hWnd],IDW_LIST,[wc.hInstance],NULL
	or	eax,eax
	jz	.failed
	mov	[hList],eax
	invoke CreateWindowEx,WS_EX_CLIENTEDGE,_edit,0,TRAN_STYLE,0,0,0,0,\
	                       [hWnd],IDW_EDIT,[wc.hInstance],NULL
	or	eax,eax
	jz	.failed
	mov	[hTran],eax
	invoke CreateWindowEx,WS_EX_CLIENTEDGE,_edit,0,EDIT_STYLE,0,0,0,0,\
	                       [hWnd],IDW_EDIT,[wc.hInstance],NULL
	or	eax,eax
	jz	.failed
	mov	[hDict],eax
	invoke CreateWindowEx,WS_EX_CLIENTEDGE,_edit,0,WRAP_STYLE,0,0,0,0,\
	                       [hWnd],IDW_EDIT,[wc.hInstance],NULL
	or  eax,eax
	jz  .failed
	mov [hText],eax
	mov [hLast],eax
    invoke CreateFont,24,0,0,0,0,0,0,0,\
	   DEFAULT_CHARSET,OUT_RASTER_PRECIS,CLIP_DEFAULT_PRECIS,\
	   DEFAULT_QUALITY,FF_DONTCARE,fontname
	or	eax,eax
	jz	.failed
	mov	[hFont],eax
	push FALSE
	push eax
	push FALSE
	push eax
	push FALSE
	push eax
	invoke SendMessage,[hDict],WM_SETFONT,eax,FALSE
	invoke SendMessage,[hText],WM_SETFONT
	invoke SendMessage,[hTran],WM_SETFONT
	invoke SendMessage,[hList],WM_SETFONT
	invoke SendMessage,[hDict],EM_SETTABSTOPS,1,tab_stops
	invoke SendMessage,[hText],EM_SETTABSTOPS,1,tab_stops
	invoke SendMessage,[hTran],EM_SETTABSTOPS,1,tab_stops
    invoke CheckMenuItem,[hMenu],IDM_TEXTWRAP,MF_CHECKED
;-----------------------------------------------------------------------
	invoke CreateWindowEx,0,_zclass,0,ZOOM_STYLE,0,0,0,0,\
	                       [hWnd],0,[wc.hInstance],NULL
	or	eax,eax
	jz	.failed
    mov [hZoom],eax	                       
    invoke CreateFont,72,0,0,0,0,0,0,0,\
	   DEFAULT_CHARSET,OUT_RASTER_PRECIS,CLIP_DEFAULT_PRECIS,\
	   DEFAULT_QUALITY,FF_DONTCARE,fontname
	or	eax,eax
	jz	.failed
	mov	[hFontB],eax
;-----------------------------------------------------------------------
    invoke CreateThread,0,2048*2048,ini_load,_ini,0,0
;-----------------------------------------------------------------------
.ok:
	xor	eax,eax
	ret
.failed:
	or	eax,-1
	ret
;-----------------------------------------------------------------------
.wm_destroy:
	invoke	DeleteObject,[hFont]
	invoke	DeleteObject,[hFontB]
	invoke	PostQuitMessage,0
	xor	eax,eax
	ret
;-----------------------------------------------------------------------
.wm_size:
	invoke ShowWindow,[hZoom],SW_HIDE
    invoke MoveWindow,[hStatus],0,0,0,0,TRUE
    invoke GetWindowRect,[hStatus],rc
    mov eax,[rc.top]
    sub eax,[rc.bottom]
    push eax
	invoke GetClientRect,[hWnd],rc
	pop eax
    add eax,[rc.bottom]
    cmp [tran],0
    mov [rc.bottom],eax
    je  @F
    mov ecx,3
    xor edx,edx
    div ecx
    jmp .put_height
@@:
    shr eax,1
.put_height:
    mov [rc.bottom],eax    
	invoke MoveWindow,[hText],0,[rc.bottom],[rc.right],[rc.bottom],TRUE
    push [rc.right]
    cmp [list],0
    je  @F
    mov eax,[rc.right]
    shr eax,1
    mov ecx,eax
    shr eax,1
    add ecx,eax
    mov [rc.right],ecx
    invoke MoveWindow,[hList],ecx,0,eax,[rc.bottom],TRUE
@@:
	invoke MoveWindow,[hDict],0,0,[rc.right],[rc.bottom],TRUE
    pop [rc.right]    
    mov ecx,[rc.bottom]
    add ecx,ecx
	invoke MoveWindow,[hTran],0,ecx,[rc.right],[rc.bottom],TRUE
	xor	eax,eax
	ret
;-----------------------------------------------------------------------
.wm_setfocus:
	invoke	SetFocus,[hLast]
	xor	eax,eax
	ret
;-----------------------------------------------------------------------
.en_setfocus:
    mov ecx,[lParam]
	mov [hLast],ecx
	cmp word [wParam + 2],EN_VSCROLL
	je  @F
	cmp word [wParam + 2],EN_HSCROLL
	jne .ok
@@:	
	invoke ShowWindow,[hZoom],SW_HIDE
	ret
;-----------------------------------------------------------------------
.wm_command:
    cmp [cmd_block],0
    jne .ok
	movzx eax,word [wParam]
	CASE eax,\
    PM_GETDICT,     .pm_getdict,    \
    PM_SHOWLIST,    .winl,          \
    PM_SHOWTRAN,    .wintr,         \
    IDM_FSEL,       .fsel,          \
    IDM_SLCTALL,    .slctall,       \
    IDW_EDIT,       .en_setfocus,   \
    IDW_LIST,       .var_list,      \
    IDM_TSHOW,      .tshow,         \
    IDM_TNEW,       .tnew,          \
    IDM_TOPEN,      .topen,         \
    IDM_TSAVE,      .tsave,         \
    IDM_TAPND,      .tapnd,         \
    IDM_LSHOW,      .lshow,         \
    IDM_XLOAD,      .xload,         \
    IDM_XFREE,      .xfree,         \
    IDM_DLOAD,      .dload,         \
    IDM_INFO,       .info,          \
    IDM_DFREE,      .dfree,         \
    IDM_VARS,       .vars,          \
    IDM_DWRAP,      .dwrap,         \
    IDM_REIDX,      .reidx,         \
    IDM_ZOOM,       .zoom,          \
    IDM_NEW,        .new,           \
    IDM_OPEN,       .open,          \
    IDM_TEXTWRAP,   .twrap,         \
    IDM_SAVEAS,     .saveas,        \
    IDM_TAGS,       .tags,          \
    IDM_SERV1,      .serv1,         \
    IDM_SERV2,      .serv2,         \
    IDM_SERV3,      .serv3,         \
    IDM_ABOUT,      .about,         \
    IDM_WWW,        .www,           \
    IDM_WIND,       .wind,          \
    IDM_WINTX,      .wintx,         \
    IDM_WINTR,      .wintr,         \
    IDM_WINL,       .winl,          \
    IDM_TEST,       .wtest,         \
    IDM_XSPACES,    .xspaces,       \
    IDM_EXIT,       .wm_destroy
;-----------------------------------------------------------------------
    cmp eax,IDM_FORMAT
    jb  .ok
    cmp eax,IDL_M9
    ja  .ok
    call format_text
    ret
;-----------------------------------------------------------------------
.wind:
    invoke SetFocus,[hDict]
    ret
;-----------------------------------------------------------------------
.slctall:
    invoke SendMessage,[hLast],EM_SETSEL,0,-1
    ret
;-----------------------------------------------------------------------
.wintx:
    invoke SetFocus,[hText]
    ret
;-----------------------------------------------------------------------
.xspaces:
    xor eax,eax
    cmp [ignore_spaces],0
    mov ecx,MF_UNCHECKED
    jne @F
    inc eax
    mov ecx,MF_CHECKED
@@:   
    mov [ignore_spaces],eax 
    invoke CheckMenuItem,[hMenu],IDM_XSPACES,ecx
    ret
;-----------------------------------------------------------------------
.wintr:
    cmp [tran],0
    jne @F
    mov [tran],1
    invoke ShowWindow,[hTran],SW_SHOW
    invoke SendMessage,[hMain],WM_SIZE,0,0
    invoke CheckMenuItem,[hMenu],IDM_TSHOW,MF_CHECKED
@@:
    invoke SetFocus,[hTran]
    ret
;-----------------------------------------------------------------------
.winl:
    cmp [list],0
    jne @F
    mov [list],1
    invoke ShowWindow,[hList],SW_SHOW
    invoke SendMessage,[hMain],WM_SIZE,0,0
    invoke CheckMenuItem,[hMenu],IDM_LSHOW,MF_CHECKED
@@:
    invoke SetFocus,[hList]
    ret
;-----------------------------------------------------------------------
.var_list:
    cmp word [wParam + 2],LBN_SELCHANGE
    jne .ok
    cmp [list_handler],0
    je  .ok
    invoke SendMessage,[lParam],LB_GETCURSEL,0,0
    cmp eax,LB_ERR
    je  .ok
    call [list_handler]
    ret
;-----------------------------------------------------------------------
.tshow:
    mov ecx,MF_CHECKED   or MF_BYCOMMAND
    mov edx,MF_UNCHECKED or MF_BYCOMMAND
    xor [tran],1
    cmovz ecx,edx 
    push ecx
    push eax
    mov eax,SW_SHOW
    mov edx,SW_HIDE
    cmovz eax,edx
    invoke ShowWindow,[hTran],eax
    invoke CheckMenuItem,[hMenu]
    invoke SendMessage,[hMain],WM_SIZE,0,0
    ret
;-----------------------------------------------------------------------
.lshow:
    mov ecx,MF_CHECKED   or MF_BYCOMMAND
    mov edx,MF_UNCHECKED or MF_BYCOMMAND
    xor [list],1
    cmovz ecx,edx 
    push ecx
    push eax
    mov eax,[hList]
    mov edx,[hLast]
    cmovz eax,edx
    push eax
    mov eax,SW_SHOW
    mov edx,SW_HIDE
    cmovz eax,edx
    invoke ShowWindow,[hList],eax
    invoke SetFocus
    invoke CheckMenuItem,[hMenu]
    invoke SendMessage,[hMain],WM_SIZE,0,0
    ret
;-----------------------------------------------------------------------
.tags:
    mov ecx,MF_CHECKED   or MF_BYCOMMAND
    mov edx,MF_UNCHECKED or MF_BYCOMMAND
    xor [tags],1
    cmovz ecx,edx 
    invoke CheckMenuItem,[hMenu],eax,ecx
    ret
;-----------------------------------------------------------------------
.pm_getdict:
    stdcall dict_menu,[lParam]
    ret    
;-----------------------------------------------------------------------
.reidx:
    invoke SetWindowText,[hStatus],reindex
    stdcall dict_menu,1
    or  eax,eax
    js  @F
    invoke CreateThread,0,2048*2048,dict_reidx,eax,0,0
@@:
    invoke SetWindowText,[hStatus],0
    ret
;-----------------------------------------------------------------------
.new:
    invoke SendMessage,[hText],WM_SETTEXT,0,0
    ret
;-----------------------------------------------------------------------
.tnew:
    invoke SendMessage,[hTran],WM_SETTEXT,0,0
    ret
;-----------------------------------------------------------------------
.tsave:
    cmp [tran],0
    je  .ok
    mov [of + OPENFILENAME.lpstrTitle],so_text
    push [hTran]
    jmp @F
.saveas:
    mov [of + OPENFILENAME.lpstrTitle],s_text
    push [hText]
@@:
    mov dword [a_buff],0
    mov [of + OPENFILENAME.Flags],OFN_HIDEREADONLY
    mov [of + OPENFILENAME.lpstrFile],a_buff
    mov [of + OPENFILENAME.lpstrFilter],f_text
    mov [of + OPENFILENAME.lpstrInitialDir],f_dir
    invoke GetSaveFileName,of
    test eax,eax
    pop eax
    jz  .ok
    stdcall SaveEdit,eax,a_buff
    test eax,eax
    jnz  @F
    invoke PathRemoveFileSpec,a_buff
    invoke lstrcpy,f_dir,a_buff
    ret
@@:
    invoke MessageBox,[hWnd],error.savefile,a_buff,0
    ret
;-----------------------------------------------------------------------
.tapnd:
    cmp [tran],0
    je  .ok
    mov [of + OPENFILENAME.lpstrTitle],ao_text
    mov [of + OPENFILENAME.lpstrFilter],f_text_dsl
    push [hTran]
    mov dword [a_buff],0
    mov [of + OPENFILENAME.Flags],OFN_HIDEREADONLY
    mov [of + OPENFILENAME.lpstrFile],a_buff
    mov [of + OPENFILENAME.lpstrInitialDir],f_dir
    invoke GetSaveFileName,of
    test eax,eax
    pop eax
    jz  .ok
    stdcall AppendToFile,eax,a_buff
    test eax,eax
    jnz  @F
    invoke PathFindFileName,a_buff
    stdcall dict_by_name,eax
    or  eax,eax
    jz  .no_reidx
    push eax
    invoke MessageBox,[hMain],reidx_request,a_buff,\
                                            MB_ICONQUESTION or MB_YESNO
    cmp eax,IDYES
    pop edx
    jne .no_reidx
    invoke CreateThread,0,2048*2048,dict_reidx,edx,0,0
.no_reidx:    
    invoke PathRemoveFileSpec,a_buff
    invoke lstrcpy,f_dir,a_buff
    ret
@@:
    invoke MessageBox,[hWnd],error.appendfile,a_buff,0
    ret
;-----------------------------------------------------------------------
.topen:
    cmp [tran],0
    je  .ok
    mov [of + OPENFILENAME.lpstrTitle],to_text
    push [hTran]
    jmp @F
.open:
    mov [of + OPENFILENAME.lpstrTitle],o_text
    push [hText]
@@:
    mov dword [a_buff],0
    mov [of + OPENFILENAME.Flags],OFN_FILEMUSTEXIST or OFN_HIDEREADONLY
    mov [of + OPENFILENAME.lpstrFile],a_buff
    mov [of + OPENFILENAME.lpstrFilter],f_text
    mov [of + OPENFILENAME.lpstrInitialDir],f_dir
    invoke GetOpenFileName,of
    test eax,eax
    pop eax
    jz  .ok
    stdcall LoadEdit,eax,a_buff
    test eax,eax
    jz  @F
    invoke MessageBox,[hWnd],error.openfile,a_buff,0
    ret
@@:
    invoke PathRemoveFileSpec,a_buff
    invoke lstrcpy,f_dir,a_buff
    ret
;-----------------------------------------------------------------------
.info:
    cmp dword [a_dict],0
    je  .info_err
    push esi
    push edi
    invoke SetWindowText,[hDict],0
    mov esi,a_dict
@@:
    mov edi,[esi]
    add edi,DICT.ndsl
    invoke SendMessage,[hDict],EM_REPLACESEL,0,edi
    invoke SendMessage,[hDict],EM_REPLACESEL,0,crlf
    stdcall put_info,[esi]
    add esi,4
    cmp dword [esi],0
    jne @B
    pop edi
    pop esi
    ret
.info_err:
    invoke SetWindowText,[hDict],error.dict_empty
    ret     
;-----------------------------------------------------------------------
.vars:
    call GetVariants
    ret
;-----------------------------------------------------------------------
.fsel:
    call GetSelVariants
    ret
;-----------------------------------------------------------------------
.serv3:
    invoke MessageBox,[hMain],dict2tran,areyousure,\
                                                MB_ICONQUESTION+MB_YESNO
    cmp eax,IDYES
    jne .ok
    invoke SendMessage,[hDict],EM_GETHANDLE,0,0
    or  eax,eax
    jz  .ok  
    invoke LocalLock,eax
    or  eax,eax
    jz  .ok
    push eax
    invoke SetWindowText,[hTran],eax
    invoke LocalUnlock
    jmp .wintr
;-----------------------------------------------------------------------
.serv1:
    call RunUserFromList
    ret
;-----------------------------------------------------------------------
.serv2:
    mov [of + OPENFILENAME.lpstrTitle],o_user
    mov dword [a_buff],0
    mov [of + OPENFILENAME.Flags],OFN_FILEMUSTEXIST or OFN_HIDEREADONLY
    mov [of + OPENFILENAME.lpstrFile],a_buff
    mov [of + OPENFILENAME.lpstrFilter],f_user
    mov [of + OPENFILENAME.lpstrInitialDir],f_dir
    invoke GetOpenFileName,of
    test eax,eax
    pop eax
    jz  .ok
    stdcall RunUserFunction,a_buff
    ret
;-----------------------------------------------------------------------
.dload:
    mov [of + OPENFILENAME.lpstrTitle],o_dict
    mov dword [a_buff],0
    mov [of + OPENFILENAME.Flags],OFN_FILEMUSTEXIST or OFN_HIDEREADONLY
    mov [of + OPENFILENAME.lpstrFile],a_buff
    mov [of + OPENFILENAME.lpstrFilter],f_dict
    mov [of + OPENFILENAME.lpstrInitialDir],f_dir
    invoke GetOpenFileName,of
    test eax,eax
    pop eax
    jz  .ok
    invoke CreateThread,0,2048*2048,dict_open,a_buff,0,0
    ret
;-----------------------------------------------------------------------
.dfree:
    invoke SetWindowText,[hStatus],dict_unload
    stdcall dict_menu,1
    or  eax,eax
    js  @F
    jz  .dfree_all
    stdcall dict_remove,eax
    jmp @F
.dfree_all:
    stdcall dict_remove,a_dict
    or  eax,eax
    jnz .dfree_all    
@@:
    invoke SetWindowText,[hStatus],0
    ret
;-----------------------------------------------------------------------
.zoom:
    invoke IsWindowVisible,[hZoom]
    test eax,eax
    jz  @F
    invoke ShowWindow,[hZoom],SW_HIDE
    ret
@@:    
    push edi
    push esi
    mov  edi,[hLast]
    invoke SendMessage,edi,EM_GETSEL,rc.top,0
    invoke SendMessage,edi,EM_GETHANDLE,0,0
    invoke LocalLock,eax
    mov edx,[rc.top]
    mov esi,[eax + edx*2]
    invoke LocalUnlock,eax
    mov eax,esi
    cmp ax,BOM
    jne @F
    shr eax,16
@@:
    movzx eax,ax    
    mov [zoom_t],eax
    mov esi,[hZoom]
    invoke SetParent,esi,edi
    invoke SendMessage,edi,EM_POSFROMCHAR,[rc.top],0
    movzx edx,ax
    shr eax,16
    cmp eax,110
    jb  @F
    sub eax,80
@@:   
    cmp edx,110
    jb  @F
    sub edx,80
@@:     
    invoke MoveWindow,esi,edx,eax,80,80,FALSE
    invoke ShowWindow,esi,SW_SHOW
    invoke SetFocus,esi
    mov edi,a_buff
    UCSAddHex [zoom_t]
    UCSAddChar "h"," ","/"," "
    UCSAddDec [zoom_t]
    UCSEnd
    invoke SetWindowText,[hStatus],a_buff
    pop esi
    pop edi
    ret
;-----------------------------------------------------------------------
.dwrap:
    push edi
    push esi
    mov edi,hDict
    mov esi,IDM_DWRAP
    xor [dwrap],1
    jmp @F
.twrap:
    push edi
    push esi
    mov edi,hText
    mov esi,IDM_TEXTWRAP
    xor [wrap],1
@@:
    mov eax,EDIT_STYLE
    mov ecx,WRAP_STYLE
    mov edx,MF_UNCHECKED
    jz  @F
    mov eax,ecx
    mov edx,MF_CHECKED
@@:    
    push edx
    mov ecx,[edi]
    cmp ecx,[hLast]
    pushf
    stdcall ChangeEdit,ecx,eax
    popf
    mov [edi],eax
    jne @F
    mov [hLast],eax
@@:    
	invoke SendMessage,eax,WM_SETFONT,[hFont],FALSE
    invoke CheckMenuItem,[hMenu],esi
    invoke SendMessage,[hMain],WM_SIZE,0,0
    pop esi
    pop edi
    ret
;-----------------------------------------------------------------------
.about:
    invoke MessageBox,[hWnd],_about_text,_about_title,MB_OK
    ret
;-----------------------------------------------------------------------
.www:
    invoke ShellExecute,0,open,www,0,0,SW_SHOWDEFAULT
    ret
;-----------------------------------------------------------------------
.xload:
    mov [of + OPENFILENAME.lpstrTitle],o_xchar
    mov dword [a_buff],0
    mov [of + OPENFILENAME.Flags],OFN_FILEMUSTEXIST or OFN_HIDEREADONLY
    mov [of + OPENFILENAME.lpstrFile],a_buff
    mov [of + OPENFILENAME.lpstrFilter],f_text
    mov [of + OPENFILENAME.lpstrInitialDir],f_dir
    invoke GetOpenFileName,of
    test eax,eax
    pop eax
    jz  .ok
    stdcall xchar_add_file,a_buff
    ret    
;-----------------------------------------------------------------------
.xfree:
    call xchar_reset
    ret    
;-----------------------------------------------------------------------
.wtest:

    ret    
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc ZoomProc hWnd,uMsg,wParam,lParam
;-----------------------------------------------------------------------
    local hDC dd ?    
    local zrc RECT
    local zpt PAINTSTRUCT
;-----------------------------------------------------------------------
    mov eax,[uMsg]
	CASE eax,\
	WM_LBUTTONDOWN,.wm_killfocus,  \
	WM_KILLFOCUS,  .wm_killfocus,  \
	WM_PAINT,      .wm_paint
;-----------------------------------------------------------------------
.defwndproc:
	leave
	jmp [DefWindowProc]
;-----------------------------------------------------------------------
.wm_killfocus:
    invoke ShowWindow,[hWnd],SW_HIDE
    xor eax,eax
    ret
;-----------------------------------------------------------------------
.wm_paint:
    lea ecx,[zpt]
    invoke BeginPaint,[hWnd],ecx
    or  eax,eax
    jz  @F  
    mov [hDC],eax
    invoke SelectObject,eax,[hFontB]
    lea ecx,[zrc]
    invoke GetClientRect,[hWnd],ecx
    lea ecx,[zrc]
    invoke DrawText,[hDC],zoom_t,-1,ecx,\
                                DT_SINGLELINE or DT_CENTER or DT_VCENTER
    lea ecx,[zpt]
    invoke EndPaint,[hWnd],ecx
@@:
    xor eax,eax
    ret  	
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
include 'index.inc'
include 'avl.inc'
include "general.inc"
include "parser.inc"
include "files.inc"
include "text.inc"
include "variants.inc"
include "dict.inc"
include "setup.inc"
include "service.inc"
include "format.inc"
include "xchar.inc"
;=======================================================================
;
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
section '.idata' import data readable 
;-----------------------------------------------------------------------
    include "idata.inc"     ;*
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
section '.rsrc' resource data readable
;-----------------------------------------------------------------------
    include "resources.inc" ;*
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
section '.data' data readable writeable
;-----------------------------------------------------------------------
    include "data.inc"
;=======================================================================
