;=======================================================================
proc xchar_reset
;-----------------------------------------------------------------------
    mov ecx,[xchar_c]
    mov [xchar_c],0
    add [xchar_f],ecx
    ret
;-----------------------------------------------------------------------
endp    
;=======================================================================
;
;=======================================================================
proc xchar_add _file
;-----------------------------------------------------------------------
    local _result: dd ?    
;-----------------------------------------------------------------------
    push esi
    push edi
    push ebx
    mov [_result],0
    cmp [xchar_f],0
    je  .done
;-----------------------------------------------------------------------
    invoke CreateFile,[_file],GENERIC_READ,FILE_SHARE_READ,0,\
                              OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0
    cmp eax,INVALID_HANDLE_VALUE
    mov [_file],eax
    je  .done
    mov edi,xchar_l
    add edi,[xchar_c]
    add edi,[xchar_c]
;-----------------------------------------------------------------------
.next_line:
    stdcall GetLineX,[_file],a_buff,1024
    or  eax,eax
    jz  .done_close
    mov esi,a_buff
    mov dx,[esi]
    or  dx,dx
    je  .next_line
    add esi,2
;-----------------------------------------------------------------------
.next_char:
    lodsw
    or  ax,ax
    jz  .next_line
    cmp ax,9
    jz  .next_char
    cmp ax,32
    jz  .next_char
    mov [edi - xchar_l + xchar_d],dx
    stosw
    inc [_result]
    inc [xchar_c]
    dec [xchar_f]
    jnz .next_char
;-----------------------------------------------------------------------
.done_close:
    invoke CloseHandle,[_file]    
;-----------------------------------------------------------------------
.done:    
    mov eax,[_result]
    pop ebx
    pop edi
    pop esi
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc xchar_add_file _file
;-----------------------------------------------------------------------
    invoke EnableWindow,[hDict],FALSE
    invoke SendMessage,[hDict],WM_ENABLE,TRUE,0
    invoke SetWindowText,[hDict],0
    stdcall xchar_add_v,[_file]
    invoke EnableWindow,[hDict],TRUE
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc xchar_add_v _file
;-----------------------------------------------------------------------
    invoke SendMessage,[hDict],EM_REPLACESEL,0,xchar_m
    invoke PathFindFileName,[_file]
    invoke SendMessage,[hDict],EM_REPLACESEL,0,eax
    stdcall xchar_add,[_file]
    push edi
    push esi
    mov edi,a_buff
    UCSAdd xchar_m.found
    UCSAddDec
    UCSAdd xchar_m.total
    UCSAddDec [xchar_c]
    UCSAddCR
    UCSEnd
    pop esi
    pop edi
    invoke SendMessage,[hDict],EM_REPLACESEL,0,a_buff
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
    