;=======================================================================
;   Combined string v 3.2 
;=======================================================================
macro CSNew _size { ;      
;-----------------------------------------------------------------------
    push edi        ;  
    push esi
    mov esi,esp     ;  
    sub esp,_size
    mov edi,esp     ;  
    push esi        ;  -   
;-----------------------------------------------------------------------
}
;=======================================================================
macro CSBuff _reg, _disp { ;     
;-----------------------------------------------------------------------
  if _disp eq  
    lea _reg,[esp + 4]
  else
    lea _reg,[esp + 4 + _disp*4]
  end if
;-----------------------------------------------------------------------
}
;=======================================================================
macro CSEnd {       ;      
;-----------------------------------------------------------------------
    mov byte [edi],0
;-----------------------------------------------------------------------
}
;=======================================================================
macro CSFree {      ;     
;-----------------------------------------------------------------------
    pop esp
    pop esi
    pop edi
;-----------------------------------------------------------------------
}    
;=======================================================================
macro CSAdd [_str] { ;       ()
;-----------------------------------------------------------------------
    local ..more
;-----------------------------------------------------------------------
    if ~(_str eq)
        mov esi,_str
    end if
..more:
    cmp byte [esi],0
    movsb
    jne ..more
    dec edi
;-----------------------------------------------------------------------
}
;=======================================================================
macro CSAddQS _str { ; eg. PathQuoteSpaces
;-----------------------------------------------------------------------
    if ~(_str eq)
        mov esi,_str
    end if
;-----------------------------------------------------------------------
    call add_qs
;-----------------------------------------------------------------------
}
;=======================================================================
macro CSQuoteSpaces _start { ; eg. PathQuoteSpaces
;-----------------------------------------------------------------------
    if ~(_start eq)
        mov edx,_start
    end if
;-----------------------------------------------------------------------
    call edx_edi_qs
;-----------------------------------------------------------------------
}
;=======================================================================
macro CSAddChar [_char] { ;      ()
;-----------------------------------------------------------------------
    mov byte [edi],_char
    inc edi
;-----------------------------------------------------------------------
}
;=======================================================================
macro CSAddCR { ;        
;-----------------------------------------------------------------------
    mov byte [edi],13
    inc edi
    mov byte [edi],10
    inc edi
;-----------------------------------------------------------------------
}
;=======================================================================
macro CSAddDec _param {  ;       
                         ;   (  ) 
;-----------------------------------------------------------------------
    local ..next
;-----------------------------------------------------------------------
    if ~(_param eq)
      mov eax,_param
    end if
;-----------------------------------------------------------------------
    call eax_edi_dec
;-----------------------------------------------------------------------
}
;=======================================================================
macro CSAddHex _param {  ;       
                         ;    (  ) 
;-----------------------------------------------------------------------
    local ..next,..dcm
;-----------------------------------------------------------------------
    if ~(_param eq)
      mov eax,_param
    end if
;-----------------------------------------------------------------------
    call eax_edi_hex
;-----------------------------------------------------------------------
}
;=======================================================================
macro CSAddHexB _param {
;-----------------------------------------------------------------------
    if ~(_param eq)
      mov eax,_param
    end if
;-----------------------------------------------------------------------
    call eax_edi_byte
;-----------------------------------------------------------------------
}
;=======================================================================
macro CSAddHexW _param {
;-----------------------------------------------------------------------
    if ~(_param eq)
      mov eax,_param
    end if
;-----------------------------------------------------------------------
    mov cl,al
    mov al,ah
    call eax_edi_byte
    mov al,cl
    call eax_edi_byte
;-----------------------------------------------------------------------
}
;=======================================================================
macro CSAddDD _param {   ;         
                         ;   / (  ) 
;-----------------------------------------------------------------------
    local ..next,..dcm
;-----------------------------------------------------------------------
    if ~(_param eq)
      mov eax,_param
    end if
;-----------------------------------------------------------------------
    call dw2hex
;-----------------------------------------------------------------------
}
;=======================================================================
macro CSAddSign _param { ;     -  ,
                         ;   ,     "-"
;-----------------------------------------------------------------------
    local ..next
;-----------------------------------------------------------------------
    if ~(_param eq)
      mov eax,_param
    end if
;-----------------------------------------------------------------------
    cmp eax,0
    jns ..next
    neg eax
    mov byte [edi],"-"
    inc edi
..next:
;-----------------------------------------------------------------------
}
;=======================================================================
macro CSAddSignX _param { ;     ("+"  "-")
                          ;  "-" -  
;-----------------------------------------------------------------------
    local ..next
;-----------------------------------------------------------------------
    if ~(_param eq)
      mov eax,_param
    end if
;-----------------------------------------------------------------------
    mov cl,"+"
    cmp eax,0
    jns ..next
    neg eax
    mov cl,"-"
..next:
    mov [edi],cl
    inc edi
;-----------------------------------------------------------------------
}
;=======================================================================
macro CSLMessage _hWnd {    ;    :)
                            ;     
;-----------------------------------------------------------------------
    CSEnd
    lea ecx,[esp + 4]
if _hWnd eq    
    invoke MessageBox,0,ecx,0,0
else
    invoke MessageBox,_hWnd,ecx,0,0
end if    
    CSFree
;-----------------------------------------------------------------------
}
;=======================================================================
macro CSLoad _addr  { ;  
;-----------------------------------------------------------------------
    push edi
    push esi
    mov  edi,_addr
;-----------------------------------------------------------------------
}
;=======================================================================
macro CSRestore     { ;  
;-----------------------------------------------------------------------
    pop esi
    pop edi
;-----------------------------------------------------------------------
}        
;=======================================================================
;
;=======================================================================
macro CSSupport { ;  -    
;-----------------------------------------------------------------------
if ~ defined CSSupportUsed
             CSSupportUsed equ 1
;-----------------------------------------------------------------------
proc eax_edi_dec ;    CSAddDec
;-----------------------------------------------------------------------
    mov esi,esp
    sub esp,16
    xor ecx,ecx
.next:
    dec esi
    xor edx,edx
    div dword [CSTen]
    add dl,"0"
    mov [esi],dl
    inc ecx
    test eax,eax
    jnz .next
    rep movsb
    add esp,16
;-----------------------------------------------------------------------
    ret
;-----------------------------------------------------------------------
endp    
;=======================================================================
proc eax_edi_hex ;    CSAddHex
;-----------------------------------------------------------------------
    mov esi,esp
    sub esp,16
    xor ecx,ecx
    xor edx,edx
.next:
    dec esi
    mov dl,al
    and dl,15
    cmp dl,9
    jbe .dcm
    add dl,7
.dcm:    
    add dl,"0"
    mov [esi],dl
    inc ecx
    shr eax,4
    jnz .next
    rep movsb
    add esp,16
;-----------------------------------------------------------------------
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
proc eax_edi_byte ;    CSAddHexB
;-----------------------------------------------------------------------
    mov ah,al
    shr al,4
    and ax,0F0Fh
    cmp al,9
    jbe .l
    add al,7
.l:
    cmp ah,9
    jbe .h
    add ah,7
.h:
    add ax,"00"
    stosw        
;-----------------------------------------------------------------------
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
proc add_qs
;-----------------------------------------------------------------------
    xor ecx,ecx
    mov edx,esi
.next:
    cmp byte [esi]," "
    je  .quot
    cmp byte [esi],0
    je  .copy
    inc esi
    jmp .next
;-----------------------------------------------------------------------
.quot:
    inc ecx
    mov byte [edi],'"'
    inc edi
.copy:
    mov esi,edx    
;-----------------------------------------------------------------------
.more:
    cmp byte [esi],0
    movsb
    jne .more
    dec edi
;-----------------------------------------------------------------------
    mov byte [edi],'"'
    jecxz .done   
    inc edi
.done:
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
proc edx_edi_qs
;-----------------------------------------------------------------------
    cmp edi,edx
    je  .done
    std
    mov esi,edi
    mov al,20h
    mov ecx,edi
    sub ecx,edx
    dec edi
    mov edx,ecx
    repne scasb
    mov edi,esi
    jne .done
    mov ecx,edx
    mov edx,esi
    dec esi
    rep movsb
    mov byte [edi],'"'
    lea edi, [edx + 1]
    mov byte [edi],'"'
    inc edi
.done:
    cld
    ret    
;-----------------------------------------------------------------------
endp
;=======================================================================
CSTen:        dd 10 ;   CSAddDec
;=======================================================================
proc NumToDec num,pstr,sign
;-----------------------------------------------------------------------
    CSLoad [pstr]
    mov eax,[num]
    cmp [sign],0
    je  @F
    CSAddSign
@@:
    CSAddDec
    CSEnd
    CSRestore
    ret    
;-----------------------------------------------------------------------
endp
;=======================================================================
proc dw2hex;(eax - num, edi - str) -- by Black_mirror
;-----------------------------------------------------------------------
    mov esi,ebx
;-----------------------------------------------------------------------
    mov ebx,eax                    ;87654321
    rol eax,4                      ;76543218
    rol ebx,8                      ;65432187
    and eax,$0F0F0F0F              ; 6 4 2 8
    and ebx,$0F0F0F0F              ; 5 3 1 7
    lea ecx,[eax+76767676h]        ;0-9 -> 76-7F
    lea edx,[ebx+76767676h]        ;A-F -> 80-85 
    and ecx,90909090h              ;0-9 -> 10
    and edx,90909090h              ;A-F -> 80
    shr ecx,4                      ;0-9 -> 01
    shr edx,4                      ;A-F -> 08
    lea eax,[eax+ecx+2F2F2F2Fh]    ;0-9 -> 30-39
    lea ebx,[ebx+edx+2F2F2F2Fh]    ;A-F -> 41-46
    ror ax,8                       ; 6 4 8 2
    ror bx,8                       ; 5 3 7 1
    ror eax,8                      ; 2 6 4 8
    mov ecx,$FF00FF00
    mov edx,$00FF00FF
    and ecx,eax                    ; 2   4
    and edx,ebx                    ;   3   1
    xor eax,ecx                    ;   6   8
    xor ebx,edx                    ; 5   7
    or  edx,ecx                    ; 2 3 4 1
    or  eax,ebx                    ; 5 6 7 8
    ror edx,8                      ; 1 2 3 4
    mov [edi],eax
    mov [edi+4],edx
    add edi,8
;-----------------------------------------------------------------------
    mov ebx,esi
    ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
end if
}
;=======================================================================
                




                       