;=======================================================================
format PE CONSOLE           
;=======================================================================
include 'win32a.inc'    ;*
include "combstr.inc"   ; some handy stuff 
;-----------------------------------------------------------------------
MAX_PARAMS = 2
MIN_PARAMS = 2
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
section '.code' code readable executable
;-----------------------------------------------------------------------
entry $
;-----------------------------------------------------------------------
    invoke GetStdHandle,STD_OUTPUT_HANDLE
    mov [con],eax
;-----------------------------------------------------------------------
    invoke GetCommandLine
    stdcall GetParameter,eax        ; skip exe name
.next_param:
    stdcall GetParameter,edx        ; get first parameter
    jnz @F                          ; optimized checking
    mov edx,err0
    jmp error                       ; empty commandline - help screen
@@:
    cmp byte [eax],"-"
    jne .no_switch
    inc eax
    stdcall h2i,eax
    mov [address],eax
    jmp .next_param
.no_switch:
    mov [iname],eax
    cmp byte [edx],0
    mov byte [edx],0
    je  cmderror                    ; no more parameters - error
    inc edx
    stdcall GetParameter,edx        ; get second parameter
    jz  cmderror                    ; no  second parameter - error
    mov [oname],eax
    cmp byte [edx],0
    mov byte [edx],0
    jne @F
    stdcall GetParameter,edx        ; get extra parameter
    jnz cmderror                    ; has some extra parameters - error
@@:    
;-----------------------------------------------------------------------
;   Opening filenames
;-----------------------------------------------------------------------
    invoke PathUnquoteSpaces,[iname]
    invoke PathUnquoteSpaces,[oname]
;-----------------------------------------------------------------------
    invoke CreateFile,[iname],GENERIC_READ,FILE_SHARE_READ,0,\
                              OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0
    cmp eax,[ihand]
    mov edx,err2
    je  error
    mov [ihand],eax    
;-----------------------------------------------------------------------
    invoke CreateFile,[oname],GENERIC_WRITE,0,0,\
                              CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,0
    cmp eax,[ohand]
    mov edx,err3
    je  error
    mov [ohand],eax    
;-----------------------------------------------------------------------
;   Reading
;-----------------------------------------------------------------------
next:
    xor eax,eax
    mov dword [ibuff + 12],eax
    mov dword [ibuff +  8],eax
    mov dword [ibuff +  4],eax
    mov dword [ibuff     ],eax
    invoke ReadFile,[ihand],ibuff,16,cnt,0
    cmp [cnt],0
    je  done
;-----------------------------------------------------------------------
;   Processing
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    mov ebx,ibuff-1
    mov edi,obuff
    CSAddHexW [address]
    CSAddChar 20h
.next_byte:
    inc ebx
    mov al,[ebx]
    CSAddHexB
    CSAddChar 20h
    cmp ebx,ibuff+15
    jb  .next_byte
    mov dword [edi],"--- "
    add edi,4
    mov edx,ibuff
    mov ecx,ebx
    call ks
    CSAddHexW
    CSAddCR    
    add [address],16
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;   Writing
;-----------------------------------------------------------------------
    sub edi,obuff
    invoke WriteFile,[ohand],obuff,edi,cnt,0
    cmp [cnt],edi
    je  next    
    mov edx,err3
    jmp error           ; error writing to file
;-----------------------------------------------------------------------
cmderror:               ; error in commandline
    mov edx,err1    
;-----------------------------------------------------------------------
error:                  ; in edx - pointer to error message
    push 0
    push cnt
    push edx
    invoke lstrlen,edx
    pop  edx
    push eax
    push edx
    invoke GetStdHandle,STD_ERROR_HANDLE
    invoke WriteFile,eax
    mov [cnt],1
;-----------------------------------------------------------------------
done:
    cmp [ihand],INVALID_HANDLE_VALUE
    je  @F
    invoke CloseHandle,[ihand]
@@:
    cmp [ohand],INVALID_HANDLE_VALUE
    je  @F
    invoke CloseHandle,[ohand]
@@:
    invoke ExitProcess,[cnt]
;-----------------------------------------------------------------------
    CSSupport
;-----------------------------------------------------------------------
include "cmdparse.inc" 
include "a2i.inc"
include "ks.inc"
include "h2i.inc"
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
section '.data' data readable writeable
err1    db 13,10,"Error in the commandline"
err0    db 13,10,"Usage: dump_ks [-ADDR] <bin_file> <txt_file>"
        db 13,10,"ADDR example: -C800"
crlf    db 13,10,0
err2    db 13,10,"Error reading file",13,10,0
err3    db 13,10,"Error writing file",13,10,0
;-----------------------------------------------------------------------
        align 4
address dd 0
ihand   dd INVALID_HANDLE_VALUE
ohand   dd INVALID_HANDLE_VALUE
cnt     dd 0
con     dd ?
iname   dd ?
oname   dd ?
ibuff   rb 16
obuff   rb 256
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
include "idata.inc"
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
