;=======================================================================
proc h2i snum ; eax -> value, [edx] -> first not recognized symbol
;-----------------------------------------------------------------------
    push esi
;-----------------------------------------------------------------------
    mov esi,[snum]
    xor edx,edx
    xor eax,eax
;-----------------------------------------------------------------------
.leadtrim:
    lodsb
    cmp al," "
    je  .leadtrim
    cmp al,9
    je  .leadtrim
;-----------------------------------------------------------------------
.h2i_loop:
    or  al,al
    je  .h2i_ex
    cmp al,"A"
    jb  .h2i_digit
    and al,not 20h
    cmp al,"F"
    ja  .h2i_ex
    sub al,"A"-10
    jmp .h2i_valid
.h2i_digit:
    cmp al,"9"
    ja  .h2i_ex    
    sub al,"0"
    js  .h2i_ex
.h2i_valid:
    shl edx,4
    add dl,al
    lodsb
    jmp .h2i_loop   
.h2i_ex:
    mov eax,edx
    lea edx,[esi - 1]
;-----------------------------------------------------------------------
    pop esi
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
