;=======================================================================
format PE CONSOLE           
;=======================================================================
include 'win32a.inc'    ;*
include "combstr.inc"   ; some handy stuff 
include "wave_def.inc"  ;*
include "dr.inc"        ;*
;-----------------------------------------------------------------------
MAX_PARAMS = 2
MIN_PARAMS = 2
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
section '.code' code readable executable
;-----------------------------------------------------------------------
entry $
;-----------------------------------------------------------------------
    invoke GetCommandLine
    stdcall GetParameter,eax        ; skip exe name
next_param:
    stdcall GetParameter,edx        ; get first parameter
    jnz @F                          ; optimized checking
    mov edx,err0
    jmp error                       ; empty commandline - help screen
@@:
;-----------------------------------------------------------------------
    cmp word [eax],"-x"
    jne @F
    mov byte [edx],0
    mov [no_head],1 
    inc edx
    jmp next_param
@@:    
    cmp word [eax],"-k"
    jne no_switch
    mov byte [edx],0
    mov [self_ks],1 
    inc edx
    jmp next_param
;-----------------------------------------------------------------------
no_switch:
    mov [iname],eax
    cmp byte [edx],0
    mov byte [edx],0
    je  cmderror                    ; no more parameters - error
    inc edx
    stdcall GetParameter,edx        ; get second parameter
    jz  cmderror                    ; no  second parameter - error
    mov [oname],eax
    cmp byte [edx],0
    mov byte [edx],0
    jne @F
    stdcall GetParameter,edx        ; get extra parameter
    jnz cmderror                    ; has some extra parameters - error
@@:    
;-----------------------------------------------------------------------
;   Opening filenames
;-----------------------------------------------------------------------
    invoke PathUnquoteSpaces,[iname]
    invoke PathUnquoteSpaces,[oname]
;-----------------------------------------------------------------------
    invoke CreateFile,[iname],GENERIC_READ,FILE_SHARE_READ,0,\
                              OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0
    cmp eax,[ihand]
    mov edx,err2
    je  error
    mov [ihand],eax    
;-----------------------------------------------------------------------
    invoke CreateFile,[oname],GENERIC_WRITE,0,0,\
                              CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,0
    cmp eax,[ohand]
    mov edx,err3
    je  error
    mov [ohand],eax    
;-----------------------------------------------------------------------
CHAR_SIZE equ 1             ; 1 - for byte, 2 - for word, 4 - for dword
;-----------------------------------------------------------------------
macro PUTBYTE [_byte] {
    mov al,_byte 
    call putbyte
    or  eax,eax
    mov edx,err3
    jnz error
}
;-----------------------------------------------------------------------
macro CHECK_WRITE {
    or  eax,eax
    mov edx,err3
    jnz error
}
;-----------------------------------------------------------------------
;   Reading
;-----------------------------------------------------------------------
    invoke GetFileSize,[ihand],0
    cmp eax,65536+16
    mov edx,err2
    ja  error
    mov [isize],eax
    invoke ReadFile,[ihand],ibuff,eax,cnt,0
    mov eax,[isize]
    cmp [cnt],eax
    mov edx,err2
    jne error
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;     wav-
;-----------------------------------------------------------------------
    invoke WriteFile,[ohand],header,header_size,cnt,0
    cmp [cnt],header_size
    mov edx,err3
    jne error           ; error writing to file
;-----------------------------------------------------------------------
;       
;-----------------------------------------------------------------------
    mov eax,255 ;   
    call pilot
    CHECK_WRITE
    PUTBYTE 0E6h ; 
;-----------------------------------------------------------------------
    cmp [no_head],0 ;  
    jne put_body
;-----------------------------------------------------------------------
    PUTBYTE 0D9h,0D9h,0D9h
    invoke PathFindFileName,[iname]
    mov edi,esi
    mov esi,eax
    invoke CharUpper,esi
@@:
    lodsb
    or  al,al
    jz @F
    call putbyte ;  
    CHECK_WRITE
    jmp @B
@@:
;-----------------------------------------------------------------------
;     
;-----------------------------------------------------------------------
    sub esi,edi
    mov eax,255+510
    cmp esi,32
    ja  @B
    sub eax,esi
@@:
    call pilot   ;  
    CHECK_WRITE
    PUTBYTE 0E6h ; 
;-----------------------------------------------------------------------
put_body:
    mov esi,ibuff
    mov edi,[isize]
    sub edi,2
@@:
    lodsb
    call putbyte ;   
    CHECK_WRITE
    dec edi
    jnz @B
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    cmp [self_ks],0
    je  @F
    mov ecx,[isize]
    mov edx,ibuff+4
    add ecx,ibuff-3
    call ks ;    
    jmp put_ks
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
@@:
    mov eax,ibuff-2
    add eax,[isize]
    movzx eax, word [eax] 
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
put_ks:    
    mov [chksum],eax
    push eax
    call putbyte ;  
    CHECK_WRITE
    pop eax
    mov al,ah
    call putbyte 
    CHECK_WRITE
;-----------------------------------------------------------------------
;      
;-----------------------------------------------------------------------
    invoke SetFilePointer,[ohand],0,0,FILE_CURRENT    
    mov [isize],eax
    invoke SetFilePointer,[ohand],4,0,FILE_BEGIN
    sub [isize],8
    invoke WriteFile,[ohand],isize,4,cnt,0
    cmp [cnt],4
    mov edx,err3
    jne error           
    invoke SetFilePointer,[ohand],header_size - 4,0,FILE_BEGIN
    sub [isize],header_size
    invoke WriteFile,[ohand],isize,4,cnt,0
    cmp [cnt],4
    mov edx,err3
    jne error           
;-----------------------------------------------------------------------
;         
;-----------------------------------------------------------------------
    mov edi,obuff
    CSAdd m_beg
    movzx eax,word [ibuff]
    CSAddHex
    CSAddChar "h"
    CSAdd m_end
    movzx eax,word [ibuff + 2]
    CSAddHex
    CSAddChar "h"
    CSAdd m_chk
    CSAddHex [chksum]
    CSAddChar "h"
    CSAddCR
    CSEnd
    sub edi,obuff
    invoke GetStdHandle,STD_OUTPUT_HANDLE
    invoke WriteFile,eax,obuff,edi,cnt,0
    jmp done
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
cmderror:               ; error in commandline
    mov edx,err1    
;-----------------------------------------------------------------------
error:                  ; in edx - pointer to error message
    push 0
    push cnt
    push edx
    invoke lstrlen,edx
    pop  edx
    push eax
    push edx
    invoke GetStdHandle,STD_ERROR_HANDLE
    invoke WriteFile,eax
    mov [cnt],1
;-----------------------------------------------------------------------
done:
    cmp [ihand],INVALID_HANDLE_VALUE
    je  @F
    invoke CloseHandle,[ihand]
@@:
    cmp [ohand],INVALID_HANDLE_VALUE
    je  @F
    invoke CloseHandle,[ohand]
@@:
    invoke ExitProcess,[cnt]
;=======================================================================
;
;=======================================================================
proc pilot 
;-----------------------------------------------------------------------
    push esi
    mov esi,eax
    xor eax,eax
@@:
    call putbyte
    or  eax,eax
    jnz .done
    dec esi
    jnz @B
.done:
    pop esi
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc putbyte 
;-----------------------------------------------------------------------
    push edi
    push ebx
    mov edi,obuff
    mov dh,al
    mov ebx,80h
@@:
    mov dl,dh
    and dl,bl
    call .putbit
    shr bl,1
    jnz @B
;-----------------------------------------------------------------------
    sub edi,obuff
    invoke WriteFile,[ohand],obuff,edi,cnt,0
    sub edi,[cnt]
    mov eax,edi
;-----------------------------------------------------------------------
    pop ebx
    pop edi
	ret
;-----------------------------------------------------------------------
.putbit:
    mov ax,[lastbit]
    neg ax
    mov ecx,[period]
    rep stosw
    mov ax,32760
    or  dl,dl
    mov ecx,[period]
    jnz @F
    neg ax
@@:
    rep stosw
    mov [lastbit],ax
    retn
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
    CSSupport
;-----------------------------------------------------------------------
include "cmdparse.inc" 
include "a2i.inc"
include "ks.inc"
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
section '.data' data readable writeable
;-----------------------------------------------------------------------
header:
    RIFF        0
    WAVE
    FMT
    WAVEDATA    0
header_size = $ - header
;-----------------------------------------------------------------------
period  dd 16
lastbit dw -32760
;-----------------------------------------------------------------------
self_ks db 0
no_head db 0
;-----------------------------------------------------------------------
err1:   dr 13,10,"   !"
err0:   dr 13,10,": rks2wav [-k] [-x] file.rks file.wav"
        dr 13,10,"-k -    "
        dr 13,10,"-x -     "
crlf:   db 13,10,0
err2:   dr 13,10,"  ",13,10,0
err3:   dr 13,10,"  ",13,10,0
;-----------------------------------------------------------------------
m_beg:  dr 13,10,"   : ",0
m_end:  dr 13,10,"    : ",0
m_chk:  dr 13,10," : ",0
;-----------------------------------------------------------------------
        align 4
;-----------------------------------------------------------------------
ihand   dd INVALID_HANDLE_VALUE
ohand   dd INVALID_HANDLE_VALUE
cnt     dd 0
iname   dd ?
oname   dd ?
isize   dd ?
chksum  dd ?
ibuff   rb 65536+16
obuff   rb 1024
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
include "idata.inc"
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
