;=======================================================================
;    
; DE - x
; HL - y
;  C - : 1 -> 1, 0 -> 0, -1 -> 
;  : B, A
;-----------------------------------------------------------------------
put_pixel:
    mov a,h
    mov b,h
    ora a
    rnz
    mov a,d
    cpi 2
    rnc
    ora a
    mov a,e
    jz  .ok
    mvi b,20h
    cpi 7Fh
    rnc
.ok:
    push h
    mov h,b
    ani 7
    mov b,a
    mvi a,80h
    jz  .bit
.shft:
    rrc
    dcr b
    jnz .shft
.bit:
    mov b,a
    mov a,e
    ani 0F8h
    rrc
    rrc
    rrc
    add h
    adi 90h
    mov h,a
    mov a,c
    ora a
    mov a,b
    jz  .set_0
    jp  .set_1
    xra m
    mov m,a
    pop h
    ret
.set_1:
    ora m
    mov m,a
    pop h
    ret
.set_0:
    cma
    ana m
    mov m,a
    pop h
    ret
;=======================================================================
;
;=======================================================================
;     
; DE - x
; HL - y1
; BC - y2
; A  - color
;-----------------------------------------------------------------------
vert_line:
    xchg
    push b
    push psw
    mov a,c
    sub e
    mov a,b
    sbb d
    mvi b,13h; inx d
    jp  @F
    mvi b,1Bh; dcx d
@@:    
    pop psw
    mov c,a
    mov a,b
    sta .next
    xthl
    jmp .next+1
.next:
    inx d
    xthl
    xchg
    call put_pixel
    xchg
    xthl
    mov a,h
    cmp d
    jnz .next   
    mov a,l
    cmp e
    jnz .next
    mov a,c
    pop h
    xchg
    ret 
;=======================================================================
;
;=======================================================================
;     
; DE - x1
; HL - y
; BC - x2
; A  - color
;-----------------------------------------------------------------------
hor_line:
    push b
    push psw
    mov a,c
    sub e
    mov a,b
    sbb d
    mvi b,13h; inx d
    jp  @F
    mvi b,1Bh; dcx d
@@:    
    pop psw
    mov c,a
    mov a,b
    sta .next
    xthl
    jmp .next+1
.next:
    inx d
    xthl
    call put_pixel
    xthl
    mov a,h
    cmp d
    jnz .next   
    mov a,l
    cmp e
    jnz .next
    mov a,c
    pop h
    ret 
;=======================================================================
;
;=======================================================================
;      ,  45
; DE - x1
; HL - y1
;  C - : 1 -> 1, 0 -> 0, -1 -> 
;  B -  (0-7:  - 0, - - 1,  ..)
;  A -     (0=256)
; :
; DE - x2
; HL - y2
;-----------------------------------------------------------------------
fast_line: 
    push psw
    push b
    mov a,b
    add a
    adi .tab and 255
    mov c,a
    mvi a,.tab shr 8
    aci 0
    mov b,a
    ldax b
    sta .step
    inx b
    ldax b
    sta .step+1
    pop b
.next:
    call put_pixel
    pop psw
    dcr a
    rz
    push psw
.step:
    nop
    nop
    jmp .next
;-----------------------------------------------------------------------
.tab:    
    inx d
    nop
    inx d
    inx h
    nop
    inx h
    dcx d
    inx h
    dcx d
    nop
    dcx d
    dcx h
    nop
    dcx h
    inx d
    dcx h
;=======================================================================
;
;=======================================================================
;    fast_line
; DE - x1
; HL - y1
; BC -    
;  : <>,<>,...,<0>
;  A - : 1 -> 1, 0 -> 0, -1 -> 
; :
; DE - xN
; HL - yN
; BC -   ,   
;-----------------------------------------------------------------------
fast_shape:
    push b
    xthl
    mov c,a
.next:
    mov a,m
    ora a
    inx h
    jz  .done
    mov b,m
    inx h
    xthl
    call fast_line
    xthl
    jmp .next
.done:
    mov b,h
    mov c,l
    pop h
    ret        
;=======================================================================
;
;=======================================================================
;    
; draw_line.x_1   - x1
; draw_line.y_1   - y1
; draw_line.x_2   - x2
; draw_line.y_2   - y2
; draw_line.color - 
;-----------------------------------------------------------------------
draw_line:
;-----------------------------------------------------------------------
    lhld .x_2
    xchg
    lhld .x_1
    call .delta
    shld .d_x
    dad h
    shld .2dx
    mov a,c
    sta .dx_x
    sta .dx_y
;-----------------------------------------------------------------------
    lhld .y_2
    xchg
    lhld .y_1
    call .delta
    shld .d_y
    dad h
    shld .2dy
    mov a,b
    sta .dy_x
    sta .dy_y
;-----------------------------------------------------------------------
    lda .color
    mov c,a
    lhld .2dy
    xchg
    lhld .2dx
    mov a,e
    sub l
    mov l,a
    mov a,d
    sbb h
    mov h,a
    jnc .draw_y
;-----------------------------------------------------------------------
.draw_x:
    shld .2dy2dx
    xchg
    lhld .d_x
    inx h
    shld .d_x
    dcx h
    dad d
    shld .err
;-----------------------------------------------------------------------
    lhld .x_1
    xchg
    lhld .y_1
.next_x:
    call put_pixel
;-----------------------------------------------------------------------
    push h
    push d
    lhld .err
    xchg
    mov a,d
    ral
    lhld .2dy
    mvi b,0    
    jc  @F
    lhld .2dy2dx
    mvi b,1
@@:
    dad d
    shld .err
    lhld .d_x
    dcx h 
    shld .d_x
    mov a,h
    ora l
    pop d
    pop h
    rz
.dx_x:
    inx d 
    dcr b
    jnz .next_x
.dy_x:
    inx h 
    jmp .next_x
;-----------------------------------------------------------------------
.draw_y:
    mov a,h
    cma
    mov h,a
    mov a,l
    cma
    mov l,a
    inx h
    shld .2dy2dx
    xchg
    lhld .d_y
    inx h
    shld .d_y
    dcx h
    dad d
    shld .err
;-----------------------------------------------------------------------
    lhld .x_1
    xchg
    lhld .y_1
.next_y:
    call put_pixel
;-----------------------------------------------------------------------
    push h
    push d
    lhld .err
    xchg
    mov a,d
    ral
    lhld .2dx
    mvi b,0    
    jc  @F
    lhld .2dy2dx
    mvi b,1
@@:
    dad d
    shld .err
    lhld .d_y
    dcx h 
    shld .d_y
    mov a,h
    ora l
    pop d
    pop h
    rz
.dy_y:
    inx h 
    dcr b
    jnz .next_y
.dx_y:
    inx d 
    jmp .next_y
;-----------------------------------------------------------------------
;  HL = |DE - HL|; B = INX H/DCX H/NOP ; C = INX D/DCX D/NOP
;-----------------------------------------------------------------------
.delta:
    mov a,l
    sub e
    mov l,a
    mov a,h
    sbb d
    mov h,a
    jp  @F
    mov a,l
    cma
    mov l,a
    mov a,h
    cma
    mov h,a
    inx h
    db 1  ; LXI B
    inx d
    inx h
    ret
@@:
    db 1
    dcx d
    dcx h
    mov a,l
    ora h
    rnz
    inx b
    ret        
;-----------------------------------------------------------------------
.x_1    dw ?
.y_1    dw ?
.x_2    dw ?
.y_2    dw ?
.d_x    dw ?
.d_y    dw ?
.2dx    dw ?
.2dy    dw ?
.2dy2dx dw ? ; 2 * dY - 2 * dX 
.err    dw ?
.color  db ?
;=======================================================================
;
;=======================================================================
;    
; draw_arc.color - 
; DE - x
; HL - y
; BC - r
; A  - :  0 -   3:00  4:30,  ..   
;-----------------------------------------------------------------------
draw_arc:
    call .init
;-----------------------------------------------------------------------
    lxi h,.draw     ;     
    lxi d,.arcs-2   ;         5 6
    lxi b,0CD09h    ;       4     7
@@:                 ;       3     0
    dcr c           ;         2 1
    jz  @F
    inx d
    inx d
    rrc
    jnc @B
    push psw
    mov m,b
    inx h
    ldax d
    mov m,a
    inx h
    inx d
    ldax d
    mov m,a
    inx h
    dcx d
    pop psw
    jmp @B
@@:   
    mvi m,0C9h 
;-----------------------------------------------------------------------
.next:
    lda .color
    mov c,a
    call .draw
    lhld .delta
    xchg
    lhld .px
    mov a,d
    ora a
    mvi a,6
    jm  @F
    lda .my
    mov c,a
    lda .my+1
    mov b,a
    dad b
    mvi a,10
@@:
    mvi b,0
    mov c,a
    dad h
    dad h
    dad d
    dad b
    shld .delta
    jm  @F
    lhld .py
    dcx h
    shld .py
    lhld .my
    inx h
    shld .my
@@:
    lhld .mx
    dcx h
    shld .mx
    lhld .px
    inx h
    shld .px
    lda .py
    sub l
    lda .py+1
    sbb h
    jnc .next
    ret
;-----------------------------------------------------------------------
.init:
    push psw    ;  :
    shld .y     ; .y  = Y
    xchg        ; .x  = X
    shld .x     ; .px = 0
    lxi h,0     ; .mx = 0
    shld .px    ; .py = R
    shld .mx    ; .my = -R
    dad b       ; .delta = 3 - 2*R
    shld .py
    mov a,h
    cma
    mov h,a
    mov a,l
    cma
    mov l,a
    inx h
    shld .my
    dad h
    lxi b,3
    dad b
    shld .delta
    pop psw
    ret
;-----------------------------------------------------------------------
.arc0:
    lhld .y
    xchg
    lhld .px
    dad d
    push h
    lhld .x
    xchg
    lhld .py
    dad d
    xchg
    pop h
    jmp put_pixel
;-----------------------------------------------------------------------
.arc1:
    lhld .y
    xchg
    lhld .py
    dad d
    push h
    lhld .x
    xchg
    lhld .px
    dad d
    xchg
    pop h
    jmp put_pixel
;-----------------------------------------------------------------------
.arc2:
    lhld .y
    xchg
    lhld .py
    dad d
    push h
    lhld .x
    xchg
    lhld .mx
    dad d
    xchg
    pop h
    jmp put_pixel
;-----------------------------------------------------------------------
.arc3:
    lhld .y
    xchg
    lhld .px
    dad d
    push h
    lhld .x
    xchg
    lhld .my
    dad d
    xchg
    pop h
    jmp put_pixel
;-----------------------------------------------------------------------
.arc4:
    lhld .y
    xchg
    lhld .mx
    dad d
    push h
    lhld .x
    xchg
    lhld .my
    dad d
    xchg
    pop h
    jmp put_pixel
;-----------------------------------------------------------------------
.arc5:
    lhld .y
    xchg
    lhld .my
    dad d
    push h
    lhld .x
    xchg
    lhld .mx
    dad d
    xchg
    pop h
    jmp put_pixel
;-----------------------------------------------------------------------
.arc6:
    lhld .y
    xchg
    lhld .my
    dad d
    push h
    lhld .x
    xchg
    lhld .px
    dad d
    xchg
    pop h
    jmp put_pixel
;-----------------------------------------------------------------------
.arc7:
    lhld .y
    xchg
    lhld .mx
    dad d
    push h
    lhld .x
    xchg
    lhld .py
    dad d
    xchg
    pop h
    jmp put_pixel
;-----------------------------------------------------------------------
.draw:
    call .arc0
    call .arc1
    call .arc2
    call .arc3
    call .arc4
    call .arc5
    call .arc6
    call .arc7
    ret
;-----------------------------------------------------------------------
.arcs:
    dw .arc0
    dw .arc1
    dw .arc2
    dw .arc3
    dw .arc4
    dw .arc5
    dw .arc6
    dw .arc7
;-----------------------------------------------------------------------
.x      dw ?
.y      dw ?
.r      dw ?
.px     dw ?
.mx     dw ?
.py     dw ?
.my     dw ?
.delta  dw ?
.color  dw ?    
;=======================================================================
;
;=======================================================================
;    
; DE - x
; HL - y
; BC - r
; A  -  (  )
;-----------------------------------------------------------------------
circle:
    call draw_arc.init
    sta  draw_arc.color
    lxi  h,.draw
    mvi  a,0C3h
    sta  draw_arc.draw
    shld draw_arc.draw+1
    jmp  draw_arc.next
;-----------------------------------------------------------------------
.draw:    
    lhld draw_arc.y
    xchg
    lhld draw_arc.px
    dad d
    push h
    lhld draw_arc.mx
    dad d
    push h
    lhld draw_arc.my
    dad d
    push h
    lhld draw_arc.py
    dad d
    push h
;-----------------------------------------------------------------------
    lhld draw_arc.x
    xchg
    lhld draw_arc.px
    dad d
    mov b,h
    mov c,l
    lhld draw_arc.mx
    dad d
    xchg
    pop h
    push b
    push d
    call hor_line
    pop d
    pop b
    pop h
    call hor_line
;-----------------------------------------------------------------------
    lhld draw_arc.x
    xchg
    lhld draw_arc.py
    dad d
    mov b,h
    mov c,l
    lhld draw_arc.my
    dad d
    xchg
    pop h
    push b
    push d
    call hor_line
    pop d
    pop b
    pop h
    jmp hor_line
;=======================================================================
;
;=======================================================================
;    
; draw_rect.x_1   - x1
; draw_rect.y_1   - y1
; draw_rect.x_2   - x2
; draw_rect.y_2   - y2
; draw_rect.color - 
;-----------------------------------------------------------------------
draw_rect:  
;-----------------------------------------------------------------------
draw_rect.x_1    equ  draw_line.x_1
draw_rect.y_1    equ  draw_line.y_1
draw_rect.x_2    equ  draw_line.x_2
draw_rect.y_2    equ  draw_line.y_2
draw_rect.color  equ  draw_line.color
;-----------------------------------------------------------------------
    lhld draw_line.x_2
    mov b,h
    mov c,l
    lhld draw_line.y_1
    xchg
    lhld draw_line.y_2
    mov a,l
    sub e
    mov a,h
    sbb d
    jp  @F
    xchg
@@:
    push h
    lhld draw_line.x_1
    dcx d
    xthl
@@:
    xthl
    xchg
    inx h
    lda draw_line.color
    call hor_line
    mov b,d
    mov c,e
    xchg
    lhld draw_line.x_1
    xthl
    mov a,l
    cmp e
    jnz @B
    mov a,d
    cmp h
    jnz @B
    pop h
    ret    
;=======================================================================
;
;=======================================================================
;  
; DE - x1
; HL - y1
; BC -    
;  A - : 1 -> 1, 0 -> 0, -1 -> 
;-----------------------------------------------------------------------
;  : <>,<>,<>,<>,...,<0>
;-----------------------------------------------------------------------
; :
; 1 - fast_shape
; 2 - dx/dy
;-----------------------------------------------------------------------
; :
; DE - xN
; HL - yN
; BC -   ,   
;-----------------------------------------------------------------------
draw:
    sta .color
.next:
    ldax b
    inx b
    ora a
    rz
    dcr a
    jnz @F
    lda .color
    call fast_shape
    jmp .next
@@:
    dcr a
    jnz @F
    ldax b
    inx b
    add e
    mov e,a
    ldax b
    inx b
    adc d
    mov d,a     
    ldax b
    inx b
    add l
    mov l,a
    ldax b
    inx b
    adc h
    mov h,a 
    jmp .next    
@@: 
    ret
;-----------------------------------------------------------------------
.color: db ?    
;=======================================================================
;
;=======================================================================
;    : HL -   , DE -   
;-----------------------------------------------------------------------
fade:
    lxi b,55h
    push b
    push h
    push h
    push h
    mov b,l
.m1:
    mov a,m
    ana c
    mov m,a
    inr l
    inr l
    mov a,l
    cmp e
    jc  .m1
    mov l,b
    inr h
    mov a,h
    cmp d
    jc  .m1
    pop h
    mov a,c
    rrc
    mov c,a
;-----------------------------------------------------------------------
    push h
    lxi h,10000
    call delay
    pop h
;-----------------------------------------------------------------------
.m2:
    inr l
    mov a,m
    ana c
    mov m,a
    inr l
    mov a,l
    cmp e
    jc  .m2
    mov l,b
    inr h
    mov a,h
    cmp d
    jc  .m2
    pop h
    mov a,h
    ora a
    rz
;-----------------------------------------------------------------------
    push h
    lxi h,10000
    call delay
    pop h
;-----------------------------------------------------------------------
    jmp .m1
;=======================================================================
;
;=======================================================================
delay:
    dcx h
    mov a,h
    ora l
    jnz delay
    ret
;=======================================================================
    
                   
        
  