;=======================================================================
;   a tutorial to get start with i8080A, "Specialist" homebrew PC,
;   emu emulator, fasm and WinAsm Studio
;=======================================================================
;   1. assemble this code with fasm
;   2. run emu, passing it resulting rks with commandline
;   3. enter "G" command for Monitor to run the program
;-----------------------------------------------------------------------
;   "high skill" (SPECROM1 as "Specialist" bios required):
;   1. as above
;   2. as above
;   3. enter "J" command to load debugger
;   4. enter "G" command in debugger prompt
;   5. press "Enter" or "Space" to see command execution
;   6. press "F4" exactly after enter subroutine to skip its debugging
;   7. ask me for more info if neccesary :)
;=======================================================================
include "8080.inc"      ; macros to define i8080 instructions
;=======================================================================
    RKS_START 0         ; binary starts at 0000h
;-----------------------------------------------------------------------
    call 0C010h         ; clear the screen
;-----------------------------------------------------------------------
    lxi h,hello
    call 0C818h         ; print message
;-----------------------------------------------------------------------
    lxi h,buffer        ; buffer start
    lxi d,buffer+31     ; buffer end
    call 0C80Fh         ; get string from user
;-----------------------------------------------------------------------
    lxi h,message        
    call 0C818h         ; print user message
;-----------------------------------------------------------------------
    mvi c,0Ah
    call 0C809h         ; "print" character to screen (go to next line)
;-----------------------------------------------------------------------
    lxi h,getkey        
    call 0C818h         ; print invitation to press any key
    call 0C803h         ; wait for the key pressing
    mov c,a             ; preserve returned code in C
    push b
    lxi h,showkey        
    call 0C818h      
    pop b
    mvi a,20h           ; if code is above then 20h, then print char
    cmp c
    jc  readykey
    mov a,c
    call 0C815h         ; else print key code in hex
    mvi c,"H"
readykey:
    call 0C809h         ; show character from C
;-----------------------------------------------------------------------
    ret
;-----------------------------------------------------------------------
;   it is enough to use 0Ah here to go next line from start.
;   use only capital latin letters for messages, small latin
;   letters are mapped to capital cyrillic letters in KOI-7
;-----------------------------------------------------------------------
hello   db 0Ch,"HELLO!" ; 0Ch - "home"
        db 0Ah,"TYPE YOUR MESSAGE: ",0
getkey  db 0Ah,"PRESS ANY KEY!",0        
showkey db 0Ah,"KEY PRESSED IS ",0        
message db 0Ah,"  YOUR MESSAGE IS: "       
buffer  rb 32
;-----------------------------------------------------------------------
    RKS_END             ; binary tail
;=======================================================================
            