;=======================================================================
;   ROM TEMPLATE
;=======================================================================
include "8080.inc"
include "win2koi7.inc" ; in case of usage of cyrillic
include "bv.inc"
;-----------------------------------------------------------------------
;   ram-less call. usefull for testing pc with absent or damaged ram. 
;   never use nested rom-calls, as there is no real stack!!!
;-----------------------------------------------------------------------
macro rom_call _proc {
    local  .next
    lxi sp,.next - 2
    jmp _proc
    dw .next
.next:    
}
;=======================================================================
rom_base equ 0C000h
scr_left equ 92h ; higher byte of screen address (leftmost=90h)
;=======================================================================
    org rom_base 
;-----------------------------------------------------------------------
    jmp @F          ; jump from 0000h to 0C003h
@@:    
    mvi a,82h
    sta 0FF03h      ; 8255 PIO init
    rom_call cls    ; clear the screen
    mvi e,5
    mvi d,scr_left
    lxi b,_hello
    rom_call str_out
    mvi e,15
    mvi d,scr_left
    lxi b,_ver
    rom_call str_out
;-----------------------------------------------------------------------
@@:
    jmp @B ; deadloop
;=======================================================================
;
;=======================================================================
cls:
    lxi h, 9000h
    lxi b,0C000h
    mvi e,0
@@:
    mov m,e 
    inx h
    mov a,h
    cmp b
    jnz @B
    mov a,l
    cmp c
    jnz @B
    ret
;-----------------------------------------------------------------------
;  a - symbol
; de - screen position (absolute address)
; hl - in use
;-----------------------------------------------------------------------
char_out: 
    lxi h,(font shr 3) - 32
    add l
    mov l,a
    jnc @F
    inr h
@@:
    dad h
    dad h
    dad h
repeat 8
    mov a,m
    stax d
    inr l
    inr e    
end repeat
    mov a,e
    sui 8
    mov e,a
    ret    
;-----------------------------------------------------------------------
; bc - pointer to the line. all registers are in use.
; de - screen position (absolute screen address)
;-----------------------------------------------------------------------
str_out:
    ldax b
    ora a
    rz
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    lxi h,(font shr 3) - 32
    add l
    mov l,a
    jnc @F
    inr h
@@:
    dad h
    dad h
    dad h
repeat 8
    mov a,m
    stax d
    inr l
    inr e    
end repeat
    mov a,e
    sui 8
    mov e,a
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    inx b
    inr d
    jmp str_out    
;=======================================================================
_hello: dr "HELLO FROM ROM",0
_ver:   dr "VER ",MAIN_VERSION,".",SUB_VERSION,".",BUILD_VERSION,0
;=======================================================================
times ((256 - ($ and 255)) and 255) db 0FFh     ; align 256
;-----------------------------------------------------------------------
font: file "font.bin"                           ; font face
;=======================================================================
times (rom_base + 2048 - $) db 0FFh             ; padding
;=======================================================================
            