;=======================================================================
include "win2koi7.inc"
include "8080.inc"
include "macro\struct.inc"
include "bv.inc"
;=======================================================================
if DEBUG_VERSION
    RKS_START 0
else
    org 0D000h
end if    
;-----------------------------------------------------------------------
XX          equ 0E6h
DATA_TOP    equ 8E00h
DATA_AREA.dir       = DATA_TOP - (4 * 10)
DATA_AREA.dir_cur   = DATA_AREA.dir - 2
DATA_AREA.dir_cnt   = DATA_AREA.dir_cur - 1
DATA_AREA.last_spc  = DATA_AREA.dir_cnt - 3
DATA_AREA.sector    = DATA_AREA.last_spc - 2
DATA_AREA.disk      = DATA_AREA.sector - 32
DATA_AREA           = DATA_AREA.disk - sizeof.FILE_HEAD
;-----------------------------------------------------------------------
struct DISK_HEAD
    aa55        dw ?
    disk_size   dd ?
    sect_size   dw ?
    label       rb 32
    sys_start   dw ?
    sys_size    dw ?
    sys_space   dd ?
ends
;-----------------------------------------------------------------------
struct FILE_HEAD
    xx          db ?
    attr        db ?
    name        rb 32
    start       dw ?
    size        dw ?
    ks          dw ?
    space       dd ?
ends
;=======================================================================

;-----------------------------------------------------------------------
    jmp start ; 00
    jmp flash_reset ; 03
    jmp flash_read_byte ; 06
    jmp flash_read ; 09
;-----------------------------------------------------------------------
start:
    sta DATA_AREA.dir_cnt
    lxi h,0
    lxi d,0
    call flash_read_byte
    mvi a,0AAh
    cmp d
    jnz no_disk
    inr l
    call flash_read_byte
    mvi a,055h
    cmp d
    jnz no_disk
;-----------------------------------------------------------------------
    lxi h,DISK_HEAD.sect_size
    mvi e,0
    call flash_read_byte
    mov a,d
    sta DATA_AREA.sector
    inr l    
    call flash_read_byte
    mov a,d
    sta DATA_AREA.sector + 1
;-----------------------------------------------------------------------
    lxi h,DATA_AREA.disk
    lxi b,32
    lxi d,DISK_HEAD.label
    xra a
    call flash_read
    lxi h,a_disk
    call 0C818h
    lxi h,DATA_AREA.disk
    call 0C818h
;-----------------------------------------------------------------------
    lda DATA_AREA.dir_cnt
    ora a
    jz  .no_sys
;-----------------------------------------------------------------------
    mvi e,0
    lxi h,DISK_HEAD.sys_size
    call flash_read_byte
    mov b,d
    inx h
    call flash_read_byte
    mov e,b
    mov a,b
    ora d
    jnz load_sys
;-----------------------------------------------------------------------
.no_sys:
    mvi e,0
    lxi h,DISK_HEAD.sys_space
    lxi b,DATA_AREA.dir
    call flash_read_byte
    mov a,d
    stax b
    inx b
    inx h
    call flash_read_byte
    mov a,d
    stax b
    inx b
    inx h
    call flash_read_byte
    mov a,d
    stax b  ; DATA_AREA.dir -    
;-----------------------------------------------------------------------
.next_page:
    lxi h,a_disk
    call 0C818h
    lxi h,DATA_AREA.disk
    call 0C818h
    mvi c,10
    call 0C809h
    lxi b,(60 shl 8) + "="
    call hor_line
;-----------------------------------------------------------------------
    mvi a,10
    sta DATA_AREA.dir_cnt
    lxi h,DATA_AREA.dir
    shld DATA_AREA.dir_cur
;-----------------------------------------------------------------------
.next_load:
    mov e,m
    inx h
    mov d,m
    inx h
    mov a,m
.next_load_fast:    
    push h
    lxi h,DATA_AREA
    lxi b,sizeof.FILE_HEAD
    call flash_read
    pop h
    lda DATA_AREA
    cpi XX
    lda DATA_AREA.dir_cnt
    jnz .bottom ;   : ZF=0 !
    lda DATA_AREA + FILE_HEAD.attr
    ora a
    jp  .deleted
;-----------------------------------------------------------------------
;   DATA_AREA.dir_cur ->   + 
;-----------------------------------------------------------------------
    inx h
    mov m,a
    mov d,a
;-----------------------------------------------------------------------
;        
;-----------------------------------------------------------------------
    lhld DATA_AREA + FILE_HEAD.space
    shld DATA_AREA.last_spc
    lda DATA_AREA + FILE_HEAD.space + 2
    sta DATA_AREA.last_spc + 2
;-----------------------------------------------------------------------
;        
;-----------------------------------------------------------------------
    lda DATA_AREA.dir_cnt
    dcr a
    sta DATA_AREA.dir_cnt
;-----------------------------------------------------------------------
;       
;-----------------------------------------------------------------------
    cma 
    adi 3Ah
    mov c,a
    call 0C809h ;   
    mvi c," "
    call 0C809h
    call show_attr ;   
    lxi h,DATA_AREA + FILE_HEAD.name
    call show_name ;   
    lda DATA_AREA + FILE_HEAD.start + 1
    call show_byte ;   
    lda DATA_AREA + FILE_HEAD.start
    call show_byte
    lxi d,0
    lhld DATA_AREA + FILE_HEAD.size
    lda DATA_AREA + FILE_HEAD.attr
    ani 40h
    jnz @F
    xchg
    lhld DATA_AREA + FILE_HEAD.size+2
    xchg
@@:
    lxi b,DATA_AREA + FILE_HEAD.name
    call ui2a
    lxi d,DATA_AREA + FILE_HEAD.name
    mov l,c
    mov h,b
@@:
    dcx h
    mvi m," "
    mov a,e
    cmp l
    jnz @B
    mov a,d
    cmp h
    jnz @B
    call 0C818h ;    
    mvi c,10
    call 0C809h
;-----------------------------------------------------------------------
    lda DATA_AREA.dir_cnt
    ora a
    jz  .bottom ;  , ZF=1 !   
;-----------------------------------------------------------------------
;      
;-----------------------------------------------------------------------
    lhld DATA_AREA.dir_cur
    xchg
    lxi h,4
    dad d
    shld DATA_AREA.dir_cur
    xchg
    lxi b,DATA_AREA + FILE_HEAD.space
    ldax b
    add m
    stax d
    inx h
    inx b
    inx d
    ldax b
    adc m
    stax d
    inx h
    inx b
    inx d
    ldax b
    adc m
    stax d
    inx h
    inx h
    jmp .next_load
;-----------------------------------------------------------------------
.bottom:    
    jz  @F
    cpi 10
    jz  .no_more_files
@@:
;-----------------------------------------------------------------------
    lxi b,(60 shl 8) + "="
    call hor_line
    lxi h,a_bottom
    call 0C818h
.get_choice:
    call 0C803h
    cpi 1Fh
    jz  0C800h
    cpi 20h
    jz  .next_page_set
    cpi 3Ah
    jnc .get_choice
    sui 30h
    jc  .get_choice
    mov l,a
    lda DATA_AREA.dir_cnt
    sui 10
    cma    
    sub l
    jc  .get_choice
;-----------------------------------------------------------------------
;    
;-----------------------------------------------------------------------
    mvi h,0
    dad h
    dad h
    lxi d,DATA_AREA.dir + 3
    dad d
    mov a,m
    mov c,a
    cma
    ani 11000111b
    jnz .get_choice ;  
;-----------------------------------------------------------------------
    mov a,c
    lxi b,sizeof.FILE_HEAD
    ani 10h
    jnz @F
    lda DATA_AREA.sector
    mov c,a
    lda DATA_AREA.sector + 1
    mov b,a
@@:    
    dcx h
    mov a,m
    dcx h
    mov d,m
    dcx h
    mov e,m
    xchg
    mov e,a ;    
    push d  ;     - H
    push h  ;     - L
    push b  ;    
;-----------------------------------------------------------------------
    xchg
    lxi h,DATA_AREA
    lxi b,sizeof.FILE_HEAD
    call flash_read
;-----------------------------------------------------------------------
    pop b
    pop h
    pop d
    mov a,e
    dad b
    aci 0
    xchg
    lhld DATA_AREA + FILE_HEAD.size
    mov b,h
    mov c,l
    lhld DATA_AREA + FILE_HEAD.start
    call flash_read
;-----------------------------------------------------------------------
    lxi h,a_run
    call 0C818h
@@:    
    call 0C803h
    lxi h,0C800h
    cpi 1Fh
    jz  @F
    cpi 0Dh
    jnz @B
    push h
    lhld DATA_AREA + FILE_HEAD.start
@@:    
    pchl
;-----------------------------------------------------------------------
.no_more_files:
    mvi c,10
    call 0C809h
    lxi b,(60 shl 8) + "-"
    call hor_line
    lxi h,a_no_more
    call 0C818h
    jmp 0C800h    
;-----------------------------------------------------------------------
.next_page_set:
    lda DATA_AREA.dir_cnt
    ora a
    jnz .no_more_files
;-----------------------------------------------------------------------
    lxi h,DATA_AREA.last_spc
    lxi b,DATA_AREA.dir
    lxi d,DATA_AREA.dir + 9*4
    ldax d
    add m
    stax b
    inx b
    inx d
    inx h
    ldax d
    adc m
    stax b
    inx b
    inx d
    inx h
    ldax d
    adc m
    stax b
    jmp .next_page    
;-----------------------------------------------------------------------
;      DATA_AREA.dir_cur ->  
;-----------------------------------------------------------------------
.deleted:
    lhld DATA_AREA.dir_cur
    lxi b,DATA_AREA + FILE_HEAD.space
    ldax b
    add m
    mov m,a
    mov e,a
    inx h
    inx b
    ldax b
    adc m
    mov m,a
    mov d,a
    inx h
    inx b
    ldax b
    adc m
    mov m,a
    jmp .next_load_fast
;-----------------------------------------------------------------------
no_disk:    
    lxi h,a_no_disk
    call 0C818h
    jmp 0C800h
;-----------------------------------------------------------------------
load_sys:
    lxi h,a_loadsys
    call 0C818h
    lxi b,(5 shl 8)+"."
.m1:   
    lxi h,8000h
.m2:
    lda 0FF01h
    rar
    rar
    jnc start.no_sys
    dcx h
    mov a,h
    ora l
    jnz .m2
    call 0C809h
    dcr b
    jnz .m1
;-----------------------------------------------------------------------
    push d
    mvi e,0
    lxi h,DISK_HEAD.sys_start
    call flash_read_byte
    mov b,d
    inx h
    call flash_read_byte
    mov e,b
    pop b
    push d
    xchg
    lxi d,sizeof.DISK_HEAD
    jmp flash_read
;-----------------------------------------------------------------------
show_byte:
    call a2hex
    call 0C809h 
    mov c,b    
    jmp 0C809h
;-----------------------------------------------------------------------
show_name:
    lxi b,(34 shl 8) + " "
@@:
    call 0C809h
    mov a,m
    mov c,a
    dcr b
    inx h
    ora a
    jnz @B 
    mvi c," "
@@:
    call 0C809h
    dcr b
    jnz @B
    ret
;-----------------------------------------------------------------------
show_attr:
    mvi c,"D"
    call @F
    mvi c,"L"
    call @F
    mvi c,"E"
    call @F
    mvi c,"A"
    call @F
    mvi c,"R"    
    call @F
    mvi c,"2"    
    call @F
    mvi c,"1"    
    call @F
    mvi c,"0"    
@@:
    mov a,d
    ral  
    mov d,a
    jnc 0C809h
    mvi c,"."
    jmp 0C809h
;-----------------------------------------------------------------------
hor_line:
    call 0C809h
    dcr b
    jnz hor_line
    mvi c,10
    jmp 0C809h
;-----------------------------------------------------------------------
a_disk:     dr 31,": ",0
a_no_disk:  dr 10,"     ",10,0
a_no_more:  dr    "  ",10,0
a_loadsys:  dr 10,"   ",0 
a_run:      dr 10,"      - "
            dr 10,"     - ",0
a_bottom:   dr    "   - "
            dr 10,"  - "
            dr 10,"     - ",0   
            
;-----------------------------------------------------------------------
include "math.inc"
include "i8255.inc"
include "flashdisk.inc"
;-----------------------------------------------------------------------
if DEBUG_VERSION
    RKS_END
end if    
;=======================================================================
            