;=======================================================================
include "i8255.inc"
;=======================================================================
IO_A equ 0F000h
IO_B equ IO_A + 1
IO_C equ IO_B + 1
IO_Z equ IO_C + 1
;-----------------------------------------------------------------------
DISK_READ = BB55_SET or A_MODE_0 or PA_IN  or PC47_OUT \
                     or B_MODE_0 or PB_OUT or PC03_OUT
;=======================================================================
;
;=======================================================================
flash_reset:
    mvi a,DISK_READ
    sta IO_Z
    mvi a,0C0h
    sta IO_C
    ret
;=======================================================================
;
;=======================================================================
;   EHL -   
;   : D  - 
;-----------------------------------------------------------------------
flash_read_byte:
    mvi a,DISK_READ
    sta IO_Z
    mov a,e
    ani 01Fh
    ori 0C0h
    sta IO_C
    mov a,h
    sta IO_B
    mvi a,BB55_SET_C5 1
    sta IO_Z
    dcr a
    sta IO_Z
    mov a,l
    sta IO_B
    mvi a,BB55_SET_C7 0
    sta IO_Z
    lda IO_A
    mov d,a
    mvi a,BB55_SET_C7 1
    sta IO_Z
    ret
;=======================================================================
;
;=======================================================================
;   HL -   
;   DE -   
;   BC -  
;     - 
;-----------------------------------------------------------------------
flash_read:
    push psw           
    mvi a,DISK_READ
    sta IO_Z
    pop psw
.m3:
    push psw
    ani 01Fh
    ori 0C0h
    sta IO_C
    mov a,d
.m2:
    sta IO_B
    mvi a,BB55_SET_C5 1
    sta IO_Z
    dcr a
    sta IO_Z
    mov a,e
.m1:
    sta IO_B
    mvi a,BB55_SET_C7 0
    sta IO_Z
    lda IO_A
    mov m,a
    mvi a,BB55_SET_C7 1
    sta IO_Z
    dcx b
    mov a,c
    ora b
    jz  .done
    inx h
    mov a,e
    adi 1
    mov e,a
    jnc .m1 
    mov a,d
    aci 0
    mov d,a
    jnc .m2
    pop psw
    inr a
    jmp .m3
.done:
    pop psw
    ret
;=======================================================================

