;=======================================================================
format PE GUI 4.0
;=======================================================================
include 'win32a.inc'    ;*
include 'rc.inc'        ;*
include 'bv.inc'        ;*
include 'shoomac.inc'   ;*
include 'encoding\win1251.inc' ;*
;-----------------------------------------------------------------------
IDI_MAIN    equ 17
hInstance   equ of.hInstance
hMain       equ of.hwndOwner
XX          equ 0E6h
;-----------------------------------------------------------------------
struct DISK_HEAD
    aa55        dw ?
    disk_size   dd ?
    sect_size   dw ?
    label       rb 32
    sys_start   dw ?
    sys_size    dw ?
    sys_space   dd ?
ends
;-----------------------------------------------------------------------
struct FILE_HEAD
    xx          db ?
    attr        db ?
    name        rb 32
    start       dw ?
    size        dw ?
    ks          dw ?
    space       dd ?
ends
;=======================================================================
section '.code' code readable executable
;-----------------------------------------------------------------------
entry $
;-----------------------------------------------------------------------
    mov [filename],0
    mov [diskname],0
    invoke GetModuleHandle,0
    mov [hInstance],eax
;-----------------------------------------------------------------------
    invoke GetModuleFileName,0,a_buff,260
    invoke PathRemoveFileSpec,a_buff
    invoke PathAppend,a_buff,ini
    invoke StrDup,a_buff
    mov [p_ini],eax
;-----------------------------------------------------------------------
    invoke DialogBoxParam,[hInstance],D_MAIN,0,dlg_proc,0
    invoke LocalFree,[p_ini]
    invoke ExitProcess,0
;=======================================================================
;
;=======================================================================
proc dlg_proc hWnd,uMsg,wParam,lParam 
    cmp [uMsg],WM_CLOSE
    jne @F
.end_dlg:
    invoke EndDialog,[hWnd],0
.exit_true:
    mov eax,TRUE
    ret
@@:
;-----------------------------------------------------------------------
    cmp [uMsg],WM_INITDIALOG
    jne @F
;-----------------------------------------------------------------------
    mov eax,[hWnd]
    mov [hMain],eax  
;-----------------------------------------------------------------------
    invoke LoadIcon,[hInstance],IDI_MAIN
    invoke SendMessage,[hWnd],WM_SETICON,ICON_SMALL,eax
;-----------------------------------------------------------------------
    invoke GetDlgItem,[hWnd],E_START
    stdcall SubclassViaUser,eax,hex_only
    invoke GetDlgItem,[hWnd],E_SYSSTART
    stdcall SubclassViaUser,eax,hex_only
;-----------------------------------------------------------------------
    invoke GetDlgItem,[hWnd],C_DISKSIZE
    push eax
    stdcall cb_fill_str,eax,disksize
    pop eax
    invoke SendMessage,eax,CB_SETCURSEL,3,0    
;-----------------------------------------------------------------------
    invoke GetDlgItem,[hWnd],C_SECTSIZE
    push eax
    stdcall cb_fill_str,eax,sectsize    
    pop eax
    invoke SendMessage,eax,CB_SETCURSEL,2,0    
;-----------------------------------------------------------------------
    jmp .exit_true
@@:    
;-----------------------------------------------------------------------
;    cmp [uMsg],?? << add new message
;    jne @F
;    
;    jmp .exit_true
;@@:    
;-----------------------------------------------------------------------
    cmp [uMsg],WM_COMMAND
    jne .exit_false
    cmp [wParam],B_CAN
    je .end_dlg
;-----------------------------------------------------------------------
    cmp [wParam],B_OK
    jne @F
    ;-------------------------------------------------------------------
    invoke GetSaveFileName,of
    or  eax,eax
    jz  .exit_true
    invoke PathFindFileName,diskname
    invoke SetDlgItemText,[hWnd],E_DISK,eax
    invoke CreateFile,diskname,GENERIC_WRITE,0,0,\
                                    CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL
    cmp eax,INVALID_HANDLE_VALUE
    mov [uMsg],eax
    je  .write_error
    invoke WriteFile,[uMsg],img,[disk_size],a_buff,0
    invoke CloseHandle,[uMsg]
    mov eax,[disk_size]
    cmp eax,dword [a_buff]
    jne .write_error     
    ;-------------------------------------------------------------------
    jmp .exit_true
.write_error:
    invoke MessageBox,[hWnd],errwritef,0,0
    jmp .exit_true    
@@:
;-----------------------------------------------------------------------
    cmp [wParam],B_NEW
    jne @F
    invoke MessageBox,[hWnd],qnewdisk,att,MB_YESNO
    cmp eax,IDYES
    jne .exit_true
    ;   
    invoke SetDlgItemText,[hWnd],E_DISK,0
    invoke SendDlgItemMessage,[hWnd],C_DISKSIZE,CB_GETCURSEL,0,0
    mov ecx,512*1024
    cmp eax,CB_ERR
    cmovz eax,ecx
    jz  .disksize_ok
    mov eax,[disksize_ + eax*4]
.disksize_ok:    
    mov [disk_size],eax
    invoke SendDlgItemMessage,[hWnd],C_SECTSIZE,CB_GETCURSEL,0,0
    mov ecx,256
    cmp eax,CB_ERR
    cmovz eax,ecx
    jz  .sectsize_ok
    mov eax,[sectsize_ + eax*4]
.sectsize_ok:    
    mov [sect_size],eax
    call new_img
.get_disk_info:
    call get_disk_info
    call get_dir
    jmp .exit_true
@@:
;-----------------------------------------------------------------------
    cmp [wParam],B_OPEN
    jne @F
    invoke GetOpenFileName,of
    or  eax,eax
    jz  .exit_true
    mov [disk_size],0
    mov [sect_size],0
    invoke PathFindFileName,diskname
    invoke SetDlgItemText,[hWnd],E_DISK,eax
    invoke CreateFile,diskname,GENERIC_READ,0,0,\
                                    OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL
    cmp eax,INVALID_HANDLE_VALUE
    mov [uMsg],eax
    je  .read_error
    invoke GetFileSize,[uMsg],0
    mov [lParam],eax
    lea ecx,[wParam]
    invoke ReadFile,[uMsg],img,eax,ecx,0
    invoke CloseHandle,[uMsg]
    mov ecx,[wParam]
    cmp ecx,[lParam]
    je  .get_disk_info
.read_error:
    invoke MessageBox,[hWnd],errreadf,0,0
    jmp .exit_true    
@@:
;-----------------------------------------------------------------------
    cmp [wParam],B_SET
    jne @F
    invoke DialogBoxParam,[hInstance],D_MOD,[hWnd],mod_file,0
    jmp .exit_true
@@:
;-----------------------------------------------------------------------
    cmp [wParam],B_SETSYS
    jne @F
    invoke GetDlgItemText,[hWnd],E_LABEL,img + DISK_HEAD.label,32
    jmp .exit_true
@@:
;-----------------------------------------------------------------------
    cmp [wParam],B_ADD
    jne @F
    mov [filesize],0
    mov [filename],0
    invoke DialogBoxParam,[hInstance],D_ADD,[hWnd],add_file,0
    jmp .exit_true
@@:
;-----------------------------------------------------------------------
    cmp [wParam],L_DIR + (LBN_SELCHANGE shl 16)
    jne @F
    call get_file_info
    jmp .exit_true
@@:    
.exit_false:
    xor eax,eax
    ret
endp
;=======================================================================
;
;=======================================================================
proc get_hex_number _buff ; CF=1 - ,  -> eax
;-----------------------------------------------------------------------
    push esi
    mov esi,[_buff]
    xor eax,eax
    xor ecx,ecx
.next:
    lodsb
    or  al,al
    je  .done
    cmp al,"F"
    ja  .get_number_err
    cmp al,"A"
    jb  .digit
    sub al,"A"-10
    jmp .valid
.digit:
    cmp al,"9"
    ja  .get_number_err    
    sub al,"0"
    js  .get_number_err
.valid:
    shl ecx,4
    add cl,al
    jmp .next   
.done:
    or eax,eax
    mov eax,ecx
    pop esi
    ret    
.get_number_err:
    pop esi
    stc
    ret            
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc al2hex
        mov     ah,al
        and     al,15
        cmp     al,10
        sbb     al,069h
        das
        xchg    ah,al
        shr     al,4
        cmp     al,10
        sbb     al,069h
        das
        ret
endp        
;=======================================================================
;
;=======================================================================
include "addfile.inc"
include "disk.inc"
;-----------------------------------------------------------------------
include 'shoolib.inc'   ;*
include 'general\subclass.inc'   ;*
;-----------------------------------------------------------------------
if FALSE
 include '%shoolib%\shooimp.imp'
end if
;=======================================================================
;
;=======================================================================
include  'data.inc'
;-----------------------------------------------------------------------
include 'idata.inc'     ;*
;=======================================================================
;
;=======================================================================
section '.rsrc' resource data readable
;-----------------------------------------------------------------------
  directory \
    RT_ICON,icons,\
    RT_GROUP_ICON,group_icons,\
    RT_DIALOG,dialogs,\
    RT_VERSION,versions
;-----------------------------------------------------------------------
  resource icons,\
    1,LANG_NEUTRAL,icon_data

  resource group_icons,\
    IDI_MAIN,LANG_NEUTRAL,main_icon

  resource versions,\
    1,LANG_NEUTRAL,version
;-----------------------------------------------------------------------
include "dialogs.tab" ;*
;-----------------------------------------------------------------------
  icon main_icon,icon_data,'573RF2.ico'
;-----------------------------------------------------------------------
include "dialogs.dat" ;*
;-----------------------------------------------------------------------
versioninfo version,VOS__WINDOWS32,VFT_APP,VFT2_UNKNOWN,\
                                   LANG_RUSSIAN+SUBLANG_DEFAULT,0,\
        'FileDescription','FACHIWEC FLASH DISK MANAGER',\
        'LegalCopyright','Freeware',\
        'CompanyName','http://shoorick.org.ua',\
        'FileVersion',<MAIN_VERSION,".",SUB_VERSION,".",BUILD_VERSION>,\
        'ProductVersion',<MAIN_VERSION,".",SUB_VERSION>,\
        'OriginalFilename','SpecDiskManager.exe'
;=======================================================================
