;=======================================================================
proc new_img
;-----------------------------------------------------------------------
    push edi
    mov ecx,[disk_size]
    shr ecx,2
    mov edi,img
    xor eax,eax
    dec eax
    rep stosd
;-----------------------------------------------------------------------
    mov edi,img
    mov [edi + DISK_HEAD.aa55], 55AAh
    mov ecx,[disk_size]
    mov eax,[sect_size]
    mov [edi + DISK_HEAD.disk_size],ecx
    mov [edi + DISK_HEAD.sect_size],ax
    mov ecx,sizeof.DISK_HEAD
    cmp eax,ecx
    cmovb eax,ecx
    mov [edi + DISK_HEAD.sys_space],eax
    xor eax,eax
    mov [edi + DISK_HEAD.label],al
    mov [edi + DISK_HEAD.sys_start],ax
    mov [edi + DISK_HEAD.sys_size], ax
;-----------------------------------------------------------------------
	pop edi
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc get_disk_info
;-----------------------------------------------------------------------
    push edi
    mov edi,img
    cmp [edi + DISK_HEAD.aa55],55AAh
    jne .error
;-----------------------------------------------------------------------
    mov ecx,[edi + DISK_HEAD.disk_size]
    mov [disk_size],ecx
    mov eax,ecx
    or  ax,ax
    jnz .error
    xor edx,edx
    bswap eax
@@:
    shr ah,1
    jc @F
    inc dl
    cmp dl,5
    ja  .error
    jmp @B
@@:
    jnz .error
    invoke SendDlgItemMessage,[hMain],C_DISKSIZE,CB_SETCURSEL,edx,0    
;-----------------------------------------------------------------------
    xor edx,edx
    movzx ecx,[edi + DISK_HEAD.sect_size]
    mov [sect_size],ecx
    cmp ecx,1
    jz  .sect_ok
    mov eax,ecx
    and eax,7
    jnz .error
    shr ecx,7
@@:
    inc dl
    cmp dl,4
    ja  .error
    shr cl,1
    jnc @B
    jnz .error
.sect_ok:
    invoke SendDlgItemMessage,[hMain],C_SECTSIZE,CB_SETCURSEL,edx,0    
;-----------------------------------------------------------------------
    lea ecx,[edi + DISK_HEAD.label]
    invoke SetDlgItemText,[hMain],E_LABEL,ecx    
;-----------------------------------------------------------------------
    movzx ecx,[edi + DISK_HEAD.sys_start]
    mov al,cl
    call al2hex
    shl eax,16
    mov al,ch
    call al2hex
    push 0
    push eax
    invoke SetDlgItemText,[hMain],E_SYSSTART,esp    
    add esp,8
;-----------------------------------------------------------------------
    movzx eax,[edi + DISK_HEAD.sys_size]
    invoke SetDlgItemInt,[hMain],E_SYSSIZE,eax,0    
    invoke SetDlgItemInt,[hMain],E_SYSSPACE,\
                                           [edi + DISK_HEAD.sys_space],0    
    jmp .done
;-----------------------------------------------------------------------
.error:
    invoke MessageBox,[hMain],errformat,0,0
.done:
    pop edi
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc get_first_file
;-----------------------------------------------------------------------
    mov eax,-1
    mov ecx,img
    add ecx,[ecx + DISK_HEAD.sys_space]
    cmp byte [ecx],XX
    cmove eax,ecx
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc get_next_file
;-----------------------------------------------------------------------
; eax - prev. file
;-----------------------------------------------------------------------
    mov ecx,eax
    mov eax,-1
    add ecx,[ecx + FILE_HEAD.space]
    cmp byte [ecx],XX
    cmove eax,ecx
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc get_disk_end
;-----------------------------------------------------------------------
    call get_first_file
    or  eax,eax
    js  .done
.next:
    call get_next_file
    or  eax,eax
    jns .next
.done:
    mov eax,ecx    
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc get_dir
;-----------------------------------------------------------------------
    push esi
    push ebx
    invoke GetDlgItem,[hMain],L_DIR
    mov esi,eax
    invoke SendMessage,esi,LB_RESETCONTENT,0,0
    stdcall get_first_file
    or  eax,eax
    js  .done
.next:
    mov ebx,eax
    lea ecx,[eax + FILE_HEAD.name]
    invoke SendMessage,esi,LB_ADDSTRING,0,ecx
    invoke SendMessage,esi,LB_SETITEMDATA,eax,ebx
    mov eax,ebx
    stdcall get_next_file
    or  eax,eax
    jns .next
.done:    
    mov eax,[disk_size]
    add eax,img
    sub eax,ecx
    mov [disk_free],eax
    invoke SetDlgItemInt,[hMain],E_FREE,eax,0    
    invoke SendMessage,esi,LB_SETCURSEL,0,0
    call get_file_info
	pop ebx
	pop esi
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc get_file_info
;-----------------------------------------------------------------------
    push esi
    push edi
    push ebx
    xor esi,esi ; space
    xor edi,edi ; size
    xor ebx,ebx ; start/attr
    dec bl
    invoke SendDlgItemMessage,[hMain],L_DIR,LB_GETCURSEL,0,0
    cmp eax,LB_ERR
    je  .done
;-----------------------------------------------------------------------
    invoke SendDlgItemMessage,[hMain],L_DIR,LB_GETITEMDATA,eax,0
    mov bl,[eax + FILE_HEAD.attr]
    bswap ebx
    mov bx,[eax + FILE_HEAD.start]
    bswap ebx
    mov ecx,dword [eax + FILE_HEAD.size]
    test bl,40h
    jz  @F
    movzx ecx,cx
@@:    
    mov edi,ecx
    mov esi,[eax + FILE_HEAD.space]
;-----------------------------------------------------------------------
.done:
    not bl
;-----------------------------------------------------------------------
    stdcall show_attr,[hMain]
;-----------------------------------------------------------------------
    bswap ebx
    mov al,bl
    call al2hex
    shl eax,16
    mov al,bh
    call al2hex
    push 0
    push eax
    invoke SetDlgItemText,[hMain],E_START,esp    
    add esp,8
;-----------------------------------------------------------------------
    invoke SetDlgItemInt,[hMain],E_SIZE,edi,0
    invoke SetDlgItemInt,[hMain],E_SPACE,esi,0
;-----------------------------------------------------------------------
	pop ebx
	pop edi
	pop esi
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc show_attr hWnd ; bl - attr.
;-----------------------------------------------------------------------
    mov eax,1
    and al,bl
    invoke SendDlgItemMessage,[hWnd],CH_0,BM_SETCHECK,eax,0
    shr bl,1
;-----------------------------------------------------------------------
    mov eax,1
    and al,bl
    invoke SendDlgItemMessage,[hWnd],CH_1,BM_SETCHECK,eax,0
    shr bl,1
;-----------------------------------------------------------------------
    mov eax,1
    and al,bl
    invoke SendDlgItemMessage,[hWnd],CH_2,BM_SETCHECK,eax,0
    shr bl,1
;-----------------------------------------------------------------------
    mov eax,1
    and al,bl
    invoke SendDlgItemMessage,[hWnd],CH_READONLY,BM_SETCHECK,eax,0
    shr bl,1
;-----------------------------------------------------------------------
    mov eax,1
    and al,bl
    invoke SendDlgItemMessage,[hWnd],CH_ALIGNED,BM_SETCHECK,eax,0
    shr bl,1
;-----------------------------------------------------------------------
    mov eax,1
    and al,bl
    invoke SendDlgItemMessage,[hWnd],CH_EXE,BM_SETCHECK,eax,0
    shr bl,1
;-----------------------------------------------------------------------
    mov eax,1
    and al,bl
    invoke SendDlgItemMessage,[hWnd],CH_LONG,BM_SETCHECK,eax,0
    shr bl,1
;-----------------------------------------------------------------------
    mov eax,1
    and al,bl
    invoke SendDlgItemMessage,[hWnd],CH_DELETED,BM_SETCHECK,eax,0
;-----------------------------------------------------------------------
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
proc mod_file hWnd,uMsg,wParam,lParam
;-----------------------------------------------------------------------
    cmp [uMsg],WM_CLOSE
    jne @F
.end_dlg:
    invoke EndDialog,[hWnd],0
.exit_true:
    mov eax,TRUE
    ret
@@:
;-----------------------------------------------------------------------
    cmp [uMsg],WM_INITDIALOG
    jne @F
;-----------------------------------------------------------------------
    invoke LoadIcon,[hInstance],IDI_MAIN
    invoke SendMessage,[hWnd],WM_SETICON,ICON_SMALL,eax
    invoke SendDlgItemMessage,[hMain],L_DIR,LB_GETCURSEL,0,0
    cmp eax,LB_ERR
    je  .end_dlg
    invoke SendDlgItemMessage,[hMain],L_DIR,LB_GETITEMDATA,eax,0
    mov [modfile],eax
    push ebx
    push esi
    mov esi,eax
    lea eax,[eax + FILE_HEAD.name]
    invoke SetDlgItemText,[hWnd],E_FILE,eax
    mov bl,[esi + FILE_HEAD.attr]
    mov [modattr],bl
    not bl
    mov eax,dword [esi + FILE_HEAD.size]
    test bl,40h
    jz  .size_ok
    movzx eax,ax
.size_ok:
    invoke SetDlgItemInt,[hWnd],E_SIZE,eax,0    
    stdcall show_attr,[hWnd]
    invoke SetDlgItemInt,[hWnd],E_SPACE,[esi + FILE_HEAD.space],0    
    mov al,byte [esi + FILE_HEAD.start]
    call al2hex
    shl eax,16
    mov al,byte [esi + FILE_HEAD.start + 1]
    call al2hex
    push 0
    push eax
    invoke SetDlgItemText,[hWnd],E_START,esp    
    add esp,8
    pop esi
    pop ebx
;-----------------------------------------------------------------------
    jmp .exit_true
@@:    
;-----------------------------------------------------------------------
;    cmp [uMsg],?? << add new message
;    jne @F
;    
;    jmp .exit_true
;@@:    
;-----------------------------------------------------------------------
    cmp [uMsg],WM_COMMAND
    jne .exit_false
    cmp [wParam],B_CAN
    je .end_dlg
;-----------------------------------------------------------------------
    cmp [wParam],B_OK
    jne @F
    ;-------------------------------------------------------------------
    push esi
    mov esi,[modfile]
    invoke GetDlgItemInt,[hWnd],E_SPACE,0,0
    cmp eax,[esi + FILE_HEAD.space]
    je  .space_ok
    
.space_ok:    
    lea ecx,[esi + FILE_HEAD.name]
    mov al,[modattr]
    mov [esi + FILE_HEAD.attr],al
    invoke GetDlgItemText,[hWnd],E_FILE,ecx,32
    invoke GetDlgItemText,[hWnd],E_START,a_buff,5
    stdcall get_hex_number,a_buff
    mov [esi + FILE_HEAD.start],ax
    pop esi
    call get_dir
    ;-------------------------------------------------------------------
    jmp .end_dlg
@@:
;-----------------------------------------------------------------------
    cmp [wParam],CH_DELETED
    jne @F
    push 80h
    jmp .set_attr
@@:
;-----------------------------------------------------------------------
    cmp [wParam],CH_LONG
    jne @F
    push 40h
    jmp .set_attr
@@:
;-----------------------------------------------------------------------
    cmp [wParam],CH_EXE
    jne @F
    push 20h
    jmp .set_attr
@@:
;-----------------------------------------------------------------------
    cmp [wParam],CH_ALIGNED
    jne @F
    push 10h
    jmp .set_attr
@@:
;-----------------------------------------------------------------------
    cmp [wParam],CH_READONLY
    jne @F
    push 8
    jmp .set_attr
@@:
;-----------------------------------------------------------------------
    cmp [wParam],CH_2
    jne @F
    push 4
    jmp .set_attr
@@:
;-----------------------------------------------------------------------
    cmp [wParam],CH_1
    jne @F
    push 2
    jmp .set_attr
@@:
;-----------------------------------------------------------------------
    cmp [wParam],CH_0
    jne @F
    push 1
.set_attr:
    invoke SendMessage,[lParam],BM_GETCHECK,0,0
    or eax,eax
    pop eax
    jz .set_1
    not al
    and [modattr],al
    jmp .exit_true
.set_1:
    or  [modattr],al
    jmp .exit_true    
@@:
;-----------------------------------------------------------------------
;    cmp [wParam],?? ; << add new command
;    jne @F
;    jmp .exit_true
;@@:
;-----------------------------------------------------------------------
.exit_false:
    xor eax,eax
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
