;=======================================================================
;    - 24
;=======================================================================
;   TAB  - start working with RS232
;=======================================================================
;include "hex.inc"
include "8051x.inc"
include "listing.inc"
;=======================================================================
LED  equ P3.7
BUT  equ P2.7
;-----------------------------------------------------------------------
BUFF_SIZE := 16
DATA CMD_BUFF,BUFF_SIZE
BUFF_END := CMD_BUFF+BUFF_SIZE-1
;=======================================================================
RAM_START = 2000h
;-----------------------------------------------------------------------
    org RAM_START
;-----------------------------------------------------------------------
    jmp start
;-----------------------------------------------------------------------
    orgx 0003h+RAM_START,-1 ; INT0
    reti
;-----------------------------------------------------------------------
    orgx 000Bh+RAM_START,-1 ; TF0
    reti
;-----------------------------------------------------------------------
    orgx 0013h+RAM_START,-1 ; INT1
    reti
;-----------------------------------------------------------------------
    orgx 001Bh+RAM_START,-1 ; TF1
    reti    
;-----------------------------------------------------------------------
    orgx 0023h+RAM_START,-1 ; TI & RI
    reti
;-----------------------------------------------------------------------
    orgx 002Bh+RAM_START,-1 ; TF2 & EXF2
    reti
;=======================================================================
;
;=======================================================================
;   9600;Flow control=None;Implicit CR on LF;
;   
;=======================================================================
;
;=======================================================================
start:
    mov  SCON,#50h
    mov  TH1,#0F3h
    mov  TMOD,#20h
    orl  PCON,#80h
    setb TR1
    clr  TI
    SELECT_BANK 0
;-----------------------------------------------------------------------
init:
    jnb  RI,$
    mov  A,SBUF
    clr  RI
    cjne A,#9h,init ; wait for TAB symbol to start working
    jmp  welcome
;=======================================================================
;
;=======================================================================
include "text.inc"
include "monitor.inc"
include "user.inc"
;=======================================================================
;
;=======================================================================
memtop=($ and 0xFF00)+100h
;=======================================================================
                
