;=======================================================================
; macro to send immediate character to RS232
macro WR_CHAR chr
    mov  SBUF,#chr
    jnb  TI,$
    clr  TI
end macro
;-----------------------------------------------------------------------
; sends new line character to RS232
eol:
    WR_CHAR 10
    ret
;-----------------------------------------------------------------------
; sends space character to RS232
space:
    WR_CHAR 32
    ret
;-----------------------------------------------------------------------
; sends message from command memory at DPTR to RS232
message: 
    clr  A
    movc A,@A+DPTR
    jz   .done
    mov  SBUF,A
    jnb  TI,$
    clr  TI
    inc  DPTR
    jmp  message
.done:
    ret 
;-----------------------------------------------------------------------
; sends line @R0 from inner memory to RS232
writeln: 
    mov  A,@R0
    jz   .done
    mov  SBUF,A
    jnb  TI,$
    clr  TI
    inc  R0
    jmp  writeln
.done:
    ret 
;-----------------------------------------------------------------------
; reads line from RS232 to inner memory
; R0 - buffer start, R1 - buffer length, ENTER - done, TAB - abort
readln: 
    mov A,R0
    push ACC
.loop:
    jnb  RI,$
    mov  A,SBUF
    clr  RI
    mov  B,A
;-----------------------------------------------------------------------
    cjne A,#0x7F,.bs
    pop  ACC
    push ACC
    clr  C
    subb A,R0
    jz   .loop
    dec  R0
    inc  R1
    jmp  .loop   
.bs:
;-----------------------------------------------------------------------
    mov  A,B
    add  A,#-13
    jz   .done    
    mov  A,B
    add  A,#-9
    jz   .error    
    mov  @R0,B
    inc  R0
    djnz R1,.loop
    WR_CHAR 0x7F
    dec  R0
    inc  R1
    jmp  .loop
.error:
    pop  ACC
    mov  R0,ACC
    mov  @R0,A
    setb C
    ret    
.done:
    clr  A
    mov  @R0,A
    pop  ACC
    mov  R0,ACC
    clr  C
    ret    
;=======================================================================
;
;=======================================================================
run:
    mov  DPTR,#.last
    clr  A
    movc A,@A+DPTR
    mov  R4,A
    mov  A,#1
    movc A,@A+DPTR
    mov  R5,A
    inc  R0
    mov  A,@R0
    jz   .ready ; empty address - continue
    call a2h
    cjne @R0,#0,.error
    jnc  .ready
.error:    
    setb C
    ret
.ready:
    mov  A,#.done and 255
    push ACC
    mov  A,#.done shr 8
    push ACC
    mov  A,R4
    movx @DPTR,A
    push ACC
    inc  DPTR
    mov  A,R5
    movx @DPTR,A
    push ACC
.done:
    ret
.default:
    mov  DPTR,#.msg
    clr  C
    jmp  message
.msg:
    db 10,"SAMPLE USER PROCEDURE",10,0
.last:
    dw .default 
;-----------------------------------------------------------------------
modify:
    mov  DPTR,#.last
    clr  A
    movc A,@A+DPTR
    mov  R4,A
    mov  A,#1
    movc A,@A+DPTR
    mov  R5,A
    inc  R0
    mov  A,@R0
    jz   .ready ; empty address - continue
    call a2h
    cjne @R0,#0,.error
    jnc  .ready
.error:    
    setb C
    ret
.ready:
    mov  DPH,R5
    mov  DPL,R4
.loop:
    call eol
    mov  A,DPH
    call sbyte            
    mov  A,DPL
    call sbyte            
    WR_CHAR ':'
    call space
    clr  A
    movc A,@A+DPTR
    call sbyte
    call space
    mov  R0,#CMD_BUFF
    mov  R1,#3
    call readln
    jc   .done
    cjne @R0,#'.',.edit
.done:
    ret
.edit:
    mov  A,CMD_BUFF
    mov  B,CMD_BUFF+1
    jz   .ok
    xch  A,B
    call hex2bin
    jc   .done
    movx @DPTR,A
.ok:
    inc  DPTR
    mov  A,DPL
    mov  B,DPH
    mov  DPTR,#.last
    movx @DPTR,A
    xch  A,B
    movx @DPTR,A
    mov  DPH,A
    mov  DPL,B
    jmp  .loop
.last:
    dw 2000h    
;-----------------------------------------------------------------------
dump:
    mov  R7,#8
    inc  R0
    mov  A,@R0
    jz   .ok
    mov  R7,#16
    call uchar
    mov  B,A
    add  A,#-'U'
    jz   .ok
    mov  A,B
    add  A,#-'C'
    jz   dumpc
    setb C ; extra chars on command line
    ret
.ok:
    mov  R1,#0
.line:    
    call eol
    mov  A,R1
    call byte2hex
    mov  SBUF,B
    jnb  TI,$
    clr  TI
    mov  SBUF,A
    jnb  TI,$
    clr  TI
    WR_CHAR ':'
    mov  R6,#16
.char:
    call space
    mov  A,@R1
    call sbyte
    inc  R1
    djnz R6,.char 
    djnz R7,.line
    call eol 
    clr  C      
    ret
;-----------------------------------------------------------------------
dumpc:
    mov  DPTR,#.default
    clr  A
    movc A,@A+DPTR
    mov  R4,A
    mov  A,#1
    movc A,@A+DPTR
    mov  R5,A
    inc  R0
    mov  A,@R0
    jz   .ok ; empty address - continue
    call a2h
    cjne @R0,#0,.error
    jnc  .ok
.error:    
    setb C
    ret
.ok:
    mov  DPH,R5
    mov  DPL,R4
    mov  R7,#16
.line:
    call eol
    mov  A,DPH
    call sbyte            
    mov  A,DPL
    call sbyte            
    WR_CHAR ':'
    mov  R6,#16
.char:
    call space
    clr  A
    movc A,@A+DPTR
    call sbyte
    inc  DPTR
    djnz R6,.char 
    djnz R7,.line
    call eol 
    mov  R4,DPL
    mov  R5,DPH
    mov  DPTR,#.default
    mov  A,R4
    movx @DPTR,A
    inc  DPTR
    mov  A,R5
    movx @DPTR,A
    clr  C      
    ret
.default:       ; default address
    dw 2000h    ; continue won't work if RAM writing is locked
;-----------------------------------------------------------------------
portw:
    call eol
    inc  R0
    cjne @R0,#0,.ok
.error:    
    setb C
    ret
.ok:
    inc  R0
    mov  B,@R0
    inc  R0
    mov  A,@R0
    inc  R0
    cjne @R0,#0,.error
    call hex2bin
    jc   .error
    dec  R0
    dec  R0
    dec  R0
    cjne @R0,#'1',.p3
    mov  P1,A
    ret
.p3:
    cjne @R0,#'3',.error
    orl  A,#RXD or TXD or WR
    mov  P3,A
    ret
;-----------------------------------------------------------------------
portr:
    call eol
    inc  R0
    clr  C
    cjne @R0,#'1',.p3
    inc  R0
    cjne @R0,#0,.error
    mov  A,P1
    jmp  sbyte
.p3:
    cjne @R0,#'3',.error
    inc  R0
    cjne @R0,#0,.error
    mov  A,P3
    jmp  sbyte
.error:
    setb C
    ret
;-----------------------------------------------------------------------
sbyte:
    call byte2hex
    mov  SBUF,B
    jnb  TI,$
    clr  TI
    mov  SBUF,A
    jnb  TI,$
    clr  TI
    ret    
;-----------------------------------------------------------------------
welcome:
    mov  DPTR,#msg.welcome
    call message
dialog:
    mov  R0,#CMD_BUFF
    mov  R1,#BUFF_SIZE
    call readln
    mov  DPTR,#msg.bad_input
    jc   .errorx
    mov  A,CMD_BUFF
    jz   .ok
    call uchar
    call interpret
    jc   .error
;-----------------------------------------------------------------------
.ok:
    mov  DPTR,#msg.ok
    call message
    jmp  dialog
;-----------------------------------------------------------------------
.errorx:
    call message
.error:
    mov  DPTR,#msg.error
    call message
    jmp  dialog
;-----------------------------------------------------------------------
include "bv.inc"
;-----------------------------------------------------------------------
msg:
.welcome:   db 10,'= SZ89S51 MONITOR = VER: '
            db MAIN_VERSION,".",SUB_VERSION,".",BUILD_VERSION
            db 10,0
.bad_input: db 10,'BAD INPUT',0
.error:     db 10,'ERROR',10,0
.ok:        db 10,'OK',10,0  
.portw:     db 10,'PORT WRITING',0  
;-----------------------------------------------------------------------
interpret: ; A - command symbol, R0 - command line
    mov  B,A
    mov  DPTR,#commands-3
.loop:
    inc  DPTR
    inc  DPTR
    inc  DPTR
    clr  A
    movc A,@A+DPTR
    jz   .error
    inc  DPTR
    clr  C
    subb A,B
    jnz  .loop
    jmp  @A+DPTR
.error:
    setb C
    ret    
;-----------------------------------------------------------------------
macro cmd ss,aa
     db   ss
     ljmp aa 
end macro
;-----------------------------------------------------------------------
commands:
;-----------------------------------------------------------------------
    cmd 'H',help
    cmd '?',help
    cmd 'V',ver
    cmd 'D',dump
    cmd 'W',portw
    cmd 'R',portr
    cmd 'M',modify
    cmd 'G',run
    cmd 'T',test
    cmd 'I',userinfo
;-----------------------------------------------------------------------
    db 0
;=======================================================================
ver:
    mov  DPTR,#msg.welcome
    clr  C
    jmp  message
;-----------------------------------------------------------------------
help:
    call eol
    mov  DPTR,#.txt
    clr  C
    jmp  message
.txt:
    file "help.txt"
    db 0
;=======================================================================
            