;=======================================================================
ISP_SCK     equ P3.5
ISP_MISO    equ P3.4
ISP_MOSI    equ P3.3
ISP_R       equ P3.2
;-----------------------------------------------------------------------
macro ISP51 cmdl&
  iterate cmdb,cmdl
    mov A,#cmdb
    call isp51.xbyte
  end iterate
end macro
;-----------------------------------------------------------------------
isp51:
.xbyte:
    push B
    mov  B,#8
    rlc  A
.xbyte_loop:
    mov  ISP_MOSI,C
    mov  R0,#50 ; SCK off delay
    djnz R0,$
    setb ISP_SCK
    mov  R0,#50 ; SCK on  delay
    djnz R0,$
    mov  C,ISP_MISO
    clr  ISP_SCK
    rlc  A
    djnz B,.xbyte_loop
    pop  B
    ret
;-----------------------------------------------------------------------
.prog_enable:
    clr  ISP_R
    clr  ISP_SCK
    setb ISP_R
    mov  R0,#30
    call .delay_ms
    ISP51 10101100b,01010011b,0b,0b
    add  A,#-01101001b
    ret 
.release:
    setb ISP_SCK
    clr  ISP_R
    ret
.read_sig: 
    push ACC
    ISP51 00101000b
    pop  ACC
    call .xbyte
    ISP51 0,0
    ret 
.read_byte: ; R7:R6 - MCU addr
    ISP51 00100000b 
    mov  A,R7
    call .xbyte
    mov  A,R6
    call .xbyte
    ISP51 0
    ret 
.write_byte: ; R7:R6 - MCU addr
    xch  A,B
    ISP51 01000000b 
    mov  A,R7
    call .xbyte
    mov  A,R6
    call .xbyte
    xch  A,B
    call .xbyte
    mov  R0,#2
    jmp  .delay_ms
.erase:
    ISP51 10101100b,10000000b,0b,0b
    mov  R0,#100
    jmp  .delay_10ms
.writex: ; R7:R6 - MCU addr, DPTR - mem addr, R5:R4 - block length
    mov  A,R5
    orl  A,R4
    jz   .writex_done
    clr  A
    movc A,@A+DPTR
    call .write_byte
;-----------------------------------------------------------------------
    call .read_byte
    xch  A,B
    clr  A
    movc A,@A+DPTR
    clr  C
    subb A,B
    jnz  .writex_done
;-----------------------------------------------------------------------
    inc  DPTR
    mov  A,R6
    add  A,#1
    mov  R6,A
    mov  A,R7
    addc A,#0
    mov  R7,A
    clr  C
    mov  A,R4
    subb A,#1
    mov  R4,A
    mov  A,R5
    subb A,#0
    mov  R5,A
    jmp  .writex
.writex_done:
    ret        
;-----------------------------------------------------------------------
;.delay_ms:   ; R0 - ms
;    clr  ONE_MS   
;    jnb  ONE_MS,$
;    djnz R0,.delay_ms
;    ret
;-----------------------------------------------------------------------
;.delay_10ms: ; R0 - 10 x ms
;    clr  TEN_MS   
;    jnb  TEN_MS,$
;    djnz R0,.delay_10ms
;    ret
;=======================================================================
;   delays with no timer usage
;-----------------------------------------------------------------------
.delay_10ms:
    mov   R1,#9
.delay_loop:
    call  .delay_ms
    djnz  R1,.delay_loop
;-----------------------------------------------------------------------
.delay_ms:
    call .delay_x
    call .delay_x
    call .delay_x
;-----------------------------------------------------------------------
.delay_x:
    mov  R0,#0            
    djnz R0,$ ; 256 us
    ret     
;=======================================================================
 

    